# Microsoft.AspNetCore.Authentication.Cookies

``` diff
 namespace Microsoft.AspNetCore.Authentication.Cookies {
     public class CookieAuthenticationEvents {
+        public virtual Task CheckSlidingExpiration(CookieSlidingExpirationContext context);
     }
     public interface ITicketStore {
+        Task RemoveAsync(string key, HttpContext httpContext, CancellationToken cancellationToken);
+        Task RenewAsync(string key, AuthenticationTicket ticket, HttpContext httpContext, CancellationToken cancellationToken);
+        Task<AuthenticationTicket?> RetrieveAsync(string key, HttpContext httpContext, CancellationToken cancellationToken);
+        Task<string> StoreAsync(AuthenticationTicket ticket, HttpContext httpContext, CancellationToken cancellationToken);
     }
     public class PostConfigureCookieAuthenticationOptions : IPostConfigureOptions<CookieAuthenticationOptions> {
-        public void PostConfigure(string name, CookieAuthenticationOptions options);
+        public void PostConfigure(string? name, CookieAuthenticationOptions options);
     }
 }
```

