# Microsoft.AspNetCore.Authorization

``` diff
 namespace Microsoft.AspNetCore.Authorization {
+    public class AuthorizationBuilder {
+        public AuthorizationBuilder(IServiceCollection services);
+        public virtual IServiceCollection Services { get; }
+        public virtual AuthorizationBuilder AddDefaultPolicy(string name, AuthorizationPolicy policy);
+        public virtual AuthorizationBuilder AddDefaultPolicy(string name, Action<AuthorizationPolicyBuilder> configurePolicy);
+        public virtual AuthorizationBuilder AddFallbackPolicy(string name, AuthorizationPolicy policy);
+        public virtual AuthorizationBuilder AddFallbackPolicy(string name, Action<AuthorizationPolicyBuilder> configurePolicy);
+        public virtual AuthorizationBuilder AddPolicy(string name, AuthorizationPolicy policy);
+        public virtual AuthorizationBuilder AddPolicy(string name, Action<AuthorizationPolicyBuilder> configurePolicy);
+        public virtual AuthorizationBuilder SetDefaultPolicy(AuthorizationPolicy policy);
+        public virtual AuthorizationBuilder SetFallbackPolicy(AuthorizationPolicy? policy);
+        public virtual AuthorizationBuilder SetInvokeHandlersAfterFailure(bool invoke);
+    }
     public class AuthorizationMiddleware {
+        public AuthorizationMiddleware(RequestDelegate next, IAuthorizationPolicyProvider policyProvider, IServiceProvider services);
     }
     public class AuthorizationPolicy {
+        public static Task<AuthorizationPolicy?> CombineAsync(IAuthorizationPolicyProvider policyProvider, IEnumerable<IAuthorizeData> authorizeData, IEnumerable<AuthorizationPolicy> policies);
     }
     public class DefaultAuthorizationPolicyProvider : IAuthorizationPolicyProvider {
+        public virtual bool AllowsCachingPolicies { get; }
     }
     public interface IAuthorizationPolicyProvider {
+        bool AllowsCachingPolicies { get; }
     }
 }
```

