# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
     public static class AuthorizationEndpointConventionBuilderExtensions {
+        public static TBuilder RequireAuthorization<TBuilder>(this TBuilder builder, AuthorizationPolicy policy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder RequireAuthorization<TBuilder>(this TBuilder builder, Action<AuthorizationPolicyBuilder> configurePolicy) where TBuilder : IEndpointConventionBuilder;
     }
     public sealed class ComponentEndpointConventionBuilder : IEndpointConventionBuilder, IHubEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public sealed class ConnectionEndpointRouteBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public sealed class ControllerActionEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public static class ControllerEndpointRouteBuilderExtensions {
-        public static ControllerActionEndpointConventionBuilder MapAreaControllerRoute(this IEndpointRouteBuilder endpoints, string name, string areaName, string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
+        public static ControllerActionEndpointConventionBuilder MapAreaControllerRoute(this IEndpointRouteBuilder endpoints, string name, string areaName, [StringSyntaxAttribute("Route")] string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
-        public static ControllerActionEndpointConventionBuilder MapControllerRoute(this IEndpointRouteBuilder endpoints, string name, string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
+        public static ControllerActionEndpointConventionBuilder MapControllerRoute(this IEndpointRouteBuilder endpoints, string name, [StringSyntaxAttribute("Route")] string pattern, object? defaults = null, object? constraints = null, object? dataTokens = null);
-        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicControllerRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
-        public static IEndpointConventionBuilder MapFallbackToAreaController(this IEndpointRouteBuilder endpoints, string pattern, string action, string controller, string area);
+        public static IEndpointConventionBuilder MapFallbackToAreaController(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string action, string controller, string area);
-        public static IEndpointConventionBuilder MapFallbackToController(this IEndpointRouteBuilder endpoints, string pattern, string action, string controller);
+        public static IEndpointConventionBuilder MapFallbackToController(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string action, string controller);
     }
     public class CookiePolicyOptions {
+        public string ConsentCookieValue { get; set; }
     }
     public abstract class EndpointBuilder {
+        public IServiceProvider ApplicationServices { get; set; }
-        public string DisplayName { get; set; }
+        public string? DisplayName { get; set; }
+        public IList<Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate>> FilterFactories { get; }
-        public RequestDelegate RequestDelegate { get; set; }
+        public RequestDelegate? RequestDelegate { get; set; }
     }
     public static class EndpointRouteBuilderExtensions {
-        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, Delegate handler);
-        public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static IEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        public static RouteHandlerBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapDelete(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, Delegate handler);
-        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static IEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        public static RouteHandlerBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapGet(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
+        public static RouteGroupBuilder MapGroup(this IEndpointRouteBuilder endpoints, RoutePattern prefix);
+        public static RouteGroupBuilder MapGroup(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string prefix);
-        public static IEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, IEnumerable<string> httpMethods, RequestDelegate requestDelegate);
-        public static RouteHandlerBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapMethods(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, IEnumerable<string> httpMethods, Delegate handler);
+        public static IEndpointConventionBuilder MapPatch(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapPatch(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static IEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        public static RouteHandlerBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapPost(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
-        public static IEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
-        public static RouteHandlerBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder MapPut(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Delegate handler);
     }
     public static class FallbackEndpointRouteBuilderExtensions {
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
     }
     public sealed class HubEndpointConventionBuilder : IEndpointConventionBuilder, IHubEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public interface IEndpointConventionBuilder {
+        void Finally(Action<EndpointBuilder> finallyConvention);
     }
     public static class MapRouteRouteBuilderExtensions {
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string? name, string? template);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string? name, [StringSyntaxAttribute("Route")] string? template);
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, string template, object defaults);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, [StringSyntaxAttribute("Route")] string template, object defaults);
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, string template, object defaults, object constraints);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, [StringSyntaxAttribute("Route")] string template, object defaults, object constraints);
-        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, string template, object defaults, object constraints, object dataTokens);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.")]
+        public static IRouteBuilder MapRoute(this IRouteBuilder routeBuilder, string name, [StringSyntaxAttribute("Route")] string template, object defaults, object constraints, object dataTokens);
     }
     public static class MvcAreaRouteBuilderExtensions {
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template);
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template, object? defaults);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template, object? defaults);
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template, object? defaults, object? constraints);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template, object? defaults, object? constraints);
-        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, string? template, object? defaults, object? constraints, object? dataTokens);
+        public static IRouteBuilder MapAreaRoute(this IRouteBuilder routeBuilder, string name, string areaName, [StringSyntaxAttribute("Route")] string? template, object? defaults, object? constraints, object? dataTokens);
     }
+    public static class OutputCacheApplicationBuilderExtensions {
+        public static IApplicationBuilder UseOutputCache(this IApplicationBuilder app);
+    }
     public sealed class PageActionEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
+    public static class RateLimiterApplicationBuilderExtensions {
+        public static IApplicationBuilder UseRateLimiter(this IApplicationBuilder app);
+        public static IApplicationBuilder UseRateLimiter(this IApplicationBuilder app, RateLimiterOptions options);
+    }
+    public static class RateLimiterEndpointConventionBuilderExtensions {
+        public static TBuilder DisableRateLimiting<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder RequireRateLimiting<TBuilder, TPartitionKey>(this TBuilder builder, IRateLimiterPolicy<TPartitionKey> policy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder RequireRateLimiting<TBuilder>(this TBuilder builder, string policyName) where TBuilder : IEndpointConventionBuilder;
+    }
+    public static class RateLimiterServiceCollectionExtensions {
+        public static IServiceCollection AddRateLimiter(this IServiceCollection services, Action<RateLimiterOptions> configureOptions);
+    }
+    public static class RequestDecompressionBuilderExtensions {
+        public static IApplicationBuilder UseRequestDecompression(this IApplicationBuilder builder);
+    }
     public sealed class RouteHandlerBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public static class StaticFilesEndpointRouteBuilderExtensions {
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case here.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath);
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath, StaticFileOptions options);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case here.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string filePath, StaticFileOptions options);
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string pattern, string filePath);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case here.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string filePath);
-        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, string pattern, string filePath, StaticFileOptions options);
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="MapFallbackToFile RequireUnreferencedCode if the RequestDelegate has a Task<T> return type which is not the case.")]
+        public static IEndpointConventionBuilder MapFallbackToFile(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string filePath, StaticFileOptions options);
     }
     public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost {
-        IApplicationBuilder IApplicationBuilder.Use(Func<RequestDelegate, RequestDelegate> middleware);
+        public IApplicationBuilder Use(Func<RequestDelegate, RequestDelegate> middleware);
     }
 }
```

