# Microsoft.AspNetCore.Components.Routing

``` diff
 namespace Microsoft.AspNetCore.Components.Routing {
     public class LocationChangedEventArgs : EventArgs {
+        public string? HistoryEntryState { get; internal set; }
     }
+    public sealed class LocationChangingContext {
+        public LocationChangingContext();
+        public CancellationToken CancellationToken { get; set; }
+        public string? HistoryEntryState { get; set; }
+        public bool IsNavigationIntercepted { get; set; }
+        public required string TargetLocation { get; set; }
+        public void PreventNavigation();
+    }
+    public sealed class NavigationLock : IAsyncDisposable, IComponent, IHandleAfterRender {
+        public NavigationLock();
+        [ParameterAttribute]
+        public bool ConfirmExternalNavigation { get; set; }
+        [ParameterAttribute]
+        public EventCallback<LocationChangingContext> OnBeforeInternalNavigation { get; set; }
+        void IComponent.Attach(RenderHandle renderHandle);
+        Task IComponent.SetParametersAsync(ParameterView parameters);
+        Task IHandleAfterRender.OnAfterRenderAsync();
+        ValueTask IAsyncDisposable.DisposeAsync();
+    }
 }
```

