# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public class DynamicComponent : IComponent {
-        public Task SetParametersAsync(ParameterView parameters);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2072", Justification="We expect that types used with DynamicComponent will be defined in assemblies that don't get trimmed.")]
+        public Task SetParametersAsync(ParameterView parameters);
     }
     public static class EventCallbackFactoryBinderExtensions {
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<bool, Task> setter, bool existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateOnly, Task> setter, DateOnly existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateOnly, Task> setter, DateOnly existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTime, Task> setter, DateTime existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTime, Task> setter, DateTime existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTimeOffset, Task> setter, DateTimeOffset existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTimeOffset, Task> setter, DateTimeOffset existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<decimal, Task> setter, decimal existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<double, Task> setter, double existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<short, Task> setter, short existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<int, Task> setter, int existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<long, Task> setter, long existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<bool?, Task> setter, bool? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateOnly?, Task> setter, DateOnly? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateOnly?, Task> setter, DateOnly? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTime?, Task> setter, DateTime? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTime?, Task> setter, DateTime? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTimeOffset?, Task> setter, DateTimeOffset? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<DateTimeOffset?, Task> setter, DateTimeOffset? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<decimal?, Task> setter, decimal? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<double?, Task> setter, double? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<short?, Task> setter, short? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<int?, Task> setter, int? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<long?, Task> setter, long? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<float?, Task> setter, float? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<TimeOnly?, Task> setter, TimeOnly? existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<TimeOnly?, Task> setter, TimeOnly? existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<float, Task> setter, float existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<string?, Task> setter, string existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<TimeOnly, Task> setter, TimeOnly existingValue, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Func<TimeOnly, Task> setter, TimeOnly existingValue, string format, CultureInfo? culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder<T>(this EventCallbackFactory factory, object receiver, Func<T, Task> setter, T existingValue, CultureInfo? culture = null);
     }
     public abstract class NavigationManager {
+        public string? HistoryEntryState { get; protected set; }
+        protected virtual void HandleLocationChangingHandlerException(Exception ex, LocationChangingContext context);
+        protected ValueTask<bool> NotifyLocationChangingAsync(string uri, string? state, bool isNavigationIntercepted);
+        public IDisposable RegisterLocationChangingHandler(Func<LocationChangingContext, ValueTask> locationChangingHandler);
+        protected virtual void SetNavigationLockState(bool value);
     }
     public readonly struct NavigationOptions {
+        public string HistoryEntryState { get; set; }
     }
     public class RouteView : IComponent {
-        protected virtual void Render(RenderTreeBuilder builder);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2111", Justification="Layout components are preserved because the LayoutAttribute constructor parameter is correctly annotated.")]
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2118", Justification="Layout components are preserved because the LayoutAttribute constructor parameter is correctly annotated.")]
+        protected virtual void Render(RenderTreeBuilder builder);
     }
 }
```

