# Microsoft.AspNetCore.Hosting

``` diff
 namespace Microsoft.AspNetCore.Hosting {
     public static class HostingAbstractionsWebHostBuilderExtensions {
-        [RequiresUnreferencedCodeAttribute("Types and members the loaded assembly depends on might be removed.")]
-        public static IWebHostBuilder UseStartup(this IWebHostBuilder hostBuilder, string startupAssemblyName);
+        [RequiresUnreferencedCodeAttribute("This API searches the specified assembly for a startup type using reflection. The startup type may be trimmed. Please use UseStartup<TStartup>() to specify the startup type explicitly.")]
+        public static IWebHostBuilder UseStartup(this IWebHostBuilder hostBuilder, string startupAssemblyName);
     }
     public class WebHostBuilder : IWebHostBuilder {
-        public string GetSetting(string key);
+        public string? GetSetting(string key);
     }
     public static class WebHostBuilderQuicExtensions {
-        [RequiresPreviewFeaturesAttribute]
-        public static IWebHostBuilder UseQuic(this IWebHostBuilder hostBuilder);
+        public static IWebHostBuilder UseQuic(this IWebHostBuilder hostBuilder);
-        [RequiresPreviewFeaturesAttribute]
-        public static IWebHostBuilder UseQuic(this IWebHostBuilder hostBuilder, Action<QuicTransportOptions> configureOptions);
+        public static IWebHostBuilder UseQuic(this IWebHostBuilder hostBuilder, Action<QuicTransportOptions> configureOptions);
     }
 }
```

