# Microsoft.AspNetCore.Http.Features

``` diff
 namespace Microsoft.AspNetCore.Http.Features {
+    public static class FeatureCollectionExtensions {
+        public static object GetRequiredFeature(this IFeatureCollection featureCollection, Type key);
+        public static TFeature GetRequiredFeature<TFeature>(this IFeatureCollection featureCollection);
+    }
+    public interface IHttpExtendedConnectFeature {
+        [MemberNotNullWhenAttribute(true, "Protocol")]
+        bool IsExtendedConnect { [MemberNotNullWhenAttribute(true, "Protocol")] get; }
+        string Protocol { get; }
+        ValueTask<Stream> AcceptAsync();
+    }
+    [RequiresPreviewFeaturesAttribute("WebTransport is a preview feature")]
+    public interface IHttpWebTransportFeature {
+        bool IsWebTransportRequest { get; }
+        ValueTask<IWebTransportSession> AcceptAsync(CancellationToken cancellationToken = default(CancellationToken));
+    }
+    [RequiresPreviewFeaturesAttribute("WebTransport is a preview feature")]
+    public interface IWebTransportSession {
+        long SessionId { get; }
+        void Abort(int errorCode);
+        ValueTask<ConnectionContext?> AcceptStreamAsync(CancellationToken cancellationToken = default(CancellationToken));
+        ValueTask<ConnectionContext?> OpenUnidirectionalStreamAsync(CancellationToken cancellationToken = default(CancellationToken));
+    }
 }
```

