# Microsoft.AspNetCore.Http.HttpResults

``` diff
+namespace Microsoft.AspNetCore.Http.HttpResults {
+    public sealed class Accepted : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        public string? Location { get; }
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class Accepted<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        public string Location { get; }
+        int? IStatusCodeHttpResult.StatusCode { get; }
+        object IValueHttpResult.Value { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class AcceptedAtRoute : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public string? RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class AcceptedAtRoute<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        int? IStatusCodeHttpResult.StatusCode { get; }
+        object IValueHttpResult.Value { get; }
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class BadRequest : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class BadRequest<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        object? Microsoft.AspNetCore.Http.IValueHttpResult.Value { get; }
+        public int StatusCode { get; }
+        public TValue? Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class ChallengeHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class Conflict : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class Conflict<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        object? Microsoft.AspNetCore.Http.IValueHttpResult.Value { get; }
+        public int StatusCode { get; }
+        public TValue? Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class ContentHttpResult : IContentTypeHttpResult, IResult, IStatusCodeHttpResult {
+        public string ContentType { get; internal set; }
+        public string ResponseContent { get; internal set; }
+        public int? StatusCode { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class Created : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        public string? Location { get; }
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class Created<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        public string Location { get; }
+        int? IStatusCodeHttpResult.StatusCode { get; }
+        object IValueHttpResult.Value { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class CreatedAtRoute : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public string? RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class CreatedAtRoute<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        int? IStatusCodeHttpResult.StatusCode { get; }
+        object IValueHttpResult.Value { get; }
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class EmptyHttpResult : IResult {
+        public static EmptyHttpResult Instance { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class FileContentHttpResult : IContentTypeHttpResult, IFileHttpResult, IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue? EntityTag { get; internal set; }
+        public ReadOnlyMemory<byte> FileContents { get; internal set; }
+        public string? FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class FileStreamHttpResult : IContentTypeHttpResult, IFileHttpResult, IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public Stream FileStream { get; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ForbidHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class JsonHttpResult<TValue> : IContentTypeHttpResult, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        public string ContentType { get; internal set; }
+        public JsonSerializerOptions JsonSerializerOptions { get; internal set; }
+        object IValueHttpResult.Value { get; }
+        public int? StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public class NoContent : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class NotFound : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class NotFound<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        int? IStatusCodeHttpResult.StatusCode { get; }
+        object IValueHttpResult.Value { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class Ok : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class Ok<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        object? Microsoft.AspNetCore.Http.IValueHttpResult.Value { get; }
+        public int StatusCode { get; }
+        public TValue? Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class PhysicalFileHttpResult : IContentTypeHttpResult, IFileHttpResult, IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue? EntityTag { get; internal set; }
+        public string? FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public string FileName { get; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ProblemHttpResult : IContentTypeHttpResult, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<ProblemDetails> {
+        public string ContentType { get; }
+        int? IStatusCodeHttpResult.StatusCode { get; }
+        object? IValueHttpResult.Value { get; }
+        ProblemDetails? IValueHttpResult<ProblemDetails>.Value { get; }
+        public ProblemDetails ProblemDetails { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class PushStreamHttpResult : IContentTypeHttpResult, IFileHttpResult, IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class RedirectHttpResult : IResult {
+        public bool AcceptLocalUrlOnly { get; }
+        public bool Permanent { get; }
+        public bool PreserveMethod { get; }
+        public string Url { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class RedirectToRouteHttpResult : IResult {
+        public string Fragment { get; }
+        public bool Permanent { get; }
+        public bool PreserveMethod { get; }
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class Results<TResult1, TResult2> : IEndpointMetadataProvider, INestedHttpResult, IResult where TResult1 : IResult where TResult2 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+        public static implicit operator Results<TResult1, TResult2> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2> (TResult2 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3> : IEndpointMetadataProvider, INestedHttpResult, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+        public static implicit operator Results<TResult1, TResult2, TResult3> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3> (TResult3 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3, TResult4> : IEndpointMetadataProvider, INestedHttpResult, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult where TResult4 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult3 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult4 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3, TResult4, TResult5> : IEndpointMetadataProvider, INestedHttpResult, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult where TResult4 : IResult where TResult5 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult3 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult4 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult5 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> : IEndpointMetadataProvider, INestedHttpResult, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult where TResult4 : IResult where TResult5 : IResult where TResult6 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult3 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult4 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult5 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult6 result);
+    }
+    public sealed class SignInHttpResult : IResult {
+        public string AuthenticationScheme { get; internal set; }
+        public ClaimsPrincipal Principal { get; internal set; }
+        public AuthenticationProperties Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class SignOutHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class StatusCodeHttpResult : IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class UnauthorizedHttpResult : IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class UnprocessableEntity : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class UnprocessableEntity<TValue> : IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<TValue> {
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        object? Microsoft.AspNetCore.Http.IValueHttpResult.Value { get; }
+        public int StatusCode { get; }
+        public TValue? Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class Utf8ContentHttpResult : IContentTypeHttpResult, IResult, IStatusCodeHttpResult {
+        public string? ContentType { get; internal set; }
+        public ReadOnlyMemory<byte> ResponseContent { get; internal set; }
+        public int? StatusCode { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ValidationProblem : IContentTypeHttpResult, IEndpointMetadataProvider, IResult, IStatusCodeHttpResult, IValueHttpResult, IValueHttpResult<HttpValidationProblemDetails> {
+        public string ContentType { get; }
+        int? Microsoft.AspNetCore.Http.IStatusCodeHttpResult.StatusCode { get; }
+        object? Microsoft.AspNetCore.Http.IValueHttpResult.Value { get; }
+        HttpValidationProblemDetails? IValueHttpResult<HttpValidationProblemDetails>.Value { get; }
+        public HttpValidationProblemDetails ProblemDetails { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(MethodInfo method, EndpointBuilder builder);
+    }
+    public sealed class VirtualFileHttpResult : IContentTypeHttpResult, IFileHttpResult, IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue? EntityTag { get; internal set; }
+        public string? FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public string FileName { get; [MemberNotNullAttribute("_fileName")] internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+}
```

