# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    [AttributeUsageAttribute(2048, Inherited=false, AllowMultiple=false)]
+    public sealed class AsParametersAttribute : Attribute {
+        public AsParametersAttribute();
+    }
     public class CookieBuilder {
+        public IList<string> Extensions { get; }
     }
     public class CookieOptions {
+        public CookieOptions(CookieOptions options);
+        public IList<string> Extensions { get; }
+        public SetCookieHeaderValue CreateCookieHeader(string name, string value);
     }
+    public sealed class DefaultEndpointFilterInvocationContext : EndpointFilterInvocationContext {
+        public DefaultEndpointFilterInvocationContext(HttpContext httpContext, params object[] arguments);
+        public override IList<object?> Arguments { get; }
+        public override HttpContext HttpContext { get; }
+        public override T GetArgument<T>(int index);
+    }
+    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
+    public sealed class EndpointDescriptionAttribute : Attribute, IEndpointDescriptionMetadata {
+        public EndpointDescriptionAttribute(string description);
+        public string Description { get; }
+    }
+    public delegate ValueTask<object?> EndpointFilterDelegate(EndpointFilterInvocationContext context);
+    public static class EndpointFilterExtensions {
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IEndpointFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, IEndpointFilter filter) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, Func<EndpointFilterInvocationContext, EndpointFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder AddEndpointFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IEndpointFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteGroupBuilder AddEndpointFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IEndpointFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddEndpointFilterFactory<TBuilder>(this TBuilder builder, Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
+    }
+    public sealed class EndpointFilterFactoryContext {
+        public EndpointFilterFactoryContext();
+        public IServiceProvider ApplicationServices { get; set; }
+        public required MethodInfo MethodInfo { get; set; }
+    }
+    public abstract class EndpointFilterInvocationContext {
+        protected EndpointFilterInvocationContext();
+        public abstract IList<object?> Arguments { get; }
+        public abstract HttpContext HttpContext { get; }
+        public abstract T GetArgument<T>(int index);
+    }
     public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object> {
+        [MethodImpl(AggressiveInlining)]public T GetRequiredMetadata<T>() where T : class;
-        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<object?> {
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<object> {
-            public object? Current { get; }
+            public object Current { get; }
         }
     }
+    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
+    public sealed class EndpointSummaryAttribute : Attribute, IEndpointSummaryMetadata {
+        public EndpointSummaryAttribute(string summary);
+        public string Summary { get; }
+    }
     public static class HttpRequestJsonExtensions {
-        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, JsonSerializerContext context, CancellationToken cancellationToken = default(CancellationToken));
-        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
-        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
-        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class HttpResponse {
-        public abstract string ContentType { get; set; }
+        public abstract string? ContentType { get; set; }
     }
     public static class HttpResponseJsonExtensions {
-        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, JsonSerializerOptions? options, string? contentType, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, JsonSerializerOptions? options, string? contentType, CancellationToken cancellationToken = default(CancellationToken));
-        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, JsonSerializerContext context, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
-        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, CancellationToken cancellationToken = default(CancellationToken));
-        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions? options, string? contentType, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions? options, string? contentType, CancellationToken cancellationToken = default(CancellationToken));
-        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions? options, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonTypeInfo<TValue> jsonTypeInfo, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
-        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
     }
+    public interface IBindableFromHttpContext<TSelf> where TSelf : class, IBindableFromHttpContext<TSelf> {
+        static abstract ValueTask<TSelf?> BindAsync(HttpContext context, ParameterInfo parameter);
+    }
+    public interface IContentTypeHttpResult {
+        string ContentType { get; }
+    }
+    public interface IEndpointFilter {
+        ValueTask<object?> InvokeAsync(EndpointFilterInvocationContext context, EndpointFilterDelegate next);
+    }
+    public interface IFileHttpResult {
+        string ContentType { get; }
+        string FileDownloadName { get; }
+    }
+    public interface INestedHttpResult {
+        IResult Result { get; }
+    }
+    public interface IProblemDetailsService {
+        ValueTask WriteAsync(ProblemDetailsContext context);
+    }
+    public interface IProblemDetailsWriter {
+        bool CanWrite(ProblemDetailsContext context);
+        ValueTask WriteAsync(ProblemDetailsContext context);
+    }
     public interface IRequestCookieCollection : IEnumerable, IEnumerable<KeyValuePair<string, string>> {
-        bool TryGetValue(string key, [MaybeNullWhenAttribute(false)] out string? value);
+        bool TryGetValue(string key, [NotNullWhenAttribute(true)] out string? value);
     }
+    public interface IStatusCodeHttpResult {
+        int? StatusCode { get; }
+    }
+    public interface IValueHttpResult {
+        object? Value { get; }
+    }
+    public interface IValueHttpResult<out TValue> {
+        TValue? Value { get; }
+    }
     public static class OpenApiRouteHandlerBuilderExtensions {
+        public static TBuilder ExcludeFromDescription<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithDescription<TBuilder>(this TBuilder builder, string description) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithSummary<TBuilder>(this TBuilder builder, string summary) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithTags<TBuilder>(this TBuilder builder, params string[] tags) where TBuilder : IEndpointConventionBuilder;
     }
+    public sealed class ProblemDetailsContext {
+        public ProblemDetailsContext();
+        public EndpointMetadataCollection? AdditionalMetadata { get; set; }
+        public required HttpContext HttpContext { get; set; }
+        public ProblemDetails ProblemDetails { get; set; }
+    }
+    public class ProblemDetailsOptions {
+        public ProblemDetailsOptions();
+        public Action<ProblemDetailsContext>? CustomizeProblemDetails { get; set; }
+    }
-    public static class RequestDelegateFactory {
+    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
+    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2060", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
+    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2072", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
+    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2075", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
+    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2077", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
+    public static class RequestDelegateFactory {
-        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
-        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory, RequestDelegateFactoryOptions? options);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateMetadataResult InferMetadata(MethodInfo methodInfo, RequestDelegateFactoryOptions? options = null);
     }
     public sealed class RequestDelegateFactoryOptions {
+        public EndpointBuilder EndpointBuilder { get; set; }
     }
+    public sealed class RequestDelegateMetadataResult {
+        public RequestDelegateMetadataResult();
+        public required IReadOnlyList<object> EndpointMetadata { get; set; }
+    }
     public static class Results {
+        public static IResult Empty { get; }
-        public static IResult Accepted(string? uri = null, object? value = null);
+        public static IResult Accepted(string uri = null, object value = null);
+        public static IResult Accepted<TValue>(string uri = null, TValue value = null);
-        public static IResult AcceptedAtRoute(string? routeName = null, object? routeValues = null, object? value = null);
+        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult AcceptedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        public static IResult BadRequest<TValue>(TValue error);
-        public static IResult Bytes(byte[] contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult Bytes(byte[] contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult Bytes(ReadOnlyMemory<byte> contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult Conflict<TValue>(TValue error);
-        public static IResult Content(string content, MediaTypeHeaderValue contentType);
+        public static IResult Content(string? content, MediaTypeHeaderValue contentType);
-        public static IResult Content(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static IResult Content(string content, string contentType, Encoding contentEncoding);
+        public static IResult Content(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
+        public static IResult Created<TValue>(string uri, TValue? value);
+        public static IResult Created<TValue>(Uri uri, TValue? value);
-        public static IResult CreatedAtRoute(string? routeName = null, object? routeValues = null, object? value = null);
+        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult CreatedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
-        public static IResult File(byte[] fileContents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult File(byte[] fileContents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static IResult File(Stream fileStream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static IResult File(Stream fileStream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static IResult File(string path, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static IResult File(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static IResult Json(object? data, JsonSerializerOptions? options = null, string? contentType = null, int? statusCode = default(int?));
+        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult NotFound<TValue>(TValue value);
+        public static IResult Ok<TValue>(TValue value);
-        public static IResult Problem(string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static IResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
-        public static IResult RedirectToRoute(string? routeName = null, object? routeValues = null, bool permanent = false, bool preserveMethod = false, string? fragment = null);
+        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        public static IResult Stream(Func<Stream, Task> streamWriterCallback, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult Stream(PipeReader pipeReader, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static IResult Stream(Stream stream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Stream(Stream stream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Text(ReadOnlySpan<byte> utf8Content, string? contentType = null, int? statusCode = default(int?));
-        public static IResult Text(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static IResult Text(string content, string contentType, Encoding contentEncoding);
+        public static IResult Text(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
+        public static IResult UnprocessableEntity<TValue>(TValue error);
-        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
     }
     public class StreamResponseBodyFeature : IHttpResponseBodyFeature {
-        public StreamResponseBodyFeature(Stream stream, IHttpResponseBodyFeature priorFeature);
+        public StreamResponseBodyFeature(Stream stream, IHttpResponseBodyFeature? priorFeature);
     }
+    public static class TypedResults {
+        public static EmptyHttpResult Empty { get; }
+        public static Accepted Accepted(string? uri);
+        public static Accepted Accepted(Uri uri);
+        public static Accepted<TValue> Accepted<TValue>(string uri, TValue value);
+        public static Accepted<TValue> Accepted<TValue>(Uri uri, TValue? value);
+        public static AcceptedAtRoute AcceptedAtRoute(string routeName = null, object routeValues = null);
+        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        public static BadRequest BadRequest();
+        public static BadRequest<TValue> BadRequest<TValue>(TValue error);
+        public static FileContentHttpResult Bytes(byte[] contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static FileContentHttpResult Bytes(ReadOnlyMemory<byte> contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static ChallengeHttpResult Challenge(AuthenticationProperties? properties = null, IList<string>? authenticationSchemes = null);
+        public static Conflict Conflict();
+        public static Conflict<TValue> Conflict<TValue>(TValue error);
+        public static ContentHttpResult Content(string? content, MediaTypeHeaderValue contentType);
+        public static ContentHttpResult Content(string content, string contentType, Encoding contentEncoding);
+        public static ContentHttpResult Content(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
+        public static Created Created(string uri);
+        public static Created Created(Uri uri);
+        public static Created<TValue> Created<TValue>(string uri, TValue? value);
+        public static Created<TValue> Created<TValue>(Uri uri, TValue? value);
+        public static CreatedAtRoute CreatedAtRoute(string routeName = null, object routeValues = null);
+        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        public static FileContentHttpResult File(byte[] fileContents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static FileStreamHttpResult File(Stream fileStream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static ForbidHttpResult Forbid(AuthenticationProperties? properties = null, IList<string>? authenticationSchemes = null);
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static RedirectHttpResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static NoContent NoContent();
+        public static NotFound NotFound();
+        public static NotFound<TValue> NotFound<TValue>(TValue value);
+        public static Ok Ok();
+        public static Ok<TValue> Ok<TValue>(TValue value);
+        public static PhysicalFileHttpResult PhysicalFile(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static ProblemHttpResult Problem(ProblemDetails problemDetails);
+        public static ProblemHttpResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
+        public static RedirectHttpResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static RedirectToRouteHttpResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        public static SignInHttpResult SignIn(ClaimsPrincipal principal, AuthenticationProperties? properties = null, string? authenticationScheme = null);
+        public static SignOutHttpResult SignOut(AuthenticationProperties? properties = null, IList<string>? authenticationSchemes = null);
+        public static StatusCodeHttpResult StatusCode(int statusCode);
+        public static PushStreamHttpResult Stream(Func<Stream, Task> streamWriterCallback, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static FileStreamHttpResult Stream(PipeReader pipeReader, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static FileStreamHttpResult Stream(Stream stream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static Utf8ContentHttpResult Text(ReadOnlySpan<byte> utf8Content, string? contentType = null, int? statusCode = default(int?));
+        public static ContentHttpResult Text(string content, string contentType, Encoding contentEncoding);
+        public static ContentHttpResult Text(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
+        public static UnauthorizedHttpResult Unauthorized();
+        public static UnprocessableEntity UnprocessableEntity();
+        public static UnprocessableEntity<TValue> UnprocessableEntity<TValue>(TValue error);
+        public static ValidationProblem ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, string title = null, string type = null, IDictionary<string, object?>? extensions = null);
+        public static VirtualFileHttpResult VirtualFile(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+    }
 }
```

