# Microsoft.AspNetCore.Mvc

``` diff
 namespace Microsoft.AspNetCore.Mvc {
     [AttributeUsageAttribute(64, AllowMultiple=true, Inherited=true)]
     public sealed class AcceptVerbsAttribute : Attribute, IActionHttpMethodProvider, IRouteTemplateProvider {
-        public string Route { get; set; }
+        [StringSyntaxAttribute("Route")]
+        public string Route { get; set; }
     }
     public class ApiBehaviorOptions : IEnumerable, IEnumerable<ICompatibilitySwitch> {
+        public bool DisableImplicitFromServicesParameters { get; set; }
     }
     [ControllerAttribute]
     public abstract class ControllerBase {
+        public static EmptyResult Empty { get; }
-        [NonActionAttribute]
-        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, IValueProvider valueProvider, params Expression<Func<TModel, object>>[] includeExpressions) where TModel : class;
+        [NonActionAttribute]
+        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, IValueProvider valueProvider, params Expression<Func<TModel, object?>>[] includeExpressions) where TModel : class;
-        [NonActionAttribute]
-        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, params Expression<Func<TModel, object>>[] includeExpressions) where TModel : class;
+        [NonActionAttribute]
+        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, params Expression<Func<TModel, object?>>[] includeExpressions) where TModel : class;
-        [NonActionAttribute]
-        public virtual ActionResult ValidationProblem();
+        [DefaultStatusCodeAttribute(400)]
+        [NonActionAttribute]
+        public virtual ActionResult ValidationProblem();
-        [NonActionAttribute]
-        public virtual ActionResult ValidationProblem([ActionResultObjectValueAttribute] ModelStateDictionary modelStateDictionary);
+        [DefaultStatusCodeAttribute(400)]
+        [NonActionAttribute]
+        public virtual ActionResult ValidationProblem([ActionResultObjectValueAttribute] ModelStateDictionary modelStateDictionary);
-        [NonActionAttribute]
-        public virtual ActionResult ValidationProblem([ActionResultObjectValueAttribute] ValidationProblemDetails descriptor);
+        [DefaultStatusCodeAttribute(400)]
+        [NonActionAttribute]
+        public virtual ActionResult ValidationProblem([ActionResultObjectValueAttribute] ValidationProblemDetails descriptor);
-        [NonActionAttribute]
-        public virtual ActionResult ValidationProblem(string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, [ActionResultObjectValueAttribute] ModelStateDictionary? modelStateDictionary = null);
+        [DefaultStatusCodeAttribute(400)]
+        [NonActionAttribute]
+        public virtual ActionResult ValidationProblem(string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, [ActionResultObjectValueAttribute] ModelStateDictionary? modelStateDictionary = null);
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class DisableRequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public class DisableRequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter, IRequestSizeLimitMetadata {
+        long? Microsoft.AspNetCore.Http.Metadata.IRequestSizeLimitMetadata.MaxRequestBodySize { get; }
     }
-    [AttributeUsageAttribute(2176, AllowMultiple=false, Inherited=true)]
-    public class FromFormAttribute : Attribute, IBindingSourceMetadata, IModelNameProvider
+    [AttributeUsageAttribute(2176, AllowMultiple=false, Inherited=true)]
+    public class FromFormAttribute : Attribute, IBindingSourceMetadata, IFromFormMetadata, IModelNameProvider
-    [AttributeUsageAttribute(2048, AllowMultiple=false, Inherited=true)]
-    public class FromServicesAttribute : Attribute, IBindingSourceMetadata, IFromServiceMetadata
+    [AttributeUsageAttribute(2176, AllowMultiple=false, Inherited=true)]
+    public class FromServicesAttribute : Attribute, IBindingSourceMetadata, IFromServiceMetadata
     public class HttpDeleteAttribute : HttpMethodAttribute {
-        public HttpDeleteAttribute(string template);
+        public HttpDeleteAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpGetAttribute : HttpMethodAttribute {
-        public HttpGetAttribute(string template);
+        public HttpGetAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpHeadAttribute : HttpMethodAttribute {
-        public HttpHeadAttribute(string template);
+        public HttpHeadAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpOptionsAttribute : HttpMethodAttribute {
-        public HttpOptionsAttribute(string template);
+        public HttpOptionsAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpPatchAttribute : HttpMethodAttribute {
-        public HttpPatchAttribute(string template);
+        public HttpPatchAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpPostAttribute : HttpMethodAttribute {
-        public HttpPostAttribute(string template);
+        public HttpPostAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpPutAttribute : HttpMethodAttribute {
-        public HttpPutAttribute(string template);
+        public HttpPutAttribute([StringSyntaxAttribute("Route")] string template);
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class RequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public class RequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter, IRequestSizeLimitMetadata {
+        long? Microsoft.AspNetCore.Http.Metadata.IRequestSizeLimitMetadata.MaxRequestBodySize { get; }
     }
     [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
     public class RouteAttribute : Attribute, IRouteTemplateProvider {
-        public RouteAttribute(string template);
+        public RouteAttribute([StringSyntaxAttribute("Route")] string template);
-        public string Template { get; }
+        [StringSyntaxAttribute("Route")]
+        public string Template { get; }
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class SkipStatusCodePagesAttribute : Attribute, IFilterMetadata, IResourceFilter
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public class SkipStatusCodePagesAttribute : Attribute, IFilterMetadata, IResourceFilter, ISkipStatusCodePagesMetadata
 }
```

