# Microsoft.AspNetCore.OutputCaching

``` diff
+namespace Microsoft.AspNetCore.OutputCaching {
+    public sealed class CacheVaryByRules {
+        public CacheVaryByRules();
+        public string CacheKeyPrefix { get; set; }
+        public StringValues HeaderNames { get; set; }
+        public StringValues QueryKeys { get; set; }
+        public StringValues RouteValueNames { get; set; }
+        public bool VaryByHost { get; set; }
+        public IDictionary<string, string> VaryByValues { get; }
+    }
+    public interface IOutputCacheFeature {
+        OutputCacheContext Context { get; }
+    }
+    public interface IOutputCachePolicy {
+        ValueTask CacheRequestAsync(OutputCacheContext context, CancellationToken cancellation);
+        ValueTask ServeFromCacheAsync(OutputCacheContext context, CancellationToken cancellation);
+        ValueTask ServeResponseAsync(OutputCacheContext context, CancellationToken cancellation);
+    }
+    public interface IOutputCacheStore {
+        ValueTask EvictByTagAsync(string tag, CancellationToken cancellationToken);
+        ValueTask<byte[]?> GetAsync(string key, CancellationToken cancellationToken);
+        ValueTask SetAsync(string key, byte[] value, string[]? tags, TimeSpan validFor, CancellationToken cancellationToken);
+    }
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public sealed class OutputCacheAttribute : Attribute {
+        public OutputCacheAttribute();
+        public int Duration { get; set; }
+        public bool NoStore { get; set; }
+        public string PolicyName { get; set; }
+        public string[]? VaryByHeaderNames { get; set; }
+        public string[]? VaryByQueryKeys { get; set; }
+        public string[]? VaryByRouteValueNames { get; set; }
+    }
+    public sealed class OutputCacheContext {
+        public OutputCacheContext();
+        public bool AllowCacheLookup { get; set; }
+        public bool AllowCacheStorage { get; set; }
+        public bool AllowLocking { get; set; }
+        public CacheVaryByRules CacheVaryByRules { get; }
+        public bool EnableOutputCaching { get; set; }
+        public required HttpContext HttpContext { get; set; }
+        public TimeSpan? ResponseExpirationTimeSpan { get; set; }
+        public DateTimeOffset? ResponseTime { get; set; }
+        public HashSet<string> Tags { get; }
+    }
+    public class OutputCacheOptions {
+        public OutputCacheOptions();
+        public IServiceProvider ApplicationServices { get; internal set; }
+        public TimeSpan DefaultExpirationTimeSpan { get; set; }
+        public long MaximumBodySize { get; set; }
+        public long SizeLimit { get; set; }
+        public bool UseCaseSensitivePaths { get; set; }
+        public void AddBasePolicy(IOutputCachePolicy policy);
+        public void AddBasePolicy(Action<OutputCachePolicyBuilder> build);
+        public void AddBasePolicy(Action<OutputCachePolicyBuilder> build, bool excludeDefaultPolicy);
+        public void AddPolicy(string name, IOutputCachePolicy policy);
+        public void AddPolicy(string name, Action<OutputCachePolicyBuilder> build);
+        public void AddPolicy(string name, Action<OutputCachePolicyBuilder> build, bool excludeDefaultPolicy);
+    }
+    public sealed class OutputCachePolicyBuilder {
+        public OutputCachePolicyBuilder AddPolicy(Type policyType);
+        public OutputCachePolicyBuilder AddPolicy<T>() where T : IOutputCachePolicy;
+        public OutputCachePolicyBuilder Cache();
+        public OutputCachePolicyBuilder Expire(TimeSpan expiration);
+        public OutputCachePolicyBuilder NoCache();
+        public OutputCachePolicyBuilder SetCacheKeyPrefix(Func<HttpContext, string> keyPrefix);
+        public OutputCachePolicyBuilder SetCacheKeyPrefix(Func<HttpContext, CancellationToken, ValueTask<string>> keyPrefix);
+        public OutputCachePolicyBuilder SetCacheKeyPrefix(string keyPrefix);
+        public OutputCachePolicyBuilder SetLocking(bool enabled);
+        public OutputCachePolicyBuilder SetVaryByHeader(string headerName, params string[] headerNames);
+        public OutputCachePolicyBuilder SetVaryByHeader(string[] headerNames);
+        public OutputCachePolicyBuilder SetVaryByHost(bool enabled);
+        public OutputCachePolicyBuilder SetVaryByQuery(string queryKey, params string[] queryKeys);
+        public OutputCachePolicyBuilder SetVaryByQuery(string[] queryKeys);
+        public OutputCachePolicyBuilder SetVaryByRouteValue(string routeValueName, params string[] routeValueNames);
+        public OutputCachePolicyBuilder SetVaryByRouteValue(string[] routeValueNames);
+        public OutputCachePolicyBuilder Tag(params string[] tags);
+        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, KeyValuePair<string, string>> varyBy);
+        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, CancellationToken, ValueTask<KeyValuePair<string, string>>> varyBy);
+        public OutputCachePolicyBuilder VaryByValue(string key, string value);
+        public OutputCachePolicyBuilder With(Func<OutputCacheContext, bool> predicate);
+        public OutputCachePolicyBuilder With(Func<OutputCacheContext, CancellationToken, ValueTask<bool>> predicate);
+    }
+}
```

