# Microsoft.AspNetCore.RateLimiting

``` diff
+namespace Microsoft.AspNetCore.RateLimiting {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public sealed class DisableRateLimitingAttribute : Attribute {
+        public DisableRateLimitingAttribute();
+    }
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public sealed class EnableRateLimitingAttribute : Attribute {
+        public EnableRateLimitingAttribute(string policyName);
+        public string PolicyName { get; }
+    }
+    public interface IRateLimiterPolicy<TPartitionKey> {
+        Func<OnRejectedContext, CancellationToken, ValueTask>? OnRejected { get; }
+        RateLimitPartition<TPartitionKey> GetPartition(HttpContext httpContext);
+    }
+    public sealed class OnRejectedContext {
+        public OnRejectedContext();
+        public required HttpContext HttpContext { get; set; }
+        public required RateLimitLease Lease { get; set; }
+    }
+    public sealed class RateLimiterOptions {
+        public RateLimiterOptions();
+        public PartitionedRateLimiter<HttpContext>? GlobalLimiter { get; set; }
+        public Func<OnRejectedContext, CancellationToken, ValueTask>? OnRejected { get; set; }
+        public int RejectionStatusCode { get; set; }
+        public RateLimiterOptions AddPolicy<TPartitionKey, TPolicy>(string policyName) where TPolicy : IRateLimiterPolicy<TPartitionKey>;
+        public RateLimiterOptions AddPolicy<TPartitionKey>(string policyName, IRateLimiterPolicy<TPartitionKey> policy);
+        public RateLimiterOptions AddPolicy<TPartitionKey>(string policyName, Func<HttpContext, RateLimitPartition<TPartitionKey>> partitioner);
+    }
+    public static class RateLimiterOptionsExtensions {
+        public static RateLimiterOptions AddConcurrencyLimiter(this RateLimiterOptions options, string policyName, Action<ConcurrencyLimiterOptions> configureOptions);
+        public static RateLimiterOptions AddFixedWindowLimiter(this RateLimiterOptions options, string policyName, Action<FixedWindowRateLimiterOptions> configureOptions);
+        public static RateLimiterOptions AddSlidingWindowLimiter(this RateLimiterOptions options, string policyName, Action<SlidingWindowRateLimiterOptions> configureOptions);
+        public static RateLimiterOptions AddTokenBucketLimiter(this RateLimiterOptions options, string policyName, Action<TokenBucketRateLimiterOptions> configureOptions);
+    }
+}
```

