# Microsoft.AspNetCore.Routing.Patterns

``` diff
 namespace Microsoft.AspNetCore.Routing.Patterns {
     public sealed class RoutePatternException : Exception {
-        public RoutePatternException(string pattern, string message);
+        public RoutePatternException([StringSyntaxAttribute("Route")] string pattern, string message);
     }
     public static class RoutePatternFactory {
+        public static RoutePattern Combine(RoutePattern? left, RoutePattern right);
-        public static RoutePattern Parse(string pattern);
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern);
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies);
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies, RouteValueDictionary? requiredValues);
-        public static RoutePattern Parse(string pattern, object? defaults, object? parameterPolicies);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, object? defaults, object? parameterPolicies);
-        public static RoutePattern Parse(string pattern, object? defaults, object? parameterPolicies, object? requiredValues);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Parse([StringSyntaxAttribute("Route")] string pattern, object? defaults, object? parameterPolicies, object? requiredValues);
+        public static RoutePattern Pattern(RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies, params RoutePatternPathSegment[] segments);
+        public static RoutePattern Pattern(RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies, IEnumerable<RoutePatternPathSegment> segments);
-        public static RoutePattern Pattern(object? defaults, object? parameterPolicies, params RoutePatternPathSegment[] segments);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Pattern(object? defaults, object? parameterPolicies, params RoutePatternPathSegment[] segments);
-        public static RoutePattern Pattern(object? defaults, object? parameterPolicies, IEnumerable<RoutePatternPathSegment> segments);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Pattern(object? defaults, object? parameterPolicies, IEnumerable<RoutePatternPathSegment> segments);
+        public static RoutePattern Pattern(string? rawText, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies, params RoutePatternPathSegment[] segments);
+        public static RoutePattern Pattern(string? rawText, RouteValueDictionary? defaults, RouteValueDictionary? parameterPolicies, IEnumerable<RoutePatternPathSegment> segments);
-        public static RoutePattern Pattern(string? rawText, object? defaults, object? parameterPolicies, params RoutePatternPathSegment[] segments);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Pattern(string? rawText, object? defaults, object? parameterPolicies, params RoutePatternPathSegment[] segments);
-        public static RoutePattern Pattern(string? rawText, object? defaults, object? parameterPolicies, IEnumerable<RoutePatternPathSegment> segments);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static RoutePattern Pattern(string? rawText, object? defaults, object? parameterPolicies, IEnumerable<RoutePatternPathSegment> segments);
     }
     public abstract class RoutePatternTransformer {
+        public virtual RoutePattern? SubstituteRequiredValues(RoutePattern original, RouteValueDictionary requiredValues);
-        public abstract RoutePattern? SubstituteRequiredValues(RoutePattern original, object requiredValues);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameter which may be trimmed if not referenced directly.Consider using a different overload to avoid this issue.")]
+        public abstract RoutePattern? SubstituteRequiredValues(RoutePattern original, object requiredValues);
     }
 }
```

