# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
-    [DebuggerDisplayAttribute("{DebuggerDisplayString,nq}")]
-    public sealed class CompositeEndpointDataSource : EndpointDataSource {
+    [DebuggerDisplayAttribute("{DebuggerDisplayString,nq}")]
+    public sealed class CompositeEndpointDataSource : EndpointDataSource, IDisposable {
+        public void Dispose();
+        public override IReadOnlyList<Endpoint> GetGroupedEndpoints(RouteGroupContext context);
     }
-    public sealed class DefaultEndpointDataSource : EndpointDataSource
+    [DebuggerDisplayAttribute("{DebuggerDisplayString,nq}")]
+    public sealed class DefaultEndpointDataSource : EndpointDataSource
     public abstract class EndpointDataSource {
+        public virtual IReadOnlyList<Endpoint> GetGroupedEndpoints(RouteGroupContext context);
     }
     [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
     public sealed class HttpMethodMetadata : IHttpMethodMetadata {
-        public bool AcceptCorsPreflight { get; }
+        public bool AcceptCorsPreflight { get; set; }
     }
     public interface IHttpMethodMetadata {
-        bool AcceptCorsPreflight { get; }
+        bool AcceptCorsPreflight { get; set; }
     }
     public static class LinkGeneratorEndpointNameAddressExtensions {
+        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, RouteValueDictionary? values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        public static string? GetPathByName(this LinkGenerator generator, string endpointName, RouteValueDictionary? values = null, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string? GetPathByName(this LinkGenerator generator, string endpointName, object? values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string? GetPathByName(this LinkGenerator generator, string endpointName, object? values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, RouteValueDictionary? values = null, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        public static string? GetUriByName(this LinkGenerator generator, string endpointName, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string? GetUriByName(this LinkGenerator generator, string endpointName, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string? GetUriByName(this LinkGenerator generator, string endpointName, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
     public static class LinkGeneratorRouteValuesAddressExtensions {
+        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, RouteValueDictionary values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, RouteValueDictionary values = null, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, object values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, object values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, RouteValueDictionary values = null, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetUriByRouteValues(this LinkGenerator generator, string? routeName, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string GetUriByRouteValues(this LinkGenerator generator, string routeName, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public static string GetUriByRouteValues(this LinkGenerator generator, string routeName, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
     }
     public static class RequestDelegateRouteBuilderExtensions {
-        public static IRouteBuilder MapDelete(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapDelete(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapDelete(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapDelete(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapGet(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapGet(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapGet(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapGet(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapMiddlewareDelete(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareDelete(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewareGet(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareGet(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewarePost(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewarePost(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewarePut(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewarePut(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewareRoute(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareRoute(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewareVerb(this IRouteBuilder builder, string verb, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareVerb(this IRouteBuilder builder, string verb, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapPost(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapPost(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapPost(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapPost(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapPut(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapPut(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapPut(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapPut(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapRoute(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapRoute(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, string template, RequestDelegate handler);
+        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
     }
     public class Route : RouteBase {
-        public Route(IRouter target, string routeTemplate, IInlineConstraintResolver inlineConstraintResolver);
+        public Route(IRouter target, [StringSyntaxAttribute("Route")] string routeTemplate, IInlineConstraintResolver inlineConstraintResolver);
-        public Route(IRouter target, string routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
+        public Route(IRouter target, [StringSyntaxAttribute("Route")] string routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
-        public Route(IRouter target, string? routeName, string? routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
+        public Route(IRouter target, string? routeName, [StringSyntaxAttribute("Route")] string? routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
     }
     public abstract class RouteBase : INamedRouter, IRouter {
-        public RouteBase(string? template, string? name, IInlineConstraintResolver constraintResolver, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens);
+        public RouteBase([StringSyntaxAttribute("Route")] string? template, string? name, IInlineConstraintResolver constraintResolver, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens);
     }
     public sealed class RouteEndpointBuilder : EndpointBuilder {
-        public RouteEndpointBuilder(RequestDelegate requestDelegate, RoutePattern routePattern, int order);
+        public RouteEndpointBuilder(RequestDelegate? requestDelegate, RoutePattern routePattern, int order);
     }
+    public sealed class RouteGroupBuilder : IEndpointConventionBuilder, IEndpointRouteBuilder {
+        ICollection<EndpointDataSource> Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.DataSources { get; }
+        IServiceProvider Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.ServiceProvider { get; }
+        void IEndpointConventionBuilder.Add(Action<EndpointBuilder> convention);
+        void IEndpointConventionBuilder.Finally(Action<EndpointBuilder> finalConvention);
+        IApplicationBuilder IEndpointRouteBuilder.CreateApplicationBuilder();
+    }
+    public sealed class RouteGroupContext {
+        public RouteGroupContext();
+        public IServiceProvider ApplicationServices { get; set; }
+        public IReadOnlyList<Action<EndpointBuilder>> Conventions { get; set; }
+        public IReadOnlyList<Action<EndpointBuilder>> FinallyConventions { get; set; }
+        public required RoutePattern Prefix { get; set; }
+    }
     public class RouteOptions {
-        public IDictionary<string, Type> ConstraintMap { get; set; }
+        public IDictionary<string, Type> ConstraintMap { [RequiresUnreferencedCodeAttribute("The linker cannot determine what constraints are being added via the ConstraintMap property. Prefer RouteOptions.SetParameterPolicy instead for setting constraints. This warning can be suppressed if this property is being used to read or delete constraints.")] get; set; }
+        public void SetParameterPolicy(string token, Type type);
+        public void SetParameterPolicy<T>(string token) where T : IParameterPolicy;
     }
     public class RouteValueDictionary : ICollection<KeyValuePair<string, object?>>, IDictionary<string, object?>, IEnumerable, IEnumerable<KeyValuePair<string, object?>>, IReadOnlyCollection<KeyValuePair<string, object?>>, IReadOnlyDictionary<string, object?> {
+        public RouteValueDictionary(RouteValueDictionary? dictionary);
+        public RouteValueDictionary(IEnumerable<KeyValuePair<string, object?>>? values);
+        public RouteValueDictionary(IEnumerable<KeyValuePair<string, string?>>? values);
-        public RouteValueDictionary(object? values);
+        [RequiresUnreferencedCodeAttribute("This constructor may perform reflection on the specificed value which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
+        public RouteValueDictionary(object? values);
     }
     public class RouteValuesAddress {
+        public override string ToString();
     }
 }
```

