# Microsoft.Extensions.Caching.Memory

``` diff
 namespace Microsoft.Extensions.Caching.Memory {
     public static class CacheEntryExtensions {
-        public static ICacheEntry RegisterPostEvictionCallback(this ICacheEntry entry, PostEvictionDelegate callback, object state);
+        public static ICacheEntry RegisterPostEvictionCallback(this ICacheEntry entry, PostEvictionDelegate callback, object? state);
     }
     public static class CacheExtensions {
-        public static object Get(this IMemoryCache cache, object key);
+        public static object? Get(this IMemoryCache cache, object key);
-        public static TItem Get<TItem>(this IMemoryCache cache, object key);
+        public static TItem? Get<TItem>(this IMemoryCache cache, object key);
-        public static TItem GetOrCreate<TItem>(this IMemoryCache cache, object key, Func<ICacheEntry, TItem> factory);
+        public static TItem? GetOrCreate<TItem>(this IMemoryCache cache, object key, Func<ICacheEntry, TItem> factory);
-        public static Task<TItem> GetOrCreateAsync<TItem>(this IMemoryCache cache, object key, Func<ICacheEntry, Task<TItem>> factory);
+        public static Task<TItem?> GetOrCreateAsync<TItem>(this IMemoryCache cache, object key, Func<ICacheEntry, Task<TItem>> factory);
-        public static TItem Set<TItem>(this IMemoryCache cache, object key, TItem value, MemoryCacheEntryOptions options);
+        public static TItem Set<TItem>(this IMemoryCache cache, object key, TItem value, MemoryCacheEntryOptions? options);
-        public static bool TryGetValue<TItem>(this IMemoryCache cache, object key, out TItem value);
+        public static bool TryGetValue<TItem>(this IMemoryCache cache, object key, out TItem? value);
     }
     public interface ICacheEntry : IDisposable {
-        object Value { get; set; }
+        object? Value { get; set; }
     }
     public interface IMemoryCache : IDisposable {
+        MemoryCacheStatistics? GetCurrentStatistics();
-        bool TryGetValue(object key, out object value);
+        bool TryGetValue(object key, out object? value);
     }
     public class MemoryCache : IDisposable, IMemoryCache {
+        public void Clear();
+        public MemoryCacheStatistics? GetCurrentStatistics();
-        public bool TryGetValue(object key, out object result);
+        public bool TryGetValue(object key, out object? result);
     }
     public static class MemoryCacheEntryExtensions {
-        public static MemoryCacheEntryOptions RegisterPostEvictionCallback(this MemoryCacheEntryOptions options, PostEvictionDelegate callback, object state);
+        public static MemoryCacheEntryOptions RegisterPostEvictionCallback(this MemoryCacheEntryOptions options, PostEvictionDelegate callback, object? state);
     }
     public class MemoryCacheOptions : IOptions<MemoryCacheOptions> {
-        MemoryCacheOptions Microsoft.Extensions.Options.IOptions<Microsoft.Extensions.Caching.Memory.MemoryCacheOptions>.Value { get; }
+        MemoryCacheOptions IOptions<MemoryCacheOptions>.Value { get; }
+        public bool TrackLinkedCacheEntries { get; set; }
+        public bool TrackStatistics { get; set; }
     }
+    public class MemoryCacheStatistics {
+        public MemoryCacheStatistics();
+        public long CurrentEntryCount { get; set; }
+        public long? CurrentEstimatedSize { get; set; }
+        public long TotalHits { get; set; }
+        public long TotalMisses { get; set; }
+    }
-    public delegate void PostEvictionDelegate(object key, object value, EvictionReason reason, object state);
+    public delegate void PostEvictionDelegate(object key, object? value, EvictionReason reason, object? state);
 }
```

