# Microsoft.Extensions.Configuration

``` diff
 namespace Microsoft.Extensions.Configuration {
     public class ChainedConfigurationProvider : IConfigurationProvider, IDisposable {
+        public IConfiguration Configuration { get; }
-        public IEnumerable<string> GetChildKeys(IEnumerable<string> earlierKeys, string parentPath);
+        public IEnumerable<string> GetChildKeys(IEnumerable<string> earlierKeys, string? parentPath);
-        public void Set(string key, string value);
+        public void Set(string key, string? value);
-        public bool TryGet(string key, out string value);
+        public bool TryGet(string key, out string? value);
     }
     public class ChainedConfigurationSource : IConfigurationSource {
-        public IConfiguration Configuration { get; set; }
+        [DisallowNullAttribute]
+        public IConfiguration Configuration { get; set; }
     }
     public static class CommandLineConfigurationExtensions {
-        public static IConfigurationBuilder AddCommandLine(this IConfigurationBuilder builder, Action<CommandLineConfigurationSource> configureSource);
+        public static IConfigurationBuilder AddCommandLine(this IConfigurationBuilder builder, Action<CommandLineConfigurationSource>? configureSource);
-        public static IConfigurationBuilder AddCommandLine(this IConfigurationBuilder configurationBuilder, string[] args, IDictionary<string, string> switchMappings);
+        public static IConfigurationBuilder AddCommandLine(this IConfigurationBuilder configurationBuilder, string[] args, IDictionary<string, string>? switchMappings);
     }
     public static class ConfigurationBinder {
-        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
-        public static void Bind(this IConfiguration configuration, object instance);
+        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
+        public static void Bind(this IConfiguration configuration, object? instance);
-        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
-        public static void Bind(this IConfiguration configuration, object instance, Action<BinderOptions> configureOptions);
+        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
+        public static void Bind(this IConfiguration configuration, object? instance, Action<BinderOptions>? configureOptions);
-        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
-        public static void Bind(this IConfiguration configuration, string key, object instance);
+        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
+        public static void Bind(this IConfiguration configuration, string key, object? instance);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static object Get(this IConfiguration configuration, Type type);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static object? Get(this IConfiguration configuration, Type type);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static object Get(this IConfiguration configuration, Type type, Action<BinderOptions> configureOptions);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static object? Get(this IConfiguration configuration, Type type, Action<BinderOptions>? configureOptions);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static T Get<T>(this IConfiguration configuration);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static T? Get<T>(this IConfiguration configuration);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static T Get<T>(this IConfiguration configuration, Action<BinderOptions> configureOptions);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static T? Get<T>(this IConfiguration configuration, Action<BinderOptions>? configureOptions);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static object GetValue(this IConfiguration configuration, Type type, string key);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static object? GetValue(this IConfiguration configuration, Type type, string key);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static object GetValue(this IConfiguration configuration, Type type, string key, object defaultValue);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static object? GetValue(this IConfiguration configuration, Type type, string key, object? defaultValue);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static T GetValue<T>(this IConfiguration configuration, string key);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static T? GetValue<T>(this IConfiguration configuration, string key);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static T GetValue<T>(this IConfiguration configuration, string key, T defaultValue);
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static T? GetValue<T>(this IConfiguration configuration, string key, T defaultValue);
     }
+    public readonly struct ConfigurationDebugViewContext {
+        public ConfigurationDebugViewContext(string path, string key, string? value, IConfigurationProvider configurationProvider);
+        public IConfigurationProvider ConfigurationProvider { get; }
+        public string Key { get; }
+        public string Path { get; }
+        public string? Value { get; }
+    }
     public static class ConfigurationExtensions {
-        public static IConfigurationBuilder Add<TSource>(this IConfigurationBuilder builder, Action<TSource> configureSource) where TSource : IConfigurationSource, new();
+        public static IConfigurationBuilder Add<TSource>(this IConfigurationBuilder builder, Action<TSource>? configureSource) where TSource : IConfigurationSource, new();
-        public static IEnumerable<KeyValuePair<string, string>> AsEnumerable(this IConfiguration configuration);
+        public static IEnumerable<KeyValuePair<string, string?>> AsEnumerable(this IConfiguration configuration);
-        public static IEnumerable<KeyValuePair<string, string>> AsEnumerable(this IConfiguration configuration, bool makePathsRelative);
+        public static IEnumerable<KeyValuePair<string, string?>> AsEnumerable(this IConfiguration configuration, bool makePathsRelative);
-        public static bool Exists(this IConfigurationSection section);
+        public static bool Exists([NotNullWhenAttribute(true)] this IConfigurationSection? section);
-        public static string GetConnectionString(this IConfiguration configuration, string name);
+        public static string? GetConnectionString(this IConfiguration configuration, string name);
     }
     public class ConfigurationKeyComparer : IComparer<string> {
-        public int Compare(string x, string y);
+        public int Compare(string? x, string? y);
     }
     public sealed class ConfigurationManager : IConfiguration, IConfigurationBuilder, IConfigurationRoot, IDisposable {
-        IDictionary<string, object> Microsoft.Extensions.Configuration.IConfigurationBuilder.Properties { get; }
+        IDictionary<string, object> IConfigurationBuilder.Properties { get; }
-        IList<IConfigurationSource> Microsoft.Extensions.Configuration.IConfigurationBuilder.Sources { get; }
-        IEnumerable<IConfigurationProvider> Microsoft.Extensions.Configuration.IConfigurationRoot.Providers { get; }
+        IEnumerable<IConfigurationProvider> IConfigurationRoot.Providers { get; }
+        public IList<IConfigurationSource> Sources { get; }
-        public string this[string key] { get; set; }
+        public string? this[string key] { get; set; }
     }
     public static class ConfigurationPath {
-        public static string GetParentPath(string path);
+        public static string? GetParentPath(string? path);
-        public static string GetSectionKey(string path);
+        [return: NotNullIfNotNullAttribute("path")]
+        public static string? GetSectionKey(string? path);
     }
     public abstract class ConfigurationProvider : IConfigurationProvider {
-        protected IDictionary<string, string> Data { get; set; }
+        protected IDictionary<string, string?> Data { get; set; }
-        public virtual IEnumerable<string> GetChildKeys(IEnumerable<string> earlierKeys, string parentPath);
+        public virtual IEnumerable<string> GetChildKeys(IEnumerable<string> earlierKeys, string? parentPath);
-        public virtual void Set(string key, string value);
+        public virtual void Set(string key, string? value);
-        public virtual bool TryGet(string key, out string value);
+        public virtual bool TryGet(string key, out string? value);
     }
     public class ConfigurationReloadToken : IChangeToken {
-        public IDisposable RegisterChangeCallback(Action<object> callback, object state);
+        public IDisposable RegisterChangeCallback(Action<object?> callback, object? state);
     }
     public class ConfigurationRoot : IConfiguration, IConfigurationRoot, IDisposable {
-        public string this[string key] { get; set; }
+        public string? this[string key] { get; set; }
     }
     public static class ConfigurationRootExtensions {
+        public static string GetDebugView(this IConfigurationRoot root, Func<ConfigurationDebugViewContext, string>? processValue);
     }
     public class ConfigurationSection : IConfiguration, IConfigurationSection {
-        public string this[string key] { get; set; }
+        public string? this[string key] { get; set; }
-        public string Value { get; set; }
+        public string? Value { get; set; }
     }
     public static class EnvironmentVariablesExtensions {
-        public static IConfigurationBuilder AddEnvironmentVariables(this IConfigurationBuilder builder, Action<EnvironmentVariablesConfigurationSource> configureSource);
+        public static IConfigurationBuilder AddEnvironmentVariables(this IConfigurationBuilder builder, Action<EnvironmentVariablesConfigurationSource>? configureSource);
-        public static IConfigurationBuilder AddEnvironmentVariables(this IConfigurationBuilder configurationBuilder, string prefix);
+        public static IConfigurationBuilder AddEnvironmentVariables(this IConfigurationBuilder configurationBuilder, string? prefix);
     }
     public static class FileConfigurationExtensions {
-        public static Action<FileLoadExceptionContext> GetFileLoadExceptionHandler(this IConfigurationBuilder builder);
+        public static Action<FileLoadExceptionContext>? GetFileLoadExceptionHandler(this IConfigurationBuilder builder);
     }
     public abstract class FileConfigurationSource : IConfigurationSource {
-        public Action<FileLoadExceptionContext> OnLoadException { get; set; }
+        public Action<FileLoadExceptionContext>? OnLoadException { get; set; }
-        public string Path { get; set; }
+        [DisallowNullAttribute]
+        public string Path { get; set; }
     }
     public interface IConfiguration {
-        string this[string key] { get; set; }
+        string? this[string key] { get; set; }
     }
     public interface IConfigurationProvider {
-        IEnumerable<string> GetChildKeys(IEnumerable<string> earlierKeys, string parentPath);
+        IEnumerable<string> GetChildKeys(IEnumerable<string> earlierKeys, string? parentPath);
-        void Set(string key, string value);
+        void Set(string key, string? value);
-        bool TryGet(string key, out string value);
+        bool TryGet(string key, out string? value);
     }
     public interface IConfigurationSection : IConfiguration {
-        string Value { get; set; }
+        string? Value { get; set; }
     }
     public static class IniConfigurationExtensions {
-        public static IConfigurationBuilder AddIniFile(this IConfigurationBuilder builder, IFileProvider provider, string path, bool optional, bool reloadOnChange);
+        public static IConfigurationBuilder AddIniFile(this IConfigurationBuilder builder, IFileProvider? provider, string path, bool optional, bool reloadOnChange);
-        public static IConfigurationBuilder AddIniFile(this IConfigurationBuilder builder, Action<IniConfigurationSource> configureSource);
+        public static IConfigurationBuilder AddIniFile(this IConfigurationBuilder builder, Action<IniConfigurationSource>? configureSource);
     }
     public static class JsonConfigurationExtensions {
-        public static IConfigurationBuilder AddJsonFile(this IConfigurationBuilder builder, IFileProvider provider, string path, bool optional, bool reloadOnChange);
+        public static IConfigurationBuilder AddJsonFile(this IConfigurationBuilder builder, IFileProvider? provider, string path, bool optional, bool reloadOnChange);
-        public static IConfigurationBuilder AddJsonFile(this IConfigurationBuilder builder, Action<JsonConfigurationSource> configureSource);
+        public static IConfigurationBuilder AddJsonFile(this IConfigurationBuilder builder, Action<JsonConfigurationSource>? configureSource);
     }
     public static class MemoryConfigurationBuilderExtensions {
-        public static IConfigurationBuilder AddInMemoryCollection(this IConfigurationBuilder configurationBuilder, IEnumerable<KeyValuePair<string, string>> initialData);
+        public static IConfigurationBuilder AddInMemoryCollection(this IConfigurationBuilder configurationBuilder, IEnumerable<KeyValuePair<string, string?>>? initialData);
     }
     public abstract class StreamConfigurationSource : IConfigurationSource {
-        public Stream Stream { get; set; }
+        [DisallowNullAttribute]
+        public Stream Stream { get; set; }
     }
     public static class XmlConfigurationExtensions {
-        public static IConfigurationBuilder AddXmlFile(this IConfigurationBuilder builder, IFileProvider provider, string path, bool optional, bool reloadOnChange);
+        public static IConfigurationBuilder AddXmlFile(this IConfigurationBuilder builder, IFileProvider? provider, string path, bool optional, bool reloadOnChange);
-        public static IConfigurationBuilder AddXmlFile(this IConfigurationBuilder builder, Action<XmlConfigurationSource> configureSource);
+        public static IConfigurationBuilder AddXmlFile(this IConfigurationBuilder builder, Action<XmlConfigurationSource>? configureSource);
     }
 }
```

