# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
+    public static class HttpJsonServiceExtensions {
+        public static IServiceCollection ConfigureHttpJsonOptions(this IServiceCollection services, Action<JsonOptions> configureOptions);
+    }
     public class OAuthPostConfigureOptions<TOptions, THandler> : IPostConfigureOptions<TOptions> where TOptions : OAuthOptions, new() where THandler : OAuthHandler<TOptions> {
-        public void PostConfigure(string name, TOptions options);
+        public void PostConfigure(string? name, TOptions options);
     }
     public static class OptionsBuilderConfigurationExtensions {
         [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
         public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config, Action<BinderOptions> configureBinder) where TOptions : class;
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static OptionsBuilder<TOptions> BindConfiguration<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, string configSectionPath, Action<BinderOptions> configureBinder = null) where TOptions : class;
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static OptionsBuilder<TOptions> BindConfiguration<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, string configSectionPath, Action<BinderOptions>? configureBinder = null) where TOptions : class;
     }
     public static class OptionsBuilderDataAnnotationsExtensions {
         [RequiresUnreferencedCodeAttribute("Uses DataAnnotationValidateOptions which is unsafe given that the options type passed in when calling Validate cannot be statically analyzed so its members may be trimmed.")]
         public static OptionsBuilder<TOptions> ValidateDataAnnotations<TOptions>(this OptionsBuilder<TOptions> optionsBuilder) where TOptions : class;
     }
     public static class OptionsConfigurationServiceCollectionExtensions {
         [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
         public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config, Action<BinderOptions> configureBinder) where TOptions : class;
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string name, IConfiguration config) where TOptions : class;
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config) where TOptions : class;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string name, IConfiguration config, Action<BinderOptions> configureBinder) where TOptions : class;
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
     }
     public static class OptionsServiceCollectionExtensions {
-        public static OptionsBuilder<TOptions> AddOptions<TOptions>(this IServiceCollection services, string name) where TOptions : class;
+        public static OptionsBuilder<TOptions> AddOptions<TOptions>(this IServiceCollection services, string? name) where TOptions : class;
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string name, Action<TOptions> configureOptions) where TOptions : class;
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, Action<TOptions> configureOptions) where TOptions : class;
-        public static IServiceCollection PostConfigure<TOptions>(this IServiceCollection services, string name, Action<TOptions> configureOptions) where TOptions : class;
+        public static IServiceCollection PostConfigure<TOptions>(this IServiceCollection services, string? name, Action<TOptions> configureOptions) where TOptions : class;
     }
+    public static class OutputCacheConventionBuilderExtensions {
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder, IOutputCachePolicy policy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder, Action<OutputCachePolicyBuilder> policy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder, Action<OutputCachePolicyBuilder> policy, bool excludeDefaultPolicy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder, string policyName) where TBuilder : IEndpointConventionBuilder;
+    }
+    public static class OutputCacheServiceCollectionExtensions {
+        public static IServiceCollection AddOutputCache(this IServiceCollection services);
+        public static IServiceCollection AddOutputCache(this IServiceCollection services, Action<OutputCacheOptions> configureOptions);
+    }
     public static class PageConventionCollectionExtensions {
-        public static PageConventionCollection AddAreaPageRoute(this PageConventionCollection conventions, string areaName, string pageName, string route);
+        public static PageConventionCollection AddAreaPageRoute(this PageConventionCollection conventions, string areaName, string pageName, [StringSyntaxAttribute("Route")] string route);
-        public static PageConventionCollection AddPageRoute(this PageConventionCollection conventions, string pageName, string route);
+        public static PageConventionCollection AddPageRoute(this PageConventionCollection conventions, string pageName, [StringSyntaxAttribute("Route")] string route);
     }
     public static class PolicyServiceCollectionExtensions {
+        public static AuthorizationBuilder AddAuthorizationBuilder(this IServiceCollection services);
     }
+    public static class ProblemDetailsServiceCollectionExtensions {
+        public static IServiceCollection AddProblemDetails(this IServiceCollection services);
+        public static IServiceCollection AddProblemDetails(this IServiceCollection services, Action<ProblemDetailsOptions>? configure);
+    }
+    public static class RequestDecompressionServiceExtensions {
+        public static IServiceCollection AddRequestDecompression(this IServiceCollection services);
+        public static IServiceCollection AddRequestDecompression(this IServiceCollection services, Action<RequestDecompressionOptions> configureOptions);
+    }
     public class ServiceCollection : ICollection<ServiceDescriptor>, IEnumerable, IEnumerable<ServiceDescriptor>, IList<ServiceDescriptor>, IServiceCollection {
+        public void MakeReadOnly();
     }
     public sealed class ServiceProvider : IAsyncDisposable, IDisposable, IServiceProvider {
-        public object GetService(Type serviceType);
+        public object? GetService(Type serviceType);
     }
 }
```

