# Microsoft.Extensions.Hosting

``` diff
 namespace Microsoft.Extensions.Hosting {
     public abstract class BackgroundService : IDisposable, IHostedService {
-        public virtual Task ExecuteTask { get; }
+        public virtual Task? ExecuteTask { get; }
     }
     public static class GenericHostBuilderExtensions {
+        public static IHostBuilder ConfigureWebHostDefaults(this IHostBuilder builder, Action<IWebHostBuilder> configure, Action<WebHostBuilderOptions> configureOptions);
     }
     public static class Host {
+        public static HostApplicationBuilder CreateApplicationBuilder();
+        public static HostApplicationBuilder CreateApplicationBuilder(string[]? args);
-        public static IHostBuilder CreateDefaultBuilder(string[] args);
+        public static IHostBuilder CreateDefaultBuilder(string[]? args);
     }
+    public sealed class HostAbortedException : Exception {
+        public HostAbortedException();
+        public HostAbortedException(string message);
+        public HostAbortedException(string message, Exception innerException);
+    }
+    public sealed class HostApplicationBuilder {
+        public HostApplicationBuilder();
+        public HostApplicationBuilder(HostApplicationBuilderSettings? settings);
+        public HostApplicationBuilder(string[]? args);
+        public ConfigurationManager Configuration { get; }
+        public IHostEnvironment Environment { get; }
+        public ILoggingBuilder Logging { get; }
+        public IServiceCollection Services { get; }
+        public IHost Build();
+        public void ConfigureContainer<TContainerBuilder>(IServiceProviderFactory<TContainerBuilder> factory, Action<TContainerBuilder>? configure = null);
+    }
+    public sealed class HostApplicationBuilderSettings {
+        public HostApplicationBuilderSettings();
+        public string ApplicationName { get; set; }
+        public string[]? Args { get; set; }
+        public ConfigurationManager Configuration { get; set; }
+        public string ContentRootPath { get; set; }
+        public bool DisableDefaults { get; set; }
+        public string EnvironmentName { get; set; }
+    }
     public static class HostingHostBuilderExtensions {
-        public static IHostBuilder ConfigureDefaults(this IHostBuilder builder, string[] args);
+        public static IHostBuilder ConfigureDefaults(this IHostBuilder builder, string[]? args);
         [UnsupportedOSPlatformAttribute("android")]
         [UnsupportedOSPlatformAttribute("browser")]
         [UnsupportedOSPlatformAttribute("ios")]
         [UnsupportedOSPlatformAttribute("tvos")]
         public static Task RunConsoleAsync(this IHostBuilder hostBuilder, Action<ConsoleLifetimeOptions> configureOptions, CancellationToken cancellationToken = default(CancellationToken));
         [UnsupportedOSPlatformAttribute("android")]
         [UnsupportedOSPlatformAttribute("browser")]
         [UnsupportedOSPlatformAttribute("ios")]
         [UnsupportedOSPlatformAttribute("tvos")]
         public static Task RunConsoleAsync(this IHostBuilder hostBuilder, CancellationToken cancellationToken = default(CancellationToken));
         [UnsupportedOSPlatformAttribute("android")]
         [UnsupportedOSPlatformAttribute("browser")]
         [UnsupportedOSPlatformAttribute("ios")]
         [UnsupportedOSPlatformAttribute("tvos")]
         public static IHostBuilder UseConsoleLifetime(this IHostBuilder hostBuilder);
         [UnsupportedOSPlatformAttribute("android")]
         [UnsupportedOSPlatformAttribute("browser")]
         [UnsupportedOSPlatformAttribute("ios")]
         [UnsupportedOSPlatformAttribute("tvos")]
         public static IHostBuilder UseConsoleLifetime(this IHostBuilder hostBuilder, Action<ConsoleLifetimeOptions> configureOptions);
     }
 }
```

