# Microsoft.Extensions.Logging.Console

``` diff
 namespace Microsoft.Extensions.Logging.Console {
     public abstract class ConsoleFormatter {
-        public abstract void Write<TState>(in LogEntry<TState> logEntry, IExternalScopeProvider scopeProvider, TextWriter textWriter);
+        public abstract void Write<TState>(in LogEntry<TState> logEntry, IExternalScopeProvider? scopeProvider, TextWriter textWriter);
     }
     public class ConsoleFormatterOptions {
-        public string TimestampFormat { get; set; }
+        [StringSyntaxAttribute("DateTimeFormat")]
+        public string TimestampFormat { get; set; }
     }
     public class ConsoleLoggerOptions {
+        public int MaxQueueLength { get; set; }
+        public ConsoleLoggerQueueFullMode QueueFullMode { get; set; }
     }
     [ProviderAliasAttribute("Console")]
     [UnsupportedOSPlatformAttribute("browser")]
     public class ConsoleLoggerProvider : IDisposable, ILoggerProvider, ISupportExternalScope {
-        public ConsoleLoggerProvider(IOptionsMonitor<ConsoleLoggerOptions> options, IEnumerable<ConsoleFormatter> formatters);
+        public ConsoleLoggerProvider(IOptionsMonitor<ConsoleLoggerOptions> options, IEnumerable<ConsoleFormatter>? formatters);
     }
+    public enum ConsoleLoggerQueueFullMode {
+        DropWrite = 1,
+        Wait = 0,
+    }
 }
```

