# Microsoft.Extensions.Primitives

``` diff
 namespace Microsoft.Extensions.Primitives {
     public class CancellationChangeToken : IChangeToken {
-        public IDisposable RegisterChangeCallback(Action<object> callback, object state);
+        public IDisposable RegisterChangeCallback(Action<object?> callback, object? state);
     }
     public static class ChangeToken {
-        public static IDisposable OnChange(Func<IChangeToken> changeTokenProducer, Action changeTokenConsumer);
+        public static IDisposable OnChange(Func<IChangeToken?> changeTokenProducer, Action changeTokenConsumer);
-        public static IDisposable OnChange<TState>(Func<IChangeToken> changeTokenProducer, Action<TState> changeTokenConsumer, TState state);
+        public static IDisposable OnChange<TState>(Func<IChangeToken?> changeTokenProducer, Action<TState> changeTokenConsumer, TState state);
     }
     public class CompositeChangeToken : IChangeToken {
-        public IDisposable RegisterChangeCallback(Action<object> callback, object state);
+        public IDisposable RegisterChangeCallback(Action<object?> callback, object? state);
     }
     public interface IChangeToken {
-        IDisposable RegisterChangeCallback(Action<object> callback, object state);
+        IDisposable RegisterChangeCallback(Action<object?> callback, object? state);
     }
-    public readonly struct StringSegment : IEquatable<string>, IEquatable<StringSegment> {
+    public readonly struct StringSegment : IEquatable<string?>, IEquatable<StringSegment> {
-        public StringSegment(string buffer);
+        public StringSegment(string? buffer);
-        public string Buffer { get; }
+        public string? Buffer { get; }
-        public bool HasValue { get; }
+        [MemberNotNullWhenAttribute(true, "Buffer")]
+        [MemberNotNullWhenAttribute(true, "Value")]
+        public bool HasValue { [MemberNotNullWhenAttribute(true, "Buffer"), MemberNotNullWhenAttribute(true, "Value")] get; }
-        public string Value { get; }
+        public string? Value { get; }
-        public override bool Equals(object obj);
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
-        public bool Equals(string text);
+        public bool Equals(string? text);
-        public bool Equals(string text, StringComparison comparisonType);
+        public bool Equals(string? text, StringComparison comparisonType);
-        public static implicit operator StringSegment (string value);
+        public static implicit operator StringSegment (string? value);
     }
-    public readonly struct StringValues : ICollection<string>, IEnumerable, IEnumerable<string>, IEquatable<string>, IEquatable<StringValues>, IEquatable<string[]>, IList<string>, IReadOnlyCollection<string>, IReadOnlyList<string> {
+    public readonly struct StringValues : ICollection<string?>, IEnumerable, IEnumerable<string?>, IEquatable<string?>, IEquatable<StringValues>, IEquatable<string?[]>, IList<string?>, IReadOnlyCollection<string?>, IReadOnlyList<string?> {
-        bool System.Collections.Generic.ICollection<System.String>.IsReadOnly { get; }
+        bool ICollection<string?>.IsReadOnly { get; }
-        string System.Collections.Generic.IList<System.String>.this[int index] { get; set; }
+        string IList<string?>.this[int index] { get; set; }
-        void ICollection<string>.Add(string item);
+        void ICollection<string?>.Add(string item);
-        void ICollection<string>.Clear();
+        void ICollection<string?>.Clear();
-        bool ICollection<string>.Contains(string item);
+        bool ICollection<string?>.Contains(string item);
-        void ICollection<string>.CopyTo(string[] array, int arrayIndex);
+        void ICollection<string?>.CopyTo(string[] array, int arrayIndex);
-        bool ICollection<string>.Remove(string item);
+        bool ICollection<string?>.Remove(string item);
-        IEnumerator<string> IEnumerable<string>.GetEnumerator();
+        IEnumerator<string> IEnumerable<string?>.GetEnumerator();
-        int IList<string>.IndexOf(string item);
+        int IList<string?>.IndexOf(string item);
-        void IList<string>.Insert(int index, string item);
+        void IList<string?>.Insert(int index, string item);
-        void IList<string>.RemoveAt(int index);
+        void IList<string?>.RemoveAt(int index);
-        public string[] ToArray();
+        public string?[] ToArray();
-        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<string> {
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<string?> {
-            public string Current { get; }
+            public string? Current { get; }
-            object System.Collections.IEnumerator.Current { get; }
+            object? System.Collections.IEnumerator.Current { get; }
         }
     }
 }
```

