# Microsoft.JSInterop.Infrastructure

``` diff
 namespace Microsoft.JSInterop.Infrastructure {
-    [UnconditionalSuppressMessageAttribute("ReflectionAnalysis", "IL2070", Justification="Linker does not propogate annotations to generated state machine. https://github.com/mono/linker/issues/1403")]
-    public static class DotNetDispatcher {
+    public static class DotNetDispatcher {
-        public static void BeginInvokeDotNet(JSRuntime jsRuntime, DotNetInvocationInfo invocationInfo, string argsJson);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2026", Justification="We expect application code is configured to ensure return types of JSInvokable methods are retained.")]
+        public static void BeginInvokeDotNet(JSRuntime jsRuntime, DotNetInvocationInfo invocationInfo, string argsJson);
-        public static string? Invoke(JSRuntime jsRuntime, in DotNetInvocationInfo invocationInfo, string argsJson);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2026", Justification="We expect application code is configured to ensure return types of JSInvokable methods are retained.")]
+        public static string? Invoke(JSRuntime jsRuntime, in DotNetInvocationInfo invocationInfo, string argsJson);
     }
 }
```

