# System.Collections.Immutable

``` diff
 namespace System.Collections.Immutable {
     public static class ImmutableArray {
+        public static ImmutableArray<T> Create<T>(ReadOnlySpan<T> items);
+        public static ImmutableArray<T> Create<T>(Span<T> items);
+        public static ImmutableArray<T> ToImmutableArray<T>(this ReadOnlySpan<T> items);
+        public static ImmutableArray<T> ToImmutableArray<T>(this Span<T> items);
     }
     public readonly struct ImmutableArray<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IEquatable<ImmutableArray<T>>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IStructuralComparable, IStructuralEquatable {
+        public ImmutableArray<T> AddRange(ImmutableArray<T> items, int length);
+        public ImmutableArray<T> AddRange(ReadOnlySpan<T> items);
+        public ImmutableArray<T> AddRange(params T[] items);
+        public ImmutableArray<T> AddRange(T[] items, int length);
+        public ImmutableArray<T> AddRange<TDerived>(ImmutableArray<TDerived> items) where TDerived : T;
+        public ImmutableArray<T> AddRange<TDerived>(TDerived[] items) where TDerived : T;
+        public ReadOnlySpan<T> AsSpan(int start, int length);
+        public ReadOnlySpan<T> AsSpan(Range range);
+        public void CopyTo(Span<T> destination);
+        public ImmutableArray<T> InsertRange(int index, ReadOnlySpan<T> items);
+        public ImmutableArray<T> InsertRange(int index, T[] items);
+        public ImmutableArray<T> RemoveRange(ReadOnlySpan<T> items, IEqualityComparer<T>? equalityComparer = null);
+        public ImmutableArray<T> RemoveRange(T[] items, IEqualityComparer<T>? equalityComparer = null);
+        public ImmutableArray<T> Slice(int start, int length);
         public sealed class Builder : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public void AddRange(ReadOnlySpan<T> items);
+            public void AddRange<TDerived>(ReadOnlySpan<TDerived> items) where TDerived : T;
+            public void CopyTo(int sourceIndex, T[] destination, int destinationIndex, int length);
+            public void CopyTo(Span<T> destination);
+            public void CopyTo(T[] destination);
+            public int IndexOf(T item, int startIndex, IEqualityComparer<T>? equalityComparer);
+            public void InsertRange(int index, IEnumerable<T> items);
+            public void InsertRange(int index, ImmutableArray<T> items);
+            public bool Remove(T element, IEqualityComparer<T>? equalityComparer);
+            public void RemoveAll(Predicate<T> match);
+            public void RemoveRange(IEnumerable<T> items);
+            public void RemoveRange(IEnumerable<T> items, IEqualityComparer<T>? equalityComparer);
+            public void RemoveRange(int index, int length);
+            public void Replace(T oldValue, T newValue);
+            public void Replace(T oldValue, T newValue, IEqualityComparer<T>? equalityComparer);
         }
     }
     public sealed class ImmutableList<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
         public sealed class Builder : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public bool Remove(T item, IEqualityComparer<T>? equalityComparer);
+            public void RemoveRange(IEnumerable<T> items);
+            public void RemoveRange(IEnumerable<T> items, IEqualityComparer<T>? equalityComparer);
+            public void RemoveRange(int index, int count);
+            public void Replace(T oldValue, T newValue);
+            public void Replace(T oldValue, T newValue, IEqualityComparer<T>? equalityComparer);
         }
     }
     public sealed class ImmutableSortedSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableSet<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IReadOnlySet<T>, ISet<T> {
         public sealed class Builder : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISet<T> {
+            public int IndexOf(T item);
         }
     }
 }
```

