# System.ComponentModel

``` diff
 namespace System.ComponentModel {
     public abstract class BaseNumberConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public class CultureInfoConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public abstract class CustomTypeDescriptor : ICustomTypeDescriptor {
-        protected CustomTypeDescriptor(ICustomTypeDescriptor? parent);
+        protected CustomTypeDescriptor(ICustomTypeDescriptor parent);
-        public virtual string? GetClassName();
+        public virtual string GetClassName();
-        public virtual string? GetComponentName();
+        public virtual string GetComponentName();
-        [RequiresUnreferencedCodeAttribute("The built-in EventDescriptor implementation uses Reflection which requires unreferenced code.")]
-        public virtual EventDescriptor? GetDefaultEvent();
+        [RequiresUnreferencedCodeAttribute("The built-in EventDescriptor implementation uses Reflection which requires unreferenced code.")]
+        public virtual EventDescriptor GetDefaultEvent();
-        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered.")]
-        public virtual PropertyDescriptor? GetDefaultProperty();
+        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered.")]
+        public virtual PropertyDescriptor GetDefaultProperty();
-        public virtual object? GetPropertyOwner(PropertyDescriptor? pd);
+        public virtual object GetPropertyOwner(PropertyDescriptor pd);
     }
+    public class DateOnlyConverter : TypeConverter {
+        public DateOnlyConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
     public class DateTimeConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public class DateTimeOffsetConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public class DecimalConverter : BaseNumberConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public class EnumConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public class GuidConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
+    public class HalfConverter : BaseNumberConverter {
+        public HalfConverter();
+    }
-    public interface IComNativeDescriptorHandler
+    [ObsoleteAttribute("IComNativeDescriptorHandler has been deprecated. Add a TypeDescriptionProvider to handle type TypeDescriptor.ComObjectType instead.")]
+    public interface IComNativeDescriptorHandler
     public interface ICustomTypeDescriptor {
-        [RequiresUnreferencedCodeAttribute("Generic TypeConverters may require the generic types to be annotated. For example, NullableConverter requires the underlying type to be DynamicallyAccessedMembers All.")]
-        TypeConverter GetConverter();
+        [RequiresUnreferencedCodeAttribute("Generic TypeConverters may require the generic types to be annotated. For example, NullableConverter requires the underlying type to be DynamicallyAccessedMembers All.")]
+        TypeConverter? GetConverter();
     }
+    public class Int128Converter : BaseNumberConverter {
+        public Int128Converter();
+    }
     public abstract class MemberDescriptor {
-        protected static object GetInvokee(Type componentClass, object component);
+        [ObsoleteAttribute("MemberDescriptor.GetInvokee has been deprecated. Use GetInvocationTarget instead.")]
+        protected static object GetInvokee(Type componentClass, object component);
     }
     public class NullableConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
-    [AttributeUsageAttribute(AttributeTargets.Property)]
-    public class RecommendedAsConfigurableAttribute : Attribute
+    [AttributeUsageAttribute(AttributeTargets.Property)]
+    [ObsoleteAttribute("RecommendedAsConfigurableAttribute has been deprecated. Use System.ComponentModel.SettingsBindableAttribute instead.")]
+    public class RecommendedAsConfigurableAttribute : Attribute
+    public class TimeOnlyConverter : TypeConverter {
+        public TimeOnlyConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
     public class TimeSpanConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public class TypeConverter {
-        public virtual bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public virtual bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
-        public bool CanConvertTo(Type destinationType);
+        public bool CanConvertTo([NotNullWhenAttribute(true)] Type destinationType);
     }
     public sealed class TypeDescriptor {
-        public static Type ComObjectType { get; }
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static Type ComObjectType { get; }
-        public static Type InterfaceType { get; }
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static Type InterfaceType { get; }
-        public static TypeDescriptionProvider AddAttributes(object instance, params Attribute[] attributes);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static TypeDescriptionProvider AddAttributes(object instance, params Attribute[] attributes);
-        public static TypeDescriptionProvider AddAttributes(Type type, params Attribute[] attributes);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static TypeDescriptionProvider AddAttributes(Type type, params Attribute[] attributes);
-        [RequiresUnreferencedCodeAttribute("The Types specified in table may be trimmed, or have their static construtors trimmed.")]
-        public static void AddEditorTable(Type editorBaseType, Hashtable table);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("The Types specified in table may be trimmed, or have their static construtors trimmed.")]
+        public static void AddEditorTable(Type editorBaseType, Hashtable table);
-        public static void AddProvider(TypeDescriptionProvider provider, object instance);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void AddProvider(TypeDescriptionProvider provider, object instance);
-        public static void AddProvider(TypeDescriptionProvider provider, Type type);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void AddProvider(TypeDescriptionProvider provider, Type type);
-        public static void AddProviderTransparent(TypeDescriptionProvider provider, object instance);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void AddProviderTransparent(TypeDescriptionProvider provider, object instance);
-        public static void AddProviderTransparent(TypeDescriptionProvider provider, Type type);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void AddProviderTransparent(TypeDescriptionProvider provider, Type type);
-        public static void CreateAssociation(object primary, object secondary);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void CreateAssociation(object primary, object secondary);
-        public static object GetAssociation(Type type, object primary);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static object GetAssociation(Type type, object primary);
-        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
-        public static AttributeCollection GetAttributes(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
+        public static AttributeCollection GetAttributes(object component, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
-        public static string? GetClassName(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
+        public static string? GetClassName(object component, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
-        public static string? GetComponentName(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
+        public static string? GetComponentName(object component, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("Generic TypeConverters may require the generic types to be annotated. For example, NullableConverter requires the underlying type to be DynamicallyAccessedMembers All. The Type of component cannot be statically discovered.")]
-        public static TypeConverter GetConverter(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("Generic TypeConverters may require the generic types to be annotated. For example, NullableConverter requires the underlying type to be DynamicallyAccessedMembers All. The Type of component cannot be statically discovered.")]
+        public static TypeConverter GetConverter(object component, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("The built-in EventDescriptor implementation uses Reflection which requires unreferenced code. The Type of component cannot be statically discovered.")]
-        public static EventDescriptor? GetDefaultEvent(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("The built-in EventDescriptor implementation uses Reflection which requires unreferenced code. The Type of component cannot be statically discovered.")]
+        public static EventDescriptor? GetDefaultEvent(object component, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered. The Type of component cannot be statically discovered.")]
-        public static PropertyDescriptor? GetDefaultProperty(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered. The Type of component cannot be statically discovered.")]
+        public static PropertyDescriptor? GetDefaultProperty(object component, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("Editors registered in TypeDescriptor.AddEditorTable may be trimmed. The Type of component cannot be statically discovered.")]
-        public static object? GetEditor(object component, Type editorBaseType, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("Editors registered in TypeDescriptor.AddEditorTable may be trimmed. The Type of component cannot be statically discovered.")]
+        public static object? GetEditor(object component, Type editorBaseType, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
-        public static EventDescriptorCollection GetEvents(object component, Attribute[]? attributes, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+        public static EventDescriptorCollection GetEvents(object component, Attribute[]? attributes, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
-        public static EventDescriptorCollection GetEvents(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("The Type of component cannot be statically discovered.")]
+        public static EventDescriptorCollection GetEvents(object component, bool noCustomTypeDesc);
-        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered. The Type of component cannot be statically discovered.")]
-        public static PropertyDescriptorCollection GetProperties(object component, bool noCustomTypeDesc);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered. The Type of component cannot be statically discovered.")]
+        public static PropertyDescriptorCollection GetProperties(object component, bool noCustomTypeDesc);
-        public static TypeDescriptionProvider GetProvider(object instance);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static TypeDescriptionProvider GetProvider(object instance);
-        public static TypeDescriptionProvider GetProvider(Type type);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static TypeDescriptionProvider GetProvider(Type type);
-        [RequiresUnreferencedCodeAttribute("GetReflectionType is not trim compatible because the Type of object cannot be statically discovered.")]
-        public static Type GetReflectionType(object instance);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        [RequiresUnreferencedCodeAttribute("GetReflectionType is not trim compatible because the Type of object cannot be statically discovered.")]
+        public static Type GetReflectionType(object instance);
-        public static Type GetReflectionType(Type type);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static Type GetReflectionType(Type type);
-        public static void RemoveAssociation(object primary, object secondary);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void RemoveAssociation(object primary, object secondary);
-        public static void RemoveAssociations(object primary);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void RemoveAssociations(object primary);
-        public static void RemoveProvider(TypeDescriptionProvider provider, object instance);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void RemoveProvider(TypeDescriptionProvider provider, object instance);
-        public static void RemoveProvider(TypeDescriptionProvider provider, Type type);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void RemoveProvider(TypeDescriptionProvider provider, Type type);
-        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, object instance);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, object instance);
-        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, Type type);
+        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
+        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, Type type);
     }
     public abstract class TypeListConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
+    public class UInt128Converter : BaseNumberConverter {
+        public UInt128Converter();
+    }
     public class VersionConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
 }
```

