# System.Diagnostics.CodeAnalysis

``` diff
 namespace System.Diagnostics.CodeAnalysis {
+    [AttributeUsageAttribute(AttributeTargets.Parameter, Inherited=false)]
+    public sealed class ConstantExpectedAttribute : Attribute {
+        public ConstantExpectedAttribute();
+        public object Max { get; set; }
+        public object Min { get; set; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Constructor | AttributeTargets.Method, Inherited=false)]
+    public sealed class RequiresDynamicCodeAttribute : Attribute {
+        public RequiresDynamicCodeAttribute(string message);
+        public string Message { get; }
+        public string? Url { get; set; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.Constructor, AllowMultiple=false, Inherited=false)]
+    public sealed class SetsRequiredMembersAttribute : Attribute {
+        public SetsRequiredMembersAttribute();
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false, Inherited=false)]
+    public sealed class StringSyntaxAttribute : Attribute {
+        public const string CompositeFormat = "CompositeFormat";
+        public const string DateOnlyFormat = "DateOnlyFormat";
+        public const string DateTimeFormat = "DateTimeFormat";
+        public const string EnumFormat = "EnumFormat";
+        public const string GuidFormat = "GuidFormat";
+        public const string Json = "Json";
+        public const string NumericFormat = "NumericFormat";
+        public const string Regex = "Regex";
+        public const string TimeOnlyFormat = "TimeOnlyFormat";
+        public const string TimeSpanFormat = "TimeSpanFormat";
+        public const string Uri = "Uri";
+        public const string Xml = "Xml";
+        public StringSyntaxAttribute(string syntax);
+        public StringSyntaxAttribute(string syntax, params object?[] arguments);
+        public object?[] Arguments { get; }
+        public string Syntax { get; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.Method | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false, Inherited=false)]
+    public sealed class UnscopedRefAttribute : Attribute {
+        public UnscopedRefAttribute();
+    }
 }
```

