# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public class Activity : IDisposable {
+        public bool HasRemoteParent { get; }
+        public bool IsStopped { get; }
+        public static event EventHandler<ActivityChangedEventArgs>? CurrentChanged;
+        public Activity.Enumerator<ActivityEvent> EnumerateEvents();
+        public Activity.Enumerator<ActivityLink> EnumerateLinks();
+        public Activity.Enumerator<KeyValuePair<string, object?>> EnumerateTagObjects();
+        public struct Enumerator<T> {
+            public ref T Current { get; }
+            [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+            public Activity.Enumerator<T> GetEnumerator();
+            public bool MoveNext();
+        }
     }
+    public readonly struct ActivityChangedEventArgs {
+        public Activity Current { get; set; }
+        public Activity Previous { get; set; }
+    }
     public readonly struct ActivityContext : IEquatable<ActivityContext> {
+        public static bool TryParse(string traceParent, string traceState, bool isRemote, out ActivityContext context);
     }
     public readonly struct ActivityCreationOptions<T> {
+        public string? TraceState { get; set; }
     }
     public readonly struct ActivityEvent {
+        public Activity.Enumerator<KeyValuePair<string, object?>> EnumerateTagObjects();
     }
     public readonly struct ActivityLink : IEquatable<ActivityLink> {
+        public Activity.Enumerator<KeyValuePair<string, object?>> EnumerateTagObjects();
     }
     public sealed class ActivitySource : IDisposable {
-        public string? Version { get; }
+        public string Version { get; }
-        public Activity? CreateActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink>? links = null, ActivityIdFormat idFormat = ActivityIdFormat.Unknown);
+        public Activity CreateActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink> links = null, ActivityIdFormat idFormat = ActivityIdFormat.Unknown);
-        public Activity? CreateActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink>? links = null, ActivityIdFormat idFormat = ActivityIdFormat.Unknown);
+        public Activity CreateActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink> links = null, ActivityIdFormat idFormat = ActivityIdFormat.Unknown);
-        public Activity? StartActivity(ActivityKind kind, ActivityContext parentContext = default(ActivityContext), IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink>? links = null, DateTimeOffset startTime = default(DateTimeOffset), [CallerMemberNameAttribute] string name = "");
+        public Activity StartActivity(ActivityKind kind, ActivityContext parentContext = default(ActivityContext), IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset), [CallerMemberNameAttribute] string name = "");
-        public Activity? StartActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink>? links = null, DateTimeOffset startTime = default(DateTimeOffset));
+        public Activity StartActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
-        public Activity? StartActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink>? links = null, DateTimeOffset startTime = default(DateTimeOffset));
+        public Activity StartActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object?>>? tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
     }
     public static class Debug {
-        [ConditionalAttribute("DEBUG")]
-        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, string? message, string detailMessageFormat, params object?[] args);
+        [ConditionalAttribute("DEBUG")]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, string? message, [StringSyntaxAttribute("CompositeFormat")] string detailMessageFormat, params object?[] args);
-        [ConditionalAttribute("DEBUG")]
-        public static void Print(string format, params object?[] args);
+        [ConditionalAttribute("DEBUG")]
+        public static void Print([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] args);
-        [ConditionalAttribute("DEBUG")]
-        public static void WriteLine(string format, params object?[] args);
+        [ConditionalAttribute("DEBUG")]
+        public static void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] args);
     }
     public class DelimitedListTraceListener : TextWriterTraceListener {
-        public override void TraceEvent(TraceEventCache? eventCache, string source, TraceEventType eventType, int id, string? format, params object?[]? args);
+        public override void TraceEvent(TraceEventCache? eventCache, string source, TraceEventType eventType, int id, [StringSyntaxAttribute("CompositeFormat")] string? format, params object?[]? args);
     }
     public class EventTypeFilter : TraceFilter {
-        public override bool ShouldTrace(TraceEventCache? cache, string source, TraceEventType eventType, int id, string? formatOrMessage, object?[]? args, object? data1, object?[]? data);
+        public override bool ShouldTrace(TraceEventCache? cache, string source, TraceEventType eventType, int id, [StringSyntaxAttribute("CompositeFormat")] string? formatOrMessage, object?[]? args, object? data1, object?[]? data);
     }
+    public sealed class InitializingSwitchEventArgs : EventArgs {
+        public InitializingSwitchEventArgs(Switch @switch);
+        public Switch Switch { get; }
+    }
+    public sealed class InitializingTraceSourceEventArgs : EventArgs {
+        public InitializingTraceSourceEventArgs(TraceSource traceSource);
+        public TraceSource TraceSource { get; }
+        public bool WasInitialized { get; set; }
+    }
     [DesignerAttribute("System.Diagnostics.Design.ProcessDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class Process : Component, IDisposable {
-        public IntPtr MaxWorkingSet { [UnsupportedOSPlatformAttribute("ios"), UnsupportedOSPlatformAttribute("tvos")] get; [SupportedOSPlatformAttribute("freebsd"), SupportedOSPlatformAttribute("macos"), SupportedOSPlatformAttribute("windows")] set; }
+        public IntPtr MaxWorkingSet { [SupportedOSPlatformAttribute("maccatalyst"), UnsupportedOSPlatformAttribute("ios"), UnsupportedOSPlatformAttribute("tvos")] get; [SupportedOSPlatformAttribute("freebsd"), SupportedOSPlatformAttribute("maccatalyst"), SupportedOSPlatformAttribute("macos"), SupportedOSPlatformAttribute("windows")] set; }
-        public IntPtr MinWorkingSet { [UnsupportedOSPlatformAttribute("ios"), UnsupportedOSPlatformAttribute("tvos")] get; [SupportedOSPlatformAttribute("freebsd"), SupportedOSPlatformAttribute("macos"), SupportedOSPlatformAttribute("windows")] set; }
+        public IntPtr MinWorkingSet { [SupportedOSPlatformAttribute("maccatalyst"), UnsupportedOSPlatformAttribute("ios"), UnsupportedOSPlatformAttribute("tvos")] get; [SupportedOSPlatformAttribute("freebsd"), SupportedOSPlatformAttribute("maccatalyst"), SupportedOSPlatformAttribute("macos"), SupportedOSPlatformAttribute("windows")] set; }
-        public TimeSpan PrivilegedProcessorTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public TimeSpan PrivilegedProcessorTime { get; }
-        public DateTime StartTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public DateTime StartTime { get; }
-        public TimeSpan TotalProcessorTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public TimeSpan TotalProcessorTime { get; }
-        public TimeSpan UserProcessorTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public TimeSpan UserProcessorTime { get; }
-        public static Process[] GetProcesses();
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process[] GetProcesses();
-        public static Process[] GetProcesses(string machineName);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process[] GetProcesses(string machineName);
-        public static Process[] GetProcessesByName(string? processName);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process[] GetProcessesByName(string? processName);
-        public static Process[] GetProcessesByName(string? processName, string machineName);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process[] GetProcessesByName(string? processName, string machineName);
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public void Kill();
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public void Kill();
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public void Kill(bool entireProcessTree);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public void Kill(bool entireProcessTree);
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public bool Start();
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public bool Start();
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public static Process? Start(ProcessStartInfo startInfo);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process? Start(ProcessStartInfo startInfo);
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public static Process Start(string fileName);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process Start(string fileName);
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public static Process Start(string fileName, IEnumerable<string> arguments);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process Start(string fileName, IEnumerable<string> arguments);
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public static Process Start(string fileName, string arguments);
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Process Start(string fileName, string arguments);
+        public bool WaitForExit(TimeSpan timeout);
+        public bool WaitForInputIdle(TimeSpan timeout);
     }
     [DesignerAttribute("System.Diagnostics.Design.ProcessThreadDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ProcessThread : Component {
-        public TimeSpan PrivilegedProcessorTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public TimeSpan PrivilegedProcessorTime { get; }
-        public TimeSpan TotalProcessorTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public TimeSpan TotalProcessorTime { get; }
-        public TimeSpan UserProcessorTime { get; }
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public TimeSpan UserProcessorTime { get; }
     }
     public class SourceFilter : TraceFilter {
-        public override bool ShouldTrace(TraceEventCache? cache, string source, TraceEventType eventType, int id, string? formatOrMessage, object?[]? args, object? data1, object?[]? data);
+        public override bool ShouldTrace(TraceEventCache? cache, string source, TraceEventType eventType, int id, [StringSyntaxAttribute("CompositeFormat")] string? formatOrMessage, object?[]? args, object? data1, object?[]? data);
     }
     public class StackFrame {
-        public virtual MethodBase GetMethod();
+        [RequiresUnreferencedCodeAttribute("Metadata for the method might be incomplete or removed")]
+        public virtual MethodBase GetMethod();
     }
     public class Stopwatch {
+        public static TimeSpan GetElapsedTime(long startingTimestamp);
+        public static TimeSpan GetElapsedTime(long startingTimestamp, long endingTimestamp);
     }
     public abstract class Switch {
+        public string DefaultValue { get; }
-        protected string Value { get; set; }
+        public string Value { get; set; }
+        public static event EventHandler<InitializingSwitchEventArgs>? Initializing;
+        public void Refresh();
     }
     public sealed class Trace {
+        public static event EventHandler Refreshing;
-        [ConditionalAttribute("TRACE")]
-        public static void TraceError(string format, params object?[]? args);
+        [ConditionalAttribute("TRACE")]
+        public static void TraceError([StringSyntaxAttribute("CompositeFormat")] string format, params object?[]? args);
-        [ConditionalAttribute("TRACE")]
-        public static void TraceInformation(string format, params object?[]? args);
+        [ConditionalAttribute("TRACE")]
+        public static void TraceInformation([StringSyntaxAttribute("CompositeFormat")] string format, params object?[]? args);
-        [ConditionalAttribute("TRACE")]
-        public static void TraceWarning(string format, params object?[]? args);
+        [ConditionalAttribute("TRACE")]
+        public static void TraceWarning([StringSyntaxAttribute("CompositeFormat")] string format, params object?[]? args);
     }
     public abstract class TraceFilter {
-        public abstract bool ShouldTrace(TraceEventCache? cache, string source, TraceEventType eventType, int id, string? formatOrMessage, object?[]? args, object? data1, object?[]? data);
+        public abstract bool ShouldTrace(TraceEventCache? cache, string source, TraceEventType eventType, int id, [StringSyntaxAttribute("CompositeFormat")] string? formatOrMessage, object?[]? args, object? data1, object?[]? data);
     }
     public abstract class TraceListener : MarshalByRefObject, IDisposable {
-        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
+        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, [StringSyntaxAttribute("CompositeFormat")] string format, params object[] args);
     }
     public class TraceSource {
+        public SourceLevels DefaultLevel { get; }
+        public static event EventHandler<InitializingTraceSourceEventArgs>? Initializing;
-        [ConditionalAttribute("TRACE")]
-        public void TraceEvent(TraceEventType eventType, int id, string? format, params object?[]? args);
+        [ConditionalAttribute("TRACE")]
+        public void TraceEvent(TraceEventType eventType, int id, [StringSyntaxAttribute("CompositeFormat")] string? format, params object?[]? args);
-        [ConditionalAttribute("TRACE")]
-        public void TraceInformation(string? format, params object?[]? args);
+        [ConditionalAttribute("TRACE")]
+        public void TraceInformation([StringSyntaxAttribute("CompositeFormat")] string? format, params object?[]? args);
     }
+    public sealed class UnreachableException : Exception {
+        public UnreachableException();
+        public UnreachableException(string message);
+        public UnreachableException(string message, Exception innerException);
+    }
     public class XmlWriterTraceListener : TextWriterTraceListener {
-        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, [StringSyntaxAttribute("CompositeFormat")] string format, params object[] args);
     }
 }
```

