# System.Formats.Tar

``` diff
+namespace System.Formats.Tar {
+    public sealed class GnuTarEntry : PosixTarEntry {
+        public GnuTarEntry(TarEntry other);
+        public GnuTarEntry(TarEntryType entryType, string entryName);
+        public DateTimeOffset AccessTime { get; set; }
+        public DateTimeOffset ChangeTime { get; set; }
+    }
+    public sealed class PaxGlobalExtendedAttributesTarEntry : PosixTarEntry {
+        public PaxGlobalExtendedAttributesTarEntry(IEnumerable<KeyValuePair<string, string>> globalExtendedAttributes);
+        public IReadOnlyDictionary<string, string> GlobalExtendedAttributes { get; }
+    }
+    public sealed class PaxTarEntry : PosixTarEntry {
+        public PaxTarEntry(TarEntry other);
+        public PaxTarEntry(TarEntryType entryType, string entryName);
+        public PaxTarEntry(TarEntryType entryType, string entryName, IEnumerable<KeyValuePair<string, string>> extendedAttributes);
+        public IReadOnlyDictionary<string, string> ExtendedAttributes { get; }
+    }
+    public abstract class PosixTarEntry : TarEntry {
+        public int DeviceMajor { get; set; }
+        public int DeviceMinor { get; set; }
+        public string GroupName { get; set; }
+        public string UserName { get; set; }
+    }
+    public abstract class TarEntry {
+        public int Checksum { get; }
+        public Stream? DataStream { get; set; }
+        public TarEntryType EntryType { get; }
+        public TarEntryFormat Format { get; }
+        public int Gid { get; set; }
+        public long Length { get; }
+        public string LinkName { get; set; }
+        public UnixFileMode Mode { get; set; }
+        public DateTimeOffset ModificationTime { get; set; }
+        public string Name { get; set; }
+        public int Uid { get; set; }
+        public void ExtractToFile(string destinationFileName, bool overwrite);
+        public Task ExtractToFileAsync(string destinationFileName, bool overwrite, CancellationToken cancellationToken = default(CancellationToken));
+        public override string ToString();
+    }
+    public enum TarEntryFormat {
+        Gnu = 4,
+        Pax = 3,
+        Unknown = 0,
+        Ustar = 2,
+        V7 = 1,
+    }
+    public enum TarEntryType : byte {
+        BlockDevice = (byte)52,
+        CharacterDevice = (byte)51,
+        ContiguousFile = (byte)55,
+        Directory = (byte)53,
+        DirectoryList = (byte)68,
+        ExtendedAttributes = (byte)120,
+        Fifo = (byte)54,
+        GlobalExtendedAttributes = (byte)103,
+        HardLink = (byte)49,
+        LongLink = (byte)75,
+        LongPath = (byte)76,
+        MultiVolume = (byte)77,
+        RegularFile = (byte)48,
+        RenamedOrSymlinked = (byte)78,
+        SparseFile = (byte)83,
+        SymbolicLink = (byte)50,
+        TapeVolume = (byte)86,
+        V7RegularFile = (byte)0,
+    }
+    public static class TarFile {
+        public static void CreateFromDirectory(string sourceDirectoryName, Stream destination, bool includeBaseDirectory);
+        public static void CreateFromDirectory(string sourceDirectoryName, string destinationFileName, bool includeBaseDirectory);
+        public static Task CreateFromDirectoryAsync(string sourceDirectoryName, Stream destination, bool includeBaseDirectory, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task CreateFromDirectoryAsync(string sourceDirectoryName, string destinationFileName, bool includeBaseDirectory, CancellationToken cancellationToken = default(CancellationToken));
+        public static void ExtractToDirectory(Stream source, string destinationDirectoryName, bool overwriteFiles);
+        public static void ExtractToDirectory(string sourceFileName, string destinationDirectoryName, bool overwriteFiles);
+        public static Task ExtractToDirectoryAsync(Stream source, string destinationDirectoryName, bool overwriteFiles, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task ExtractToDirectoryAsync(string sourceFileName, string destinationDirectoryName, bool overwriteFiles, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class TarReader : IAsyncDisposable, IDisposable {
+        public TarReader(Stream archiveStream, bool leaveOpen = false);
+        public void Dispose();
+        public ValueTask DisposeAsync();
+        public TarEntry? GetNextEntry(bool copyData = false);
+        public ValueTask<TarEntry?> GetNextEntryAsync(bool copyData = false, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class TarWriter : IAsyncDisposable, IDisposable {
+        public TarWriter(Stream archiveStream);
+        public TarWriter(Stream archiveStream, bool leaveOpen = false);
+        public TarWriter(Stream archiveStream, TarEntryFormat format = TarEntryFormat.Pax, bool leaveOpen = false);
+        public TarEntryFormat Format { get; }
+        public void Dispose();
+        public ValueTask DisposeAsync();
+        public void WriteEntry(TarEntry entry);
+        public void WriteEntry(string fileName, string? entryName);
+        public Task WriteEntryAsync(TarEntry entry, CancellationToken cancellationToken = default(CancellationToken));
+        public Task WriteEntryAsync(string fileName, string? entryName, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class UstarTarEntry : PosixTarEntry {
+        public UstarTarEntry(TarEntry other);
+        public UstarTarEntry(TarEntryType entryType, string entryName);
+    }
+    public sealed class V7TarEntry : TarEntry {
+        public V7TarEntry(TarEntry other);
+        public V7TarEntry(TarEntryType entryType, string entryName);
+    }
+}
```

