# System.IO

``` diff
 namespace System.IO {
     public static class Directory {
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static DirectoryInfo CreateDirectory(string path, UnixFileMode unixCreateMode);
+        public static DirectoryInfo CreateTempSubdirectory(string? prefix = null);
     }
     public static class File {
+        public static FileAttributes GetAttributes(SafeFileHandle fileHandle);
+        public static DateTime GetCreationTime(SafeFileHandle fileHandle);
+        public static DateTime GetCreationTimeUtc(SafeFileHandle fileHandle);
+        public static DateTime GetLastAccessTime(SafeFileHandle fileHandle);
+        public static DateTime GetLastAccessTimeUtc(SafeFileHandle fileHandle);
+        public static DateTime GetLastWriteTime(SafeFileHandle fileHandle);
+        public static DateTime GetLastWriteTimeUtc(SafeFileHandle fileHandle);
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static UnixFileMode GetUnixFileMode(SafeFileHandle fileHandle);
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static UnixFileMode GetUnixFileMode(string path);
+        public static IAsyncEnumerable<string> ReadLinesAsync(string path, Encoding encoding, CancellationToken cancellationToken = default(CancellationToken));
+        public static IAsyncEnumerable<string> ReadLinesAsync(string path, CancellationToken cancellationToken = default(CancellationToken));
+        public static void SetAttributes(SafeFileHandle fileHandle, FileAttributes fileAttributes);
+        public static void SetCreationTime(SafeFileHandle fileHandle, DateTime creationTime);
+        public static void SetCreationTimeUtc(SafeFileHandle fileHandle, DateTime creationTimeUtc);
+        public static void SetLastAccessTime(SafeFileHandle fileHandle, DateTime lastAccessTime);
+        public static void SetLastAccessTimeUtc(SafeFileHandle fileHandle, DateTime lastAccessTimeUtc);
+        public static void SetLastWriteTime(SafeFileHandle fileHandle, DateTime lastWriteTime);
+        public static void SetLastWriteTimeUtc(SafeFileHandle fileHandle, DateTime lastWriteTimeUtc);
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static void SetUnixFileMode(SafeFileHandle fileHandle, UnixFileMode mode);
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static void SetUnixFileMode(string path, UnixFileMode mode);
     }
     public sealed class FileInfo : FileSystemInfo {
-        public override string ToString();
     }
     public class FileStream : Stream {
+        [UnsupportedOSPlatformAttribute("freebsd")]
        public virtual void Lock(long position, long length);
+        [UnsupportedOSPlatformAttribute("freebsd")]
        public virtual void Unlock(long position, long length);
     }
     public sealed class FileStreamOptions {
+        public UnixFileMode? UnixCreateMode { get; [UnsupportedOSPlatformAttribute("windows")] set; }
     }
     public static class FileSystemAclExtensions {
-        public static FileStream Create(this FileInfo fileInfo, FileMode mode, FileSystemRights rights, FileShare share, int bufferSize, FileOptions options, FileSecurity fileSecurity);
+        public static FileStream Create(this FileInfo fileInfo, FileMode mode, FileSystemRights rights, FileShare share, int bufferSize, FileOptions options, FileSecurity? fileSecurity);
     }
     public abstract class FileSystemInfo : MarshalByRefObject, ISerializable {
+        public UnixFileMode UnixFileMode { get; [UnsupportedOSPlatformAttribute("windows")] set; }
     }
     public class FileSystemWatcher : Component, ISupportInitialize {
+        public WaitForChangedResult WaitForChanged(WatcherChangeTypes changeType, TimeSpan timeout);
     }
     public static class Path {
+        public static bool Exists([NotNullWhenAttribute(true)] string? path);
     }
     public static class RandomAccess {
+        public static void SetLength(SafeFileHandle handle, long length);
     }
     public abstract class Stream : MarshalByRefObject, IAsyncDisposable, IDisposable {
+        public int ReadAtLeast(Span<byte> buffer, int minimumBytes, bool throwOnEndOfStream = true);
+        public ValueTask<int> ReadAtLeastAsync(Memory<byte> buffer, int minimumBytes, bool throwOnEndOfStream = true, CancellationToken cancellationToken = default(CancellationToken));
+        public void ReadExactly(byte[] buffer, int offset, int count);
+        public void ReadExactly(Span<byte> buffer);
+        public ValueTask ReadExactlyAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask ReadExactlyAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class StreamReader : TextReader {
+        public override ValueTask<string?> ReadLineAsync(CancellationToken cancellationToken);
+        public override Task<string> ReadToEndAsync(CancellationToken cancellationToken);
     }
     public class StreamWriter : TextWriter {
-        public override void Write(string format, object? arg0);
+        public override void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public override void Write(string format, object? arg0, object? arg1);
+        public override void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public override void Write(string format, object? arg0, object? arg1, object? arg2);
+        public override void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public override void Write(string format, params object?[] arg);
+        public override void Write([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] arg);
-        public override void WriteLine(string format, object? arg0);
+        public override void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public override void WriteLine(string format, object? arg0, object? arg1);
+        public override void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public override void WriteLine(string format, object? arg0, object? arg1, object? arg2);
+        public override void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public override void WriteLine(string format, params object?[] arg);
+        public override void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] arg);
     }
     public class StringReader : TextReader {
+        public override ValueTask<string?> ReadLineAsync(CancellationToken cancellationToken);
+        public override Task<string> ReadToEndAsync(CancellationToken cancellationToken);
     }
     public abstract class TextReader : MarshalByRefObject, IDisposable {
+        public virtual ValueTask<string?> ReadLineAsync(CancellationToken cancellationToken);
+        public virtual Task<string> ReadToEndAsync(CancellationToken cancellationToken);
     }
     public abstract class TextWriter : MarshalByRefObject, IAsyncDisposable, IDisposable {
-        public virtual void Write(string format, object? arg0);
+        public virtual void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public virtual void Write(string format, object? arg0, object? arg1);
+        public virtual void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public virtual void Write(string format, object? arg0, object? arg1, object? arg2);
+        public virtual void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public virtual void Write(string format, params object?[] arg);
+        public virtual void Write([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] arg);
-        public virtual void WriteLine(string format, object? arg0);
+        public virtual void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public virtual void WriteLine(string format, object? arg0, object? arg1);
+        public virtual void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public virtual void WriteLine(string format, object? arg0, object? arg1, object? arg2);
+        public virtual void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public virtual void WriteLine(string format, params object?[] arg);
+        public virtual void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] arg);
     }
+    [FlagsAttribute]
+    public enum UnixFileMode {
+        GroupExecute = 8,
+        GroupRead = 32,
+        GroupWrite = 16,
+        None = 0,
+        OtherExecute = 1,
+        OtherRead = 4,
+        OtherWrite = 2,
+        SetGroup = 1024,
+        SetUser = 2048,
+        StickyBit = 512,
+        UserExecute = 64,
+        UserRead = 256,
+        UserWrite = 128,
+    }
 }
```

