# System.Linq

``` diff
 namespace System.Linq {
     public static class Enumerable {
+        public static IOrderedEnumerable<T> Order<T>(this IEnumerable<T> source);
+        public static IOrderedEnumerable<T> Order<T>(this IEnumerable<T> source, IComparer<T>? comparer);
+        public static IOrderedEnumerable<T> OrderDescending<T>(this IEnumerable<T> source);
+        public static IOrderedEnumerable<T> OrderDescending<T>(this IEnumerable<T> source, IComparer<T>? comparer);
     }
-    public class EnumerableQuery<T> : EnumerableQuery, IEnumerable, IEnumerable<T>, IOrderedQueryable, IOrderedQueryable<T>, IQueryable, IQueryable<T>, IQueryProvider {
+    [RequiresUnreferencedCodeAttribute("Enumerating in-memory collections as IQueryable can require unreferenced code because expressions referencing IQueryable extension methods can get rebound to IEnumerable extension methods. The IEnumerable extension methods could be trimmed causing the application to fail at runtime.")]
+    public class EnumerableQuery<T> : EnumerableQuery, IEnumerable, IEnumerable<T>, IOrderedQueryable, IOrderedQueryable<T>, IQueryable, IQueryable<T>, IQueryProvider {
-        [RequiresUnreferencedCodeAttribute("Enumerating in-memory collections as IQueryable can require unreferenced code because expressions referencing IQueryable extension methods can get rebound to IEnumerable extension methods. The IEnumerable extension methods could be trimmed causing the application to fail at runtime.")]
-        public EnumerableQuery(IEnumerable<T> enumerable);
+        public EnumerableQuery(IEnumerable<T> enumerable);
-        [RequiresUnreferencedCodeAttribute("Enumerating in-memory collections as IQueryable can require unreferenced code because expressions referencing IQueryable extension methods can get rebound to IEnumerable extension methods. The IEnumerable extension methods could be trimmed causing the application to fail at runtime.")]
-        public EnumerableQuery(Expression expression);
+        public EnumerableQuery(Expression expression);
     }
     public static class Queryable {
-        public static IQueryable<TSource> DefaultIfEmpty<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TSource?> DefaultIfEmpty<TSource>(this IQueryable<TSource> source);
+        public static IOrderedQueryable<T> Order<T>(this IQueryable<T> source);
+        public static IOrderedQueryable<T> Order<T>(this IQueryable<T> source, IComparer<T> comparer);
+        public static IOrderedQueryable<T> OrderDescending<T>(this IQueryable<T> source);
+        public static IOrderedQueryable<T> OrderDescending<T>(this IQueryable<T> source, IComparer<T> comparer);
     }
 }
```

