# System.Net.Http

``` diff
 namespace System.Net.Http {
     public class HttpClient : HttpMessageInvoker {
-        public Task<HttpResponseMessage> DeleteAsync(string? requestUri);
+        public Task<HttpResponseMessage> DeleteAsync([StringSyntaxAttribute("Uri")] string? requestUri);
-        public Task<HttpResponseMessage> DeleteAsync(string? requestUri, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> DeleteAsync([StringSyntaxAttribute("Uri")] string? requestUri, CancellationToken cancellationToken);
-        public Task<HttpResponseMessage> GetAsync(string? requestUri);
+        public Task<HttpResponseMessage> GetAsync([StringSyntaxAttribute("Uri")] string? requestUri);
-        public Task<HttpResponseMessage> GetAsync(string? requestUri, HttpCompletionOption completionOption);
+        public Task<HttpResponseMessage> GetAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpCompletionOption completionOption);
-        public Task<HttpResponseMessage> GetAsync(string? requestUri, HttpCompletionOption completionOption, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> GetAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpCompletionOption completionOption, CancellationToken cancellationToken);
-        public Task<HttpResponseMessage> GetAsync(string? requestUri, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> GetAsync([StringSyntaxAttribute("Uri")] string? requestUri, CancellationToken cancellationToken);
-        public Task<byte[]> GetByteArrayAsync(string? requestUri);
+        public Task<byte[]> GetByteArrayAsync([StringSyntaxAttribute("Uri")] string? requestUri);
-        public Task<byte[]> GetByteArrayAsync(string? requestUri, CancellationToken cancellationToken);
+        public Task<byte[]> GetByteArrayAsync([StringSyntaxAttribute("Uri")] string? requestUri, CancellationToken cancellationToken);
-        public Task<Stream> GetStreamAsync(string? requestUri);
+        public Task<Stream> GetStreamAsync([StringSyntaxAttribute("Uri")] string? requestUri);
-        public Task<Stream> GetStreamAsync(string? requestUri, CancellationToken cancellationToken);
+        public Task<Stream> GetStreamAsync([StringSyntaxAttribute("Uri")] string? requestUri, CancellationToken cancellationToken);
-        public Task<string> GetStringAsync(string? requestUri);
+        public Task<string> GetStringAsync([StringSyntaxAttribute("Uri")] string? requestUri);
-        public Task<string> GetStringAsync(string? requestUri, CancellationToken cancellationToken);
+        public Task<string> GetStringAsync([StringSyntaxAttribute("Uri")] string? requestUri, CancellationToken cancellationToken);
-        public Task<HttpResponseMessage> PatchAsync(string? requestUri, HttpContent? content);
+        public Task<HttpResponseMessage> PatchAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpContent? content);
-        public Task<HttpResponseMessage> PatchAsync(string? requestUri, HttpContent? content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> PatchAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpContent? content, CancellationToken cancellationToken);
-        public Task<HttpResponseMessage> PostAsync(string? requestUri, HttpContent? content);
+        public Task<HttpResponseMessage> PostAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpContent? content);
-        public Task<HttpResponseMessage> PostAsync(string? requestUri, HttpContent? content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> PostAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpContent? content, CancellationToken cancellationToken);
-        public Task<HttpResponseMessage> PutAsync(string? requestUri, HttpContent? content);
+        public Task<HttpResponseMessage> PutAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpContent? content);
-        public Task<HttpResponseMessage> PutAsync(string? requestUri, HttpContent? content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> PutAsync([StringSyntaxAttribute("Uri")] string? requestUri, HttpContent? content, CancellationToken cancellationToken);
     }
     public class HttpClientHandler : HttpMessageHandler {
-        [UnsupportedOSPlatformAttribute("browser")]
-        public IWebProxy Proxy { get; set; }
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public IWebProxy Proxy { get; set; }
     }
     public class HttpMethod : IEquatable<HttpMethod> {
+        public static HttpMethod Connect { get; }
     }
+    public sealed class HttpProtocolException : IOException {
+        public HttpProtocolException(long errorCode, string? message, Exception? innerException);
+        public long ErrorCode { get; }
+    }
     public class HttpRequestMessage : IDisposable {
-        public HttpRequestMessage(HttpMethod method, string? requestUri);
+        public HttpRequestMessage(HttpMethod method, [StringSyntaxAttribute("Uri")] string? requestUri);
     }
     public class StringContent : ByteArrayContent {
+        public StringContent(string content, MediaTypeHeaderValue mediaType);
+        public StringContent(string content, Encoding? encoding, MediaTypeHeaderValue mediaType);
-        public StringContent(string content, Encoding? encoding, string? mediaType);
+        public StringContent(string content, Encoding? encoding, string mediaType);
     }
 }
```

