# System.Net.Quic

``` diff
+namespace System.Net.Quic {
+    [FlagsAttribute]
+    public enum QuicAbortDirection {
+        Both = 3,
+        Read = 1,
+        Write = 2,
+    }
+    public sealed class QuicClientConnectionOptions : QuicConnectionOptions {
+        public QuicClientConnectionOptions();
+        public SslClientAuthenticationOptions ClientAuthenticationOptions { get; set; }
+        public IPEndPoint? LocalEndPoint { get; set; }
+        public EndPoint RemoteEndPoint { get; set; }
+    }
+    public sealed class QuicConnection : IAsyncDisposable {
+        public static bool IsSupported { get; }
+        public IPEndPoint LocalEndPoint { get; }
+        public SslApplicationProtocol NegotiatedApplicationProtocol { get; }
+        public X509Certificate? RemoteCertificate { get; }
+        public IPEndPoint RemoteEndPoint { get; }
+        public ValueTask<QuicStream> AcceptInboundStreamAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask CloseAsync(long errorCode, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<QuicConnection> ConnectAsync(QuicClientConnectionOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask DisposeAsync();
+        public ValueTask<QuicStream> OpenOutboundStreamAsync(QuicStreamType type, CancellationToken cancellationToken = default(CancellationToken));
+        public override string ToString();
+    }
+    public abstract class QuicConnectionOptions {
+        public long DefaultCloseErrorCode { get; set; }
+        public long DefaultStreamErrorCode { get; set; }
+        public TimeSpan IdleTimeout { get; set; }
+        public int MaxInboundBidirectionalStreams { get; set; }
+        public int MaxInboundUnidirectionalStreams { get; set; }
+    }
+    public enum QuicError {
+        AddressInUse = 4,
+        ConnectionAborted = 2,
+        ConnectionIdle = 10,
+        ConnectionRefused = 8,
+        ConnectionTimeout = 6,
+        HostUnreachable = 7,
+        InternalError = 1,
+        InvalidAddress = 5,
+        OperationAborted = 12,
+        ProtocolError = 11,
+        StreamAborted = 3,
+        Success = 0,
+        VersionNegotiationError = 9,
+    }
+    public sealed class QuicException : IOException {
+        public QuicException(QuicError error, long? applicationErrorCode, string message);
+        public long? ApplicationErrorCode { get; }
+        public QuicError QuicError { get; }
+    }
+    public sealed class QuicListener : IAsyncDisposable {
+        public static bool IsSupported { get; }
+        public IPEndPoint LocalEndPoint { get; }
+        public ValueTask<QuicConnection> AcceptConnectionAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask DisposeAsync();
+        public static ValueTask<QuicListener> ListenAsync(QuicListenerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public override string ToString();
+    }
+    public sealed class QuicListenerOptions {
+        public QuicListenerOptions();
+        public List<SslApplicationProtocol> ApplicationProtocols { get; set; }
+        public Func<QuicConnection, SslClientHelloInfo, CancellationToken, ValueTask<QuicServerConnectionOptions>> ConnectionOptionsCallback { get; set; }
+        public int ListenBacklog { get; set; }
+        public IPEndPoint ListenEndPoint { get; set; }
+    }
+    public sealed class QuicServerConnectionOptions : QuicConnectionOptions {
+        public QuicServerConnectionOptions();
+        public SslServerAuthenticationOptions ServerAuthenticationOptions { get; set; }
+    }
+    public sealed class QuicStream : Stream {
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanTimeout { get; }
+        public override bool CanWrite { get; }
+        public long Id { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public Task ReadsClosed { get; }
+        public override int ReadTimeout { get; set; }
+        public QuicStreamType Type { get; }
+        public Task WritesClosed { get; }
+        public override int WriteTimeout { get; set; }
+        public void Abort(QuicAbortDirection abortDirection, long errorCode);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback? callback, object? state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback? callback, object? state);
+        public void CompleteWrites();
+        protected override void Dispose(bool disposing);
+        public override ValueTask DisposeAsync();
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public override int Read(byte[] buffer, int offset, int count);
+        public override int Read(Span<byte> buffer);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override void Write(ReadOnlySpan<byte> buffer);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, bool completeWrites, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteByte(byte value);
+    }
+    public enum QuicStreamType {
+        Bidirectional = 1,
+        Unidirectional = 0,
+    }
+}
```

