# System.Net.Security

``` diff
 namespace System.Net.Security {
     public enum EncryptionPolicy {
-        AllowNoEncryption = 1,
+        [ObsoleteAttribute("EncryptionPolicy.NoEncryption and AllowEncryption significantly reduce security and should not be used in production code.", DiagnosticId="SYSLIB0040", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        AllowNoEncryption = 1,
-        NoEncryption = 2,
+        [ObsoleteAttribute("EncryptionPolicy.NoEncryption and AllowEncryption significantly reduce security and should not be used in production code.", DiagnosticId="SYSLIB0040", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        NoEncryption = 2,
     }
+    public sealed class NegotiateAuthentication : IDisposable {
+        public NegotiateAuthentication(NegotiateAuthenticationClientOptions clientOptions);
+        public NegotiateAuthentication(NegotiateAuthenticationServerOptions serverOptions);
+        public TokenImpersonationLevel ImpersonationLevel { get; }
+        public bool IsAuthenticated { get; }
+        public bool IsEncrypted { get; }
+        public bool IsMutuallyAuthenticated { get; }
+        public bool IsServer { get; }
+        public bool IsSigned { get; }
+        public string Package { get; }
+        public ProtectionLevel ProtectionLevel { get; }
+        public IIdentity RemoteIdentity { get; }
+        public string? TargetName { get; }
+        public void Dispose();
+        public byte[]? GetOutgoingBlob(ReadOnlySpan<byte> incomingBlob, out NegotiateAuthenticationStatusCode statusCode);
+        public string? GetOutgoingBlob(string? incomingBlob, out NegotiateAuthenticationStatusCode statusCode);
+        public NegotiateAuthenticationStatusCode Unwrap(ReadOnlySpan<byte> input, IBufferWriter<byte> outputWriter, out bool wasEncrypted);
+        public NegotiateAuthenticationStatusCode UnwrapInPlace(Span<byte> input, out int unwrappedOffset, out int unwrappedLength, out bool wasEncrypted);
+        public NegotiateAuthenticationStatusCode Wrap(ReadOnlySpan<byte> input, IBufferWriter<byte> outputWriter, bool requestEncryption, out bool isEncrypted);
+    }
+    public class NegotiateAuthenticationClientOptions {
+        public NegotiateAuthenticationClientOptions();
+        public TokenImpersonationLevel AllowedImpersonationLevel { get; set; }
+        public ChannelBinding? Binding { get; set; }
+        public NetworkCredential Credential { get; set; }
+        public string Package { get; set; }
+        public ProtectionLevel RequiredProtectionLevel { get; set; }
+        public bool RequireMutualAuthentication { get; set; }
+        public string? TargetName { get; set; }
+    }
+    public class NegotiateAuthenticationServerOptions {
+        public NegotiateAuthenticationServerOptions();
+        public ChannelBinding? Binding { get; set; }
+        public NetworkCredential Credential { get; set; }
+        public string Package { get; set; }
+        public ExtendedProtectionPolicy? Policy { get; set; }
+        public TokenImpersonationLevel RequiredImpersonationLevel { get; set; }
+        public ProtectionLevel RequiredProtectionLevel { get; set; }
+    }
+    public enum NegotiateAuthenticationStatusCode {
+        BadBinding = 3,
+        Completed = 0,
+        ContextExpired = 6,
+        ContinueNeeded = 1,
+        CredentialsExpired = 7,
+        GenericFailure = 2,
+        ImpersonationValidationFailed = 15,
+        InvalidCredentials = 8,
+        InvalidToken = 9,
+        MessageAltered = 5,
+        OutOfSequence = 12,
+        QopNotSupported = 11,
+        SecurityQosFailed = 13,
+        TargetUnknown = 14,
+        UnknownCredentials = 10,
+        Unsupported = 4,
+    }
     public sealed class SslCertificateTrust {
-        [UnsupportedOSPlatformAttribute("windows")]
-        public static SslCertificateTrust CreateForX509Collection(X509Certificate2Collection trustList, bool sendTrustInHandshake = false);
+        public static SslCertificateTrust CreateForX509Collection(X509Certificate2Collection trustList, bool sendTrustInHandshake = false);
     }
     public class SslClientAuthenticationOptions {
+        public X509ChainPolicy CertificateChainPolicy { get; set; }
     }
     public class SslServerAuthenticationOptions {
+        public X509ChainPolicy CertificateChainPolicy { get; set; }
     }
-    public sealed class SslStreamCertificateContext
+    public class SslStreamCertificateContext
 }
```

