# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
-    public struct IPPacketInformation {
+    public struct IPPacketInformation : IEquatable<IPPacketInformation> {
+        public bool Equals(IPPacketInformation other);
     }
     public class NetworkStream : Stream {
+        public void Close(TimeSpan timeout);
     }
     public sealed class SafeSocketHandle : SafeHandleMinusOneIsInvalid {
+        public override bool IsInvalid { get; }
     }
     public class Socket : IDisposable {
+        public bool Poll(TimeSpan timeout, SelectMode mode);
+        public Task<int> ReceiveAsync(ArraySegment<byte> buffer);
+        public Task<int> ReceiveAsync(IList<ArraySegment<byte>> buffers);
+        public ValueTask<int> ReceiveAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<SocketReceiveFromResult> ReceiveFromAsync(ArraySegment<byte> buffer, EndPoint remoteEndPoint);
+        public ValueTask<SocketReceiveFromResult> ReceiveFromAsync(Memory<byte> buffer, EndPoint remoteEndPoint, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(ArraySegment<byte> buffer, EndPoint remoteEndPoint);
+        public ValueTask<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(Memory<byte> buffer, EndPoint remoteEndPoint, CancellationToken cancellationToken = default(CancellationToken));
+        public static void Select(IList? checkRead, IList? checkWrite, IList? checkError, TimeSpan timeout);
+        public Task<int> SendAsync(ArraySegment<byte> buffer);
+        public Task<int> SendAsync(IList<ArraySegment<byte>> buffers);
+        public ValueTask<int> SendAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<int> SendToAsync(ArraySegment<byte> buffer, EndPoint remoteEP);
+        public ValueTask<int> SendToAsync(ReadOnlyMemory<byte> buffer, EndPoint remoteEP, CancellationToken cancellationToken = default(CancellationToken));
     }
-    public static class SocketTaskExtensions
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public static class SocketTaskExtensions
     public sealed class UnixDomainSocketEndPoint : EndPoint {
+        public override AddressFamily AddressFamily { get; }
+        public override EndPoint Create(SocketAddress socketAddress);
+        public override SocketAddress Serialize();
+        public override string ToString();
     }
 }
```

