# System.Net

``` diff
 namespace System.Net {
     public class FileWebRequest : WebRequest, ISerializable {
-        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for FileWebRequest.")]
+        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for FileWebRequest.")]
+        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class FileWebResponse : WebResponse, ISerializable {
-        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for FileWebResponse.")]
+        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for FileWebResponse.")]
+        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public sealed class HttpListenerResponse : IDisposable {
-        public void Redirect(string url);
+        public void Redirect([StringSyntaxAttribute("Uri")] string url);
     }
     public class HttpWebRequest : WebRequest, ISerializable {
-        [ObsoleteAttribute("WebRequest, HttpWebRequest, ServicePoint, and WebClient are obsolete. Use HttpClient instead", DiagnosticId="SYSLIB0014", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        protected HttpWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("WebRequest, HttpWebRequest, ServicePoint, and WebClient are obsolete. Use HttpClient instead.", DiagnosticId="SYSLIB0014", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected HttpWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class IPAddress {
-        [ObsoleteAttribute("IPAddress.Address is address family dependent and has been deprecated. Use IPAddress.Equals to perform comparisons.")]
-        public long Address { get; set; }
+        [ObsoleteAttribute("IPAddress.Address is address family dependent and has been deprecated. Use IPAddress.Equals to perform comparisons instead.")]
+        public long Address { get; set; }
     }
     public class WebProxy : ISerializable, IWebProxy {
-        public WebProxy(string Address, bool BypassOnLocal, string[]? BypassList);
+        public WebProxy(string Address, bool BypassOnLocal, [StringSyntaxAttribute("Regex", new object[]{ RegexOptions.CultureInvariant | RegexOptions.IgnoreCase})] string[]? BypassList);
-        public WebProxy(string Address, bool BypassOnLocal, string[]? BypassList, ICredentials Credentials);
+        public WebProxy(string Address, bool BypassOnLocal, [StringSyntaxAttribute("Regex", new object[]{ RegexOptions.CultureInvariant | RegexOptions.IgnoreCase})] string[]? BypassList, ICredentials Credentials);
-        public WebProxy(Uri Address, bool BypassOnLocal, string[]? BypassList);
+        public WebProxy(Uri Address, bool BypassOnLocal, [StringSyntaxAttribute("Regex", new object[]{ RegexOptions.CultureInvariant | RegexOptions.IgnoreCase})] string[]? BypassList);
-        public WebProxy(Uri Address, bool BypassOnLocal, string[]? BypassList, ICredentials Credentials);
+        public WebProxy(Uri Address, bool BypassOnLocal, [StringSyntaxAttribute("Regex", new object[]{ RegexOptions.CultureInvariant | RegexOptions.IgnoreCase})] string[]? BypassList, ICredentials Credentials);
     }
     public abstract class WebRequest : MarshalByRefObject, ISerializable {
-        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for WebRequest.")]
+        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for WebRequest.")]
+        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public abstract class WebResponse : MarshalByRefObject, IDisposable, ISerializable {
-        protected WebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for WebResponse.")]
+        protected WebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for WebResponse.")]
+        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [ObsoleteAttribute("Serialization has been deprecated for WebResponse.")]
+        void ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
 }
```

