# System.Numerics

``` diff
 namespace System.Numerics {
-    public readonly struct BigInteger : IComparable, IComparable<BigInteger>, IEquatable<BigInteger>, IFormattable, ISpanFormattable {
+    public readonly struct BigInteger : IAdditionOperators<BigInteger, BigInteger, BigInteger>, IAdditiveIdentity<BigInteger, BigInteger>, IBinaryInteger<BigInteger>, IBinaryNumber<BigInteger>, IBitwiseOperators<BigInteger, BigInteger, BigInteger>, IComparable, IComparable<BigInteger>, IComparisonOperators<BigInteger, BigInteger, bool>, IDecrementOperators<BigInteger>, IDivisionOperators<BigInteger, BigInteger, BigInteger>, IEqualityOperators<BigInteger, BigInteger, bool>, IEquatable<BigInteger>, IFormattable, IIncrementOperators<BigInteger>, IModulusOperators<BigInteger, BigInteger, BigInteger>, IMultiplicativeIdentity<BigInteger, BigInteger>, IMultiplyOperators<BigInteger, BigInteger, BigInteger>, INumber<BigInteger>, INumberBase<BigInteger>, IParsable<BigInteger>, IShiftOperators<BigInteger, int, BigInteger>, ISignedNumber<BigInteger>, ISpanFormattable, ISpanParsable<BigInteger>, ISubtractionOperators<BigInteger, BigInteger, BigInteger>, IUnaryNegationOperators<BigInteger, BigInteger>, IUnaryPlusOperators<BigInteger, BigInteger> {
+        static BigInteger System.Numerics.IAdditiveIdentity<System.Numerics.BigInteger,System.Numerics.BigInteger>.AdditiveIdentity { get; }
+        static BigInteger System.Numerics.IBinaryNumber<System.Numerics.BigInteger>.AllBitsSet { get; }
+        static BigInteger System.Numerics.IMultiplicativeIdentity<System.Numerics.BigInteger,System.Numerics.BigInteger>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.Numerics.BigInteger>.Radix { get; }
+        static BigInteger System.Numerics.ISignedNumber<System.Numerics.BigInteger>.NegativeOne { get; }
+        public static BigInteger Clamp(BigInteger value, BigInteger min, BigInteger max);
+        public static BigInteger CopySign(BigInteger value, BigInteger sign);
+        public static BigInteger CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static BigInteger CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static BigInteger CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (BigInteger Quotient, BigInteger Remainder) DivRem(BigInteger left, BigInteger right);
+        public static bool IsEvenInteger(BigInteger value);
+        public static bool IsNegative(BigInteger value);
+        public static bool IsOddInteger(BigInteger value);
+        public static bool IsPositive(BigInteger value);
+        public static bool IsPow2(BigInteger value);
+        public static BigInteger LeadingZeroCount(BigInteger value);
+        public static BigInteger Log2(BigInteger value);
+        public static BigInteger MaxMagnitude(BigInteger x, BigInteger y);
+        public static BigInteger MinMagnitude(BigInteger x, BigInteger y);
+        public static explicit operator BigInteger (Half value);
+        public static explicit operator char (BigInteger value);
+        public static explicit operator Half (BigInteger value);
+        public static explicit operator Int128 (BigInteger value);
+        public static explicit operator IntPtr (BigInteger value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UInt128 (BigInteger value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UIntPtr (BigInteger value);
+        public static explicit operator BigInteger (Complex value);
+        public static implicit operator BigInteger (char value);
+        public static implicit operator BigInteger (Int128 value);
+        public static implicit operator BigInteger (IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator BigInteger (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator BigInteger (UIntPtr value);
+        public static BigInteger operator >>>(BigInteger value, int shiftAmount);
+        public static BigInteger Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static BigInteger PopCount(BigInteger value);
+        public static BigInteger RotateLeft(BigInteger value, int rotateAmount);
+        public static BigInteger RotateRight(BigInteger value, int rotateAmount);
+        int IBinaryInteger<BigInteger>.GetByteCount();
+        int IBinaryInteger<BigInteger>.GetShortestBitLength();
+        static bool IBinaryInteger<BigInteger>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out BigInteger value);
+        static bool IBinaryInteger<BigInteger>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out BigInteger value);
+        bool IBinaryInteger<BigInteger>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<BigInteger>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static BigInteger INumber<BigInteger>.MaxNumber(BigInteger x, BigInteger y);
+        static BigInteger INumber<BigInteger>.MinNumber(BigInteger x, BigInteger y);
+        static int INumber<BigInteger>.Sign(BigInteger value);
+        static bool INumberBase<BigInteger>.IsCanonical(BigInteger value);
+        static bool INumberBase<BigInteger>.IsComplexNumber(BigInteger value);
+        static bool INumberBase<BigInteger>.IsFinite(BigInteger value);
+        static bool INumberBase<BigInteger>.IsImaginaryNumber(BigInteger value);
+        static bool INumberBase<BigInteger>.IsInfinity(BigInteger value);
+        static bool INumberBase<BigInteger>.IsInteger(BigInteger value);
+        static bool INumberBase<BigInteger>.IsNaN(BigInteger value);
+        static bool INumberBase<BigInteger>.IsNegativeInfinity(BigInteger value);
+        static bool INumberBase<BigInteger>.IsNormal(BigInteger value);
+        static bool INumberBase<BigInteger>.IsPositiveInfinity(BigInteger value);
+        static bool INumberBase<BigInteger>.IsRealNumber(BigInteger value);
+        static bool INumberBase<BigInteger>.IsSubnormal(BigInteger value);
+        static bool INumberBase<BigInteger>.IsZero(BigInteger value);
+        static BigInteger INumberBase<BigInteger>.MaxMagnitudeNumber(BigInteger x, BigInteger y);
+        static BigInteger INumberBase<BigInteger>.MinMagnitudeNumber(BigInteger x, BigInteger y);
+        static bool INumberBase<BigInteger>.TryConvertFromChecked<TOther>(TOther value, out BigInteger result);
+        static bool INumberBase<BigInteger>.TryConvertFromSaturating<TOther>(TOther value, out BigInteger result);
+        static bool INumberBase<BigInteger>.TryConvertFromTruncating<TOther>(TOther value, out BigInteger result);
+        static bool INumberBase<BigInteger>.TryConvertToChecked<TOther>(BigInteger value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<BigInteger>.TryConvertToSaturating<TOther>(BigInteger value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<BigInteger>.TryConvertToTruncating<TOther>(BigInteger value, [MaybeNullWhenAttribute(false)] out TOther result);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static BigInteger TrailingZeroCount(BigInteger value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out BigInteger result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out BigInteger result);
     }
     public static class BitOperations {
+        public static bool IsPow2(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static bool IsPow2(UIntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static int LeadingZeroCount(UIntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static int Log2(UIntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static int PopCount(UIntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static UIntPtr RotateLeft(UIntPtr value, int offset);
+        [CLSCompliantAttribute(false)]
+        public static UIntPtr RotateRight(UIntPtr value, int offset);
+        [CLSCompliantAttribute(false)]
+        public static UIntPtr RoundUpToPowerOf2(UIntPtr value);
+        public static int TrailingZeroCount(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static int TrailingZeroCount(UIntPtr value);
     }
-    public readonly struct Complex : IEquatable<Complex>, IFormattable {
+    public readonly struct Complex : IAdditionOperators<Complex, Complex, Complex>, IAdditiveIdentity<Complex, Complex>, IDecrementOperators<Complex>, IDivisionOperators<Complex, Complex, Complex>, IEqualityOperators<Complex, Complex, bool>, IEquatable<Complex>, IFormattable, IIncrementOperators<Complex>, IMultiplicativeIdentity<Complex, Complex>, IMultiplyOperators<Complex, Complex, Complex>, INumberBase<Complex>, IParsable<Complex>, ISignedNumber<Complex>, ISpanFormattable, ISpanParsable<Complex>, ISubtractionOperators<Complex, Complex, Complex>, IUnaryNegationOperators<Complex, Complex>, IUnaryPlusOperators<Complex, Complex> {
+        static Complex System.Numerics.IAdditiveIdentity<System.Numerics.Complex,System.Numerics.Complex>.AdditiveIdentity { get; }
+        static Complex System.Numerics.IMultiplicativeIdentity<System.Numerics.Complex,System.Numerics.Complex>.MultiplicativeIdentity { get; }
+        static Complex System.Numerics.INumberBase<System.Numerics.Complex>.One { get; }
+        static int System.Numerics.INumberBase<System.Numerics.Complex>.Radix { get; }
+        static Complex System.Numerics.INumberBase<System.Numerics.Complex>.Zero { get; }
+        static Complex System.Numerics.ISignedNumber<System.Numerics.Complex>.NegativeOne { get; }
+        public static Complex CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static Complex CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static Complex CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static bool IsComplexNumber(Complex value);
+        public static bool IsEvenInteger(Complex value);
+        public static bool IsImaginaryNumber(Complex value);
+        public static bool IsInteger(Complex value);
+        public static bool IsNegative(Complex value);
+        public static bool IsNegativeInfinity(Complex value);
+        public static bool IsNormal(Complex value);
+        public static bool IsOddInteger(Complex value);
+        public static bool IsPositive(Complex value);
+        public static bool IsPositiveInfinity(Complex value);
+        public static bool IsRealNumber(Complex value);
+        public static bool IsSubnormal(Complex value);
+        public static Complex MaxMagnitude(Complex x, Complex y);
+        public static Complex MinMagnitude(Complex x, Complex y);
+        public static Complex operator --(Complex value);
+        public static explicit operator Complex (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator Complex (UInt128 value);
+        public static implicit operator Complex (char value);
+        public static implicit operator Complex (Half value);
+        public static implicit operator Complex (IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator Complex (UIntPtr value);
+        public static Complex operator ++(Complex value);
+        public static Complex operator +(Complex value);
+        public static Complex Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);
+        public static Complex Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static Complex Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static Complex Parse(string s, IFormatProvider? provider);
+        static Complex INumberBase<Complex>.Abs(Complex value);
+        static bool INumberBase<Complex>.IsCanonical(Complex value);
+        static bool INumberBase<Complex>.IsZero(Complex value);
+        static Complex INumberBase<Complex>.MaxMagnitudeNumber(Complex x, Complex y);
+        static Complex INumberBase<Complex>.MinMagnitudeNumber(Complex x, Complex y);
+        static bool INumberBase<Complex>.TryConvertFromChecked<TOther>(TOther value, out Complex result);
+        static bool INumberBase<Complex>.TryConvertFromSaturating<TOther>(TOther value, out Complex result);
+        static bool INumberBase<Complex>.TryConvertFromTruncating<TOther>(TOther value, out Complex result);
+        static bool INumberBase<Complex>.TryConvertToChecked<TOther>(Complex value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<Complex>.TryConvertToSaturating<TOther>(Complex value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<Complex>.TryConvertToTruncating<TOther>(Complex value, [MaybeNullWhenAttribute(false)] out TOther result);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider? provider);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Complex result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Complex result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, NumberStyles style, IFormatProvider? provider, out Complex result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out Complex result);
     }
+    public interface IAdditionOperators<TSelf, TOther, TResult> where TSelf : IAdditionOperators<TSelf, TOther, TResult>? {
+        static abstract TResult operator +(TSelf left, TOther right);
+        static TResult operator checked +(TSelf left, TOther right);
+    }
+    public interface IAdditiveIdentity<TSelf, TResult> where TSelf : IAdditiveIdentity<TSelf, TResult>? {
+        static abstract TResult AdditiveIdentity { get; }
+    }
+    public interface IBinaryFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointConstants<TSelf>, IFloatingPointIeee754<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryFloatingPointIeee754<TSelf>?
+    public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IShiftOperators<TSelf, int, TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryInteger<TSelf>? {
+        static (TSelf Quotient, TSelf Remainder) DivRem(TSelf left, TSelf right);
+        int GetByteCount();
+        int GetShortestBitLength();
+        static TSelf LeadingZeroCount(TSelf value);
+        static abstract TSelf PopCount(TSelf value);
+        static TSelf ReadBigEndian(byte[] source, bool isUnsigned);
+        static TSelf ReadBigEndian(byte[] source, int startIndex, bool isUnsigned);
+        static TSelf ReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned);
+        static TSelf ReadLittleEndian(byte[] source, bool isUnsigned);
+        static TSelf ReadLittleEndian(byte[] source, int startIndex, bool isUnsigned);
+        static TSelf ReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned);
+        static TSelf RotateLeft(TSelf value, int rotateAmount);
+        static TSelf RotateRight(TSelf value, int rotateAmount);
+        static abstract TSelf TrailingZeroCount(TSelf value);
+        static abstract bool TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out TSelf value);
+        static abstract bool TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out TSelf value);
+        bool TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        int WriteBigEndian(byte[] destination);
+        int WriteBigEndian(byte[] destination, int startIndex);
+        int WriteBigEndian(Span<byte> destination);
+        int WriteLittleEndian(byte[] destination);
+        int WriteLittleEndian(byte[] destination, int startIndex);
+        int WriteLittleEndian(Span<byte> destination);
+    }
+    public interface IBinaryNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryNumber<TSelf>? {
+        static TSelf AllBitsSet { get; }
+        static abstract bool IsPow2(TSelf value);
+        static abstract TSelf Log2(TSelf value);
+    }
+    public interface IBitwiseOperators<TSelf, TOther, TResult> where TSelf : IBitwiseOperators<TSelf, TOther, TResult>? {
+        static abstract TResult operator &(TSelf left, TOther right);
+        static abstract TResult operator |(TSelf left, TOther right);
+        static abstract TResult operator ^(TSelf left, TOther right);
+        static abstract TResult operator ~(TSelf value);
+    }
+    public interface IComparisonOperators<TSelf, TOther, TResult> : IEqualityOperators<TSelf, TOther, TResult> where TSelf : IComparisonOperators<TSelf, TOther, TResult>? {
+        static abstract TResult operator >(TSelf left, TOther right);
+        static abstract TResult operator >=(TSelf left, TOther right);
+        static abstract TResult operator <(TSelf left, TOther right);
+        static abstract TResult operator <=(TSelf left, TOther right);
+    }
+    public interface IDecrementOperators<TSelf> where TSelf : IDecrementOperators<TSelf>? {
+        static TSelf operator checked --(TSelf value);
+        static abstract TSelf operator --(TSelf value);
+    }
+    public interface IDivisionOperators<TSelf, TOther, TResult> where TSelf : IDivisionOperators<TSelf, TOther, TResult>? {
+        static TResult operator checked /(TSelf left, TOther right);
+        static abstract TResult operator /(TSelf left, TOther right);
+    }
+    public interface IEqualityOperators<TSelf, TOther, TResult> where TSelf : IEqualityOperators<TSelf, TOther, TResult>? {
+        static abstract TResult operator ==(TSelf left, TOther right);
+        static abstract TResult operator !=(TSelf left, TOther right);
+    }
+    public interface IExponentialFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IExponentialFunctions<TSelf>? {
+        static abstract TSelf Exp(TSelf x);
+        static abstract TSelf Exp10(TSelf x);
+        static TSelf Exp10M1(TSelf x);
+        static abstract TSelf Exp2(TSelf x);
+        static TSelf Exp2M1(TSelf x);
+        static TSelf ExpM1(TSelf x);
+    }
+    public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPoint<TSelf>? {
+        static TSelf Ceiling(TSelf x);
+        static TSelf Floor(TSelf x);
+        int GetExponentByteCount();
+        int GetExponentShortestBitLength();
+        int GetSignificandBitLength();
+        int GetSignificandByteCount();
+        static TSelf Round(TSelf x);
+        static TSelf Round(TSelf x, int digits);
+        static abstract TSelf Round(TSelf x, int digits, MidpointRounding mode);
+        static TSelf Round(TSelf x, MidpointRounding mode);
+        static TSelf Truncate(TSelf x);
+        bool TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        bool TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        int WriteExponentBigEndian(byte[] destination);
+        int WriteExponentBigEndian(byte[] destination, int startIndex);
+        int WriteExponentBigEndian(Span<byte> destination);
+        int WriteExponentLittleEndian(byte[] destination);
+        int WriteExponentLittleEndian(byte[] destination, int startIndex);
+        int WriteExponentLittleEndian(Span<byte> destination);
+        int WriteSignificandBigEndian(byte[] destination);
+        int WriteSignificandBigEndian(byte[] destination, int startIndex);
+        int WriteSignificandBigEndian(Span<byte> destination);
+        int WriteSignificandLittleEndian(byte[] destination);
+        int WriteSignificandLittleEndian(byte[] destination, int startIndex);
+        int WriteSignificandLittleEndian(Span<byte> destination);
+    }
+    public interface IFloatingPointConstants<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointConstants<TSelf>? {
+        static abstract TSelf E { get; }
+        static abstract TSelf Pi { get; }
+        static abstract TSelf Tau { get; }
+    }
+    public interface IFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointIeee754<TSelf>? {
+        static abstract TSelf Epsilon { get; }
+        static abstract TSelf NaN { get; }
+        static abstract TSelf NegativeInfinity { get; }
+        static abstract TSelf NegativeZero { get; }
+        static abstract TSelf PositiveInfinity { get; }
+        static abstract TSelf Atan2(TSelf y, TSelf x);
+        static abstract TSelf Atan2Pi(TSelf y, TSelf x);
+        static abstract TSelf BitDecrement(TSelf x);
+        static abstract TSelf BitIncrement(TSelf x);
+        static abstract TSelf FusedMultiplyAdd(TSelf left, TSelf right, TSelf addend);
+        static abstract TSelf Ieee754Remainder(TSelf left, TSelf right);
+        static abstract int ILogB(TSelf x);
+        static TSelf ReciprocalEstimate(TSelf x);
+        static TSelf ReciprocalSqrtEstimate(TSelf x);
+        static abstract TSelf ScaleB(TSelf x, int n);
+    }
+    public interface IHyperbolicFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IHyperbolicFunctions<TSelf>? {
+        static abstract TSelf Acosh(TSelf x);
+        static abstract TSelf Asinh(TSelf x);
+        static abstract TSelf Atanh(TSelf x);
+        static abstract TSelf Cosh(TSelf x);
+        static abstract TSelf Sinh(TSelf x);
+        static abstract TSelf Tanh(TSelf x);
+    }
+    public interface IIncrementOperators<TSelf> where TSelf : IIncrementOperators<TSelf>? {
+        static TSelf operator checked ++(TSelf value);
+        static abstract TSelf operator ++(TSelf value);
+    }
+    public interface ILogarithmicFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ILogarithmicFunctions<TSelf>? {
+        static abstract TSelf Log(TSelf x);
+        static abstract TSelf Log(TSelf x, TSelf newBase);
+        static abstract TSelf Log10(TSelf x);
+        static TSelf Log10P1(TSelf x);
+        static abstract TSelf Log2(TSelf x);
+        static TSelf Log2P1(TSelf x);
+        static TSelf LogP1(TSelf x);
+    }
+    public interface IMinMaxValue<TSelf> where TSelf : IMinMaxValue<TSelf>? {
+        static abstract TSelf MaxValue { get; }
+        static abstract TSelf MinValue { get; }
+    }
+    public interface IModulusOperators<TSelf, TOther, TResult> where TSelf : IModulusOperators<TSelf, TOther, TResult>? {
+        static abstract TResult operator %(TSelf left, TOther right);
+    }
+    public interface IMultiplicativeIdentity<TSelf, TResult> where TSelf : IMultiplicativeIdentity<TSelf, TResult>? {
+        static abstract TResult MultiplicativeIdentity { get; }
+    }
+    public interface IMultiplyOperators<TSelf, TOther, TResult> where TSelf : IMultiplyOperators<TSelf, TOther, TResult>? {
+        static TResult operator checked *(TSelf left, TOther right);
+        static abstract TResult operator *(TSelf left, TOther right);
+    }
+    public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumber<TSelf>? {
+        static TSelf Clamp(TSelf value, TSelf min, TSelf max);
+        static TSelf CopySign(TSelf value, TSelf sign);
+        static TSelf Max(TSelf x, TSelf y);
+        static TSelf MaxNumber(TSelf x, TSelf y);
+        static TSelf Min(TSelf x, TSelf y);
+        static TSelf MinNumber(TSelf x, TSelf y);
+        static int Sign(TSelf value);
+    }
+    public interface INumberBase<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumberBase<TSelf>? {
+        static abstract TSelf One { get; }
+        static abstract int Radix { get; }
+        static abstract TSelf Zero { get; }
+        static abstract TSelf Abs(TSelf value);
+        static TSelf CreateChecked<TOther>(TOther value);
+        static TSelf CreateSaturating<TOther>(TOther value);
+        static TSelf CreateTruncating<TOther>(TOther value);
+        static abstract bool IsCanonical(TSelf value);
+        static abstract bool IsComplexNumber(TSelf value);
+        static abstract bool IsEvenInteger(TSelf value);
+        static abstract bool IsFinite(TSelf value);
+        static abstract bool IsImaginaryNumber(TSelf value);
+        static abstract bool IsInfinity(TSelf value);
+        static abstract bool IsInteger(TSelf value);
+        static abstract bool IsNaN(TSelf value);
+        static abstract bool IsNegative(TSelf value);
+        static abstract bool IsNegativeInfinity(TSelf value);
+        static abstract bool IsNormal(TSelf value);
+        static abstract bool IsOddInteger(TSelf value);
+        static abstract bool IsPositive(TSelf value);
+        static abstract bool IsPositiveInfinity(TSelf value);
+        static abstract bool IsRealNumber(TSelf value);
+        static abstract bool IsSubnormal(TSelf value);
+        static abstract bool IsZero(TSelf value);
+        static abstract TSelf MaxMagnitude(TSelf x, TSelf y);
+        static abstract TSelf MaxMagnitudeNumber(TSelf x, TSelf y);
+        static abstract TSelf MinMagnitude(TSelf x, TSelf y);
+        static abstract TSelf MinMagnitudeNumber(TSelf x, TSelf y);
+        static abstract TSelf Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);
+        static abstract TSelf Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static abstract bool TryConvertFromChecked<TOther>(TOther value, [MaybeNullWhenAttribute(false)] out TSelf result);
+        static abstract bool TryConvertFromSaturating<TOther>(TOther value, [MaybeNullWhenAttribute(false)] out TSelf result);
+        static abstract bool TryConvertFromTruncating<TOther>(TOther value, [MaybeNullWhenAttribute(false)] out TSelf result);
+        static abstract bool TryConvertToChecked<TOther>(TSelf value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static abstract bool TryConvertToSaturating<TOther>(TSelf value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static abstract bool TryConvertToTruncating<TOther>(TSelf value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static abstract bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, [MaybeNullWhenAttribute(false)] out TSelf result);
+        static abstract bool TryParse([NotNullWhenAttribute(true)] string? s, NumberStyles style, IFormatProvider? provider, [MaybeNullWhenAttribute(false)] out TSelf result);
+    }
+    public interface IPowerFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IPowerFunctions<TSelf>? {
+        static abstract TSelf Pow(TSelf x, TSelf y);
+    }
+    public interface IRootFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IRootFunctions<TSelf>? {
+        static abstract TSelf Cbrt(TSelf x);
+        static abstract TSelf Hypot(TSelf x, TSelf y);
+        static abstract TSelf RootN(TSelf x, int n);
+        static abstract TSelf Sqrt(TSelf x);
+    }
+    public interface IShiftOperators<TSelf, TOther, TResult> where TSelf : IShiftOperators<TSelf, TOther, TResult>? {
+        static abstract TResult operator <<(TSelf value, TOther shiftAmount);
+        static abstract TResult operator >>(TSelf value, TOther shiftAmount);
+        static abstract TResult operator >>>(TSelf value, TOther shiftAmount);
+    }
+    public interface ISignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ISignedNumber<TSelf>? {
+        static abstract TSelf NegativeOne { get; }
+    }
+    public interface ISubtractionOperators<TSelf, TOther, TResult> where TSelf : ISubtractionOperators<TSelf, TOther, TResult>? {
+        static TResult operator checked -(TSelf left, TOther right);
+        static abstract TResult operator -(TSelf left, TOther right);
+    }
+    public interface ITrigonometricFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ITrigonometricFunctions<TSelf>? {
+        static abstract TSelf Acos(TSelf x);
+        static abstract TSelf AcosPi(TSelf x);
+        static abstract TSelf Asin(TSelf x);
+        static abstract TSelf AsinPi(TSelf x);
+        static abstract TSelf Atan(TSelf x);
+        static abstract TSelf AtanPi(TSelf x);
+        static abstract TSelf Cos(TSelf x);
+        static abstract TSelf CosPi(TSelf x);
+        static abstract TSelf Sin(TSelf x);
+        static abstract (TSelf Sin, TSelf Cos) SinCos(TSelf x);
+        static abstract (TSelf SinPi, TSelf CosPi) SinCosPi(TSelf x);
+        static abstract TSelf SinPi(TSelf x);
+        static abstract TSelf Tan(TSelf x);
+        static abstract TSelf TanPi(TSelf x);
+    }
+    public interface IUnaryNegationOperators<TSelf, TResult> where TSelf : IUnaryNegationOperators<TSelf, TResult>? {
+        static TResult operator checked -(TSelf value);
+        static abstract TResult operator -(TSelf value);
+    }
+    public interface IUnaryPlusOperators<TSelf, TResult> where TSelf : IUnaryPlusOperators<TSelf, TResult>? {
+        static abstract TResult operator +(TSelf value);
+    }
+    public interface IUnsignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IUnsignedNumber<TSelf>?
     public struct Matrix3x2 : IEquatable<Matrix3x2> {
+        public float this[int row, int column] { get; set; }
     }
     public struct Matrix4x4 : IEquatable<Matrix4x4> {
+        public float this[int row, int column] { get; set; }
     }
     public struct Quaternion : IEquatable<Quaternion> {
+        public float this[int index] { get; set; }
+        public static Quaternion Zero { get; }
     }
     public static class Vector {
+        public static Vector<byte> ShiftLeft(Vector<byte> value, int shiftCount);
+        public static Vector<short> ShiftLeft(Vector<short> value, int shiftCount);
+        public static Vector<int> ShiftLeft(Vector<int> value, int shiftCount);
+        public static Vector<long> ShiftLeft(Vector<long> value, int shiftCount);
+        public static Vector<IntPtr> ShiftLeft(Vector<IntPtr> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<sbyte> ShiftLeft(Vector<sbyte> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> ShiftLeft(Vector<ushort> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> ShiftLeft(Vector<uint> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> ShiftLeft(Vector<ulong> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<UIntPtr> ShiftLeft(Vector<UIntPtr> value, int shiftCount);
+        public static Vector<short> ShiftRightArithmetic(Vector<short> value, int shiftCount);
+        public static Vector<int> ShiftRightArithmetic(Vector<int> value, int shiftCount);
+        public static Vector<long> ShiftRightArithmetic(Vector<long> value, int shiftCount);
+        public static Vector<IntPtr> ShiftRightArithmetic(Vector<IntPtr> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<sbyte> ShiftRightArithmetic(Vector<sbyte> value, int shiftCount);
+        public static Vector<byte> ShiftRightLogical(Vector<byte> value, int shiftCount);
+        public static Vector<short> ShiftRightLogical(Vector<short> value, int shiftCount);
+        public static Vector<int> ShiftRightLogical(Vector<int> value, int shiftCount);
+        public static Vector<long> ShiftRightLogical(Vector<long> value, int shiftCount);
+        public static Vector<IntPtr> ShiftRightLogical(Vector<IntPtr> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<sbyte> ShiftRightLogical(Vector<sbyte> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> ShiftRightLogical(Vector<ushort> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> ShiftRightLogical(Vector<uint> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> ShiftRightLogical(Vector<ulong> value, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector<UIntPtr> ShiftRightLogical(Vector<UIntPtr> value, int shiftCount);
     }
-    public struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+    public readonly struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+        public static bool IsSupported { get; }
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? formatProvider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? formatProvider);
     }
     public struct Vector2 : IEquatable<Vector2>, IFormattable {
+        public float this[int index] { get; set; }
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? formatProvider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? formatProvider);
     }
     public struct Vector3 : IEquatable<Vector3>, IFormattable {
+        public float this[int index] { get; set; }
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? formatProvider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? formatProvider);
     }
     public struct Vector4 : IEquatable<Vector4>, IFormattable {
+        public float this[int index] { get; set; }
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? formatProvider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? formatProvider);
     }
 }
```

