# System.Reflection.Emit

``` diff
 namespace System.Reflection.Emit {
     public sealed class AssemblyBuilder : Assembly {
-        [ObsoleteAttribute("Assembly.CodeBase and Assembly.EscapedCodeBase are only included for .NET Framework compatibility. Use Assembly.Location instead.", DiagnosticId="SYSLIB0012", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public override string? CodeBase { get; }
+        [ObsoleteAttribute("Assembly.CodeBase and Assembly.EscapedCodeBase are only included for .NET Framework compatibility. Use Assembly.Location instead.", DiagnosticId="SYSLIB0012", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresAssemblyFilesAttribute("This member throws an exception for assemblies embedded in a single-file app")]
+        public override string? CodeBase { get; }
     }
     public sealed class EnumBuilder : TypeInfo {
-        public Type? CreateType();
+        public Type CreateType();
-        public TypeInfo? CreateTypeInfo();
+        public TypeInfo CreateTypeInfo();
     }
     public class ILGenerator {
-        public virtual void BeginCatchBlock(Type exceptionType);
+        public virtual void BeginCatchBlock(Type? exceptionType);
     }
     public class ModuleBuilder : Module {
-        public override string FullyQualifiedName { get; }
+        [RequiresAssemblyFilesAttribute("Returns <Unknown> for modules with no file path")]
+        public override string FullyQualifiedName { get; }
-        public override string Name { get; }
+        [RequiresAssemblyFilesAttribute("Returns <Unknown> for modules with no file path")]
+        public override string Name { get; }
     }
     public sealed class TypeBuilder : TypeInfo {
-        public Type? CreateType();
+        public Type CreateType();
-        public TypeInfo? CreateTypeInfo();
+        public TypeInfo CreateTypeInfo();
     }
 }
```

