# System.Reflection

``` diff
 namespace System.Reflection {
     public sealed class AssemblyName : ICloneable, IDeserializationCallback, ISerializable {
-        public string CodeBase { [RequiresAssemblyFilesAttribute("The code will return an empty string for assemblies embedded in a single-file app")] get; set; }
+        [ObsoleteAttribute("AssemblyName.CodeBase and AssemblyName.EscapedCodeBase are obsolete. Using them for loading an assembly is not supported.", DiagnosticId="SYSLIB0044", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public string CodeBase { [RequiresAssemblyFilesAttribute("The code will return an empty string for assemblies embedded in a single-file app")] get; set; }
-        [RequiresAssemblyFilesAttribute("The code will return an empty string for assemblies embedded in a single-file app")]
-        public string EscapedCodeBase { get; }
+        [ObsoleteAttribute("AssemblyName.CodeBase and AssemblyName.EscapedCodeBase are obsolete. Using them for loading an assembly is not supported.", DiagnosticId="SYSLIB0044", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresAssemblyFilesAttribute("The code will return an empty string for assemblies embedded in a single-file app")]
+        public string EscapedCodeBase { get; }
-        public AssemblyHashAlgorithm HashAlgorithm { get; set; }
+        [ObsoleteAttribute("AssemblyName members HashAlgorithm, ProcessorArchitecture, and VersionCompatibility are obsolete and not supported.", DiagnosticId="SYSLIB0037", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public AssemblyHashAlgorithm HashAlgorithm { get; set; }
-        public ProcessorArchitecture ProcessorArchitecture { get; set; }
+        [ObsoleteAttribute("AssemblyName members HashAlgorithm, ProcessorArchitecture, and VersionCompatibility are obsolete and not supported.", DiagnosticId="SYSLIB0037", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public ProcessorArchitecture ProcessorArchitecture { get; set; }
-        public AssemblyVersionCompatibility VersionCompatibility { get; set; }
+        [ObsoleteAttribute("AssemblyName members HashAlgorithm, ProcessorArchitecture, and VersionCompatibility are obsolete and not supported.", DiagnosticId="SYSLIB0037", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public AssemblyVersionCompatibility VersionCompatibility { get; set; }
     }
-    public readonly struct CustomAttributeNamedArgument {
+    public readonly struct CustomAttributeNamedArgument : IEquatable<CustomAttributeNamedArgument> {
-        public override bool Equals(object? obj);
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
+        public bool Equals(CustomAttributeNamedArgument other);
     }
-    public readonly struct CustomAttributeTypedArgument {
+    public readonly struct CustomAttributeTypedArgument : IEquatable<CustomAttributeTypedArgument> {
-        public override bool Equals(object? obj);
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
+        public bool Equals(CustomAttributeTypedArgument other);
     }
     public abstract class MethodBase : MemberInfo {
-        public static MethodBase GetCurrentMethod();
+        [RequiresUnreferencedCodeAttribute("Metadata for the method might be incomplete or removed")]
+        public static MethodBase GetCurrentMethod();
     }
     public class TypeDelegator : TypeInfo {
+        public override MemberInfo GetMemberWithSameMetadataDefinitionAs(MemberInfo member);
     }
 }
```

