# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    [AttributeUsageAttribute(AttributeTargets.All, AllowMultiple=true, Inherited=false)]
+    public sealed class CompilerFeatureRequiredAttribute : Attribute {
+        public const string RefStructs = "RefStructs";
+        public const string RequiredMembers = "RequiredMembers";
+        public CompilerFeatureRequiredAttribute(string featureName);
+        public string FeatureName { get; }
+        public bool IsOptional { get; set; }
+    }
     public sealed class ConditionalWeakTable<TKey, TValue> : IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>> where TKey : class where TValue : class? {
+        public bool TryAdd(TKey key, TValue value);
     }
+    [AttributeUsageAttribute(AttributeTargets.Assembly, Inherited=false, AllowMultiple=false)]
+    public sealed class DisableRuntimeMarshallingAttribute : Attribute {
+        public DisableRuntimeMarshallingAttribute();
+    }
     public static class FormattableStringFactory {
-        public static FormattableString Create(string format, params object?[] arguments);
+        public static FormattableString Create([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] arguments);
     }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Struct, AllowMultiple=false, Inherited=false)]
+    public class MetadataUpdateOriginalTypeAttribute : Attribute {
+        public MetadataUpdateOriginalTypeAttribute(Type originalType);
+        public Type OriginalType { get; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Field | AttributeTargets.Property | AttributeTargets.Struct, AllowMultiple=false, Inherited=false)]
+    public sealed class RequiredMemberAttribute : Attribute {
+        public RequiredMemberAttribute();
+    }
-    public class RuleCache<T> where T : class
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public class RuleCache<T> where T : class
     public static class RuntimeFeature {
+        public const string ByRefFields = "ByRefFields";
+        public const string NumericIntPtr = "NumericIntPtr";
-        [RequiresPreviewFeaturesAttribute("Generic Math is in preview.", Url="https://aka.ms/dotnet-warnings/generic-math-preview")]
-        public const string VirtualStaticsInInterfaces = "VirtualStaticsInInterfaces";
+        public const string VirtualStaticsInInterfaces = "VirtualStaticsInInterfaces";
     }
     public static class RuntimeHelpers {
+        public static ReadOnlySpan<T> CreateSpan<T>(RuntimeFieldHandle fldHandle);
     }
     public static class Unsafe {
-        public unsafe static void* Add<T>(void* source, int elementOffset);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void* Add<T>(void* source, int elementOffset);
-        public static ref T Add<T>(ref T source, [NativeIntegerAttribute] UIntPtr elementOffset);
+        [CLSCompliantAttribute(false)]
+        public static ref T Add<T>(ref T source, UIntPtr elementOffset);
-        public static ref T AddByteOffset<T>(ref T source, [NativeIntegerAttribute] UIntPtr byteOffset);
+        [CLSCompliantAttribute(false)]
+        public static ref T AddByteOffset<T>(ref T source, UIntPtr byteOffset);
-        public unsafe static void* AsPointer<T>(ref T value);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void* AsPointer<T>(ref T value);
-        public unsafe static ref T AsRef<T>(void* source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static ref T AsRef<T>(void* source);
-        public unsafe static void Copy<T>(void* destination, ref T source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Copy<T>(void* destination, ref T source);
-        public unsafe static void Copy<T>(ref T destination, void* source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Copy<T>(ref T destination, void* source);
-        public static void CopyBlock(ref byte destination, ref byte source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void CopyBlock(ref byte destination, ref byte source, uint byteCount);
-        public unsafe static void CopyBlock(void* destination, void* source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void CopyBlock(void* destination, void* source, uint byteCount);
-        public static void CopyBlockUnaligned(ref byte destination, ref byte source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void CopyBlockUnaligned(ref byte destination, ref byte source, uint byteCount);
-        public unsafe static void CopyBlockUnaligned(void* destination, void* source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void CopyBlockUnaligned(void* destination, void* source, uint byteCount);
-        public static void InitBlock(ref byte startAddress, byte value, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void InitBlock(ref byte startAddress, byte value, uint byteCount);
-        public unsafe static void InitBlock(void* startAddress, byte value, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void InitBlock(void* startAddress, byte value, uint byteCount);
-        public static void InitBlockUnaligned(ref byte startAddress, byte value, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void InitBlockUnaligned(ref byte startAddress, byte value, uint byteCount);
-        public unsafe static void InitBlockUnaligned(void* startAddress, byte value, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void InitBlockUnaligned(void* startAddress, byte value, uint byteCount);
-        public unsafe static T Read<T>(void* source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static T Read<T>(void* source);
-        public unsafe static T ReadUnaligned<T>(void* source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static T ReadUnaligned<T>(void* source);
-        public unsafe static void* Subtract<T>(void* source, int elementOffset);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void* Subtract<T>(void* source, int elementOffset);
-        public static ref T Subtract<T>(ref T source, [NativeIntegerAttribute] UIntPtr elementOffset);
+        [CLSCompliantAttribute(false)]
+        public static ref T Subtract<T>(ref T source, UIntPtr elementOffset);
-        public static ref T SubtractByteOffset<T>(ref T source, [NativeIntegerAttribute] UIntPtr byteOffset);
+        [CLSCompliantAttribute(false)]
+        public static ref T SubtractByteOffset<T>(ref T source, UIntPtr byteOffset);
-        public unsafe static void Write<T>(void* destination, T value);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Write<T>(void* destination, T value);
-        public unsafe static void WriteUnaligned<T>(void* destination, T value);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void WriteUnaligned<T>(void* destination, T value);
     }
 }
```

