# System.Runtime.InteropServices.JavaScript

``` diff
+namespace System.Runtime.InteropServices.JavaScript {
+    [SupportedOSPlatformAttribute("browser")]
+    public sealed class JSException : Exception {
+        public JSException(string msg);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Method, Inherited=false, AllowMultiple=false)]
+    [SupportedOSPlatformAttribute("browser")]
+    public sealed class JSExportAttribute : Attribute {
+        public JSExportAttribute();
+    }
+    [CLSCompliantAttribute(false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    [SupportedOSPlatformAttribute("browser")]
+    public sealed class JSFunctionBinding {
+        internal JSFunctionBinding();
+        public static JSFunctionBinding BindJSFunction(string functionName, string moduleName, ReadOnlySpan<JSMarshalerType> signatures);
+        public static JSFunctionBinding BindManagedFunction(string fullyQualifiedName, int signatureHash, ReadOnlySpan<JSMarshalerType> signatures);
+        public static void InvokeJS(JSFunctionBinding signature, Span<JSMarshalerArgument> arguments);
+    }
+    [SupportedOSPlatformAttribute("browser")]
+    public static class JSHost {
+        public static JSObject DotnetInstance { get; }
+        public static JSObject GlobalThis { get; }
+        public static Task<JSObject> ImportAsync(string moduleName, string moduleUrl, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    [AttributeUsageAttribute(AttributeTargets.Method, Inherited=false, AllowMultiple=false)]
+    [SupportedOSPlatformAttribute("browser")]
+    public sealed class JSImportAttribute : Attribute {
+        public JSImportAttribute(string functionName);
+        public JSImportAttribute(string functionName, string moduleName);
+        public string FunctionName { get; }
+        public string? ModuleName { get; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.Parameter | AttributeTargets.ReturnValue, Inherited=false, AllowMultiple=false)]
+    [SupportedOSPlatformAttribute("browser")]
+    public sealed class JSMarshalAsAttribute<T> : Attribute where T : JSType {
+        public JSMarshalAsAttribute();
+    }
+    [CLSCompliantAttribute(false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    [SupportedOSPlatformAttribute("browser")]
+    public struct JSMarshalerArgument {
+        public void Initialize();
+        public void ToJS(Action value);
+        public void ToJS(ArraySegment<byte> value);
+        public void ToJS(ArraySegment<double> value);
+        public void ToJS(ArraySegment<int> value);
+        public void ToJS(bool value);
+        public void ToJS(byte value);
+        public void ToJS(byte[] value);
+        public void ToJS(char value);
+        public void ToJS(DateTime value);
+        public void ToJS(DateTimeOffset value);
+        public void ToJS(double value);
+        public void ToJS(double[] value);
+        public void ToJS(Exception value);
+        public void ToJS(short value);
+        public void ToJS(int value);
+        public void ToJS(int[] value);
+        public void ToJS(long value);
+        public void ToJS(IntPtr value);
+        public void ToJS(bool? value);
+        public void ToJS(byte? value);
+        public void ToJS(char? value);
+        public void ToJS(DateTime? value);
+        public void ToJS(DateTimeOffset? value);
+        public void ToJS(double? value);
+        public void ToJS(short? value);
+        public void ToJS(int? value);
+        public void ToJS(long? value);
+        public void ToJS(IntPtr? value);
+        public void ToJS(float? value);
+        public void ToJS(object value);
+        public void ToJS(object[] value);
+        public void ToJS(JSObject value);
+        public void ToJS(JSObject[] value);
+        public void ToJS(float value);
+        public void ToJS(Span<byte> value);
+        public void ToJS(Span<double> value);
+        public void ToJS(Span<int> value);
+        public void ToJS(string value);
+        public void ToJS(string[] value);
+        public void ToJS(Task value);
+        public unsafe void ToJS(void* value);
+        public void ToJS<T, TResult>(Func<T, TResult>? value, JSMarshalerArgument.ArgumentToManagedCallback<T> arg1Marshaler, JSMarshalerArgument.ArgumentToJSCallback<TResult> resMarshaler);
+        public void ToJS<T1, T2, T3, TResult>(Func<T1, T2, T3, TResult>? value, JSMarshalerArgument.ArgumentToManagedCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<T2> arg2Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<T3> arg3Marshaler, JSMarshalerArgument.ArgumentToJSCallback<TResult> resMarshaler);
+        public void ToJS<T1, T2, T3>(Action<T1, T2, T3>? value, JSMarshalerArgument.ArgumentToManagedCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<T2> arg2Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<T3> arg3Marshaler);
+        public void ToJS<T1, T2, TResult>(Func<T1, T2, TResult>? value, JSMarshalerArgument.ArgumentToManagedCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<T2> arg2Marshaler, JSMarshalerArgument.ArgumentToJSCallback<TResult> resMarshaler);
+        public void ToJS<T1, T2>(Action<T1, T2>? value, JSMarshalerArgument.ArgumentToManagedCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<T2> arg2Marshaler);
+        public void ToJS<T>(Action<T>? value, JSMarshalerArgument.ArgumentToManagedCallback<T> arg1Marshaler);
+        public void ToJS<T>(Task<T>? value, JSMarshalerArgument.ArgumentToJSCallback<T> marshaler);
+        public void ToJS<TResult>(Func<TResult>? value, JSMarshalerArgument.ArgumentToJSCallback<TResult> resMarshaler);
+        public void ToJSBig(long value);
+        public void ToJSBig(long? value);
+        public void ToManaged(out Action value);
+        public void ToManaged(out ArraySegment<byte> value);
+        public void ToManaged(out ArraySegment<double> value);
+        public void ToManaged(out ArraySegment<int> value);
+        public void ToManaged(out bool value);
+        public void ToManaged(out byte value);
+        public void ToManaged(out byte[] value);
+        public void ToManaged(out char value);
+        public void ToManaged(out DateTime value);
+        public void ToManaged(out DateTimeOffset value);
+        public void ToManaged(out double value);
+        public void ToManaged(out double[] value);
+        public void ToManaged(out Exception value);
+        public void ToManaged(out short value);
+        public void ToManaged(out int value);
+        public void ToManaged(out int[] value);
+        public void ToManaged(out long value);
+        public void ToManaged(out IntPtr value);
+        public void ToManaged(out bool? value);
+        public void ToManaged(out byte? value);
+        public void ToManaged(out char? value);
+        public void ToManaged(out DateTime? value);
+        public void ToManaged(out DateTimeOffset? value);
+        public void ToManaged(out double? value);
+        public void ToManaged(out short? value);
+        public void ToManaged(out int? value);
+        public void ToManaged(out long? value);
+        public void ToManaged(out IntPtr? value);
+        public void ToManaged(out float? value);
+        public void ToManaged(out object value);
+        public void ToManaged(out object[] value);
+        public void ToManaged(out JSObject value);
+        public void ToManaged(out JSObject[] value);
+        public void ToManaged(out float value);
+        public void ToManaged(out Span<byte> value);
+        public void ToManaged(out Span<double> value);
+        public void ToManaged(out Span<int> value);
+        public void ToManaged(out string value);
+        public void ToManaged(out string[] value);
+        public void ToManaged(out Task value);
+        public unsafe void ToManaged(out void* value);
+        public void ToManaged<T, TResult>(out Func<T, TResult>? value, JSMarshalerArgument.ArgumentToJSCallback<T> arg1Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<TResult> resMarshaler);
+        public void ToManaged<T1, T2, T3, TResult>(out Func<T1, T2, T3, TResult>? value, JSMarshalerArgument.ArgumentToJSCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToJSCallback<T2> arg2Marshaler, JSMarshalerArgument.ArgumentToJSCallback<T3> arg3Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<TResult> resMarshaler);
+        public void ToManaged<T1, T2, T3>(out Action<T1, T2, T3>? value, JSMarshalerArgument.ArgumentToJSCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToJSCallback<T2> arg2Marshaler, JSMarshalerArgument.ArgumentToJSCallback<T3> arg3Marshaler);
+        public void ToManaged<T1, T2, TResult>(out Func<T1, T2, TResult>? value, JSMarshalerArgument.ArgumentToJSCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToJSCallback<T2> arg2Marshaler, JSMarshalerArgument.ArgumentToManagedCallback<TResult> resMarshaler);
+        public void ToManaged<T1, T2>(out Action<T1, T2>? value, JSMarshalerArgument.ArgumentToJSCallback<T1> arg1Marshaler, JSMarshalerArgument.ArgumentToJSCallback<T2> arg2Marshaler);
+        public void ToManaged<T>(out Action<T>? value, JSMarshalerArgument.ArgumentToJSCallback<T> arg1Marshaler);
+        public void ToManaged<T>(out Task<T>? value, JSMarshalerArgument.ArgumentToManagedCallback<T> marshaler);
+        public void ToManaged<TResult>(out Func<TResult>? value, JSMarshalerArgument.ArgumentToManagedCallback<TResult> resMarshaler);
+        public void ToManagedBig(out long value);
+        public void ToManagedBig(out long? value);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public delegate void ArgumentToJSCallback<T>(ref JSMarshalerArgument arg, T value);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public delegate void ArgumentToManagedCallback<T>(ref JSMarshalerArgument arg, out T value);
+    }
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    [SupportedOSPlatformAttribute("browser")]
+    public sealed class JSMarshalerType {
+        public static JSMarshalerType BigInt64 { get; }
+        public static JSMarshalerType Boolean { get; }
+        public static JSMarshalerType Byte { get; }
+        public static JSMarshalerType Char { get; }
+        public static JSMarshalerType DateTime { get; }
+        public static JSMarshalerType DateTimeOffset { get; }
+        public static JSMarshalerType Discard { get; }
+        public static JSMarshalerType Double { get; }
+        public static JSMarshalerType Exception { get; }
+        public static JSMarshalerType Int16 { get; }
+        public static JSMarshalerType Int32 { get; }
+        public static JSMarshalerType Int52 { get; }
+        public static JSMarshalerType IntPtr { get; }
+        public static JSMarshalerType JSObject { get; }
+        public static JSMarshalerType Object { get; }
+        public static JSMarshalerType Single { get; }
+        public static JSMarshalerType String { get; }
+        public static JSMarshalerType Void { get; }
+        public static JSMarshalerType Action();
+        public static JSMarshalerType Action(JSMarshalerType arg1);
+        public static JSMarshalerType Action(JSMarshalerType arg1, JSMarshalerType arg2);
+        public static JSMarshalerType Action(JSMarshalerType arg1, JSMarshalerType arg2, JSMarshalerType arg3);
+        public static JSMarshalerType Array(JSMarshalerType element);
+        public static JSMarshalerType ArraySegment(JSMarshalerType element);
+        public static JSMarshalerType Function(JSMarshalerType result);
+        public static JSMarshalerType Function(JSMarshalerType arg1, JSMarshalerType result);
+        public static JSMarshalerType Function(JSMarshalerType arg1, JSMarshalerType arg2, JSMarshalerType result);
+        public static JSMarshalerType Function(JSMarshalerType arg1, JSMarshalerType arg2, JSMarshalerType arg3, JSMarshalerType result);
+        public static JSMarshalerType Nullable(JSMarshalerType primitive);
+        public static JSMarshalerType Span(JSMarshalerType element);
+        public static JSMarshalerType Task();
+        public static JSMarshalerType Task(JSMarshalerType result);
+    }
+    [SupportedOSPlatformAttribute("browser")]
+    public class JSObject : IDisposable {
+        public bool IsDisposed { get; }
+        public void Dispose();
+        public bool GetPropertyAsBoolean(string propertyName);
+        public byte[]? GetPropertyAsByteArray(string propertyName);
+        public double GetPropertyAsDouble(string propertyName);
+        public int GetPropertyAsInt32(string propertyName);
+        public JSObject? GetPropertyAsJSObject(string propertyName);
+        public string? GetPropertyAsString(string propertyName);
+        public string GetTypeOfProperty(string propertyName);
+        public bool HasProperty(string propertyName);
+        public void SetProperty(string propertyName, bool value);
+        public void SetProperty(string propertyName, byte[]? value);
+        public void SetProperty(string propertyName, double value);
+        public void SetProperty(string propertyName, int value);
+        public void SetProperty(string propertyName, JSObject? value);
+        public void SetProperty(string propertyName, string? value);
+    }
+    [SupportedOSPlatformAttribute("browser")]
+    public abstract class JSType {
+        public sealed class Any : JSType
+        public sealed class Array<T> : JSType where T : JSType
+        public sealed class BigInt : JSType
+        public sealed class Boolean : JSType
+        public sealed class Date : JSType
+        public sealed class Discard : JSType
+        public sealed class Error : JSType
+        public sealed class Function : JSType
+        public sealed class Function<T> : JSType where T : JSType
+        public sealed class Function<T1, T2> : JSType where T1 : JSType where T2 : JSType
+        public sealed class Function<T1, T2, T3> : JSType where T1 : JSType where T2 : JSType where T3 : JSType
+        public sealed class Function<T1, T2, T3, T4> : JSType where T1 : JSType where T2 : JSType where T3 : JSType where T4 : JSType
+        public sealed class MemoryView : JSType
+        public sealed class Number : JSType
+        public sealed class Object : JSType
+        public sealed class Promise<T> : JSType where T : JSType
+        public sealed class String : JSType
+        public sealed class Void : JSType
+    }
+}
```

