# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public enum Architecture {
+        Armv6 = 7,
+        LoongArch64 = 6,
+        Ppc64le = 8,
     }
-    public readonly struct ArrayWithOffset
+    public readonly struct ArrayWithOffset : IEquatable<ArrayWithOffset>
     public enum ClassInterfaceType {
-        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
-        [ObsoleteAttribute("Support for IDispatch may be unavailable in future releases.")]
-        AutoDispatch = 1,
+        AutoDispatch = 1,
-        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
-        [ObsoleteAttribute("Support for IDispatch may be unavailable in future releases.")]
-        AutoDual = 2,
+        AutoDual = 2,
     }
-    public struct GCHandle {
+    public struct GCHandle : IEquatable<GCHandle> {
+        public bool Equals(GCHandle other);
     }
+    [AttributeUsageAttribute(AttributeTargets.Method, AllowMultiple=false, Inherited=false)]
+    public sealed class LibraryImportAttribute : Attribute {
+        public LibraryImportAttribute(string libraryName);
+        public string EntryPoint { get; set; }
+        public string LibraryName { get; }
+        public bool SetLastError { get; set; }
+        public StringMarshalling StringMarshalling { get; set; }
+        public Type StringMarshallingCustomType { get; set; }
+    }
     public static class Marshal {
-        public static IntPtr GetHINSTANCE(Module m);
+        [RequiresAssemblyFilesAttribute("Windows only assigns HINSTANCE to assemblies loaded from disk. This API will return -1 for modules without a file on disk.")]
+        public static IntPtr GetHINSTANCE(Module m);
+        public static string GetLastPInvokeErrorMessage();
+        public static string GetPInvokeErrorMessage(int error);
     }
     public static class NativeLibrary {
+        public static IntPtr GetMainProgramHandle();
     }
     public static class NativeMemory {
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Clear(void* ptr, UIntPtr byteCount);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Copy(void* source, void* destination, UIntPtr byteCount);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Fill(void* ptr, UIntPtr byteCount, byte value);
     }
-    public readonly struct NFloat : IEquatable<NFloat> {
+    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat, bool>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat, bool>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointConstants<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat> {
+        public static NFloat E { get; }
+        public static NFloat Epsilon { get; }
+        public static NFloat MaxValue { get; }
+        public static NFloat MinValue { get; }
+        public static NFloat NaN { get; }
+        public static NFloat NegativeInfinity { get; }
+        public static NFloat NegativeZero { get; }
+        public static NFloat Pi { get; }
+        public static NFloat PositiveInfinity { get; }
+        public static int Size { get; }
+        static NFloat System.Numerics.IAdditiveIdentity<System.Runtime.InteropServices.NFloat,System.Runtime.InteropServices.NFloat>.AdditiveIdentity { get; }
+        static NFloat System.Numerics.IBinaryNumber<System.Runtime.InteropServices.NFloat>.AllBitsSet { get; }
+        static NFloat System.Numerics.IMultiplicativeIdentity<System.Runtime.InteropServices.NFloat,System.Runtime.InteropServices.NFloat>.MultiplicativeIdentity { get; }
+        static NFloat System.Numerics.INumberBase<System.Runtime.InteropServices.NFloat>.One { get; }
+        static int System.Numerics.INumberBase<System.Runtime.InteropServices.NFloat>.Radix { get; }
+        static NFloat System.Numerics.INumberBase<System.Runtime.InteropServices.NFloat>.Zero { get; }
+        static NFloat System.Numerics.ISignedNumber<System.Runtime.InteropServices.NFloat>.NegativeOne { get; }
+        public static NFloat Tau { get; }
+        public static NFloat Abs(NFloat value);
+        public static NFloat Acos(NFloat x);
+        public static NFloat Acosh(NFloat x);
+        public static NFloat AcosPi(NFloat x);
+        public static NFloat Asin(NFloat x);
+        public static NFloat Asinh(NFloat x);
+        public static NFloat AsinPi(NFloat x);
+        public static NFloat Atan(NFloat x);
+        public static NFloat Atan2(NFloat y, NFloat x);
+        public static NFloat Atan2Pi(NFloat y, NFloat x);
+        public static NFloat Atanh(NFloat x);
+        public static NFloat AtanPi(NFloat x);
+        public static NFloat BitDecrement(NFloat x);
+        public static NFloat BitIncrement(NFloat x);
+        public static NFloat Cbrt(NFloat x);
+        public static NFloat Ceiling(NFloat x);
+        public static NFloat Clamp(NFloat value, NFloat min, NFloat max);
+        public int CompareTo(object? obj);
+        public int CompareTo(NFloat other);
+        public static NFloat CopySign(NFloat value, NFloat sign);
+        public static NFloat Cos(NFloat x);
+        public static NFloat Cosh(NFloat x);
+        public static NFloat CosPi(NFloat x);
+        public static NFloat CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static NFloat CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static NFloat CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
-        public override bool Equals([NotNullWhenAttribute(true)] object? o);
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
+        public static NFloat Exp(NFloat x);
+        public static NFloat Exp10(NFloat x);
+        public static NFloat Exp10M1(NFloat x);
+        public static NFloat Exp2(NFloat x);
+        public static NFloat Exp2M1(NFloat x);
+        public static NFloat ExpM1(NFloat x);
+        public static NFloat Floor(NFloat x);
+        public static NFloat FusedMultiplyAdd(NFloat left, NFloat right, NFloat addend);
+        public static NFloat Hypot(NFloat x, NFloat y);
+        public static NFloat Ieee754Remainder(NFloat left, NFloat right);
+        public static int ILogB(NFloat x);
+        public static bool IsEvenInteger(NFloat value);
+        public static bool IsFinite(NFloat value);
+        public static bool IsInfinity(NFloat value);
+        public static bool IsInteger(NFloat value);
+        public static bool IsNaN(NFloat value);
+        public static bool IsNegative(NFloat value);
+        public static bool IsNegativeInfinity(NFloat value);
+        public static bool IsNormal(NFloat value);
+        public static bool IsOddInteger(NFloat value);
+        public static bool IsPositive(NFloat value);
+        public static bool IsPositiveInfinity(NFloat value);
+        public static bool IsPow2(NFloat value);
+        public static bool IsRealNumber(NFloat value);
+        public static bool IsSubnormal(NFloat value);
+        public static NFloat Log(NFloat x);
+        public static NFloat Log(NFloat x, NFloat newBase);
+        public static NFloat Log10(NFloat x);
+        public static NFloat Log10P1(NFloat x);
+        public static NFloat Log2(NFloat value);
+        public static NFloat Log2P1(NFloat x);
+        public static NFloat LogP1(NFloat x);
+        public static NFloat Max(NFloat x, NFloat y);
+        public static NFloat MaxMagnitude(NFloat x, NFloat y);
+        public static NFloat MaxMagnitudeNumber(NFloat x, NFloat y);
+        public static NFloat MaxNumber(NFloat x, NFloat y);
+        public static NFloat Min(NFloat x, NFloat y);
+        public static NFloat MinMagnitude(NFloat x, NFloat y);
+        public static NFloat MinMagnitudeNumber(NFloat x, NFloat y);
+        public static NFloat MinNumber(NFloat x, NFloat y);
+        public static NFloat operator +(NFloat left, NFloat right);
+        public static explicit operator checked byte (NFloat value);
+        public static explicit operator checked char (NFloat value);
+        public static explicit operator checked short (NFloat value);
+        public static explicit operator checked int (NFloat value);
+        public static explicit operator checked long (NFloat value);
+        public static explicit operator checked Int128 (NFloat value);
+        public static explicit operator checked IntPtr (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked sbyte (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ushort (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked uint (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ulong (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UInt128 (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UIntPtr (NFloat value);
+        public static NFloat operator --(NFloat value);
+        public static NFloat operator /(NFloat left, NFloat right);
+        public static bool operator ==(NFloat left, NFloat right);
+        public static explicit operator NFloat (decimal value);
+        public static explicit operator NFloat (double value);
+        public static explicit operator NFloat (Int128 value);
+        public static explicit operator byte (NFloat value);
+        public static explicit operator char (NFloat value);
+        public static explicit operator decimal (NFloat value);
+        public static explicit operator Half (NFloat value);
+        public static explicit operator Int128 (NFloat value);
+        public static explicit operator short (NFloat value);
+        public static explicit operator int (NFloat value);
+        public static explicit operator long (NFloat value);
+        public static explicit operator IntPtr (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator sbyte (NFloat value);
+        public static explicit operator float (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UInt128 (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ushort (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator uint (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ulong (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UIntPtr (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator NFloat (UInt128 value);
+        public static bool operator >(NFloat left, NFloat right);
+        public static bool operator >=(NFloat left, NFloat right);
+        public static implicit operator NFloat (byte value);
+        public static implicit operator NFloat (char value);
+        public static implicit operator NFloat (Half value);
+        public static implicit operator NFloat (short value);
+        public static implicit operator NFloat (int value);
+        public static implicit operator NFloat (long value);
+        public static implicit operator NFloat (IntPtr value);
+        public static implicit operator double (NFloat value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator NFloat (sbyte value);
+        public static implicit operator NFloat (float value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator NFloat (ushort value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator NFloat (uint value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator NFloat (ulong value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator NFloat (UIntPtr value);
+        public static NFloat operator ++(NFloat value);
+        public static bool operator !=(NFloat left, NFloat right);
+        public static bool operator <(NFloat left, NFloat right);
+        public static bool operator <=(NFloat left, NFloat right);
+        public static NFloat operator %(NFloat left, NFloat right);
+        public static NFloat operator *(NFloat left, NFloat right);
+        public static NFloat operator -(NFloat left, NFloat right);
+        public static NFloat operator -(NFloat value);
+        public static NFloat operator +(NFloat value);
+        public static NFloat Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        public static NFloat Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static NFloat Parse(string s);
+        public static NFloat Parse(string s, NumberStyles style);
+        public static NFloat Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static NFloat Parse(string s, IFormatProvider? provider);
+        public static NFloat Pow(NFloat x, NFloat y);
+        public static NFloat ReciprocalEstimate(NFloat x);
+        public static NFloat ReciprocalSqrtEstimate(NFloat x);
+        public static NFloat RootN(NFloat x, int n);
+        public static NFloat Round(NFloat x);
+        public static NFloat Round(NFloat x, int digits);
+        public static NFloat Round(NFloat x, int digits, MidpointRounding mode);
+        public static NFloat Round(NFloat x, MidpointRounding mode);
+        public static NFloat ScaleB(NFloat x, int n);
+        public static int Sign(NFloat value);
+        public static NFloat Sin(NFloat x);
+        public static (NFloat Sin, NFloat Cos) SinCos(NFloat x);
+        public static (NFloat SinPi, NFloat CosPi) SinCosPi(NFloat x);
+        public static NFloat Sinh(NFloat x);
+        public static NFloat SinPi(NFloat x);
+        public static NFloat Sqrt(NFloat x);
+        static NFloat IAdditionOperators<NFloat, NFloat, NFloat>.operator checked +(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator &(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator |(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator ^(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator ~(NFloat value);
+        static NFloat IDecrementOperators<NFloat>.operator checked --(NFloat value);
+        static NFloat IDivisionOperators<NFloat, NFloat, NFloat>.operator checked /(NFloat left, NFloat right);
+        int IFloatingPoint<NFloat>.GetExponentByteCount();
+        int IFloatingPoint<NFloat>.GetExponentShortestBitLength();
+        int IFloatingPoint<NFloat>.GetSignificandBitLength();
+        int IFloatingPoint<NFloat>.GetSignificandByteCount();
+        bool IFloatingPoint<NFloat>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<NFloat>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<NFloat>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<NFloat>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static NFloat IIncrementOperators<NFloat>.operator checked ++(NFloat value);
+        static NFloat IMultiplyOperators<NFloat, NFloat, NFloat>.operator checked *(NFloat left, NFloat right);
+        static bool INumberBase<NFloat>.IsCanonical(NFloat value);
+        static bool INumberBase<NFloat>.IsComplexNumber(NFloat value);
+        static bool INumberBase<NFloat>.IsImaginaryNumber(NFloat value);
+        static bool INumberBase<NFloat>.IsZero(NFloat value);
+        static bool INumberBase<NFloat>.TryConvertFromChecked<TOther>(TOther value, out NFloat result);
+        static bool INumberBase<NFloat>.TryConvertFromSaturating<TOther>(TOther value, out NFloat result);
+        static bool INumberBase<NFloat>.TryConvertFromTruncating<TOther>(TOther value, out NFloat result);
+        static bool INumberBase<NFloat>.TryConvertToChecked<TOther>(NFloat value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<NFloat>.TryConvertToSaturating<TOther>(NFloat value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<NFloat>.TryConvertToTruncating<TOther>(NFloat value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static NFloat ISubtractionOperators<NFloat, NFloat, NFloat>.operator checked -(NFloat left, NFloat right);
+        static NFloat IUnaryNegationOperators<NFloat, NFloat>.operator checked -(NFloat value);
+        public static NFloat Tan(NFloat x);
+        public static NFloat Tanh(NFloat x);
+        public static NFloat TanPi(NFloat x);
+        public string ToString(IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static NFloat Truncate(NFloat x);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse(ReadOnlySpan<char> s, out NFloat result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, NumberStyles style, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, out NFloat result);
     }
+    public enum StringMarshalling {
+        Custom = 0,
+        Utf16 = 2,
+        Utf8 = 1,
+    }
 }
```

