# System.Runtime.Intrinsics

``` diff
 namespace System.Runtime.Intrinsics {
     public static class Vector128 {
+        public static bool IsHardwareAccelerated { get; }
+        public static Vector128<T> Abs<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> Add<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> AndNot<T>(Vector128<T> left, Vector128<T> right) where T : struct;
-        public static Vector128<U> As<T, U>(this Vector128<T> vector) where T : struct where U : struct;
+        public static Vector128<TTo> As<TFrom, TTo>(this Vector128<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector128<IntPtr> AsNInt<T>(this Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<UIntPtr> AsNUInt<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<T> BitwiseAnd<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> BitwiseOr<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<double> Ceiling(Vector128<double> vector);
+        public static Vector128<float> Ceiling(Vector128<float> vector);
+        public static Vector128<T> ConditionalSelect<T>(Vector128<T> condition, Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<double> ConvertToDouble(Vector128<long> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<double> ConvertToDouble(Vector128<ulong> vector);
+        public static Vector128<int> ConvertToInt32(Vector128<float> vector);
+        public static Vector128<long> ConvertToInt64(Vector128<double> vector);
+        public static Vector128<float> ConvertToSingle(Vector128<int> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<float> ConvertToSingle(Vector128<uint> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<uint> ConvertToUInt32(Vector128<float> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ulong> ConvertToUInt64(Vector128<double> vector);
+        public static void CopyTo<T>(this Vector128<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector128<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector128<T> vector, T[] destination, int startIndex) where T : struct;
+        public static Vector128<IntPtr> Create(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<UIntPtr> Create(UIntPtr value);
+        public static Vector128<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector128<T> Create<T>(T value) where T : struct;
+        public static Vector128<T> Create<T>(T[] values) where T : struct;
+        public static Vector128<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector128<IntPtr> CreateScalar(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<UIntPtr> CreateScalar(UIntPtr value);
+        public static Vector128<IntPtr> CreateScalarUnsafe(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<UIntPtr> CreateScalarUnsafe(UIntPtr value);
+        public static Vector128<T> Divide<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static T Dot<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Equals<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static uint ExtractMostSignificantBits<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<double> Floor(Vector128<double> vector);
+        public static Vector128<float> Floor(Vector128<float> vector);
+        public static Vector128<T> GreaterThan<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> GreaterThanOrEqual<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> LessThan<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> LessThanOrEqual<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector128<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector128<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector128<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        public static Vector128<T> LoadUnsafe<T>(ref T source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        public static Vector128<T> Max<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Min<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Multiply<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Multiply<T>(Vector128<T> left, T right) where T : struct;
+        public static Vector128<T> Multiply<T>(T left, Vector128<T> right) where T : struct;
+        public static Vector128<float> Narrow(Vector128<double> lower, Vector128<double> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<sbyte> Narrow(Vector128<short> lower, Vector128<short> upper);
+        public static Vector128<short> Narrow(Vector128<int> lower, Vector128<int> upper);
+        public static Vector128<int> Narrow(Vector128<long> lower, Vector128<long> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<byte> Narrow(Vector128<ushort> lower, Vector128<ushort> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ushort> Narrow(Vector128<uint> lower, Vector128<uint> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<uint> Narrow(Vector128<ulong> lower, Vector128<ulong> upper);
+        public static Vector128<T> Negate<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> OnesComplement<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<byte> ShiftLeft(Vector128<byte> vector, int shiftCount);
+        public static Vector128<short> ShiftLeft(Vector128<short> vector, int shiftCount);
+        public static Vector128<int> ShiftLeft(Vector128<int> vector, int shiftCount);
+        public static Vector128<long> ShiftLeft(Vector128<long> vector, int shiftCount);
+        public static Vector128<IntPtr> ShiftLeft(Vector128<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<sbyte> ShiftLeft(Vector128<sbyte> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ushort> ShiftLeft(Vector128<ushort> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<uint> ShiftLeft(Vector128<uint> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ulong> ShiftLeft(Vector128<ulong> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<UIntPtr> ShiftLeft(Vector128<UIntPtr> vector, int shiftCount);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> vector, int shiftCount);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> vector, int shiftCount);
+        public static Vector128<long> ShiftRightArithmetic(Vector128<long> vector, int shiftCount);
+        public static Vector128<IntPtr> ShiftRightArithmetic(Vector128<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<sbyte> ShiftRightArithmetic(Vector128<sbyte> vector, int shiftCount);
+        public static Vector128<byte> ShiftRightLogical(Vector128<byte> vector, int shiftCount);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> vector, int shiftCount);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> vector, int shiftCount);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> vector, int shiftCount);
+        public static Vector128<IntPtr> ShiftRightLogical(Vector128<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<sbyte> ShiftRightLogical(Vector128<sbyte> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<UIntPtr> ShiftRightLogical(Vector128<UIntPtr> vector, int shiftCount);
+        public static Vector128<byte> Shuffle(Vector128<byte> vector, Vector128<byte> indices);
+        public static Vector128<double> Shuffle(Vector128<double> vector, Vector128<long> indices);
+        public static Vector128<short> Shuffle(Vector128<short> vector, Vector128<short> indices);
+        public static Vector128<int> Shuffle(Vector128<int> vector, Vector128<int> indices);
+        public static Vector128<long> Shuffle(Vector128<long> vector, Vector128<long> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<sbyte> Shuffle(Vector128<sbyte> vector, Vector128<sbyte> indices);
+        public static Vector128<float> Shuffle(Vector128<float> vector, Vector128<int> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ushort> Shuffle(Vector128<ushort> vector, Vector128<ushort> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<uint> Shuffle(Vector128<uint> vector, Vector128<uint> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ulong> Shuffle(Vector128<ulong> vector, Vector128<ulong> indices);
+        public static Vector128<T> Sqrt<T>(Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector128<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector128<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector128<T> source, T* destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        public static Vector128<T> Subtract<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static T Sum<T>(Vector128<T> vector) where T : struct;
+        public static bool TryCopyTo<T>(this Vector128<T> vector, Span<T> destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static (Vector128<ushort> Lower, Vector128<ushort> Upper) Widen(Vector128<byte> source);
+        public static (Vector128<int> Lower, Vector128<int> Upper) Widen(Vector128<short> source);
+        public static (Vector128<long> Lower, Vector128<long> Upper) Widen(Vector128<int> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector128<short> Lower, Vector128<short> Upper) Widen(Vector128<sbyte> source);
+        public static (Vector128<double> Lower, Vector128<double> Upper) Widen(Vector128<float> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector128<uint> Lower, Vector128<uint> Upper) Widen(Vector128<ushort> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector128<ulong> Lower, Vector128<ulong> Upper) Widen(Vector128<uint> source);
+        public static Vector128<T> Xor<T>(Vector128<T> left, Vector128<T> right) where T : struct;
     }
     public readonly struct Vector128<T> : IEquatable<Vector128<T>> where T : struct {
+        public static bool IsSupported { get; }
+        public T this[int index] { get; }
+        public static Vector128<T> operator +(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator &(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator |(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator /(Vector128<T> left, Vector128<T> right);
+        public static bool operator ==(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator ^(Vector128<T> left, Vector128<T> right);
+        public static bool operator !=(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator *(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator *(Vector128<T> left, T right);
+        public static Vector128<T> operator *(T left, Vector128<T> right);
+        public static Vector128<T> operator ~(Vector128<T> vector);
+        public static Vector128<T> operator -(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator -(Vector128<T> vector);
+        public static Vector128<T> operator +(Vector128<T> value);
     }
     public static class Vector256 {
+        public static bool IsHardwareAccelerated { get; }
+        public static Vector256<T> Abs<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> Add<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> AndNot<T>(Vector256<T> left, Vector256<T> right) where T : struct;
-        public static Vector256<U> As<T, U>(this Vector256<T> vector) where T : struct where U : struct;
+        public static Vector256<TTo> As<TFrom, TTo>(this Vector256<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector256<IntPtr> AsNInt<T>(this Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<UIntPtr> AsNUInt<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<T> BitwiseAnd<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> BitwiseOr<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<double> Ceiling(Vector256<double> vector);
+        public static Vector256<float> Ceiling(Vector256<float> vector);
+        public static Vector256<T> ConditionalSelect<T>(Vector256<T> condition, Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<double> ConvertToDouble(Vector256<long> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<double> ConvertToDouble(Vector256<ulong> vector);
+        public static Vector256<int> ConvertToInt32(Vector256<float> vector);
+        public static Vector256<long> ConvertToInt64(Vector256<double> vector);
+        public static Vector256<float> ConvertToSingle(Vector256<int> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<float> ConvertToSingle(Vector256<uint> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<uint> ConvertToUInt32(Vector256<float> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ulong> ConvertToUInt64(Vector256<double> vector);
+        public static void CopyTo<T>(this Vector256<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector256<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector256<T> vector, T[] destination, int startIndex) where T : struct;
+        public static Vector256<IntPtr> Create(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<UIntPtr> Create(UIntPtr value);
+        public static Vector256<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector256<T> Create<T>(T value) where T : struct;
+        public static Vector256<T> Create<T>(T[] values) where T : struct;
+        public static Vector256<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector256<IntPtr> CreateScalar(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<UIntPtr> CreateScalar(UIntPtr value);
+        public static Vector256<IntPtr> CreateScalarUnsafe(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<UIntPtr> CreateScalarUnsafe(UIntPtr value);
+        public static Vector256<T> Divide<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static T Dot<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Equals<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static uint ExtractMostSignificantBits<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<double> Floor(Vector256<double> vector);
+        public static Vector256<float> Floor(Vector256<float> vector);
+        public static Vector256<T> GreaterThan<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> GreaterThanOrEqual<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> LessThan<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> LessThanOrEqual<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector256<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector256<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector256<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        public static Vector256<T> LoadUnsafe<T>(ref T source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        public static Vector256<T> Max<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Min<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Multiply<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Multiply<T>(Vector256<T> left, T right) where T : struct;
+        public static Vector256<T> Multiply<T>(T left, Vector256<T> right) where T : struct;
+        public static Vector256<float> Narrow(Vector256<double> lower, Vector256<double> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<sbyte> Narrow(Vector256<short> lower, Vector256<short> upper);
+        public static Vector256<short> Narrow(Vector256<int> lower, Vector256<int> upper);
+        public static Vector256<int> Narrow(Vector256<long> lower, Vector256<long> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<byte> Narrow(Vector256<ushort> lower, Vector256<ushort> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ushort> Narrow(Vector256<uint> lower, Vector256<uint> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<uint> Narrow(Vector256<ulong> lower, Vector256<ulong> upper);
+        public static Vector256<T> Negate<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> OnesComplement<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<byte> ShiftLeft(Vector256<byte> vector, int shiftCount);
+        public static Vector256<short> ShiftLeft(Vector256<short> vector, int shiftCount);
+        public static Vector256<int> ShiftLeft(Vector256<int> vector, int shiftCount);
+        public static Vector256<long> ShiftLeft(Vector256<long> vector, int shiftCount);
+        public static Vector256<IntPtr> ShiftLeft(Vector256<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<sbyte> ShiftLeft(Vector256<sbyte> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ushort> ShiftLeft(Vector256<ushort> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<uint> ShiftLeft(Vector256<uint> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ulong> ShiftLeft(Vector256<ulong> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<UIntPtr> ShiftLeft(Vector256<UIntPtr> vector, int shiftCount);
+        public static Vector256<short> ShiftRightArithmetic(Vector256<short> vector, int shiftCount);
+        public static Vector256<int> ShiftRightArithmetic(Vector256<int> vector, int shiftCount);
+        public static Vector256<long> ShiftRightArithmetic(Vector256<long> vector, int shiftCount);
+        public static Vector256<IntPtr> ShiftRightArithmetic(Vector256<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<sbyte> ShiftRightArithmetic(Vector256<sbyte> vector, int shiftCount);
+        public static Vector256<byte> ShiftRightLogical(Vector256<byte> vector, int shiftCount);
+        public static Vector256<short> ShiftRightLogical(Vector256<short> vector, int shiftCount);
+        public static Vector256<int> ShiftRightLogical(Vector256<int> vector, int shiftCount);
+        public static Vector256<long> ShiftRightLogical(Vector256<long> vector, int shiftCount);
+        public static Vector256<IntPtr> ShiftRightLogical(Vector256<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<sbyte> ShiftRightLogical(Vector256<sbyte> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<uint> ShiftRightLogical(Vector256<uint> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<UIntPtr> ShiftRightLogical(Vector256<UIntPtr> vector, int shiftCount);
+        public static Vector256<byte> Shuffle(Vector256<byte> vector, Vector256<byte> indices);
+        public static Vector256<double> Shuffle(Vector256<double> vector, Vector256<long> indices);
+        public static Vector256<short> Shuffle(Vector256<short> vector, Vector256<short> indices);
+        public static Vector256<int> Shuffle(Vector256<int> vector, Vector256<int> indices);
+        public static Vector256<long> Shuffle(Vector256<long> vector, Vector256<long> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<sbyte> Shuffle(Vector256<sbyte> vector, Vector256<sbyte> indices);
+        public static Vector256<float> Shuffle(Vector256<float> vector, Vector256<int> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ushort> Shuffle(Vector256<ushort> vector, Vector256<ushort> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<uint> Shuffle(Vector256<uint> vector, Vector256<uint> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ulong> Shuffle(Vector256<ulong> vector, Vector256<ulong> indices);
+        public static Vector256<T> Sqrt<T>(Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector256<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector256<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector256<T> source, T* destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        public static Vector256<T> Subtract<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static T Sum<T>(Vector256<T> vector) where T : struct;
+        public static bool TryCopyTo<T>(this Vector256<T> vector, Span<T> destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static (Vector256<ushort> Lower, Vector256<ushort> Upper) Widen(Vector256<byte> source);
+        public static (Vector256<int> Lower, Vector256<int> Upper) Widen(Vector256<short> source);
+        public static (Vector256<long> Lower, Vector256<long> Upper) Widen(Vector256<int> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector256<short> Lower, Vector256<short> Upper) Widen(Vector256<sbyte> source);
+        public static (Vector256<double> Lower, Vector256<double> Upper) Widen(Vector256<float> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector256<uint> Lower, Vector256<uint> Upper) Widen(Vector256<ushort> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector256<ulong> Lower, Vector256<ulong> Upper) Widen(Vector256<uint> source);
+        public static Vector256<T> Xor<T>(Vector256<T> left, Vector256<T> right) where T : struct;
     }
     public readonly struct Vector256<T> : IEquatable<Vector256<T>> where T : struct {
+        public static bool IsSupported { get; }
+        public T this[int index] { get; }
+        public static Vector256<T> operator +(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator &(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator |(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator /(Vector256<T> left, Vector256<T> right);
+        public static bool operator ==(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator ^(Vector256<T> left, Vector256<T> right);
+        public static bool operator !=(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator *(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator *(Vector256<T> left, T right);
+        public static Vector256<T> operator *(T left, Vector256<T> right);
+        public static Vector256<T> operator ~(Vector256<T> vector);
+        public static Vector256<T> operator -(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator -(Vector256<T> vector);
+        public static Vector256<T> operator +(Vector256<T> value);
     }
     public static class Vector64 {
+        public static bool IsHardwareAccelerated { get; }
+        public static Vector64<T> Abs<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> Add<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> AndNot<T>(Vector64<T> left, Vector64<T> right) where T : struct;
-        public static Vector64<U> As<T, U>(this Vector64<T> vector) where T : struct where U : struct;
+        public static Vector64<TTo> As<TFrom, TTo>(this Vector64<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector64<IntPtr> AsNInt<T>(this Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<UIntPtr> AsNUInt<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<T> BitwiseAnd<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> BitwiseOr<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<double> Ceiling(Vector64<double> vector);
+        public static Vector64<float> Ceiling(Vector64<float> vector);
+        public static Vector64<T> ConditionalSelect<T>(Vector64<T> condition, Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<double> ConvertToDouble(Vector64<long> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<double> ConvertToDouble(Vector64<ulong> vector);
+        public static Vector64<int> ConvertToInt32(Vector64<float> vector);
+        public static Vector64<long> ConvertToInt64(Vector64<double> vector);
+        public static Vector64<float> ConvertToSingle(Vector64<int> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<float> ConvertToSingle(Vector64<uint> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<uint> ConvertToUInt32(Vector64<float> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ulong> ConvertToUInt64(Vector64<double> vector);
+        public static void CopyTo<T>(this Vector64<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector64<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector64<T> vector, T[] destination, int startIndex) where T : struct;
+        public static Vector64<IntPtr> Create(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<UIntPtr> Create(UIntPtr value);
+        public static Vector64<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector64<T> Create<T>(T value) where T : struct;
+        public static Vector64<T> Create<T>(T[] values) where T : struct;
+        public static Vector64<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector64<IntPtr> CreateScalar(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<UIntPtr> CreateScalar(UIntPtr value);
+        public static Vector64<IntPtr> CreateScalarUnsafe(IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<UIntPtr> CreateScalarUnsafe(UIntPtr value);
+        public static Vector64<T> Divide<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static T Dot<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Equals<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static uint ExtractMostSignificantBits<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<double> Floor(Vector64<double> vector);
+        public static Vector64<float> Floor(Vector64<float> vector);
+        public static Vector64<T> GreaterThan<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> GreaterThanOrEqual<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> LessThan<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> LessThanOrEqual<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector64<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector64<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector64<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        public static Vector64<T> LoadUnsafe<T>(ref T source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        public static Vector64<T> Max<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Min<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Multiply<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Multiply<T>(Vector64<T> left, T right) where T : struct;
+        public static Vector64<T> Multiply<T>(T left, Vector64<T> right) where T : struct;
+        public static Vector64<float> Narrow(Vector64<double> lower, Vector64<double> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<sbyte> Narrow(Vector64<short> lower, Vector64<short> upper);
+        public static Vector64<short> Narrow(Vector64<int> lower, Vector64<int> upper);
+        public static Vector64<int> Narrow(Vector64<long> lower, Vector64<long> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<byte> Narrow(Vector64<ushort> lower, Vector64<ushort> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ushort> Narrow(Vector64<uint> lower, Vector64<uint> upper);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<uint> Narrow(Vector64<ulong> lower, Vector64<ulong> upper);
+        public static Vector64<T> Negate<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> OnesComplement<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<byte> ShiftLeft(Vector64<byte> vector, int shiftCount);
+        public static Vector64<short> ShiftLeft(Vector64<short> vector, int shiftCount);
+        public static Vector64<int> ShiftLeft(Vector64<int> vector, int shiftCount);
+        public static Vector64<long> ShiftLeft(Vector64<long> vector, int shiftCount);
+        public static Vector64<IntPtr> ShiftLeft(Vector64<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<sbyte> ShiftLeft(Vector64<sbyte> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ushort> ShiftLeft(Vector64<ushort> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<uint> ShiftLeft(Vector64<uint> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ulong> ShiftLeft(Vector64<ulong> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<UIntPtr> ShiftLeft(Vector64<UIntPtr> vector, int shiftCount);
+        public static Vector64<short> ShiftRightArithmetic(Vector64<short> vector, int shiftCount);
+        public static Vector64<int> ShiftRightArithmetic(Vector64<int> vector, int shiftCount);
+        public static Vector64<long> ShiftRightArithmetic(Vector64<long> vector, int shiftCount);
+        public static Vector64<IntPtr> ShiftRightArithmetic(Vector64<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<sbyte> ShiftRightArithmetic(Vector64<sbyte> vector, int shiftCount);
+        public static Vector64<byte> ShiftRightLogical(Vector64<byte> vector, int shiftCount);
+        public static Vector64<short> ShiftRightLogical(Vector64<short> vector, int shiftCount);
+        public static Vector64<int> ShiftRightLogical(Vector64<int> vector, int shiftCount);
+        public static Vector64<long> ShiftRightLogical(Vector64<long> vector, int shiftCount);
+        public static Vector64<IntPtr> ShiftRightLogical(Vector64<IntPtr> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<sbyte> ShiftRightLogical(Vector64<sbyte> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ushort> ShiftRightLogical(Vector64<ushort> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<uint> ShiftRightLogical(Vector64<uint> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ulong> ShiftRightLogical(Vector64<ulong> vector, int shiftCount);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<UIntPtr> ShiftRightLogical(Vector64<UIntPtr> vector, int shiftCount);
+        public static Vector64<byte> Shuffle(Vector64<byte> vector, Vector64<byte> indices);
+        public static Vector64<short> Shuffle(Vector64<short> vector, Vector64<short> indices);
+        public static Vector64<int> Shuffle(Vector64<int> vector, Vector64<int> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<sbyte> Shuffle(Vector64<sbyte> vector, Vector64<sbyte> indices);
+        public static Vector64<float> Shuffle(Vector64<float> vector, Vector64<int> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ushort> Shuffle(Vector64<ushort> vector, Vector64<ushort> indices);
+        [CLSCompliantAttribute(false)]
+        public static Vector64<uint> Shuffle(Vector64<uint> vector, Vector64<uint> indices);
+        public static Vector64<T> Sqrt<T>(Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector64<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector64<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector64<T> source, T* destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        public static Vector64<T> Subtract<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static T Sum<T>(Vector64<T> vector) where T : struct;
+        public static bool TryCopyTo<T>(this Vector64<T> vector, Span<T> destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static (Vector64<ushort> Lower, Vector64<ushort> Upper) Widen(Vector64<byte> source);
+        public static (Vector64<int> Lower, Vector64<int> Upper) Widen(Vector64<short> source);
+        public static (Vector64<long> Lower, Vector64<long> Upper) Widen(Vector64<int> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector64<short> Lower, Vector64<short> Upper) Widen(Vector64<sbyte> source);
+        public static (Vector64<double> Lower, Vector64<double> Upper) Widen(Vector64<float> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector64<uint> Lower, Vector64<uint> Upper) Widen(Vector64<ushort> source);
+        [CLSCompliantAttribute(false)]
+        public static (Vector64<ulong> Lower, Vector64<ulong> Upper) Widen(Vector64<uint> source);
+        public static Vector64<T> Xor<T>(Vector64<T> left, Vector64<T> right) where T : struct;
     }
     public readonly struct Vector64<T> : IEquatable<Vector64<T>> where T : struct {
+        public static bool IsSupported { get; }
+        public T this[int index] { get; }
+        public static Vector64<T> operator +(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator &(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator |(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator /(Vector64<T> left, Vector64<T> right);
+        public static bool operator ==(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator ^(Vector64<T> left, Vector64<T> right);
+        public static bool operator !=(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator *(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator *(Vector64<T> left, T right);
+        public static Vector64<T> operator *(T left, Vector64<T> right);
+        public static Vector64<T> operator ~(Vector64<T> vector);
+        public static Vector64<T> operator -(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator -(Vector64<T> vector);
+        public static Vector64<T> operator +(Vector64<T> value);
     }
 }
```

