# System.Runtime.Serialization.DataContracts

``` diff
+namespace System.Runtime.Serialization.DataContracts {
+    public abstract class DataContract {
+        public virtual DataContract? BaseContract { [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")] get; }
+        public virtual string? ContractType { get; }
+        public virtual ReadOnlyCollection<DataMember> DataMembers { get; }
+        public virtual bool IsBuiltInDataContract { get; }
+        public virtual bool IsISerializable { get; }
+        public virtual bool IsReference { get; }
+        public virtual bool IsValueType { get; }
+        public virtual Dictionary<XmlQualifiedName, DataContract>? KnownDataContracts { [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")] get; }
+        public virtual Type OriginalUnderlyingType { get; }
+        public virtual XmlDictionaryString? TopLevelElementName { get; }
+        public virtual XmlDictionaryString? TopLevelElementNamespace { get; }
+        [DynamicallyAccessedMembers(ClassDataContract.DataContractPreserveMemberTypes)]
+        public virtual Type UnderlyingType { get; }
+        public virtual XmlQualifiedName XmlName { get; }
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public virtual XmlQualifiedName GetArrayTypeName(bool isNullable);
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public static DataContract? GetBuiltInDataContract(string name, string ns);
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public static XmlQualifiedName GetXmlName(Type type);
+        public virtual bool IsDictionaryLike([NotNullWhenAttribute(true)] out string? keyName, [NotNullWhenAttribute(true)] out string? valueName, [NotNullWhenAttribute(true)] out string? itemName);
+    }
+    public sealed class DataContractSet {
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public DataContractSet(DataContractSet dataContractSet);
+        public DataContractSet(ISerializationSurrogateProvider? dataContractSurrogate, IEnumerable<Type>? referencedTypes, IEnumerable<Type>? referencedCollectionTypes);
+        public Dictionary<XmlQualifiedName, DataContract> Contracts { get; }
+        public Dictionary<XmlQualifiedName, DataContract>? KnownTypesForObject { get; }
+        public Dictionary<DataContract, object> ProcessedContracts { get; }
+        public Hashtable SurrogateData { get; }
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public DataContract GetDataContract(Type type);
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public DataContract? GetDataContract(XmlQualifiedName key);
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public Type? GetReferencedType(XmlQualifiedName xmlName, DataContract dataContract, out DataContract? referencedContract, out object[]? genericParameters, bool? supportGenericTypes = default(bool?));
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public List<XmlQualifiedName> ImportSchemaSet(XmlSchemaSet schemaSet, IEnumerable<XmlSchemaElement> elements, bool importXmlDataType);
+        [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")]
+        public void ImportSchemaSet(XmlSchemaSet schemaSet, IEnumerable<XmlQualifiedName>? typeNames, bool importXmlDataType);
+    }
+    public sealed class DataMember {
+        public bool EmitDefaultValue { get; }
+        public bool IsNullable { get; }
+        public bool IsRequired { get; }
+        public DataContract MemberTypeContract { [RequiresUnreferencedCodeAttribute("Data Contract Serialization and Deserialization might require types that cannot be statically analyzed. Make sure all of the required types are preserved.")] get; }
+        public string Name { get; }
+        public long Order { get; }
+    }
+    public sealed class XmlDataContract : DataContract {
+        public bool HasRoot { get; }
+        public bool IsAnonymous { get; }
+        public bool IsTopLevelElementNullable { get; }
+        public bool IsTypeDefinedOnImport { get; set; }
+        public new bool IsValueType { get; set; }
+        public XmlSchemaType? XsdType { get; }
+    }
+}
```

