# System.Security.Cryptography.X509Certificates

``` diff
 namespace System.Security.Cryptography.X509Certificates {
-    public sealed class CertificateRequest {
+    [UnsupportedOSPlatformAttribute("browser")]
+    public sealed class CertificateRequest {
+        public CertificateRequest(X500DistinguishedName subjectName, PublicKey publicKey, HashAlgorithmName hashAlgorithm, RSASignaturePadding? rsaSignaturePadding = null);
+        public Collection<AsnEncodedData> OtherRequestAttributes { get; }
+        public string CreateSigningRequestPem();
+        public string CreateSigningRequestPem(X509SignatureGenerator signatureGenerator);
+        public static CertificateRequest LoadSigningRequest(byte[] pkcs10, HashAlgorithmName signerHashAlgorithm, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
+        public static CertificateRequest LoadSigningRequest(ReadOnlySpan<byte> pkcs10, HashAlgorithmName signerHashAlgorithm, out int bytesConsumed, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
+        public static CertificateRequest LoadSigningRequestPem(ReadOnlySpan<char> pkcs10Pem, HashAlgorithmName signerHashAlgorithm, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
+        public static CertificateRequest LoadSigningRequestPem(string pkcs10Pem, HashAlgorithmName signerHashAlgorithm, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
     }
+    [FlagsAttribute]
+    public enum CertificateRequestLoadOptions {
+        Default = 0,
+        SkipSignatureValidation = 1,
+        UnsafeLoadCertificateExtensions = 2,
+    }
+    public sealed class CertificateRevocationListBuilder {
+        public CertificateRevocationListBuilder();
+        public void AddEntry(byte[] serialNumber, DateTimeOffset? revocationTime = default(DateTimeOffset?), X509RevocationReason? reason = default(X509RevocationReason?));
+        public void AddEntry(ReadOnlySpan<byte> serialNumber, DateTimeOffset? revocationTime = default(DateTimeOffset?), X509RevocationReason? reason = default(X509RevocationReason?));
+        public void AddEntry(X509Certificate2 certificate, DateTimeOffset? revocationTime = default(DateTimeOffset?), X509RevocationReason? reason = default(X509RevocationReason?));
+        public byte[] Build(X500DistinguishedName issuerName, X509SignatureGenerator generator, BigInteger crlNumber, DateTimeOffset nextUpdate, HashAlgorithmName hashAlgorithm, X509AuthorityKeyIdentifierExtension authorityKeyIdentifier, DateTimeOffset? thisUpdate = default(DateTimeOffset?));
+        public byte[] Build(X509Certificate2 issuerCertificate, BigInteger crlNumber, DateTimeOffset nextUpdate, HashAlgorithmName hashAlgorithm, RSASignaturePadding? rsaSignaturePadding = null, DateTimeOffset? thisUpdate = default(DateTimeOffset?));
+        public static X509Extension BuildCrlDistributionPointExtension(IEnumerable<string> uris, bool critical = false);
+        public static CertificateRevocationListBuilder Load(byte[] currentCrl, out BigInteger currentCrlNumber);
+        public static CertificateRevocationListBuilder Load(ReadOnlySpan<byte> currentCrl, out BigInteger currentCrlNumber, out int bytesConsumed);
+        public static CertificateRevocationListBuilder LoadPem(ReadOnlySpan<char> currentCrl, out BigInteger currentCrlNumber);
+        public static CertificateRevocationListBuilder LoadPem(string currentCrl, out BigInteger currentCrlNumber);
+        public bool RemoveEntry(byte[] serialNumber);
+        public bool RemoveEntry(ReadOnlySpan<byte> serialNumber);
+    }
     public sealed class PublicKey {
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public DSA? GetDSAPublicKey();
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public DSA? GetDSAPublicKey();
-        public ECDiffieHellman? GetECDiffieHellmanPublicKey();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public ECDiffieHellman? GetECDiffieHellmanPublicKey();
-        public ECDsa? GetECDsaPublicKey();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public ECDsa? GetECDsaPublicKey();
-        public RSA? GetRSAPublicKey();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public RSA? GetRSAPublicKey();
     }
     public sealed class X500DistinguishedName : AsnEncodedData {
+        public IEnumerable<X500RelativeDistinguishedName> EnumerateRelativeDistinguishedNames(bool reversed = true);
     }
+    public sealed class X500DistinguishedNameBuilder {
+        public X500DistinguishedNameBuilder();
+        public void Add(Oid oid, string value, UniversalTagNumber? stringEncodingType = default(UniversalTagNumber?));
+        public void Add(string oidValue, string value, UniversalTagNumber? stringEncodingType = default(UniversalTagNumber?));
+        public void AddCommonName(string commonName);
+        public void AddCountryOrRegion(string twoLetterCode);
+        public void AddDomainComponent(string domainComponent);
+        public void AddEmailAddress(string emailAddress);
+        public void AddLocalityName(string localityName);
+        public void AddOrganizationalUnitName(string organizationalUnitName);
+        public void AddOrganizationName(string organizationName);
+        public void AddStateOrProvinceName(string stateOrProvinceName);
+        public X500DistinguishedName Build();
+    }
+    public sealed class X500RelativeDistinguishedName {
+        public bool HasMultipleElements { get; }
+        public ReadOnlyMemory<byte> RawData { get; }
+        public Oid GetSingleElementType();
+        public string? GetSingleElementValue();
+    }
+    public sealed class X509AuthorityInformationAccessExtension : X509Extension {
+        public X509AuthorityInformationAccessExtension();
+        public X509AuthorityInformationAccessExtension(byte[] rawData, bool critical = false);
+        public X509AuthorityInformationAccessExtension(IEnumerable<string>? ocspUris, IEnumerable<string>? caIssuersUris, bool critical = false);
+        public X509AuthorityInformationAccessExtension(ReadOnlySpan<byte> rawData, bool critical = false);
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+        public IEnumerable<string> EnumerateCAIssuersUris();
+        public IEnumerable<string> EnumerateOcspUris();
+        public IEnumerable<string> EnumerateUris(Oid accessMethodOid);
+        public IEnumerable<string> EnumerateUris(string accessMethodOid);
+    }
+    public sealed class X509AuthorityKeyIdentifierExtension : X509Extension {
+        public X509AuthorityKeyIdentifierExtension();
+        public X509AuthorityKeyIdentifierExtension(byte[] rawData, bool critical = false);
+        public X509AuthorityKeyIdentifierExtension(ReadOnlySpan<byte> rawData, bool critical = false);
+        public ReadOnlyMemory<byte>? KeyIdentifier { get; }
+        public X500DistinguishedName? NamedIssuer { get; }
+        public ReadOnlyMemory<byte>? RawIssuer { get; }
+        public ReadOnlyMemory<byte>? SerialNumber { get; }
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+        public static X509AuthorityKeyIdentifierExtension Create(byte[] keyIdentifier, X500DistinguishedName issuerName, byte[] serialNumber);
+        public static X509AuthorityKeyIdentifierExtension Create(ReadOnlySpan<byte> keyIdentifier, X500DistinguishedName issuerName, ReadOnlySpan<byte> serialNumber);
+        public static X509AuthorityKeyIdentifierExtension CreateFromCertificate(X509Certificate2 certificate, bool includeKeyIdentifier, bool includeIssuerAndSerial);
+        public static X509AuthorityKeyIdentifierExtension CreateFromIssuerNameAndSerialNumber(X500DistinguishedName issuerName, byte[] serialNumber);
+        public static X509AuthorityKeyIdentifierExtension CreateFromIssuerNameAndSerialNumber(X500DistinguishedName issuerName, ReadOnlySpan<byte> serialNumber);
+        public static X509AuthorityKeyIdentifierExtension CreateFromSubjectKeyIdentifier(byte[] subjectKeyIdentifier);
+        public static X509AuthorityKeyIdentifierExtension CreateFromSubjectKeyIdentifier(ReadOnlySpan<byte> subjectKeyIdentifier);
+        public static X509AuthorityKeyIdentifierExtension CreateFromSubjectKeyIdentifier(X509SubjectKeyIdentifierExtension subjectKeyIdentifier);
+    }
     public sealed class X509BasicConstraintsExtension : X509Extension {
+        public static X509BasicConstraintsExtension CreateForCertificateAuthority(int? pathLengthConstraint = default(int?));
+        public static X509BasicConstraintsExtension CreateForEndEntity(bool critical = false);
     }
     public class X509Certificate : IDeserializationCallback, IDisposable, ISerializable {
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public X509Certificate();
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate();
-        public X509Certificate(byte[] data);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] data);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate(byte[] rawData, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        public X509Certificate(byte[] rawData, string? password);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, string? password);
-        public X509Certificate(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
-        public X509Certificate(IntPtr handle);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(IntPtr handle);
-        public X509Certificate(X509Certificate cert);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(X509Certificate cert);
-        public X509Certificate(string fileName);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate(string fileName, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        public X509Certificate(string fileName, string? password);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, string? password);
-        public X509Certificate(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        public ReadOnlyMemory<byte> SerialNumberBytes { get; }
-        public static X509Certificate CreateFromCertFile(string filename);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate CreateFromCertFile(string filename);
-        public static X509Certificate CreateFromSignedFile(string filename);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate CreateFromSignedFile(string filename);
     }
     public class X509Certificate2 : X509Certificate {
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public X509Certificate2();
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2();
-        public X509Certificate2(byte[] rawData);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate2(byte[] rawData, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate2(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        public X509Certificate2(byte[] rawData, string? password);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, string? password);
-        public X509Certificate2(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
-        public X509Certificate2(IntPtr handle);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(IntPtr handle);
-        public X509Certificate2(ReadOnlySpan<byte> rawData);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(ReadOnlySpan<byte> rawData);
-        public X509Certificate2(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        public X509Certificate2(X509Certificate certificate);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(X509Certificate certificate);
-        public X509Certificate2(string fileName);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName);
-        public X509Certificate2(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate2(string fileName, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        public X509Certificate2(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        public X509Certificate2(string fileName, string? password);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, string? password);
-        public X509Certificate2(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        public ReadOnlyMemory<byte> RawDataMemory { get; }
-        public static X509Certificate2 CreateFromEncryptedPem(ReadOnlySpan<char> certPem, ReadOnlySpan<char> keyPem, ReadOnlySpan<char> password);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate2 CreateFromEncryptedPem(ReadOnlySpan<char> certPem, ReadOnlySpan<char> keyPem, ReadOnlySpan<char> password);
-        public static X509Certificate2 CreateFromEncryptedPemFile(string certPemFilePath, ReadOnlySpan<char> password, string? keyPemFilePath = null);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate2 CreateFromEncryptedPemFile(string certPemFilePath, ReadOnlySpan<char> password, string? keyPemFilePath = null);
-        public static X509Certificate2 CreateFromPem(ReadOnlySpan<char> certPem);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate2 CreateFromPem(ReadOnlySpan<char> certPem);
-        public static X509Certificate2 CreateFromPem(ReadOnlySpan<char> certPem, ReadOnlySpan<char> keyPem);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate2 CreateFromPem(ReadOnlySpan<char> certPem, ReadOnlySpan<char> keyPem);
-        public static X509Certificate2 CreateFromPemFile(string certPemFilePath, string? keyPemFilePath = null);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate2 CreateFromPemFile(string certPemFilePath, string? keyPemFilePath = null);
+        public string ExportCertificatePem();
-        public static X509ContentType GetCertContentType(byte[] rawData);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509ContentType GetCertContentType(byte[] rawData);
-        public static X509ContentType GetCertContentType(ReadOnlySpan<byte> rawData);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509ContentType GetCertContentType(ReadOnlySpan<byte> rawData);
-        public static X509ContentType GetCertContentType(string fileName);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509ContentType GetCertContentType(string fileName);
+        public bool MatchesHostname(string hostname, bool allowWildcards = true, bool allowCommonName = true);
+        public bool TryExportCertificatePem(Span<char> destination, out int charsWritten);
     }
     public class X509Certificate2Collection : X509CertificateCollection, IEnumerable, IEnumerable<X509Certificate2> {
+        public string ExportCertificatePems();
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public string ExportPkcs7Pem();
+        public bool TryExportCertificatePems(Span<char> destination, out int charsWritten);
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public bool TryExportPkcs7Pem(Span<char> destination, out int charsWritten);
     }
     public class X509Chain : IDisposable {
-        public bool Build(X509Certificate2 certificate);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public bool Build(X509Certificate2 certificate);
     }
     public sealed class X509ChainPolicy {
+        public bool VerificationTimeIgnored { get; set; }
+        public X509ChainPolicy Clone();
     }
+    public enum X509RevocationReason {
+        AACompromise = 10,
+        AffiliationChanged = 3,
+        CACompromise = 2,
+        CertificateHold = 6,
+        CessationOfOperation = 5,
+        KeyCompromise = 1,
+        PrivilegeWithdrawn = 9,
+        RemoveFromCrl = 8,
+        Superseded = 4,
+        Unspecified = 0,
+        WeakAlgorithmOrKey = 11,
+    }
+    public sealed class X509SubjectAlternativeNameExtension : X509Extension {
+        public X509SubjectAlternativeNameExtension();
+        public X509SubjectAlternativeNameExtension(byte[] rawData, bool critical = false);
+        public X509SubjectAlternativeNameExtension(ReadOnlySpan<byte> rawData, bool critical = false);
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+        public IEnumerable<string> EnumerateDnsNames();
+        public IEnumerable<IPAddress> EnumerateIPAddresses();
+    }
     public sealed class X509SubjectKeyIdentifierExtension : X509Extension {
+        public ReadOnlyMemory<byte> SubjectKeyIdentifierBytes { get; }
     }
 }
```

