# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class Aes : SymmetricAlgorithm {
+    public abstract class Aes : SymmetricAlgorithm {
-        public static new Aes Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new Aes Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new Aes? Create(string algorithmName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new Aes? Create(string algorithmName);
     }
     public sealed class AesCng : Aes {
-        public AesCng();
+        [SupportedOSPlatformAttribute("windows")]
+        public AesCng();
-        public AesCng(string keyName);
+        [SupportedOSPlatformAttribute("windows")]
+        public AesCng(string keyName);
-        public AesCng(string keyName, CngProvider provider);
+        [SupportedOSPlatformAttribute("windows")]
+        public AesCng(string keyName, CngProvider provider);
-        public AesCng(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        [SupportedOSPlatformAttribute("windows")]
+        public AesCng(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        protected override bool TryDecryptCbcCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryDecryptCfbCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryDecryptEcbCore(ReadOnlySpan<byte> ciphertext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCbcCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCfbCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryEncryptEcbCore(ReadOnlySpan<byte> plaintext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
     }
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     [ObsoleteAttribute("Derived cryptographic types are obsolete. Use the Create method on the base type instead.", DiagnosticId="SYSLIB0021", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public sealed class AesCryptoServiceProvider : Aes {
-        public AesCryptoServiceProvider();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public AesCryptoServiceProvider();
     }
     public abstract class AsymmetricAlgorithm : IDisposable {
-        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public static AsymmetricAlgorithm Create();
+        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported.", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static AsymmetricAlgorithm Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static AsymmetricAlgorithm? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static AsymmetricAlgorithm? Create(string algName);
+        public string ExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public string ExportPkcs8PrivateKeyPem();
+        public string ExportSubjectPublicKeyInfoPem();
+        public bool TryExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<char> destination, out int charsWritten);
+        public bool TryExportPkcs8PrivateKeyPem(Span<char> destination, out int charsWritten);
+        public bool TryExportSubjectPublicKeyInfoPem(Span<char> destination, out int charsWritten);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class AsymmetricKeyExchangeDeformatter
+    public abstract class AsymmetricKeyExchangeDeformatter
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class AsymmetricKeyExchangeFormatter
+    public abstract class AsymmetricKeyExchangeFormatter
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class AsymmetricSignatureDeformatter
+    public abstract class AsymmetricSignatureDeformatter
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class AsymmetricSignatureFormatter
+    public abstract class AsymmetricSignatureFormatter
     public sealed class CngKey : IDisposable {
-        public static CngKey Create(CngAlgorithm algorithm);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Create(CngAlgorithm algorithm);
-        public static CngKey Create(CngAlgorithm algorithm, string? keyName);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Create(CngAlgorithm algorithm, string? keyName);
-        public static CngKey Create(CngAlgorithm algorithm, string? keyName, CngKeyCreationParameters? creationParameters);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Create(CngAlgorithm algorithm, string? keyName, CngKeyCreationParameters? creationParameters);
-        public static bool Exists(string keyName);
+        [SupportedOSPlatformAttribute("windows")]
+        public static bool Exists(string keyName);
-        public static bool Exists(string keyName, CngProvider provider);
+        [SupportedOSPlatformAttribute("windows")]
+        public static bool Exists(string keyName, CngProvider provider);
-        public static bool Exists(string keyName, CngProvider provider, CngKeyOpenOptions options);
+        [SupportedOSPlatformAttribute("windows")]
+        public static bool Exists(string keyName, CngProvider provider, CngKeyOpenOptions options);
-        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format);
-        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format, CngProvider provider);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format, CngProvider provider);
-        public static CngKey Open(SafeNCryptKeyHandle keyHandle, CngKeyHandleOpenOptions keyHandleOpenOptions);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Open(SafeNCryptKeyHandle keyHandle, CngKeyHandleOpenOptions keyHandleOpenOptions);
-        public static CngKey Open(string keyName);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Open(string keyName);
-        public static CngKey Open(string keyName, CngProvider provider);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Open(string keyName, CngProvider provider);
-        public static CngKey Open(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        [SupportedOSPlatformAttribute("windows")]
+        public static CngKey Open(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
     }
     public class CryptographicException : SystemException {
-        public CryptographicException(string format, string? insert);
+        public CryptographicException([StringSyntaxAttribute("CompositeFormat")] string format, string? insert);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class DeriveBytes : IDisposable
+    public abstract class DeriveBytes : IDisposable
-    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class DES : SymmetricAlgorithm {
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public abstract class DES : SymmetricAlgorithm {
-        public static new DES Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new DES Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new DES? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new DES? Create(string algName);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class DSA : AsymmetricAlgorithm {
+    public abstract class DSA : AsymmetricAlgorithm {
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public static new DSA Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static new DSA Create();
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public static DSA Create(int keySizeInBits);
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static DSA Create(int keySizeInBits);
-        [UnsupportedOSPlatformAttribute("ios")]
-        [UnsupportedOSPlatformAttribute("tvos")]
-        public static DSA Create(DSAParameters parameters);
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static DSA Create(DSAParameters parameters);
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new DSA? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new DSA? Create(string algName);
     }
     public sealed class DSACng : DSA {
-        public DSACng();
+        [SupportedOSPlatformAttribute("windows")]
+        public DSACng();
-        public DSACng(int keySize);
+        [SupportedOSPlatformAttribute("windows")]
+        public DSACng(int keySize);
-        public DSACng(CngKey key);
+        [SupportedOSPlatformAttribute("windows")]
+        public DSACng(CngKey key);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        protected override bool TryCreateSignatureCore(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        protected override bool VerifySignatureCore(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
     }
     public sealed class DSACryptoServiceProvider : DSA, ICspAsymmetricAlgorithm {
-        public DSACryptoServiceProvider();
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public DSACryptoServiceProvider();
-        public DSACryptoServiceProvider(int dwKeySize);
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public DSACryptoServiceProvider(int dwKeySize);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
     }
     public sealed class DSAOpenSsl : DSA {
-        public DSAOpenSsl();
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public DSAOpenSsl();
-        public DSAOpenSsl(int keySize);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public DSAOpenSsl(int keySize);
-        public DSAOpenSsl(IntPtr handle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public DSAOpenSsl(IntPtr handle);
-        public DSAOpenSsl(DSAParameters parameters);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public DSAOpenSsl(DSAParameters parameters);
-        public DSAOpenSsl(SafeEvpPKeyHandle pkeyHandle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public DSAOpenSsl(SafeEvpPKeyHandle pkeyHandle);
-        public override int KeySize { set; }
-        public override KeySizes[] LegalKeySizes { get; }
-        protected override void Dispose(bool disposing);
-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class DSASignatureDeformatter : AsymmetricSignatureDeformatter
+    public class DSASignatureDeformatter : AsymmetricSignatureDeformatter
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class DSASignatureFormatter : AsymmetricSignatureFormatter
+    public class DSASignatureFormatter : AsymmetricSignatureFormatter
+    public abstract class ECAlgorithm : AsymmetricAlgorithm {
+        protected ECAlgorithm();
+        public virtual byte[] ExportECPrivateKey();
+        public string ExportECPrivateKeyPem();
+        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);
+        public virtual ECParameters ExportParameters(bool includePrivateParameters);
+        public virtual void GenerateKey(ECCurve curve);
+        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
+        public override void ImportFromPem(ReadOnlySpan<char> input);
+        public virtual void ImportParameters(ECParameters parameters);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);
+        public bool TryExportECPrivateKeyPem(Span<char> destination, out int charsWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
+    }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public struct ECCurve
+    public struct ECCurve
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class ECDiffieHellman : AsymmetricAlgorithm {
+    public abstract class ECDiffieHellman : ECAlgorithm {
-        public static new ECDiffieHellman Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new ECDiffieHellman Create();
-        public static ECDiffieHellman Create(ECCurve curve);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ECDiffieHellman Create(ECCurve curve);
-        public static ECDiffieHellman Create(ECParameters parameters);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ECDiffieHellman Create(ECParameters parameters);
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new ECDiffieHellman? Create(string algorithm);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new ECDiffieHellman? Create(string algorithm);
-        public virtual byte[] ExportECPrivateKey();
-        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);
-        public virtual ECParameters ExportParameters(bool includePrivateParameters);
-        public virtual void GenerateKey(ECCurve curve);
-        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
-        public override void ImportFromPem(ReadOnlySpan<char> input);
-        public virtual void ImportParameters(ECParameters parameters);
-        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
-        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);
-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
-        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
-        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public sealed class ECDiffieHellmanCng : ECDiffieHellman {
-        public ECDiffieHellmanCng();
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanCng();
-        public ECDiffieHellmanCng(int keySize);
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanCng(int keySize);
-        public ECDiffieHellmanCng(CngKey key);
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanCng(CngKey key);
-        public ECDiffieHellmanCng(ECCurve curve);
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanCng(ECCurve curve);
+        public override KeySizes[] LegalKeySizes { get; }
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
-        public void FromXmlString(string xml, ECKeyXmlFormat format);
+        [ObsoleteAttribute("ToXmlString and FromXmlString have no implementation for ECC types, and are obsolete. Use a standard import and export format such as ExportSubjectPublicKeyInfo or ImportSubjectPublicKeyInfo for public keys and ExportPkcs8PrivateKey or ImportPkcs8PrivateKey for private keys.", DiagnosticId="SYSLIB0042", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void FromXmlString(string xml, ECKeyXmlFormat format);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
-        public string ToXmlString(ECKeyXmlFormat format);
+        [ObsoleteAttribute("ToXmlString and FromXmlString have no implementation for ECC types, and are obsolete. Use a standard import and export format such as ExportSubjectPublicKeyInfo or ImportSubjectPublicKeyInfo for public keys and ExportPkcs8PrivateKey or ImportPkcs8PrivateKey for private keys.", DiagnosticId="SYSLIB0042", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public string ToXmlString(ECKeyXmlFormat format);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
     }
     public sealed class ECDiffieHellmanCngPublicKey : ECDiffieHellmanPublicKey {
-        public static ECDiffieHellmanPublicKey FromByteArray(byte[] publicKeyBlob, CngKeyBlobFormat format);
+        [SupportedOSPlatformAttribute("windows")]
+        public static ECDiffieHellmanPublicKey FromByteArray(byte[] publicKeyBlob, CngKeyBlobFormat format);
-        public static ECDiffieHellmanCngPublicKey FromXmlString(string xml);
+        [ObsoleteAttribute("ToXmlString and FromXmlString have no implementation for ECC types, and are obsolete. Use a standard import and export format such as ExportSubjectPublicKeyInfo or ImportSubjectPublicKeyInfo for public keys and ExportPkcs8PrivateKey or ImportPkcs8PrivateKey for private keys.", DiagnosticId="SYSLIB0042", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static ECDiffieHellmanCngPublicKey FromXmlString(string xml);
-        public override string ToXmlString();
+        [ObsoleteAttribute("ToXmlString and FromXmlString have no implementation for ECC types, and are obsolete. Use a standard import and export format such as ExportSubjectPublicKeyInfo or ImportSubjectPublicKeyInfo for public keys and ExportPkcs8PrivateKey or ImportPkcs8PrivateKey for private keys.", DiagnosticId="SYSLIB0042", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override string ToXmlString();
     }
     public sealed class ECDiffieHellmanOpenSsl : ECDiffieHellman {
-        public ECDiffieHellmanOpenSsl();
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanOpenSsl();
-        public ECDiffieHellmanOpenSsl(int keySize);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanOpenSsl(int keySize);
-        public ECDiffieHellmanOpenSsl(IntPtr handle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanOpenSsl(IntPtr handle);
-        public ECDiffieHellmanOpenSsl(ECCurve curve);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanOpenSsl(ECCurve curve);
-        public ECDiffieHellmanOpenSsl(SafeEvpPKeyHandle pkeyHandle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDiffieHellmanOpenSsl(SafeEvpPKeyHandle pkeyHandle);
-        public override byte[] DeriveKeyFromHash(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm, byte[]? secretPrepend, byte[]? secretAppend);
-        public override byte[] DeriveKeyFromHmac(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm, byte[]? hmacKey, byte[]? secretPrepend, byte[]? secretAppend);
-        public override byte[] DeriveKeyMaterial(ECDiffieHellmanPublicKey otherPartyPublicKey);
-        public override byte[] DeriveKeyTls(ECDiffieHellmanPublicKey otherPartyPublicKey, byte[] prfLabel, byte[] prfSeed);
-        public override ECParameters ExportExplicitParameters(bool includePrivateParameters);
-        public override void GenerateKey(ECCurve curve);
     }
     public abstract class ECDiffieHellmanPublicKey : IDisposable {
-        protected ECDiffieHellmanPublicKey(byte[] keyBlob);
+        [ObsoleteAttribute("ECDiffieHellmanPublicKey.ToByteArray() and the associated constructor do not have a consistent and interoperable implementation on all platforms. Use ECDiffieHellmanPublicKey.ExportSubjectPublicKeyInfo() instead.", DiagnosticId="SYSLIB0043", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ECDiffieHellmanPublicKey(byte[] keyBlob);
-        public virtual byte[] ToByteArray();
+        [ObsoleteAttribute("ECDiffieHellmanPublicKey.ToByteArray() and the associated constructor do not have a consistent and interoperable implementation on all platforms. Use ECDiffieHellmanPublicKey.ExportSubjectPublicKeyInfo() instead.", DiagnosticId="SYSLIB0043", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual byte[] ToByteArray();
-        public virtual string ToXmlString();
+        [ObsoleteAttribute("ToXmlString and FromXmlString have no implementation for ECC types, and are obsolete. Use a standard import and export format such as ExportSubjectPublicKeyInfo or ImportSubjectPublicKeyInfo for public keys and ExportPkcs8PrivateKey or ImportPkcs8PrivateKey for private keys.", DiagnosticId="SYSLIB0042", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual string ToXmlString();
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class ECDsa : AsymmetricAlgorithm {
+    public abstract class ECDsa : ECAlgorithm {
-        public static new ECDsa Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new ECDsa Create();
-        public static ECDsa Create(ECCurve curve);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ECDsa Create(ECCurve curve);
-        public static ECDsa Create(ECParameters parameters);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ECDsa Create(ECParameters parameters);
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new ECDsa? Create(string algorithm);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new ECDsa? Create(string algorithm);
-        public virtual byte[] ExportECPrivateKey();
-        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);
-        public virtual ECParameters ExportParameters(bool includePrivateParameters);
-        public virtual void GenerateKey(ECCurve curve);
-        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
-        public override void ImportFromPem(ReadOnlySpan<char> input);
-        public virtual void ImportParameters(ECParameters parameters);
-        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
-        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public byte[] SignData(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm);
+        public byte[] SignData(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public int SignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm);
+        public int SignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public byte[] SignHash(ReadOnlySpan<byte> hash);
+        public byte[] SignHash(ReadOnlySpan<byte> hash, DSASignatureFormat signatureFormat);
+        public int SignHash(ReadOnlySpan<byte> hash, Span<byte> destination);
+        public int SignHash(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat);
-        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);
-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
-        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
-        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public sealed class ECDsaCng : ECDsa {
-        public ECDsaCng();
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDsaCng();
-        public ECDsaCng(int keySize);
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDsaCng(int keySize);
-        public ECDsaCng(CngKey key);
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDsaCng(CngKey key);
-        public ECDsaCng(ECCurve curve);
+        [SupportedOSPlatformAttribute("windows")]
+        public ECDsaCng(ECCurve curve);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
-        public void FromXmlString(string xml, ECKeyXmlFormat format);
+        [ObsoleteAttribute("ToXmlString and FromXmlString have no implementation for ECC types, and are obsolete. Use a standard import and export format such as ExportSubjectPublicKeyInfo or ImportSubjectPublicKeyInfo for public keys and ExportPkcs8PrivateKey or ImportPkcs8PrivateKey for private keys.", DiagnosticId="SYSLIB0042", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void FromXmlString(string xml, ECKeyXmlFormat format);
-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
-        public string ToXmlString(ECKeyXmlFormat format);
+        [ObsoleteAttribute("ToXmlString and FromXmlString have no implementation for ECC types, and are obsolete. Use a standard import and export format such as ExportSubjectPublicKeyInfo or ImportSubjectPublicKeyInfo for public keys and ExportPkcs8PrivateKey or ImportPkcs8PrivateKey for private keys.", DiagnosticId="SYSLIB0042", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public string ToXmlString(ECKeyXmlFormat format);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TrySignHash(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected override bool TrySignHashCore(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public override bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature);
+        protected override bool VerifyHashCore(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
     }
     public sealed class ECDsaOpenSsl : ECDsa {
-        public ECDsaOpenSsl();
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDsaOpenSsl();
-        public ECDsaOpenSsl(int keySize);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDsaOpenSsl(int keySize);
-        public ECDsaOpenSsl(IntPtr handle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDsaOpenSsl(IntPtr handle);
-        public ECDsaOpenSsl(ECCurve curve);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDsaOpenSsl(ECCurve curve);
-        public ECDsaOpenSsl(SafeEvpPKeyHandle pkeyHandle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public ECDsaOpenSsl(SafeEvpPKeyHandle pkeyHandle);
-        public override int KeySize { get; set; }
-        public override KeySizes[] LegalKeySizes { get; }
-        protected override void Dispose(bool disposing);
-        public override ECParameters ExportExplicitParameters(bool includePrivateParameters);
-        public override ECParameters ExportParameters(bool includePrivateParameters);
-        public override void GenerateKey(ECCurve curve);
-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
-        public override void ImportParameters(ECParameters parameters);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public struct ECParameters
+    public struct ECParameters
     public abstract class HashAlgorithm : ICryptoTransform, IDisposable {
-        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public static HashAlgorithm Create();
+        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported.", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static HashAlgorithm Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static HashAlgorithm? Create(string hashName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static HashAlgorithm? Create(string hashName);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public static class HKDF
+    public static class HKDF
     public abstract class HMAC : KeyedHashAlgorithm {
-        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public static new HMAC Create();
+        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported.", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static new HMAC Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new HMAC? Create(string algorithmName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new HMAC? Create(string algorithmName);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class HMACMD5 : HMAC {
+    public class HMACMD5 : HMAC {
+        public const int HashSizeInBits = 128;
+        public const int HashSizeInBytes = 16;
-        public HMACMD5();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public HMACMD5();
-        public HMACMD5(byte[] key);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public HMACMD5(byte[] key);
-        public static byte[] HashData(byte[] key, byte[] source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(byte[] key, byte[] source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(byte[] key, Stream source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
-        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
-        public static int HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
-        public static bool TryHashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static bool TryHashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class HMACSHA1 : HMAC {
+    public class HMACSHA1 : HMAC {
+        public const int HashSizeInBits = 160;
+        public const int HashSizeInBytes = 20;
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class HMACSHA256 : HMAC {
+    public class HMACSHA256 : HMAC {
+        public const int HashSizeInBits = 256;
+        public const int HashSizeInBytes = 32;
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class HMACSHA384 : HMAC {
+    public class HMACSHA384 : HMAC {
+        public const int HashSizeInBits = 384;
+        public const int HashSizeInBytes = 48;
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class HMACSHA512 : HMAC {
+    public class HMACSHA512 : HMAC {
+        public const int HashSizeInBits = 512;
+        public const int HashSizeInBytes = 64;
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public sealed class IncrementalHash : IDisposable {
-        [UnsupportedOSPlatformAttribute("browser")]
-        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, byte[] key);
+        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, byte[] key);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key);
+        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key);
     }
     public abstract class KeyedHashAlgorithm : HashAlgorithm {
-        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public static new KeyedHashAlgorithm Create();
+        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported.", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static new KeyedHashAlgorithm Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new KeyedHashAlgorithm? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new KeyedHashAlgorithm? Create(string algName);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class MaskGenerationMethod
+    public abstract class MaskGenerationMethod
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class MD5 : HashAlgorithm {
+    public abstract class MD5 : HashAlgorithm {
+        public const int HashSizeInBits = 128;
+        public const int HashSizeInBytes = 16;
-        public static new MD5 Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new MD5 Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new MD5? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new MD5? Create(string algName);
-        public static byte[] HashData(byte[] source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(byte[] source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(Stream source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(Stream source, Span<byte> destination);
-        public static byte[] HashData(ReadOnlySpan<byte> source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(ReadOnlySpan<byte> source);
-        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
-        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public static class PemEncoding {
+        public static string WriteString(ReadOnlySpan<char> label, ReadOnlySpan<byte> data);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class PKCS1MaskGenerationMethod : MaskGenerationMethod
+    public class PKCS1MaskGenerationMethod : MaskGenerationMethod
     public abstract class RandomNumberGenerator : IDisposable {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public static RandomNumberGenerator? Create(string rngName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static RandomNumberGenerator? Create(string rngName);
     }
-    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class RC2 : SymmetricAlgorithm {
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public abstract class RC2 : SymmetricAlgorithm {
-        [UnsupportedOSPlatformAttribute("android")]
-        public static new RC2 Create();
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new RC2 Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new RC2? Create(string AlgName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new RC2? Create(string AlgName);
     }
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     [ObsoleteAttribute("Derived cryptographic types are obsolete. Use the Create method on the base type instead.", DiagnosticId="SYSLIB0021", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public sealed class RC2CryptoServiceProvider : RC2 {
-        public RC2CryptoServiceProvider();
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public RC2CryptoServiceProvider();
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class Rfc2898DeriveBytes : DeriveBytes {
+    public class Rfc2898DeriveBytes : DeriveBytes {
-        public Rfc2898DeriveBytes(byte[] password, byte[] salt, int iterations);
+        [ObsoleteAttribute("The default hash algorithm and iteration counts in Rfc2898DeriveBytes constructors are outdated and insecure. Use a constructor that accepts the hash algorithm and the number of iterations.", DiagnosticId="SYSLIB0041", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public Rfc2898DeriveBytes(byte[] password, byte[] salt, int iterations);
-        public Rfc2898DeriveBytes(string password, byte[] salt);
+        [ObsoleteAttribute("The default hash algorithm and iteration counts in Rfc2898DeriveBytes constructors are outdated and insecure. Use a constructor that accepts the hash algorithm and the number of iterations.", DiagnosticId="SYSLIB0041", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public Rfc2898DeriveBytes(string password, byte[] salt);
-        public Rfc2898DeriveBytes(string password, byte[] salt, int iterations);
+        [ObsoleteAttribute("The default hash algorithm and iteration counts in Rfc2898DeriveBytes constructors are outdated and insecure. Use a constructor that accepts the hash algorithm and the number of iterations.", DiagnosticId="SYSLIB0041", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public Rfc2898DeriveBytes(string password, byte[] salt, int iterations);
-        public Rfc2898DeriveBytes(string password, int saltSize);
+        [ObsoleteAttribute("The default hash algorithm and iteration counts in Rfc2898DeriveBytes constructors are outdated and insecure. Use a constructor that accepts the hash algorithm and the number of iterations.", DiagnosticId="SYSLIB0041", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public Rfc2898DeriveBytes(string password, int saltSize);
-        public Rfc2898DeriveBytes(string password, int saltSize, int iterations);
+        [ObsoleteAttribute("The default hash algorithm and iteration counts in Rfc2898DeriveBytes constructors are outdated and insecure. Use a constructor that accepts the hash algorithm and the number of iterations.", DiagnosticId="SYSLIB0041", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public Rfc2898DeriveBytes(string password, int saltSize, int iterations);
     }
-    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
-    [ObsoleteAttribute("The Rijndael and RijndaelManaged types are obsolete. Use Aes instead.", DiagnosticId="SYSLIB0022", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class Rijndael : SymmetricAlgorithm {
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    [ObsoleteAttribute("The Rijndael and RijndaelManaged types are obsolete. Use Aes instead.", DiagnosticId="SYSLIB0022", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public abstract class Rijndael : SymmetricAlgorithm {
-        public static new Rijndael Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new Rijndael Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new Rijndael? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new Rijndael? Create(string algName);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class RSA : AsymmetricAlgorithm {
+    public abstract class RSA : AsymmetricAlgorithm {
-        public static new RSA Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new RSA Create();
-        public static RSA Create(int keySizeInBits);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static RSA Create(int keySizeInBits);
-        public static RSA Create(RSAParameters parameters);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static RSA Create(RSAParameters parameters);
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new RSA? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new RSA? Create(string algName);
+        public byte[] Decrypt(ReadOnlySpan<byte> data, RSAEncryptionPadding padding);
+        public int Decrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding);
+        public byte[] Encrypt(ReadOnlySpan<byte> data, RSAEncryptionPadding padding);
+        public int Encrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding);
+        public string ExportRSAPrivateKeyPem();
+        public string ExportRSAPublicKeyPem();
+        public byte[] SignData(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public int SignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public byte[] SignHash(ReadOnlySpan<byte> hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public int SignHash(ReadOnlySpan<byte> hash, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public bool TryExportRSAPrivateKeyPem(Span<char> destination, out int charsWritten);
+        public bool TryExportRSAPublicKeyPem(Span<char> destination, out int charsWritten);
     }
     public sealed class RSACng : RSA {
-        public RSACng();
+        [SupportedOSPlatformAttribute("windows")]
+        public RSACng();
-        public RSACng(int keySize);
+        [SupportedOSPlatformAttribute("windows")]
+        public RSACng(int keySize);
-        public RSACng(CngKey key);
+        [SupportedOSPlatformAttribute("windows")]
+        public RSACng(CngKey key);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryDecrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        public override bool TryEncrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TrySignHash(ReadOnlySpan<byte> hash, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding, out int bytesWritten);
+        public override bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
     }
     public sealed class RSACryptoServiceProvider : RSA, ICspAsymmetricAlgorithm {
-        public RSACryptoServiceProvider();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public RSACryptoServiceProvider();
-        public RSACryptoServiceProvider(int dwKeySize);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public RSACryptoServiceProvider(int dwKeySize);
-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public sealed class RSAEncryptionPadding : IEquatable<RSAEncryptionPadding>
+    public sealed class RSAEncryptionPadding : IEquatable<RSAEncryptionPadding>
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class RSAOAEPKeyExchangeDeformatter : AsymmetricKeyExchangeDeformatter
+    public class RSAOAEPKeyExchangeDeformatter : AsymmetricKeyExchangeDeformatter
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class RSAOAEPKeyExchangeFormatter : AsymmetricKeyExchangeFormatter
+    public class RSAOAEPKeyExchangeFormatter : AsymmetricKeyExchangeFormatter
     public sealed class RSAOpenSsl : RSA {
-        public RSAOpenSsl();
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public RSAOpenSsl();
-        public RSAOpenSsl(int keySize);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public RSAOpenSsl(int keySize);
-        public RSAOpenSsl(IntPtr handle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public RSAOpenSsl(IntPtr handle);
-        public RSAOpenSsl(RSAParameters parameters);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public RSAOpenSsl(RSAParameters parameters);
-        public RSAOpenSsl(SafeEvpPKeyHandle pkeyHandle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public RSAOpenSsl(SafeEvpPKeyHandle pkeyHandle);
-        public override int KeySize { set; }
-        public override KeySizes[] LegalKeySizes { get; }
-        public override byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
-        protected override void Dispose(bool disposing);
-        public override byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
-        public override byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
-        public override bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class RSAPKCS1KeyExchangeDeformatter : AsymmetricKeyExchangeDeformatter
+    public class RSAPKCS1KeyExchangeDeformatter : AsymmetricKeyExchangeDeformatter
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class RSAPKCS1KeyExchangeFormatter : AsymmetricKeyExchangeFormatter
+    public class RSAPKCS1KeyExchangeFormatter : AsymmetricKeyExchangeFormatter
-    [UnsupportedOSPlatformAttribute("browser")]
-    public sealed class RSASignaturePadding : IEquatable<RSASignaturePadding>
+    public sealed class RSASignaturePadding : IEquatable<RSASignaturePadding>
     public sealed class SafeEvpPKeyHandle : SafeHandle {
-        public SafeEvpPKeyHandle();
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public SafeEvpPKeyHandle();
-        public SafeEvpPKeyHandle(IntPtr handle, bool ownsHandle);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public SafeEvpPKeyHandle(IntPtr handle, bool ownsHandle);
-        public static long OpenSslVersion { get; }
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static long OpenSslVersion { get; }
     }
     public abstract class SHA1 : HashAlgorithm {
+        public const int HashSizeInBits = 160;
+        public const int HashSizeInBytes = 20;
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new SHA1? Create(string hashName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new SHA1? Create(string hashName);
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class SHA256 : HashAlgorithm {
+        public const int HashSizeInBits = 256;
+        public const int HashSizeInBytes = 32;
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new SHA256? Create(string hashName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new SHA256? Create(string hashName);
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class SHA384 : HashAlgorithm {
+        public const int HashSizeInBits = 384;
+        public const int HashSizeInBytes = 48;
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new SHA384? Create(string hashName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new SHA384? Create(string hashName);
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class SHA512 : HashAlgorithm {
+        public const int HashSizeInBits = 512;
+        public const int HashSizeInBytes = 64;
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new SHA512? Create(string hashName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new SHA512? Create(string hashName);
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class SignatureDescription
+    public class SignatureDescription
     public abstract class SymmetricAlgorithm : IDisposable {
-        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public static SymmetricAlgorithm Create();
+        [ObsoleteAttribute("The default implementation of this cryptography algorithm is not supported.", DiagnosticId="SYSLIB0007", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static SymmetricAlgorithm Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static SymmetricAlgorithm? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static SymmetricAlgorithm? Create(string algName);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public abstract class TripleDES : SymmetricAlgorithm {
+    public abstract class TripleDES : SymmetricAlgorithm {
-        public static new TripleDES Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new TripleDES Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        public static new TripleDES? Create(string str);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        public static new TripleDES? Create(string str);
     }
     public sealed class TripleDESCng : TripleDES {
-        public TripleDESCng();
+        [SupportedOSPlatformAttribute("windows")]
+        public TripleDESCng();
-        public TripleDESCng(string keyName);
+        [SupportedOSPlatformAttribute("windows")]
+        public TripleDESCng(string keyName);
-        public TripleDESCng(string keyName, CngProvider provider);
+        [SupportedOSPlatformAttribute("windows")]
+        public TripleDESCng(string keyName, CngProvider provider);
-        public TripleDESCng(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        [SupportedOSPlatformAttribute("windows")]
+        public TripleDESCng(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        protected override bool TryDecryptCbcCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryDecryptCfbCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryDecryptEcbCore(ReadOnlySpan<byte> ciphertext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCbcCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCfbCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryEncryptEcbCore(ReadOnlySpan<byte> plaintext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
     }
 }
```

