# System.Text.Json.Serialization.Metadata

``` diff
 namespace System.Text.Json.Serialization.Metadata {
+    public class DefaultJsonTypeInfoResolver : IJsonTypeInfoResolver {
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public DefaultJsonTypeInfoResolver();
+        public IList<Action<JsonTypeInfo>> Modifiers { get; }
+        public virtual JsonTypeInfo GetTypeInfo(Type type, JsonSerializerOptions options);
+    }
+    public interface IJsonTypeInfoResolver {
+        JsonTypeInfo? GetTypeInfo(Type type, JsonSerializerOptions options);
+    }
-    public sealed class JsonCollectionInfoValues<TCollection>
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class JsonCollectionInfoValues<TCollection>
+    public readonly struct JsonDerivedType {
+        public JsonDerivedType(Type derivedType);
+        public JsonDerivedType(Type derivedType, int typeDiscriminator);
+        public JsonDerivedType(Type derivedType, string typeDiscriminator);
+        public Type DerivedType { get; }
+        public object? TypeDiscriminator { get; }
+    }
-    public static class JsonMetadataServices {
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public static class JsonMetadataServices {
+        public static JsonConverter<DateOnly> DateOnlyConverter { get; }
+        public static JsonConverter<JsonDocument> JsonDocumentConverter { get; }
-        public static JsonConverter<object> ObjectConverter { get; }
+        public static JsonConverter<object?> ObjectConverter { get; }
+        public static JsonConverter<TimeOnly> TimeOnlyConverter { get; }
+        public static JsonTypeInfo<TCollection> CreateIAsyncEnumerableInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IAsyncEnumerable<TElement>;
+        public static JsonConverter<T?> GetNullableConverter<T>(JsonSerializerOptions options) where T : struct;
     }
-    public sealed class JsonObjectInfoValues<T>
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class JsonObjectInfoValues<T>
-    public sealed class JsonParameterInfoValues
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class JsonParameterInfoValues
+    public class JsonPolymorphismOptions {
+        public JsonPolymorphismOptions();
+        public IList<JsonDerivedType> DerivedTypes { get; }
+        public bool IgnoreUnrecognizedTypeDiscriminators { get; set; }
+        [AllowNullAttribute]
+        public string TypeDiscriminatorPropertyName { get; set; }
+        public JsonUnknownDerivedTypeHandling UnknownDerivedTypeHandling { get; set; }
+    }
     public abstract class JsonPropertyInfo {
+        public ICustomAttributeProvider? AttributeProvider { get; set; }
+        public JsonConverter? CustomConverter { get; set; }
+        public Func<object, object?>? Get { get; set; }
+        public bool IsExtensionData { get; set; }
+        public bool IsRequired { get; set; }
+        public string Name { get; set; }
+        public JsonNumberHandling? NumberHandling { get; set; }
+        public JsonSerializerOptions Options { get; }
+        public int Order { get; set; }
+        public Type PropertyType { get; }
+        public Action<object, object?>? Set { get; set; }
+        public Func<object, object?, bool>? ShouldSerialize { get; set; }
     }
-    public sealed class JsonPropertyInfoValues<T>
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class JsonPropertyInfoValues<T>
-    public class JsonTypeInfo {
+    public abstract class JsonTypeInfo {
+        public JsonConverter Converter { get; }
+        public Func<object>? CreateObject { get; set; }
+        public bool IsReadOnly { get; }
+        public JsonTypeInfoKind Kind { get; }
+        public JsonNumberHandling? NumberHandling { get; set; }
+        public Action<object>? OnDeserialized { get; set; }
+        public Action<object>? OnDeserializing { get; set; }
+        public Action<object>? OnSerialized { get; set; }
+        public Action<object>? OnSerializing { get; set; }
+        public JsonSerializerOptions Options { get; }
+        public JsonPolymorphismOptions? PolymorphismOptions { get; set; }
+        public IList<JsonPropertyInfo> Properties { get; }
+        public Type Type { get; }
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        public JsonPropertyInfo CreateJsonPropertyInfo(Type propertyType, string name);
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        public static JsonTypeInfo CreateJsonTypeInfo(Type type, JsonSerializerOptions options);
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        public static JsonTypeInfo<T> CreateJsonTypeInfo<T>(JsonSerializerOptions options);
+        public void MakeReadOnly();
     }
     public abstract class JsonTypeInfo<T> : JsonTypeInfo {
+        public new Func<T>? CreateObject { get; set; }
-        public Action<Utf8JsonWriter, T>? SerializeHandler { get; }
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public Action<Utf8JsonWriter, T>? SerializeHandler { get; }
     }
+    public enum JsonTypeInfoKind {
+        Dictionary = 3,
+        Enumerable = 2,
+        None = 0,
+        Object = 1,
+    }
+    public static class JsonTypeInfoResolver {
+        public static IJsonTypeInfoResolver Combine(params IJsonTypeInfoResolver[] resolvers);
+    }
 }
```

