# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Interface, AllowMultiple=true, Inherited=false)]
+    public class JsonDerivedTypeAttribute : JsonAttribute {
+        public JsonDerivedTypeAttribute(Type derivedType);
+        public JsonDerivedTypeAttribute(Type derivedType, int typeDiscriminator);
+        public JsonDerivedTypeAttribute(Type derivedType, string typeDiscriminator);
+        public Type DerivedType { get; }
+        public object? TypeDiscriminator { get; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Interface, AllowMultiple=false, Inherited=false)]
+    public sealed class JsonPolymorphicAttribute : JsonAttribute {
+        public JsonPolymorphicAttribute();
+        public bool IgnoreUnrecognizedTypeDiscriminators { get; set; }
+        public string TypeDiscriminatorPropertyName { get; set; }
+        public JsonUnknownDerivedTypeHandling UnknownDerivedTypeHandling { get; set; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Property, AllowMultiple=false)]
+    public sealed class JsonRequiredAttribute : JsonAttribute {
+        public JsonRequiredAttribute();
+    }
-    public abstract class JsonSerializerContext {
+    public abstract class JsonSerializerContext : IJsonTypeInfoResolver {
+        JsonTypeInfo IJsonTypeInfoResolver.GetTypeInfo(Type type, JsonSerializerOptions options);
     }
+    public enum JsonUnknownDerivedTypeHandling {
+        FailSerialization = 0,
+        FallBackToBaseType = 1,
+        FallBackToNearestAncestor = 2,
+    }
 }
```

