# System.Text.Json

``` diff
 namespace System.Text.Json {
     public sealed class JsonDocument : IDisposable {
-        public static JsonDocument Parse(ReadOnlyMemory<char> json, JsonDocumentOptions options = default(JsonDocumentOptions));
+        public static JsonDocument Parse([StringSyntaxAttribute("Json")] ReadOnlyMemory<char> json, JsonDocumentOptions options = default(JsonDocumentOptions));
-        public static JsonDocument Parse(string json, JsonDocumentOptions options = default(JsonDocumentOptions));
+        public static JsonDocument Parse([StringSyntaxAttribute("Json")] string json, JsonDocumentOptions options = default(JsonDocumentOptions));
     }
     public static class JsonSerializer {
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static object? Deserialize(ReadOnlySpan<char> json, Type returnType, JsonSerializerOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static object? Deserialize([StringSyntaxAttribute("Json")] ReadOnlySpan<char> json, Type returnType, JsonSerializerOptions? options = null);
-        public static object? Deserialize(ReadOnlySpan<char> json, Type returnType, JsonSerializerContext context);
+        public static object? Deserialize([StringSyntaxAttribute("Json")] ReadOnlySpan<char> json, Type returnType, JsonSerializerContext context);
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static object? Deserialize(string json, Type returnType, JsonSerializerOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static object? Deserialize([StringSyntaxAttribute("Json")] string json, Type returnType, JsonSerializerOptions? options = null);
-        public static object? Deserialize(string json, Type returnType, JsonSerializerContext context);
+        public static object? Deserialize([StringSyntaxAttribute("Json")] string json, Type returnType, JsonSerializerContext context);
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static TValue? Deserialize<TValue>(ReadOnlySpan<char> json, JsonSerializerOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static TValue? Deserialize<TValue>([StringSyntaxAttribute("Json")] ReadOnlySpan<char> json, JsonSerializerOptions? options = null);
-        public static TValue? Deserialize<TValue>(ReadOnlySpan<char> json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue? Deserialize<TValue>([StringSyntaxAttribute("Json")] ReadOnlySpan<char> json, JsonTypeInfo<TValue> jsonTypeInfo);
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static TValue? Deserialize<TValue>(string json, JsonSerializerOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static TValue? Deserialize<TValue>([StringSyntaxAttribute("Json")] string json, JsonSerializerOptions? options = null);
-        public static TValue? Deserialize<TValue>(string json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue? Deserialize<TValue>([StringSyntaxAttribute("Json")] string json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static IAsyncEnumerable<TValue?> DeserializeAsyncEnumerable<TValue>(Stream utf8Json, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
     }
     public sealed class JsonSerializerOptions {
+        public static JsonSerializerOptions Default { [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")] get; }
+        public IJsonTypeInfoResolver TypeInfoResolver { get; set; }
+        public JsonTypeInfo GetTypeInfo(Type type);
     }
     public struct JsonWriterOptions {
+        public int MaxDepth { get; set; }
     }
     public ref struct Utf8JsonReader {
+        public bool ValueIsEscaped { get; }
+        public int CopyString(Span<byte> utf8Destination);
+        public int CopyString(Span<char> destination);
     }
     public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
-        public void WriteRawValue(ReadOnlySpan<char> json, bool skipInputValidation = false);
+        public void WriteRawValue([StringSyntaxAttribute("Json")] ReadOnlySpan<char> json, bool skipInputValidation = false);
-        public void WriteRawValue(string json, bool skipInputValidation = false);
+        public void WriteRawValue([StringSyntaxAttribute("Json")] string json, bool skipInputValidation = false);
     }
 }
```

