# System.Text.RegularExpressions

``` diff
 namespace System.Text.RegularExpressions {
+    [AttributeUsageAttribute(AttributeTargets.Method, AllowMultiple=false, Inherited=false)]
+    public sealed class GeneratedRegexAttribute : Attribute {
+        public GeneratedRegexAttribute([StringSyntaxAttribute("Regex")] string pattern);
+        public GeneratedRegexAttribute([StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
+        public GeneratedRegexAttribute([StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, int matchTimeoutMilliseconds);
+        public GeneratedRegexAttribute([StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, int matchTimeoutMilliseconds, string cultureName);
+        public GeneratedRegexAttribute([StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, string cultureName);
+        public string CultureName { get; }
+        public int MatchTimeoutMilliseconds { get; }
+        public RegexOptions Options { get; }
+        public string Pattern { get; }
+    }
     public class Regex : ISerializable {
-        protected internal string? pattern;
+        [StringSyntaxAttribute("Regex")]
+        protected internal string? pattern;
-        public Regex(string pattern);
+        public Regex([StringSyntaxAttribute("Regex")] string pattern);
-        public Regex(string pattern, RegexOptions options);
+        public Regex([StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
-        public Regex(string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public Regex([StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
-        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname);
+        [ObsoleteAttribute("Regex.CompileToAssembly is obsolete and not supported. Use the GeneratedRegexAttribute with the regular expression source generator instead.", DiagnosticId="SYSLIB0036", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname);
-        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname, CustomAttributeBuilder[]? attributes);
+        [ObsoleteAttribute("Regex.CompileToAssembly is obsolete and not supported. Use the GeneratedRegexAttribute with the regular expression source generator instead.", DiagnosticId="SYSLIB0036", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname, CustomAttributeBuilder[]? attributes);
-        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname, CustomAttributeBuilder[]? attributes, string? resourceFile);
+        [ObsoleteAttribute("Regex.CompileToAssembly is obsolete and not supported. Use the GeneratedRegexAttribute with the regular expression source generator instead.", DiagnosticId="SYSLIB0036", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname, CustomAttributeBuilder[]? attributes, string? resourceFile);
+        public int Count(ReadOnlySpan<char> input);
+        public int Count(ReadOnlySpan<char> input, int startat);
+        public static int Count(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex")] string pattern);
+        public static int Count(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
+        public static int Count(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public int Count(string input);
+        public static int Count(string input, [StringSyntaxAttribute("Regex")] string pattern);
+        public static int Count(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
+        public static int Count(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public Regex.ValueMatchEnumerator EnumerateMatches(ReadOnlySpan<char> input);
+        public Regex.ValueMatchEnumerator EnumerateMatches(ReadOnlySpan<char> input, int startat);
+        public static Regex.ValueMatchEnumerator EnumerateMatches(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex")] string pattern);
+        public static Regex.ValueMatchEnumerator EnumerateMatches(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
+        public static Regex.ValueMatchEnumerator EnumerateMatches(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public bool IsMatch(ReadOnlySpan<char> input);
+        public bool IsMatch(ReadOnlySpan<char> input, int startat);
+        public static bool IsMatch(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex")] string pattern);
+        public static bool IsMatch(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
+        public static bool IsMatch(ReadOnlySpan<char> input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
-        public static bool IsMatch(string input, string pattern);
+        public static bool IsMatch(string input, [StringSyntaxAttribute("Regex")] string pattern);
-        public static bool IsMatch(string input, string pattern, RegexOptions options);
+        public static bool IsMatch(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
-        public static bool IsMatch(string input, string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public static bool IsMatch(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
-        public static Match Match(string input, string pattern);
+        public static Match Match(string input, [StringSyntaxAttribute("Regex")] string pattern);
-        public static Match Match(string input, string pattern, RegexOptions options);
+        public static Match Match(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
-        public static Match Match(string input, string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public static Match Match(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
-        public static MatchCollection Matches(string input, string pattern);
+        public static MatchCollection Matches(string input, [StringSyntaxAttribute("Regex")] string pattern);
-        public static MatchCollection Matches(string input, string pattern, RegexOptions options);
+        public static MatchCollection Matches(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
-        public static MatchCollection Matches(string input, string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public static MatchCollection Matches(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
-        public static string Replace(string input, string pattern, string replacement);
+        public static string Replace(string input, [StringSyntaxAttribute("Regex")] string pattern, string replacement);
-        public static string Replace(string input, string pattern, string replacement, RegexOptions options);
+        public static string Replace(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, string replacement, RegexOptions options);
-        public static string Replace(string input, string pattern, string replacement, RegexOptions options, TimeSpan matchTimeout);
+        public static string Replace(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, string replacement, RegexOptions options, TimeSpan matchTimeout);
-        public static string Replace(string input, string pattern, MatchEvaluator evaluator);
+        public static string Replace(string input, [StringSyntaxAttribute("Regex")] string pattern, MatchEvaluator evaluator);
-        public static string Replace(string input, string pattern, MatchEvaluator evaluator, RegexOptions options);
+        public static string Replace(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, MatchEvaluator evaluator, RegexOptions options);
-        public static string Replace(string input, string pattern, MatchEvaluator evaluator, RegexOptions options, TimeSpan matchTimeout);
+        public static string Replace(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, MatchEvaluator evaluator, RegexOptions options, TimeSpan matchTimeout);
-        public static string[] Split(string input, string pattern);
+        public static string[] Split(string input, [StringSyntaxAttribute("Regex")] string pattern);
-        public static string[] Split(string input, string pattern, RegexOptions options);
+        public static string[] Split(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options);
-        public static string[] Split(string input, string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public static string[] Split(string input, [StringSyntaxAttribute("Regex", new object[]{ "options"})] string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public ref struct ValueMatchEnumerator {
+            public ValueMatch Current { get; }
+            public Regex.ValueMatchEnumerator GetEnumerator();
+            public bool MoveNext();
+        }
     }
-    public class RegexCompilationInfo
+    [ObsoleteAttribute("Regex.CompileToAssembly is obsolete and not supported. Use the GeneratedRegexAttribute with the regular expression source generator instead.", DiagnosticId="SYSLIB0036", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public class RegexCompilationInfo
     [FlagsAttribute]
     public enum RegexOptions {
+        NonBacktracking = 1024,
     }
     public abstract class RegexRunner {
-        protected abstract bool FindFirstChar();
+        protected virtual bool FindFirstChar();
-        protected abstract void Go();
+        protected virtual void Go();
-        protected abstract void InitTrackCount();
+        protected virtual void InitTrackCount();
+        protected internal virtual void Scan(ReadOnlySpan<char> text);
     }
+    public readonly ref struct ValueMatch {
+        public int Index { get; }
+        public int Length { get; }
+    }
 }
```

