# System.Xml

``` diff
 namespace System.Xml {
     public class XmlConvert {
-        public static DateTime ToDateTime(string s, string format);
+        public static DateTime ToDateTime(string s, [StringSyntaxAttribute("DateTimeFormat")] string format);
-        public static DateTime ToDateTime(string s, string[] formats);
+        public static DateTime ToDateTime(string s, [StringSyntaxAttribute("DateTimeFormat")] string[] formats);
-        public static DateTimeOffset ToDateTimeOffset(string s, string format);
+        public static DateTimeOffset ToDateTimeOffset(string s, [StringSyntaxAttribute("DateTimeFormat")] string format);
-        public static DateTimeOffset ToDateTimeOffset(string s, string[] formats);
+        public static DateTimeOffset ToDateTimeOffset(string s, [StringSyntaxAttribute("DateTimeFormat")] string[] formats);
-        public static string ToString(DateTime value, string format);
+        public static string ToString(DateTime value, [StringSyntaxAttribute("DateTimeFormat")] string format);
-        public static string ToString(DateTimeOffset value, string format);
+        public static string ToString(DateTimeOffset value, [StringSyntaxAttribute("DateTimeFormat")] string format);
     }
     public class XmlDocument : XmlNode {
-        public virtual XmlProcessingInstruction CreateProcessingInstruction(string target, string data);
+        public virtual XmlProcessingInstruction CreateProcessingInstruction(string target, string? data);
-        public virtual void LoadXml(string xml);
+        public virtual void LoadXml([StringSyntaxAttribute("Xml")] string xml);
     }
     public class XmlElement : XmlLinkedNode {
-        protected internal XmlElement(string prefix, string localName, string? namespaceURI, XmlDocument doc);
+        protected internal XmlElement(string? prefix, string localName, string? namespaceURI, XmlDocument doc);
     }
     public class XmlNamespaceManager : IEnumerable, IXmlNamespaceResolver {
-        public virtual void AddNamespace(string prefix, string uri);
+        public virtual void AddNamespace(string prefix, [StringSyntaxAttribute("Uri")] string uri);
-        public virtual string? LookupPrefix(string uri);
+        public virtual string? LookupPrefix([StringSyntaxAttribute("Uri")] string uri);
-        public virtual void RemoveNamespace(string prefix, string uri);
+        public virtual void RemoveNamespace(string prefix, [StringSyntaxAttribute("Uri")] string uri);
     }
     public class XmlProcessingInstruction : XmlLinkedNode {
-        protected internal XmlProcessingInstruction(string target, string data, XmlDocument doc);
+        protected internal XmlProcessingInstruction(string target, string? data, XmlDocument doc);
-        public string Data { get; set; }
+        [AllowNullAttribute]
+        public string Data { get; set; }
-        public override string InnerText { get; set; }
+        [AllowNullAttribute]
+        public override string InnerText { get; set; }
-        public string? Target { get; }
+        public string Target { get; }
     }
     public class XmlQualifiedName {
-        public static string ToString(string name, string ns);
+        public static string ToString(string name, string? ns);
     }
     public abstract class XmlResolver {
+        public static XmlResolver ThrowingResolver { get; }
     }
-    public class XmlSecureResolver : XmlResolver
+    [ObsoleteAttribute("XmlSecureResolver is obsolete. Use XmlResolver.ThrowingResolver instead when attempting to forbid XML external entity resolution.", DiagnosticId="SYSLIB0047", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public class XmlSecureResolver : XmlResolver
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     public class XmlTextReader : XmlReader, IXmlLineInfo, IXmlNamespaceResolver {
-        public XmlTextReader(string url);
+        public XmlTextReader([StringSyntaxAttribute("Uri")] string url);
-        public XmlTextReader(string url, Stream input);
+        public XmlTextReader([StringSyntaxAttribute("Uri")] string url, Stream input);
-        public XmlTextReader(string url, Stream input, XmlNameTable nt);
+        public XmlTextReader([StringSyntaxAttribute("Uri")] string url, Stream input, XmlNameTable nt);
-        public XmlTextReader(string url, TextReader input);
+        public XmlTextReader([StringSyntaxAttribute("Uri")] string url, TextReader input);
-        public XmlTextReader(string url, TextReader input, XmlNameTable nt);
+        public XmlTextReader([StringSyntaxAttribute("Uri")] string url, TextReader input, XmlNameTable nt);
-        public XmlTextReader(string url, XmlNameTable nt);
+        public XmlTextReader([StringSyntaxAttribute("Uri")] string url, XmlNameTable nt);
-        public XmlTextReader(string xmlFragment, XmlNodeType fragType, XmlParserContext? context);
+        public XmlTextReader([StringSyntaxAttribute("Xml")] string xmlFragment, XmlNodeType fragType, XmlParserContext? context);
     }
     [ObsoleteAttribute("XmlValidatingReader has been deprecated. Use XmlReader created by XmlReader.Create() method using appropriate XmlReaderSettings instead.")]
     public class XmlValidatingReader : XmlReader, IXmlLineInfo, IXmlNamespaceResolver {
-        public XmlValidatingReader(string xmlFragment, XmlNodeType fragType, XmlParserContext context);
+        public XmlValidatingReader([StringSyntaxAttribute("Xml")] string xmlFragment, XmlNodeType fragType, XmlParserContext context);
     }
 }
```

