# System

``` diff
 namespace System {
     public static class AppContext {
+        public static void SetData(string name, object? data);
     }
     public sealed class AppDomain : MarshalByRefObject {
-        [ObsoleteAttribute("AppDomain.GetCurrentThreadId has been deprecated because it does not provide a stable Id when managed threads are running on fibers (aka lightweight threads). To get a stable identifier for a managed thread, use the ManagedThreadId property on Thread.")]
-        public static int GetCurrentThreadId();
+        [ObsoleteAttribute("AppDomain.GetCurrentThreadId has been deprecated because it does not provide a stable Id when managed threads are running on fibers (aka lightweight threads). To get a stable identifier for a managed thread, use the ManagedThreadId property on Thread instead.")]
+        public static int GetCurrentThreadId();
     }
     public class ArgumentException : SystemException {
+        public static void ThrowIfNullOrEmpty([NotNullAttribute] string argument, [CallerArgumentExpressionAttribute("argument")] string paramName = null);
     }
     public class ArgumentNullException : ArgumentException {
+        [CLSCompliantAttribute(false)]
+        public unsafe static void ThrowIfNull([NotNullAttribute] void* argument, [CallerArgumentExpressionAttribute("argument")] string? paramName = null);
     }
-    public readonly struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable, ISpanFormattable {
+    public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte, bool>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte, bool>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, INumberBase<byte>, IParsable<byte>, IShiftOperators<byte, int, byte>, ISpanFormattable, ISpanParsable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
+        static byte System.Numerics.IAdditiveIdentity<System.Byte,System.Byte>.AdditiveIdentity { get; }
+        static byte System.Numerics.IBinaryNumber<System.Byte>.AllBitsSet { get; }
+        static byte System.Numerics.IMinMaxValue<System.Byte>.MaxValue { get; }
+        static byte System.Numerics.IMinMaxValue<System.Byte>.MinValue { get; }
+        static byte System.Numerics.IMultiplicativeIdentity<System.Byte,System.Byte>.MultiplicativeIdentity { get; }
+        static byte System.Numerics.INumberBase<System.Byte>.One { get; }
+        static int System.Numerics.INumberBase<System.Byte>.Radix { get; }
+        static byte System.Numerics.INumberBase<System.Byte>.Zero { get; }
+        public static byte Clamp(byte value, byte min, byte max);
+        public static byte CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static byte CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static byte CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (byte Quotient, byte Remainder) DivRem(byte left, byte right);
+        public static bool IsEvenInteger(byte value);
+        public static bool IsOddInteger(byte value);
+        public static bool IsPow2(byte value);
+        public static byte LeadingZeroCount(byte value);
+        public static byte Log2(byte value);
+        public static byte Max(byte x, byte y);
+        public static byte Min(byte x, byte y);
+        public static byte Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static byte PopCount(byte value);
+        public static byte RotateLeft(byte value, int rotateAmount);
+        public static byte RotateRight(byte value, int rotateAmount);
+        public static int Sign(byte value);
+        static byte IAdditionOperators<byte, byte, byte>.operator +(byte left, byte right);
+        static byte IAdditionOperators<byte, byte, byte>.operator checked +(byte left, byte right);
+        int IBinaryInteger<byte>.GetByteCount();
+        int IBinaryInteger<byte>.GetShortestBitLength();
+        static bool IBinaryInteger<byte>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out byte value);
+        static bool IBinaryInteger<byte>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out byte value);
+        bool IBinaryInteger<byte>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<byte>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static byte IBitwiseOperators<byte, byte, byte>.operator &(byte left, byte right);
+        static byte IBitwiseOperators<byte, byte, byte>.operator |(byte left, byte right);
+        static byte IBitwiseOperators<byte, byte, byte>.operator ^(byte left, byte right);
+        static byte IBitwiseOperators<byte, byte, byte>.operator ~(byte value);
+        static bool IComparisonOperators<byte, byte, bool>.operator >(byte left, byte right);
+        static bool IComparisonOperators<byte, byte, bool>.operator >=(byte left, byte right);
+        static bool IComparisonOperators<byte, byte, bool>.operator <(byte left, byte right);
+        static bool IComparisonOperators<byte, byte, bool>.operator <=(byte left, byte right);
+        static byte IDecrementOperators<byte>.operator checked --(byte value);
+        static byte IDecrementOperators<byte>.operator --(byte value);
+        static byte IDivisionOperators<byte, byte, byte>.operator /(byte left, byte right);
+        static bool IEqualityOperators<byte, byte, bool>.operator ==(byte left, byte right);
+        static bool IEqualityOperators<byte, byte, bool>.operator !=(byte left, byte right);
+        static byte IIncrementOperators<byte>.operator checked ++(byte value);
+        static byte IIncrementOperators<byte>.operator ++(byte value);
+        static byte IModulusOperators<byte, byte, byte>.operator %(byte left, byte right);
+        static byte IMultiplyOperators<byte, byte, byte>.operator checked *(byte left, byte right);
+        static byte IMultiplyOperators<byte, byte, byte>.operator *(byte left, byte right);
+        static byte INumber<byte>.CopySign(byte value, byte sign);
+        static byte INumber<byte>.MaxNumber(byte x, byte y);
+        static byte INumber<byte>.MinNumber(byte x, byte y);
+        static byte INumberBase<byte>.Abs(byte value);
+        static bool INumberBase<byte>.IsCanonical(byte value);
+        static bool INumberBase<byte>.IsComplexNumber(byte value);
+        static bool INumberBase<byte>.IsFinite(byte value);
+        static bool INumberBase<byte>.IsImaginaryNumber(byte value);
+        static bool INumberBase<byte>.IsInfinity(byte value);
+        static bool INumberBase<byte>.IsInteger(byte value);
+        static bool INumberBase<byte>.IsNaN(byte value);
+        static bool INumberBase<byte>.IsNegative(byte value);
+        static bool INumberBase<byte>.IsNegativeInfinity(byte value);
+        static bool INumberBase<byte>.IsNormal(byte value);
+        static bool INumberBase<byte>.IsPositive(byte value);
+        static bool INumberBase<byte>.IsPositiveInfinity(byte value);
+        static bool INumberBase<byte>.IsRealNumber(byte value);
+        static bool INumberBase<byte>.IsSubnormal(byte value);
+        static bool INumberBase<byte>.IsZero(byte value);
+        static byte INumberBase<byte>.MaxMagnitude(byte x, byte y);
+        static byte INumberBase<byte>.MaxMagnitudeNumber(byte x, byte y);
+        static byte INumberBase<byte>.MinMagnitude(byte x, byte y);
+        static byte INumberBase<byte>.MinMagnitudeNumber(byte x, byte y);
+        static bool INumberBase<byte>.TryConvertFromChecked<TOther>(TOther value, out byte result);
+        static bool INumberBase<byte>.TryConvertFromSaturating<TOther>(TOther value, out byte result);
+        static bool INumberBase<byte>.TryConvertFromTruncating<TOther>(TOther value, out byte result);
+        static bool INumberBase<byte>.TryConvertToChecked<TOther>(byte value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<byte>.TryConvertToSaturating<TOther>(byte value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<byte>.TryConvertToTruncating<TOther>(byte value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static byte IShiftOperators<byte, int, byte>.operator <<(byte value, int shiftAmount);
+        static byte IShiftOperators<byte, int, byte>.operator >>(byte value, int shiftAmount);
+        static byte IShiftOperators<byte, int, byte>.operator >>>(byte value, int shiftAmount);
+        static byte ISubtractionOperators<byte, byte, byte>.operator checked -(byte left, byte right);
+        static byte ISubtractionOperators<byte, byte, byte>.operator -(byte left, byte right);
+        static byte IUnaryNegationOperators<byte, byte>.operator checked -(byte value);
+        static byte IUnaryNegationOperators<byte, byte>.operator -(byte value);
+        static byte IUnaryPlusOperators<byte, byte>.operator +(byte value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static byte TrailingZeroCount(byte value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out byte result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out byte result);
     }
-    public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char>, IFormattable, ISpanFormattable {
+    public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char, bool>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char, bool>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, INumberBase<char>, IParsable<char>, IShiftOperators<char, int, char>, ISpanFormattable, ISpanParsable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
+        static char System.Numerics.IAdditiveIdentity<System.Char,System.Char>.AdditiveIdentity { get; }
+        static char System.Numerics.IBinaryNumber<System.Char>.AllBitsSet { get; }
+        static char System.Numerics.IMinMaxValue<System.Char>.MaxValue { get; }
+        static char System.Numerics.IMinMaxValue<System.Char>.MinValue { get; }
+        static char System.Numerics.IMultiplicativeIdentity<System.Char,System.Char>.MultiplicativeIdentity { get; }
+        static char System.Numerics.INumberBase<System.Char>.One { get; }
+        static int System.Numerics.INumberBase<System.Char>.Radix { get; }
+        static char System.Numerics.INumberBase<System.Char>.Zero { get; }
+        public static bool IsAsciiDigit(char c);
+        public static bool IsAsciiHexDigit(char c);
+        public static bool IsAsciiHexDigitLower(char c);
+        public static bool IsAsciiHexDigitUpper(char c);
+        public static bool IsAsciiLetter(char c);
+        public static bool IsAsciiLetterLower(char c);
+        public static bool IsAsciiLetterOrDigit(char c);
+        public static bool IsAsciiLetterUpper(char c);
+        public static bool IsBetween(char c, char minInclusive, char maxInclusive);
+        static char IParsable<char>.Parse(string s, IFormatProvider provider);
+        static bool IParsable<char>.TryParse([NotNullWhenAttribute(true)] string s, IFormatProvider provider, out char result);
+        static char ISpanParsable<char>.Parse(ReadOnlySpan<char> s, IFormatProvider provider);
+        static bool ISpanParsable<char>.TryParse(ReadOnlySpan<char> s, IFormatProvider provider, out char result);
+        static char IAdditionOperators<char, char, char>.operator +(char left, char right);
+        static char IAdditionOperators<char, char, char>.operator checked +(char left, char right);
+        int IBinaryInteger<char>.GetByteCount();
+        int IBinaryInteger<char>.GetShortestBitLength();
+        static char IBinaryInteger<char>.LeadingZeroCount(char value);
+        static char IBinaryInteger<char>.PopCount(char value);
+        static char IBinaryInteger<char>.RotateLeft(char value, int rotateAmount);
+        static char IBinaryInteger<char>.RotateRight(char value, int rotateAmount);
+        static char IBinaryInteger<char>.TrailingZeroCount(char value);
+        static bool IBinaryInteger<char>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out char value);
+        static bool IBinaryInteger<char>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out char value);
+        bool IBinaryInteger<char>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<char>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static bool IBinaryNumber<char>.IsPow2(char value);
+        static char IBinaryNumber<char>.Log2(char value);
+        static char IBitwiseOperators<char, char, char>.operator &(char left, char right);
+        static char IBitwiseOperators<char, char, char>.operator |(char left, char right);
+        static char IBitwiseOperators<char, char, char>.operator ^(char left, char right);
+        static char IBitwiseOperators<char, char, char>.operator ~(char value);
+        static bool IComparisonOperators<char, char, bool>.operator >(char left, char right);
+        static bool IComparisonOperators<char, char, bool>.operator >=(char left, char right);
+        static bool IComparisonOperators<char, char, bool>.operator <(char left, char right);
+        static bool IComparisonOperators<char, char, bool>.operator <=(char left, char right);
+        static char IDecrementOperators<char>.operator checked --(char value);
+        static char IDecrementOperators<char>.operator --(char value);
+        static char IDivisionOperators<char, char, char>.operator /(char left, char right);
+        static bool IEqualityOperators<char, char, bool>.operator ==(char left, char right);
+        static bool IEqualityOperators<char, char, bool>.operator !=(char left, char right);
+        static char IIncrementOperators<char>.operator checked ++(char value);
+        static char IIncrementOperators<char>.operator ++(char value);
+        static char IModulusOperators<char, char, char>.operator %(char left, char right);
+        static char IMultiplyOperators<char, char, char>.operator checked *(char left, char right);
+        static char IMultiplyOperators<char, char, char>.operator *(char left, char right);
+        static char INumberBase<char>.Abs(char value);
+        static bool INumberBase<char>.IsCanonical(char value);
+        static bool INumberBase<char>.IsComplexNumber(char value);
+        static bool INumberBase<char>.IsEvenInteger(char value);
+        static bool INumberBase<char>.IsFinite(char value);
+        static bool INumberBase<char>.IsImaginaryNumber(char value);
+        static bool INumberBase<char>.IsInfinity(char value);
+        static bool INumberBase<char>.IsInteger(char value);
+        static bool INumberBase<char>.IsNaN(char value);
+        static bool INumberBase<char>.IsNegative(char value);
+        static bool INumberBase<char>.IsNegativeInfinity(char value);
+        static bool INumberBase<char>.IsNormal(char value);
+        static bool INumberBase<char>.IsOddInteger(char value);
+        static bool INumberBase<char>.IsPositive(char value);
+        static bool INumberBase<char>.IsPositiveInfinity(char value);
+        static bool INumberBase<char>.IsRealNumber(char value);
+        static bool INumberBase<char>.IsSubnormal(char value);
+        static bool INumberBase<char>.IsZero(char value);
+        static char INumberBase<char>.MaxMagnitude(char x, char y);
+        static char INumberBase<char>.MaxMagnitudeNumber(char x, char y);
+        static char INumberBase<char>.MinMagnitude(char x, char y);
+        static char INumberBase<char>.MinMagnitudeNumber(char x, char y);
+        static char INumberBase<char>.Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider);
+        static char INumberBase<char>.Parse(string s, NumberStyles style, IFormatProvider provider);
+        static bool INumberBase<char>.TryConvertFromChecked<TOther>(TOther value, out char result);
+        static bool INumberBase<char>.TryConvertFromSaturating<TOther>(TOther value, out char result);
+        static bool INumberBase<char>.TryConvertFromTruncating<TOther>(TOther value, out char result);
+        static bool INumberBase<char>.TryConvertToChecked<TOther>(char value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<char>.TryConvertToSaturating<TOther>(char value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<char>.TryConvertToTruncating<TOther>(char value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<char>.TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out char result);
+        static bool INumberBase<char>.TryParse([NotNullWhenAttribute(true)] string s, NumberStyles style, IFormatProvider provider, out char result);
+        static char IShiftOperators<char, int, char>.operator <<(char value, int shiftAmount);
+        static char IShiftOperators<char, int, char>.operator >>(char value, int shiftAmount);
+        static char IShiftOperators<char, int, char>.operator >>>(char value, int shiftAmount);
+        static char ISubtractionOperators<char, char, char>.operator checked -(char left, char right);
+        static char ISubtractionOperators<char, char, char>.operator -(char left, char right);
+        static char IUnaryNegationOperators<char, char>.operator checked -(char value);
+        static char IUnaryNegationOperators<char, char>.operator -(char value);
+        static char IUnaryPlusOperators<char, char>.operator +(char value);
     }
     public static class Console {
-        public static void Write(string format, object? arg0);
+        public static void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public static void Write(string format, object? arg0, object? arg1);
+        public static void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public static void Write(string format, object? arg0, object? arg1, object? arg2);
+        public static void Write([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public static void Write(string format, params object?[]? arg);
+        public static void Write([StringSyntaxAttribute("CompositeFormat")] string format, params object?[]? arg);
-        public static void WriteLine(string format, object? arg0);
+        public static void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public static void WriteLine(string format, object? arg0, object? arg1);
+        public static void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public static void WriteLine(string format, object? arg0, object? arg1, object? arg2);
+        public static void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public static void WriteLine(string format, params object?[]? arg);
+        public static void WriteLine([StringSyntaxAttribute("CompositeFormat")] string format, params object?[]? arg);
     }
-    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IEquatable<DateOnly>, IFormattable, ISpanFormattable {
+    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IEquatable<DateOnly>, IFormattable, IParsable<DateOnly>, ISpanFormattable, ISpanParsable<DateOnly> {
+        public static DateOnly Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static DateOnly Parse(string s, IFormatProvider? provider);
-        public static DateOnly ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider? provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateOnlyFormat")] ReadOnlySpan<char> format, IFormatProvider? provider = null, DateTimeStyles style = DateTimeStyles.None);
-        public static DateOnly ParseExact(ReadOnlySpan<char> s, string[] formats);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateOnlyFormat")] string[] formats);
-        public static DateOnly ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateOnlyFormat")] string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public static DateOnly ParseExact(string s, string format);
+        public static DateOnly ParseExact(string s, [StringSyntaxAttribute("DateOnlyFormat")] string format);
-        public static DateOnly ParseExact(string s, string format, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(string s, [StringSyntaxAttribute("DateOnlyFormat")] string format, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public static DateOnly ParseExact(string s, string[] formats);
+        public static DateOnly ParseExact(string s, [StringSyntaxAttribute("DateOnlyFormat")] string[] formats);
-        public static DateOnly ParseExact(string s, string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(string s, [StringSyntaxAttribute("DateOnlyFormat")] string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("DateOnlyFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("DateOnlyFormat")] string? format, IFormatProvider? provider);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("DateOnlyFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out DateOnly result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out DateOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateOnlyFormat")] ReadOnlySpan<char> format, out DateOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateOnlyFormat")] ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true)] string?[]? formats, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateOnlyFormat")] string?[]? formats, out DateOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateOnlyFormat")] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string? format, out DateOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateOnlyFormat")] string? format, out DateOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string? format, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateOnlyFormat")] string? format, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string?[]? formats, out DateOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateOnlyFormat")] string?[]? formats, out DateOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateOnlyFormat")] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateOnly result);
     }
-    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, IParsable<DateTime>, ISerializable, ISpanFormattable, ISpanParsable<DateTime> {
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, DateTimeKind kind);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, Calendar calendar, DateTimeKind kind);
+        public int Microsecond { get; }
+        public int Nanosecond { get; }
+        public DateTime AddMicroseconds(double value);
+        public static DateTime Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static DateTime ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateTime ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateTimeFormat")] ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public static DateTime ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateTime ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateTimeFormat")] string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public static DateTime ParseExact(string s, string format, IFormatProvider? provider);
+        public static DateTime ParseExact(string s, [StringSyntaxAttribute("DateTimeFormat")] string format, IFormatProvider? provider);
-        public static DateTime ParseExact(string s, string format, IFormatProvider? provider, DateTimeStyles style);
+        public static DateTime ParseExact(string s, [StringSyntaxAttribute("DateTimeFormat")] string format, IFormatProvider? provider, DateTimeStyles style);
-        public static DateTime ParseExact(string s, string[] formats, IFormatProvider? provider, DateTimeStyles style);
+        public static DateTime ParseExact(string s, [StringSyntaxAttribute("DateTimeFormat")] string[] formats, IFormatProvider? provider, DateTimeStyles style);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("DateTimeFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("DateTimeFormat")] string? format, IFormatProvider? provider);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("DateTimeFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out DateTime result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out DateTime result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("DateTimeFormat")] ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateTimeFormat")] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string? format, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateTimeFormat")] string? format, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateTimeFormat")] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out DateTime result);
     }
-    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, IParsable<DateTimeOffset>, ISerializable, ISpanFormattable, ISpanParsable<DateTimeOffset> {
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, Calendar calendar, TimeSpan offset);
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, TimeSpan offset);
+        public int Microsecond { get; }
+        public int Nanosecond { get; }
+        public DateTimeOffset AddMicroseconds(double microseconds);
+        public static DateTimeOffset Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static DateTimeOffset ParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider? formatProvider, DateTimeStyles styles = DateTimeStyles.None);
+        public static DateTimeOffset ParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("DateTimeFormat")] ReadOnlySpan<char> format, IFormatProvider? formatProvider, DateTimeStyles styles = DateTimeStyles.None);
-        public static DateTimeOffset ParseExact(ReadOnlySpan<char> input, string[] formats, IFormatProvider? formatProvider, DateTimeStyles styles = DateTimeStyles.None);
+        public static DateTimeOffset ParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("DateTimeFormat")] string[] formats, IFormatProvider? formatProvider, DateTimeStyles styles = DateTimeStyles.None);
-        public static DateTimeOffset ParseExact(string input, string format, IFormatProvider? formatProvider);
+        public static DateTimeOffset ParseExact(string input, [StringSyntaxAttribute("DateTimeFormat")] string format, IFormatProvider? formatProvider);
-        public static DateTimeOffset ParseExact(string input, string format, IFormatProvider? formatProvider, DateTimeStyles styles);
+        public static DateTimeOffset ParseExact(string input, [StringSyntaxAttribute("DateTimeFormat")] string format, IFormatProvider? formatProvider, DateTimeStyles styles);
-        public static DateTimeOffset ParseExact(string input, string[] formats, IFormatProvider? formatProvider, DateTimeStyles styles);
+        public static DateTimeOffset ParseExact(string input, [StringSyntaxAttribute("DateTimeFormat")] string[] formats, IFormatProvider? formatProvider, DateTimeStyles styles);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("DateTimeFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? formatProvider);
+        public string ToString([StringSyntaxAttribute("DateTimeFormat")] string? format, IFormatProvider? formatProvider);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? formatProvider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("DateTimeFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? formatProvider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out DateTimeOffset result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out DateTimeOffset result);
-        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("DateTimeFormat")] ReadOnlySpan<char> format, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
-        public static bool TryParseExact(ReadOnlySpan<char> input, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateTimeFormat")] string?[]? formats, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true)] string? format, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateTimeFormat")] string? format, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true), StringSyntaxAttribute("DateTimeFormat")] string?[]? formats, IFormatProvider? formatProvider, DateTimeStyles styles, out DateTimeOffset result);
     }
-    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal, bool>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal, bool>, IEquatable<decimal>, IFloatingPoint<decimal>, IFloatingPointConstants<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, INumberBase<decimal>, IParsable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParsable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
+        public byte Scale { get; }
+        static decimal System.Numerics.IAdditiveIdentity<System.Decimal,System.Decimal>.AdditiveIdentity { get; }
+        static decimal System.Numerics.IFloatingPointConstants<System.Decimal>.E { get; }
+        static decimal System.Numerics.IFloatingPointConstants<System.Decimal>.Pi { get; }
+        static decimal System.Numerics.IFloatingPointConstants<System.Decimal>.Tau { get; }
+        static decimal System.Numerics.IMinMaxValue<System.Decimal>.MaxValue { get; }
+        static decimal System.Numerics.IMinMaxValue<System.Decimal>.MinValue { get; }
+        static decimal System.Numerics.IMultiplicativeIdentity<System.Decimal,System.Decimal>.MultiplicativeIdentity { get; }
+        static decimal System.Numerics.INumberBase<System.Decimal>.One { get; }
+        static int System.Numerics.INumberBase<System.Decimal>.Radix { get; }
+        static decimal System.Numerics.INumberBase<System.Decimal>.Zero { get; }
+        static decimal System.Numerics.ISignedNumber<System.Decimal>.NegativeOne { get; }
+        public static decimal Abs(decimal value);
+        public static decimal Clamp(decimal value, decimal min, decimal max);
+        public static decimal CopySign(decimal value, decimal sign);
+        public static decimal CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static decimal CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static decimal CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static bool IsCanonical(decimal value);
+        public static bool IsEvenInteger(decimal value);
+        public static bool IsInteger(decimal value);
+        public static bool IsNegative(decimal value);
+        public static bool IsOddInteger(decimal value);
+        public static bool IsPositive(decimal value);
+        public static decimal Max(decimal x, decimal y);
+        public static decimal MaxMagnitude(decimal x, decimal y);
+        public static decimal Min(decimal x, decimal y);
+        public static decimal MinMagnitude(decimal x, decimal y);
+        public static decimal Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static int Sign(decimal d);
+        int IFloatingPoint<decimal>.GetExponentByteCount();
+        int IFloatingPoint<decimal>.GetExponentShortestBitLength();
+        int IFloatingPoint<decimal>.GetSignificandBitLength();
+        int IFloatingPoint<decimal>.GetSignificandByteCount();
+        bool IFloatingPoint<decimal>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<decimal>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<decimal>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<decimal>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static decimal INumber<decimal>.MaxNumber(decimal x, decimal y);
+        static decimal INumber<decimal>.MinNumber(decimal x, decimal y);
+        static bool INumberBase<decimal>.IsComplexNumber(decimal value);
+        static bool INumberBase<decimal>.IsFinite(decimal value);
+        static bool INumberBase<decimal>.IsImaginaryNumber(decimal value);
+        static bool INumberBase<decimal>.IsInfinity(decimal value);
+        static bool INumberBase<decimal>.IsNaN(decimal value);
+        static bool INumberBase<decimal>.IsNegativeInfinity(decimal value);
+        static bool INumberBase<decimal>.IsNormal(decimal value);
+        static bool INumberBase<decimal>.IsPositiveInfinity(decimal value);
+        static bool INumberBase<decimal>.IsRealNumber(decimal value);
+        static bool INumberBase<decimal>.IsSubnormal(decimal value);
+        static bool INumberBase<decimal>.IsZero(decimal value);
+        static decimal INumberBase<decimal>.MaxMagnitudeNumber(decimal x, decimal y);
+        static decimal INumberBase<decimal>.MinMagnitudeNumber(decimal x, decimal y);
+        static bool INumberBase<decimal>.TryConvertFromChecked<TOther>(TOther value, out decimal result);
+        static bool INumberBase<decimal>.TryConvertFromSaturating<TOther>(TOther value, out decimal result);
+        static bool INumberBase<decimal>.TryConvertFromTruncating<TOther>(TOther value, out decimal result);
+        static bool INumberBase<decimal>.TryConvertToChecked<TOther>(decimal value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<decimal>.TryConvertToSaturating<TOther>(decimal value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<decimal>.TryConvertToTruncating<TOther>(decimal value, [MaybeNullWhenAttribute(false)] out TOther result);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out decimal result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out decimal result);
     }
-    public readonly struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable, ISpanFormattable {
+    public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double, bool>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double, bool>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointConstants<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+        public const double E = 2.718281828459045;
+        public const double NegativeZero = 0;
+        public const double Pi = 3.141592653589793;
+        public const double Tau = 6.283185307179586;
+        static double System.Numerics.IAdditiveIdentity<System.Double,System.Double>.AdditiveIdentity { get; }
+        static double System.Numerics.IBinaryNumber<System.Double>.AllBitsSet { get; }
+        static double System.Numerics.IFloatingPointConstants<System.Double>.E { get; }
+        static double System.Numerics.IFloatingPointConstants<System.Double>.Pi { get; }
+        static double System.Numerics.IFloatingPointConstants<System.Double>.Tau { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.Epsilon { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.NaN { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.NegativeInfinity { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.NegativeZero { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.PositiveInfinity { get; }
+        static double System.Numerics.IMinMaxValue<System.Double>.MaxValue { get; }
+        static double System.Numerics.IMinMaxValue<System.Double>.MinValue { get; }
+        static double System.Numerics.IMultiplicativeIdentity<System.Double,System.Double>.MultiplicativeIdentity { get; }
+        static double System.Numerics.INumberBase<System.Double>.One { get; }
+        static int System.Numerics.INumberBase<System.Double>.Radix { get; }
+        static double System.Numerics.INumberBase<System.Double>.Zero { get; }
+        static double System.Numerics.ISignedNumber<System.Double>.NegativeOne { get; }
+        public static double Abs(double value);
+        public static double Acos(double x);
+        public static double Acosh(double x);
+        public static double AcosPi(double x);
+        public static double Asin(double x);
+        public static double Asinh(double x);
+        public static double AsinPi(double x);
+        public static double Atan(double x);
+        public static double Atan2(double y, double x);
+        public static double Atan2Pi(double y, double x);
+        public static double Atanh(double x);
+        public static double AtanPi(double x);
+        public static double BitDecrement(double x);
+        public static double BitIncrement(double x);
+        public static double Cbrt(double x);
+        public static double Ceiling(double x);
+        public static double Clamp(double value, double min, double max);
+        public static double CopySign(double value, double sign);
+        public static double Cos(double x);
+        public static double Cosh(double x);
+        public static double CosPi(double x);
+        public static double CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static double CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static double CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static double Exp(double x);
+        public static double Exp10(double x);
+        public static double Exp10M1(double x);
+        public static double Exp2(double x);
+        public static double Exp2M1(double x);
+        public static double ExpM1(double x);
+        public static double Floor(double x);
+        public static double FusedMultiplyAdd(double left, double right, double addend);
+        public static double Hypot(double x, double y);
+        public static double Ieee754Remainder(double left, double right);
+        public static int ILogB(double x);
+        public static bool IsEvenInteger(double value);
+        public static bool IsInteger(double value);
+        public static bool IsOddInteger(double value);
+        public static bool IsPositive(double value);
+        public static bool IsPow2(double value);
+        public static bool IsRealNumber(double value);
+        public static double Log(double x);
+        public static double Log(double x, double newBase);
+        public static double Log10(double x);
+        public static double Log10P1(double x);
+        public static double Log2(double value);
+        public static double Log2P1(double x);
+        public static double LogP1(double x);
+        public static double Max(double x, double y);
+        public static double MaxMagnitude(double x, double y);
+        public static double MaxMagnitudeNumber(double x, double y);
+        public static double MaxNumber(double x, double y);
+        public static double Min(double x, double y);
+        public static double MinMagnitude(double x, double y);
+        public static double MinMagnitudeNumber(double x, double y);
+        public static double MinNumber(double x, double y);
+        public static double Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static double Pow(double x, double y);
+        public static double ReciprocalEstimate(double x);
+        public static double ReciprocalSqrtEstimate(double x);
+        public static double RootN(double x, int n);
+        public static double Round(double x);
+        public static double Round(double x, int digits);
+        public static double Round(double x, int digits, MidpointRounding mode);
+        public static double Round(double x, MidpointRounding mode);
+        public static double ScaleB(double x, int n);
+        public static int Sign(double value);
+        public static double Sin(double x);
+        public static (double Sin, double Cos) SinCos(double x);
+        public static (double SinPi, double CosPi) SinCosPi(double x);
+        public static double Sinh(double x);
+        public static double SinPi(double x);
+        public static double Sqrt(double x);
+        static double IAdditionOperators<double, double, double>.operator +(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator &(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator |(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator ^(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator ~(double value);
+        static double IDecrementOperators<double>.operator --(double value);
+        static double IDivisionOperators<double, double, double>.operator /(double left, double right);
+        int IFloatingPoint<double>.GetExponentByteCount();
+        int IFloatingPoint<double>.GetExponentShortestBitLength();
+        int IFloatingPoint<double>.GetSignificandBitLength();
+        int IFloatingPoint<double>.GetSignificandByteCount();
+        bool IFloatingPoint<double>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<double>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<double>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<double>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static double IIncrementOperators<double>.operator ++(double value);
+        static double IModulusOperators<double, double, double>.operator %(double left, double right);
+        static double IMultiplyOperators<double, double, double>.operator *(double left, double right);
+        static bool INumberBase<double>.IsCanonical(double value);
+        static bool INumberBase<double>.IsComplexNumber(double value);
+        static bool INumberBase<double>.IsImaginaryNumber(double value);
+        static bool INumberBase<double>.IsZero(double value);
+        static bool INumberBase<double>.TryConvertFromChecked<TOther>(TOther value, out double result);
+        static bool INumberBase<double>.TryConvertFromSaturating<TOther>(TOther value, out double result);
+        static bool INumberBase<double>.TryConvertFromTruncating<TOther>(TOther value, out double result);
+        static bool INumberBase<double>.TryConvertToChecked<TOther>(double value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<double>.TryConvertToSaturating<TOther>(double value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<double>.TryConvertToTruncating<TOther>(double value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static double ISubtractionOperators<double, double, double>.operator -(double left, double right);
+        static double IUnaryNegationOperators<double, double>.operator -(double value);
+        static double IUnaryPlusOperators<double, double>.operator +(double value);
+        public static double Tan(double x);
+        public static double Tanh(double x);
+        public static double TanPi(double x);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static double Truncate(double x);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out double result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out double result);
     }
     public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
-        public static string Format(Type enumType, object value, string format);
+        public static string Format(Type enumType, object value, [StringSyntaxAttribute("EnumFormat")] string format);
+        public static Array GetValuesAsUnderlyingType(Type enumType);
+        public static Array GetValuesAsUnderlyingType<TEnum>() where TEnum : struct;
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("EnumFormat")] string? format);
-        [ObsoleteAttribute("The provider argument is not used. Use ToString(String) instead.")]
-        public string ToString(string? format, IFormatProvider? provider);
+        [ObsoleteAttribute("The provider argument is not used. Use ToString(String) instead.")]
+        public string ToString([StringSyntaxAttribute("EnumFormat")] string? format, IFormatProvider? provider);
-        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, bool ignoreCase, out object? result);
+        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, bool ignoreCase, [NotNullWhenAttribute(true)] out object? result);
-        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, out object? result);
+        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, [NotNullWhenAttribute(true)] out object? result);
-        public static bool TryParse(Type enumType, string? value, bool ignoreCase, out object? result);
+        public static bool TryParse(Type enumType, string? value, bool ignoreCase, [NotNullWhenAttribute(true)] out object? result);
-        public static bool TryParse(Type enumType, string? value, out object? result);
+        public static bool TryParse(Type enumType, string? value, [NotNullWhenAttribute(true)] out object? result);
     }
     public class Exception : ISerializable {
-        public MethodBase TargetSite { get; }
+        public MethodBase TargetSite { [RequiresUnreferencedCodeAttribute("Metadata for the method might be incomplete or removed")] get; }
     }
     public abstract class FormattableString : IFormattable {
-        public abstract string Format { get; }
+        [StringSyntaxAttribute("CompositeFormat")]
+        public abstract string Format { get; }
     }
     public static class GC {
+        public static IReadOnlyDictionary<string, object> GetConfigurationVariables();
+        public static TimeSpan GetTotalPauseDuration();
+        public static GCNotificationStatus WaitForFullGCApproach(TimeSpan timeout);
+        public static GCNotificationStatus WaitForFullGCComplete(TimeSpan timeout);
     }
     public enum GCCollectionMode {
+        Aggressive = 3,
     }
-    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable, ISpanFormattable {
+    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable, IParsable<Guid>, ISpanFormattable, ISpanParsable<Guid> {
+        public static bool operator >(Guid left, Guid right);
+        public static bool operator >=(Guid left, Guid right);
+        public static bool operator <(Guid left, Guid right);
+        public static bool operator <=(Guid left, Guid right);
+        public static Guid Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static Guid Parse(string s, IFormatProvider? provider);
-        public static Guid ParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format);
+        public static Guid ParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("GuidFormat")] ReadOnlySpan<char> format);
-        public static Guid ParseExact(string input, string format);
+        public static Guid ParseExact(string input, [StringSyntaxAttribute("GuidFormat")] string format);
-        bool ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+        bool ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("GuidFormat")] ReadOnlySpan<char> format, IFormatProvider provider);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("GuidFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("GuidFormat")] string? format, IFormatProvider? provider);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>));
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("GuidFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>));
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Guid result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out Guid result);
-        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, out Guid result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("GuidFormat")] ReadOnlySpan<char> format, out Guid result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true)] string? format, out Guid result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true), StringSyntaxAttribute("GuidFormat")] string? format, out Guid result);
     }
-    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable, ISpanFormattable {
+    public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half, bool>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half, bool>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointConstants<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+        public static Half E { get; }
+        public static Half MultiplicativeIdentity { get; }
+        public static Half NegativeOne { get; }
+        public static Half NegativeZero { get; }
+        public static Half One { get; }
+        public static Half Pi { get; }
+        static Half System.Numerics.IAdditiveIdentity<System.Half,System.Half>.AdditiveIdentity { get; }
+        static Half System.Numerics.IBinaryNumber<System.Half>.AllBitsSet { get; }
+        static int System.Numerics.INumberBase<System.Half>.Radix { get; }
+        public static Half Tau { get; }
+        public static Half Zero { get; }
+        public static Half Abs(Half value);
+        public static Half Acos(Half x);
+        public static Half Acosh(Half x);
+        public static Half AcosPi(Half x);
+        public static Half Asin(Half x);
+        public static Half Asinh(Half x);
+        public static Half AsinPi(Half x);
+        public static Half Atan(Half x);
+        public static Half Atan2(Half y, Half x);
+        public static Half Atan2Pi(Half y, Half x);
+        public static Half Atanh(Half x);
+        public static Half AtanPi(Half x);
+        public static Half BitDecrement(Half x);
+        public static Half BitIncrement(Half x);
+        public static Half Cbrt(Half x);
+        public static Half Ceiling(Half x);
+        public static Half Clamp(Half value, Half min, Half max);
+        public static Half CopySign(Half value, Half sign);
+        public static Half Cos(Half x);
+        public static Half Cosh(Half x);
+        public static Half CosPi(Half x);
+        public static Half CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static Half CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static Half CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static Half Exp(Half x);
+        public static Half Exp10(Half x);
+        public static Half Exp10M1(Half x);
+        public static Half Exp2(Half x);
+        public static Half Exp2M1(Half x);
+        public static Half ExpM1(Half x);
+        public static Half Floor(Half x);
+        public static Half FusedMultiplyAdd(Half left, Half right, Half addend);
+        public static Half Hypot(Half x, Half y);
+        public static Half Ieee754Remainder(Half left, Half right);
+        public static int ILogB(Half x);
+        public static bool IsEvenInteger(Half value);
+        public static bool IsInteger(Half value);
+        public static bool IsOddInteger(Half value);
+        public static bool IsPositive(Half value);
+        public static bool IsPow2(Half value);
+        public static bool IsRealNumber(Half value);
+        public static Half Log(Half x);
+        public static Half Log(Half x, Half newBase);
+        public static Half Log10(Half x);
+        public static Half Log10P1(Half x);
+        public static Half Log2(Half value);
+        public static Half Log2P1(Half x);
+        public static Half LogP1(Half x);
+        public static Half Max(Half x, Half y);
+        public static Half MaxMagnitude(Half x, Half y);
+        public static Half MaxMagnitudeNumber(Half x, Half y);
+        public static Half MaxNumber(Half x, Half y);
+        public static Half Min(Half x, Half y);
+        public static Half MinMagnitude(Half x, Half y);
+        public static Half MinMagnitudeNumber(Half x, Half y);
+        public static Half MinNumber(Half x, Half y);
+        public static Half operator +(Half left, Half right);
+        public static explicit operator checked byte (Half value);
+        public static explicit operator checked char (Half value);
+        public static explicit operator checked short (Half value);
+        public static explicit operator checked int (Half value);
+        public static explicit operator checked long (Half value);
+        public static explicit operator checked Int128 (Half value);
+        public static explicit operator checked IntPtr (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked sbyte (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ushort (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked uint (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ulong (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UInt128 (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UIntPtr (Half value);
+        public static Half operator --(Half value);
+        public static Half operator /(Half left, Half right);
+        public static explicit operator Half (char value);
+        public static explicit operator Half (decimal value);
+        public static explicit operator byte (Half value);
+        public static explicit operator char (Half value);
+        public static explicit operator decimal (Half value);
+        public static explicit operator Int128 (Half value);
+        public static explicit operator short (Half value);
+        public static explicit operator int (Half value);
+        public static explicit operator long (Half value);
+        public static explicit operator IntPtr (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator sbyte (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UInt128 (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ushort (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator uint (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ulong (Half value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UIntPtr (Half value);
+        public static explicit operator Half (short value);
+        public static explicit operator Half (int value);
+        public static explicit operator Half (long value);
+        public static explicit operator Half (IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator Half (ushort value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator Half (uint value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator Half (ulong value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator Half (UIntPtr value);
+        public static implicit operator Half (byte value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator Half (sbyte value);
+        public static Half operator ++(Half value);
+        public static Half operator %(Half left, Half right);
+        public static Half operator *(Half left, Half right);
+        public static Half operator -(Half left, Half right);
+        public static Half operator -(Half value);
+        public static Half operator +(Half value);
+        public static Half Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static Half Pow(Half x, Half y);
+        public static Half ReciprocalEstimate(Half x);
+        public static Half ReciprocalSqrtEstimate(Half x);
+        public static Half RootN(Half x, int n);
+        public static Half Round(Half x);
+        public static Half Round(Half x, int digits);
+        public static Half Round(Half x, int digits, MidpointRounding mode);
+        public static Half Round(Half x, MidpointRounding mode);
+        public static Half ScaleB(Half x, int n);
+        public static int Sign(Half value);
+        public static Half Sin(Half x);
+        public static (Half Sin, Half Cos) SinCos(Half x);
+        public static (Half SinPi, Half CosPi) SinCosPi(Half x);
+        public static Half Sinh(Half x);
+        public static Half SinPi(Half x);
+        public static Half Sqrt(Half x);
+        static Half IBitwiseOperators<Half, Half, Half>.operator &(Half left, Half right);
+        static Half IBitwiseOperators<Half, Half, Half>.operator |(Half left, Half right);
+        static Half IBitwiseOperators<Half, Half, Half>.operator ^(Half left, Half right);
+        static Half IBitwiseOperators<Half, Half, Half>.operator ~(Half value);
+        int IFloatingPoint<Half>.GetExponentByteCount();
+        int IFloatingPoint<Half>.GetExponentShortestBitLength();
+        int IFloatingPoint<Half>.GetSignificandBitLength();
+        int IFloatingPoint<Half>.GetSignificandByteCount();
+        bool IFloatingPoint<Half>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<Half>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<Half>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<Half>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static bool INumberBase<Half>.IsCanonical(Half value);
+        static bool INumberBase<Half>.IsComplexNumber(Half value);
+        static bool INumberBase<Half>.IsImaginaryNumber(Half value);
+        static bool INumberBase<Half>.IsZero(Half value);
+        static bool INumberBase<Half>.TryConvertFromChecked<TOther>(TOther value, out Half result);
+        static bool INumberBase<Half>.TryConvertFromSaturating<TOther>(TOther value, out Half result);
+        static bool INumberBase<Half>.TryConvertFromTruncating<TOther>(TOther value, out Half result);
+        static bool INumberBase<Half>.TryConvertToChecked<TOther>(Half value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<Half>.TryConvertToSaturating<TOther>(Half value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<Half>.TryConvertToTruncating<TOther>(Half value, [MaybeNullWhenAttribute(false)] out TOther result);
+        public static Half Tan(Half x);
+        public static Half Tanh(Half x);
+        public static Half TanPi(Half x);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static Half Truncate(Half x);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Half result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out Half result);
     }
+    public readonly struct Int128 : IAdditionOperators<Int128, Int128, Int128>, IAdditiveIdentity<Int128, Int128>, IBinaryInteger<Int128>, IBinaryNumber<Int128>, IBitwiseOperators<Int128, Int128, Int128>, IComparable, IComparable<Int128>, IComparisonOperators<Int128, Int128, bool>, IDecrementOperators<Int128>, IDivisionOperators<Int128, Int128, Int128>, IEqualityOperators<Int128, Int128, bool>, IEquatable<Int128>, IFormattable, IIncrementOperators<Int128>, IMinMaxValue<Int128>, IModulusOperators<Int128, Int128, Int128>, IMultiplicativeIdentity<Int128, Int128>, IMultiplyOperators<Int128, Int128, Int128>, INumber<Int128>, INumberBase<Int128>, IParsable<Int128>, IShiftOperators<Int128, int, Int128>, ISignedNumber<Int128>, ISpanFormattable, ISpanParsable<Int128>, ISubtractionOperators<Int128, Int128, Int128>, IUnaryNegationOperators<Int128, Int128>, IUnaryPlusOperators<Int128, Int128> {
+        [CLSCompliantAttribute(false)]
+        public Int128(ulong upper, ulong lower);
+        public static Int128 MaxValue { get; }
+        public static Int128 MinValue { get; }
+        public static Int128 NegativeOne { get; }
+        public static Int128 One { get; }
+        static Int128 System.Numerics.IAdditiveIdentity<System.Int128,System.Int128>.AdditiveIdentity { get; }
+        static Int128 System.Numerics.IBinaryNumber<System.Int128>.AllBitsSet { get; }
+        static Int128 System.Numerics.IMultiplicativeIdentity<System.Int128,System.Int128>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.Int128>.Radix { get; }
+        public static Int128 Zero { get; }
+        public static Int128 Abs(Int128 value);
+        public static Int128 Clamp(Int128 value, Int128 min, Int128 max);
+        public int CompareTo(Int128 value);
+        public int CompareTo(object? value);
+        public static Int128 CopySign(Int128 value, Int128 sign);
+        public static Int128 CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static Int128 CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static Int128 CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (Int128 Quotient, Int128 Remainder) DivRem(Int128 left, Int128 right);
+        public bool Equals(Int128 other);
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
+        public override int GetHashCode();
+        public static bool IsEvenInteger(Int128 value);
+        public static bool IsNegative(Int128 value);
+        public static bool IsOddInteger(Int128 value);
+        public static bool IsPositive(Int128 value);
+        public static bool IsPow2(Int128 value);
+        public static Int128 LeadingZeroCount(Int128 value);
+        public static Int128 Log2(Int128 value);
+        public static Int128 Max(Int128 x, Int128 y);
+        public static Int128 MaxMagnitude(Int128 x, Int128 y);
+        public static Int128 Min(Int128 x, Int128 y);
+        public static Int128 MinMagnitude(Int128 x, Int128 y);
+        public static Int128 operator +(Int128 left, Int128 right);
+        public static Int128 operator &(Int128 left, Int128 right);
+        public static Int128 operator |(Int128 left, Int128 right);
+        public static Int128 operator checked +(Int128 left, Int128 right);
+        public static Int128 operator checked --(Int128 value);
+        public static Int128 operator checked /(Int128 left, Int128 right);
+        public static explicit operator checked Int128 (double value);
+        public static explicit operator checked byte (Int128 value);
+        public static explicit operator checked char (Int128 value);
+        public static explicit operator checked short (Int128 value);
+        public static explicit operator checked int (Int128 value);
+        public static explicit operator checked long (Int128 value);
+        public static explicit operator checked IntPtr (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked sbyte (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ushort (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked uint (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ulong (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UInt128 (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UIntPtr (Int128 value);
+        public static explicit operator checked Int128 (float value);
+        public static Int128 operator checked ++(Int128 value);
+        public static Int128 operator checked *(Int128 left, Int128 right);
+        public static Int128 operator checked -(Int128 left, Int128 right);
+        public static Int128 operator checked -(Int128 value);
+        public static Int128 operator --(Int128 value);
+        public static Int128 operator /(Int128 left, Int128 right);
+        public static bool operator ==(Int128 left, Int128 right);
+        public static Int128 operator ^(Int128 left, Int128 right);
+        public static explicit operator Int128 (decimal value);
+        public static explicit operator Int128 (double value);
+        public static explicit operator byte (Int128 value);
+        public static explicit operator char (Int128 value);
+        public static explicit operator decimal (Int128 value);
+        public static explicit operator double (Int128 value);
+        public static explicit operator Half (Int128 value);
+        public static explicit operator short (Int128 value);
+        public static explicit operator int (Int128 value);
+        public static explicit operator long (Int128 value);
+        public static explicit operator IntPtr (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator sbyte (Int128 value);
+        public static explicit operator float (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UInt128 (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ushort (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator uint (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ulong (Int128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UIntPtr (Int128 value);
+        public static explicit operator Int128 (float value);
+        public static bool operator >(Int128 left, Int128 right);
+        public static bool operator >=(Int128 left, Int128 right);
+        public static implicit operator Int128 (byte value);
+        public static implicit operator Int128 (char value);
+        public static implicit operator Int128 (short value);
+        public static implicit operator Int128 (int value);
+        public static implicit operator Int128 (long value);
+        public static implicit operator Int128 (IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator Int128 (sbyte value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator Int128 (ushort value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator Int128 (uint value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator Int128 (ulong value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator Int128 (UIntPtr value);
+        public static Int128 operator ++(Int128 value);
+        public static bool operator !=(Int128 left, Int128 right);
+        public static Int128 operator <<(Int128 value, int shiftAmount);
+        public static bool operator <(Int128 left, Int128 right);
+        public static bool operator <=(Int128 left, Int128 right);
+        public static Int128 operator %(Int128 left, Int128 right);
+        public static Int128 operator *(Int128 left, Int128 right);
+        public static Int128 operator ~(Int128 value);
+        public static Int128 operator >>(Int128 value, int shiftAmount);
+        public static Int128 operator -(Int128 left, Int128 right);
+        public static Int128 operator -(Int128 value);
+        public static Int128 operator +(Int128 value);
+        public static Int128 operator >>>(Int128 value, int shiftAmount);
+        public static Int128 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        public static Int128 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static Int128 Parse(string s);
+        public static Int128 Parse(string s, NumberStyles style);
+        public static Int128 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static Int128 Parse(string s, IFormatProvider? provider);
+        public static Int128 PopCount(Int128 value);
+        public static Int128 RotateLeft(Int128 value, int rotateAmount);
+        public static Int128 RotateRight(Int128 value, int rotateAmount);
+        public static int Sign(Int128 value);
+        int IBinaryInteger<Int128>.GetByteCount();
+        int IBinaryInteger<Int128>.GetShortestBitLength();
+        static bool IBinaryInteger<Int128>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out Int128 value);
+        static bool IBinaryInteger<Int128>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out Int128 value);
+        bool IBinaryInteger<Int128>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<Int128>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static Int128 INumber<Int128>.MaxNumber(Int128 x, Int128 y);
+        static Int128 INumber<Int128>.MinNumber(Int128 x, Int128 y);
+        static bool INumberBase<Int128>.IsCanonical(Int128 value);
+        static bool INumberBase<Int128>.IsComplexNumber(Int128 value);
+        static bool INumberBase<Int128>.IsFinite(Int128 value);
+        static bool INumberBase<Int128>.IsImaginaryNumber(Int128 value);
+        static bool INumberBase<Int128>.IsInfinity(Int128 value);
+        static bool INumberBase<Int128>.IsInteger(Int128 value);
+        static bool INumberBase<Int128>.IsNaN(Int128 value);
+        static bool INumberBase<Int128>.IsNegativeInfinity(Int128 value);
+        static bool INumberBase<Int128>.IsNormal(Int128 value);
+        static bool INumberBase<Int128>.IsPositiveInfinity(Int128 value);
+        static bool INumberBase<Int128>.IsRealNumber(Int128 value);
+        static bool INumberBase<Int128>.IsSubnormal(Int128 value);
+        static bool INumberBase<Int128>.IsZero(Int128 value);
+        static Int128 INumberBase<Int128>.MaxMagnitudeNumber(Int128 x, Int128 y);
+        static Int128 INumberBase<Int128>.MinMagnitudeNumber(Int128 x, Int128 y);
+        static bool INumberBase<Int128>.TryConvertFromChecked<TOther>(TOther value, out Int128 result);
+        static bool INumberBase<Int128>.TryConvertFromSaturating<TOther>(TOther value, out Int128 result);
+        static bool INumberBase<Int128>.TryConvertFromTruncating<TOther>(TOther value, out Int128 result);
+        static bool INumberBase<Int128>.TryConvertToChecked<TOther>(Int128 value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<Int128>.TryConvertToSaturating<TOther>(Int128 value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<Int128>.TryConvertToTruncating<TOther>(Int128 value, [MaybeNullWhenAttribute(false)] out TOther result);
+        public override string ToString();
+        public string ToString(IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static Int128 TrailingZeroCount(Int128 value);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Int128 result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, NumberStyles style, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, out Int128 result);
+    }
-    public readonly struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable, ISpanFormattable {
+    public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short, bool>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short, bool>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, INumberBase<short>, IParsable<short>, IShiftOperators<short, int, short>, ISignedNumber<short>, ISpanFormattable, ISpanParsable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
+        static short System.Numerics.IAdditiveIdentity<System.Int16,System.Int16>.AdditiveIdentity { get; }
+        static short System.Numerics.IBinaryNumber<System.Int16>.AllBitsSet { get; }
+        static short System.Numerics.IMinMaxValue<System.Int16>.MaxValue { get; }
+        static short System.Numerics.IMinMaxValue<System.Int16>.MinValue { get; }
+        static short System.Numerics.IMultiplicativeIdentity<System.Int16,System.Int16>.MultiplicativeIdentity { get; }
+        static short System.Numerics.INumberBase<System.Int16>.One { get; }
+        static int System.Numerics.INumberBase<System.Int16>.Radix { get; }
+        static short System.Numerics.INumberBase<System.Int16>.Zero { get; }
+        static short System.Numerics.ISignedNumber<System.Int16>.NegativeOne { get; }
+        public static short Abs(short value);
+        public static short Clamp(short value, short min, short max);
+        public static short CopySign(short value, short sign);
+        public static short CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static short CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static short CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (short Quotient, short Remainder) DivRem(short left, short right);
+        public static bool IsEvenInteger(short value);
+        public static bool IsNegative(short value);
+        public static bool IsOddInteger(short value);
+        public static bool IsPositive(short value);
+        public static bool IsPow2(short value);
+        public static short LeadingZeroCount(short value);
+        public static short Log2(short value);
+        public static short Max(short x, short y);
+        public static short MaxMagnitude(short x, short y);
+        public static short Min(short x, short y);
+        public static short MinMagnitude(short x, short y);
+        public static short Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static short PopCount(short value);
+        public static short RotateLeft(short value, int rotateAmount);
+        public static short RotateRight(short value, int rotateAmount);
+        public static int Sign(short value);
+        static short IAdditionOperators<short, short, short>.operator +(short left, short right);
+        static short IAdditionOperators<short, short, short>.operator checked +(short left, short right);
+        int IBinaryInteger<short>.GetByteCount();
+        int IBinaryInteger<short>.GetShortestBitLength();
+        static bool IBinaryInteger<short>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out short value);
+        static bool IBinaryInteger<short>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out short value);
+        bool IBinaryInteger<short>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<short>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static short IBitwiseOperators<short, short, short>.operator &(short left, short right);
+        static short IBitwiseOperators<short, short, short>.operator |(short left, short right);
+        static short IBitwiseOperators<short, short, short>.operator ^(short left, short right);
+        static short IBitwiseOperators<short, short, short>.operator ~(short value);
+        static bool IComparisonOperators<short, short, bool>.operator >(short left, short right);
+        static bool IComparisonOperators<short, short, bool>.operator >=(short left, short right);
+        static bool IComparisonOperators<short, short, bool>.operator <(short left, short right);
+        static bool IComparisonOperators<short, short, bool>.operator <=(short left, short right);
+        static short IDecrementOperators<short>.operator checked --(short value);
+        static short IDecrementOperators<short>.operator --(short value);
+        static short IDivisionOperators<short, short, short>.operator /(short left, short right);
+        static bool IEqualityOperators<short, short, bool>.operator ==(short left, short right);
+        static bool IEqualityOperators<short, short, bool>.operator !=(short left, short right);
+        static short IIncrementOperators<short>.operator checked ++(short value);
+        static short IIncrementOperators<short>.operator ++(short value);
+        static short IModulusOperators<short, short, short>.operator %(short left, short right);
+        static short IMultiplyOperators<short, short, short>.operator checked *(short left, short right);
+        static short IMultiplyOperators<short, short, short>.operator *(short left, short right);
+        static short INumber<short>.MaxNumber(short x, short y);
+        static short INumber<short>.MinNumber(short x, short y);
+        static bool INumberBase<short>.IsCanonical(short value);
+        static bool INumberBase<short>.IsComplexNumber(short value);
+        static bool INumberBase<short>.IsFinite(short value);
+        static bool INumberBase<short>.IsImaginaryNumber(short value);
+        static bool INumberBase<short>.IsInfinity(short value);
+        static bool INumberBase<short>.IsInteger(short value);
+        static bool INumberBase<short>.IsNaN(short value);
+        static bool INumberBase<short>.IsNegativeInfinity(short value);
+        static bool INumberBase<short>.IsNormal(short value);
+        static bool INumberBase<short>.IsPositiveInfinity(short value);
+        static bool INumberBase<short>.IsRealNumber(short value);
+        static bool INumberBase<short>.IsSubnormal(short value);
+        static bool INumberBase<short>.IsZero(short value);
+        static short INumberBase<short>.MaxMagnitudeNumber(short x, short y);
+        static short INumberBase<short>.MinMagnitudeNumber(short x, short y);
+        static bool INumberBase<short>.TryConvertFromChecked<TOther>(TOther value, out short result);
+        static bool INumberBase<short>.TryConvertFromSaturating<TOther>(TOther value, out short result);
+        static bool INumberBase<short>.TryConvertFromTruncating<TOther>(TOther value, out short result);
+        static bool INumberBase<short>.TryConvertToChecked<TOther>(short value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<short>.TryConvertToSaturating<TOther>(short value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<short>.TryConvertToTruncating<TOther>(short value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static short IShiftOperators<short, int, short>.operator <<(short value, int shiftAmount);
+        static short IShiftOperators<short, int, short>.operator >>(short value, int shiftAmount);
+        static short IShiftOperators<short, int, short>.operator >>>(short value, int shiftAmount);
+        static short ISubtractionOperators<short, short, short>.operator checked -(short left, short right);
+        static short ISubtractionOperators<short, short, short>.operator -(short left, short right);
+        static short IUnaryNegationOperators<short, short>.operator checked -(short value);
+        static short IUnaryNegationOperators<short, short>.operator -(short value);
+        static short IUnaryPlusOperators<short, short>.operator +(short value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static short TrailingZeroCount(short value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out short result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out short result);
     }
-    public readonly struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable, ISpanFormattable {
+    public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int, bool>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int, bool>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, INumberBase<int>, IParsable<int>, IShiftOperators<int, int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParsable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
+        static int System.Numerics.IAdditiveIdentity<System.Int32,System.Int32>.AdditiveIdentity { get; }
+        static int System.Numerics.IBinaryNumber<System.Int32>.AllBitsSet { get; }
+        static int System.Numerics.IMinMaxValue<System.Int32>.MaxValue { get; }
+        static int System.Numerics.IMinMaxValue<System.Int32>.MinValue { get; }
+        static int System.Numerics.IMultiplicativeIdentity<System.Int32,System.Int32>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.Int32>.One { get; }
+        static int System.Numerics.INumberBase<System.Int32>.Radix { get; }
+        static int System.Numerics.INumberBase<System.Int32>.Zero { get; }
+        static int System.Numerics.ISignedNumber<System.Int32>.NegativeOne { get; }
+        public static int Abs(int value);
+        public static int Clamp(int value, int min, int max);
+        public static int CopySign(int value, int sign);
+        public static int CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static int CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static int CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (int Quotient, int Remainder) DivRem(int left, int right);
+        public static bool IsEvenInteger(int value);
+        public static bool IsNegative(int value);
+        public static bool IsOddInteger(int value);
+        public static bool IsPositive(int value);
+        public static bool IsPow2(int value);
+        public static int LeadingZeroCount(int value);
+        public static int Log2(int value);
+        public static int Max(int x, int y);
+        public static int MaxMagnitude(int x, int y);
+        public static int Min(int x, int y);
+        public static int MinMagnitude(int x, int y);
+        public static int Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static int PopCount(int value);
+        public static int RotateLeft(int value, int rotateAmount);
+        public static int RotateRight(int value, int rotateAmount);
+        public static int Sign(int value);
+        static int IAdditionOperators<int, int, int>.operator +(int left, int right);
+        static int IAdditionOperators<int, int, int>.operator checked +(int left, int right);
+        int IBinaryInteger<int>.GetByteCount();
+        int IBinaryInteger<int>.GetShortestBitLength();
+        static bool IBinaryInteger<int>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out int value);
+        static bool IBinaryInteger<int>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out int value);
+        bool IBinaryInteger<int>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<int>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static int IBitwiseOperators<int, int, int>.operator &(int left, int right);
+        static int IBitwiseOperators<int, int, int>.operator |(int left, int right);
+        static int IBitwiseOperators<int, int, int>.operator ^(int left, int right);
+        static int IBitwiseOperators<int, int, int>.operator ~(int value);
+        static bool IComparisonOperators<int, int, bool>.operator >(int left, int right);
+        static bool IComparisonOperators<int, int, bool>.operator >=(int left, int right);
+        static bool IComparisonOperators<int, int, bool>.operator <(int left, int right);
+        static bool IComparisonOperators<int, int, bool>.operator <=(int left, int right);
+        static int IDecrementOperators<int>.operator checked --(int value);
+        static int IDecrementOperators<int>.operator --(int value);
+        static int IDivisionOperators<int, int, int>.operator /(int left, int right);
+        static bool IEqualityOperators<int, int, bool>.operator ==(int left, int right);
+        static bool IEqualityOperators<int, int, bool>.operator !=(int left, int right);
+        static int IIncrementOperators<int>.operator checked ++(int value);
+        static int IIncrementOperators<int>.operator ++(int value);
+        static int IModulusOperators<int, int, int>.operator %(int left, int right);
+        static int IMultiplyOperators<int, int, int>.operator checked *(int left, int right);
+        static int IMultiplyOperators<int, int, int>.operator *(int left, int right);
+        static int INumber<int>.MaxNumber(int x, int y);
+        static int INumber<int>.MinNumber(int x, int y);
+        static bool INumberBase<int>.IsCanonical(int value);
+        static bool INumberBase<int>.IsComplexNumber(int value);
+        static bool INumberBase<int>.IsFinite(int value);
+        static bool INumberBase<int>.IsImaginaryNumber(int value);
+        static bool INumberBase<int>.IsInfinity(int value);
+        static bool INumberBase<int>.IsInteger(int value);
+        static bool INumberBase<int>.IsNaN(int value);
+        static bool INumberBase<int>.IsNegativeInfinity(int value);
+        static bool INumberBase<int>.IsNormal(int value);
+        static bool INumberBase<int>.IsPositiveInfinity(int value);
+        static bool INumberBase<int>.IsRealNumber(int value);
+        static bool INumberBase<int>.IsSubnormal(int value);
+        static bool INumberBase<int>.IsZero(int value);
+        static int INumberBase<int>.MaxMagnitudeNumber(int x, int y);
+        static int INumberBase<int>.MinMagnitudeNumber(int x, int y);
+        static bool INumberBase<int>.TryConvertFromChecked<TOther>(TOther value, out int result);
+        static bool INumberBase<int>.TryConvertFromSaturating<TOther>(TOther value, out int result);
+        static bool INumberBase<int>.TryConvertFromTruncating<TOther>(TOther value, out int result);
+        static bool INumberBase<int>.TryConvertToChecked<TOther>(int value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<int>.TryConvertToSaturating<TOther>(int value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<int>.TryConvertToTruncating<TOther>(int value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static int IShiftOperators<int, int, int>.operator <<(int value, int shiftAmount);
+        static int IShiftOperators<int, int, int>.operator >>(int value, int shiftAmount);
+        static int IShiftOperators<int, int, int>.operator >>>(int value, int shiftAmount);
+        static int ISubtractionOperators<int, int, int>.operator checked -(int left, int right);
+        static int ISubtractionOperators<int, int, int>.operator -(int left, int right);
+        static int IUnaryNegationOperators<int, int>.operator checked -(int value);
+        static int IUnaryNegationOperators<int, int>.operator -(int value);
+        static int IUnaryPlusOperators<int, int>.operator +(int value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static int TrailingZeroCount(int value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out int result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out int result);
     }
-    public readonly struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable, ISpanFormattable {
+    public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long, bool>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long, bool>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, INumberBase<long>, IParsable<long>, IShiftOperators<long, int, long>, ISignedNumber<long>, ISpanFormattable, ISpanParsable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
+        static long System.Numerics.IAdditiveIdentity<System.Int64,System.Int64>.AdditiveIdentity { get; }
+        static long System.Numerics.IBinaryNumber<System.Int64>.AllBitsSet { get; }
+        static long System.Numerics.IMinMaxValue<System.Int64>.MaxValue { get; }
+        static long System.Numerics.IMinMaxValue<System.Int64>.MinValue { get; }
+        static long System.Numerics.IMultiplicativeIdentity<System.Int64,System.Int64>.MultiplicativeIdentity { get; }
+        static long System.Numerics.INumberBase<System.Int64>.One { get; }
+        static int System.Numerics.INumberBase<System.Int64>.Radix { get; }
+        static long System.Numerics.INumberBase<System.Int64>.Zero { get; }
+        static long System.Numerics.ISignedNumber<System.Int64>.NegativeOne { get; }
+        public static long Abs(long value);
+        public static long Clamp(long value, long min, long max);
+        public static long CopySign(long value, long sign);
+        public static long CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static long CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static long CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (long Quotient, long Remainder) DivRem(long left, long right);
+        public static bool IsEvenInteger(long value);
+        public static bool IsNegative(long value);
+        public static bool IsOddInteger(long value);
+        public static bool IsPositive(long value);
+        public static bool IsPow2(long value);
+        public static long LeadingZeroCount(long value);
+        public static long Log2(long value);
+        public static long Max(long x, long y);
+        public static long MaxMagnitude(long x, long y);
+        public static long Min(long x, long y);
+        public static long MinMagnitude(long x, long y);
+        public static long Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static long PopCount(long value);
+        public static long RotateLeft(long value, int rotateAmount);
+        public static long RotateRight(long value, int rotateAmount);
+        public static int Sign(long value);
+        static long IAdditionOperators<long, long, long>.operator +(long left, long right);
+        static long IAdditionOperators<long, long, long>.operator checked +(long left, long right);
+        int IBinaryInteger<long>.GetByteCount();
+        int IBinaryInteger<long>.GetShortestBitLength();
+        static bool IBinaryInteger<long>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out long value);
+        static bool IBinaryInteger<long>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out long value);
+        bool IBinaryInteger<long>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<long>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static long IBitwiseOperators<long, long, long>.operator &(long left, long right);
+        static long IBitwiseOperators<long, long, long>.operator |(long left, long right);
+        static long IBitwiseOperators<long, long, long>.operator ^(long left, long right);
+        static long IBitwiseOperators<long, long, long>.operator ~(long value);
+        static bool IComparisonOperators<long, long, bool>.operator >(long left, long right);
+        static bool IComparisonOperators<long, long, bool>.operator >=(long left, long right);
+        static bool IComparisonOperators<long, long, bool>.operator <(long left, long right);
+        static bool IComparisonOperators<long, long, bool>.operator <=(long left, long right);
+        static long IDecrementOperators<long>.operator checked --(long value);
+        static long IDecrementOperators<long>.operator --(long value);
+        static long IDivisionOperators<long, long, long>.operator /(long left, long right);
+        static bool IEqualityOperators<long, long, bool>.operator ==(long left, long right);
+        static bool IEqualityOperators<long, long, bool>.operator !=(long left, long right);
+        static long IIncrementOperators<long>.operator checked ++(long value);
+        static long IIncrementOperators<long>.operator ++(long value);
+        static long IModulusOperators<long, long, long>.operator %(long left, long right);
+        static long IMultiplyOperators<long, long, long>.operator checked *(long left, long right);
+        static long IMultiplyOperators<long, long, long>.operator *(long left, long right);
+        static long INumber<long>.MaxNumber(long x, long y);
+        static long INumber<long>.MinNumber(long x, long y);
+        static bool INumberBase<long>.IsCanonical(long value);
+        static bool INumberBase<long>.IsComplexNumber(long value);
+        static bool INumberBase<long>.IsFinite(long value);
+        static bool INumberBase<long>.IsImaginaryNumber(long value);
+        static bool INumberBase<long>.IsInfinity(long value);
+        static bool INumberBase<long>.IsInteger(long value);
+        static bool INumberBase<long>.IsNaN(long value);
+        static bool INumberBase<long>.IsNegativeInfinity(long value);
+        static bool INumberBase<long>.IsNormal(long value);
+        static bool INumberBase<long>.IsPositiveInfinity(long value);
+        static bool INumberBase<long>.IsRealNumber(long value);
+        static bool INumberBase<long>.IsSubnormal(long value);
+        static bool INumberBase<long>.IsZero(long value);
+        static long INumberBase<long>.MaxMagnitudeNumber(long x, long y);
+        static long INumberBase<long>.MinMagnitudeNumber(long x, long y);
+        static bool INumberBase<long>.TryConvertFromChecked<TOther>(TOther value, out long result);
+        static bool INumberBase<long>.TryConvertFromSaturating<TOther>(TOther value, out long result);
+        static bool INumberBase<long>.TryConvertFromTruncating<TOther>(TOther value, out long result);
+        static bool INumberBase<long>.TryConvertToChecked<TOther>(long value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<long>.TryConvertToSaturating<TOther>(long value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<long>.TryConvertToTruncating<TOther>(long value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static long IShiftOperators<long, int, long>.operator <<(long value, int shiftAmount);
+        static long IShiftOperators<long, int, long>.operator >>(long value, int shiftAmount);
+        static long IShiftOperators<long, int, long>.operator >>>(long value, int shiftAmount);
+        static long ISubtractionOperators<long, long, long>.operator checked -(long left, long right);
+        static long ISubtractionOperators<long, long, long>.operator -(long left, long right);
+        static long IUnaryNegationOperators<long, long>.operator checked -(long value);
+        static long IUnaryNegationOperators<long, long>.operator -(long value);
+        static long IUnaryPlusOperators<long, long>.operator +(long value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static long TrailingZeroCount(long value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out long result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out long result);
     }
-    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct IntPtr : IAdditionOperators<IntPtr, IntPtr, IntPtr>, IAdditiveIdentity<IntPtr, IntPtr>, IBinaryInteger<IntPtr>, IBinaryNumber<IntPtr>, IBitwiseOperators<IntPtr, IntPtr, IntPtr>, IComparable, IComparable<IntPtr>, IComparisonOperators<IntPtr, IntPtr, bool>, IDecrementOperators<IntPtr>, IDivisionOperators<IntPtr, IntPtr, IntPtr>, IEqualityOperators<IntPtr, IntPtr, bool>, IEquatable<IntPtr>, IFormattable, IIncrementOperators<IntPtr>, IMinMaxValue<IntPtr>, IModulusOperators<IntPtr, IntPtr, IntPtr>, IMultiplicativeIdentity<IntPtr, IntPtr>, IMultiplyOperators<IntPtr, IntPtr, IntPtr>, INumber<IntPtr>, INumberBase<IntPtr>, IParsable<IntPtr>, ISerializable, IShiftOperators<IntPtr, int, IntPtr>, ISignedNumber<IntPtr>, ISpanFormattable, ISpanParsable<IntPtr>, ISubtractionOperators<IntPtr, IntPtr, IntPtr>, IUnaryNegationOperators<IntPtr, IntPtr>, IUnaryPlusOperators<IntPtr, IntPtr> {
+        static IntPtr System.Numerics.IAdditiveIdentity<nint,nint>.AdditiveIdentity { get; }
+        static IntPtr System.Numerics.IBinaryNumber<nint>.AllBitsSet { get; }
+        static IntPtr System.Numerics.IMinMaxValue<nint>.MaxValue { get; }
+        static IntPtr System.Numerics.IMinMaxValue<nint>.MinValue { get; }
+        static IntPtr System.Numerics.IMultiplicativeIdentity<nint,nint>.MultiplicativeIdentity { get; }
+        static IntPtr System.Numerics.INumberBase<nint>.One { get; }
+        static int System.Numerics.INumberBase<nint>.Radix { get; }
+        static IntPtr System.Numerics.INumberBase<nint>.Zero { get; }
+        static IntPtr System.Numerics.ISignedNumber<nint>.NegativeOne { get; }
+        public static IntPtr Abs(IntPtr value);
+        public static IntPtr Clamp(IntPtr value, IntPtr min, IntPtr max);
+        public static IntPtr CopySign(IntPtr value, IntPtr sign);
+        public static IntPtr CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static IntPtr CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static IntPtr CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (IntPtr Quotient, IntPtr Remainder) DivRem(IntPtr left, IntPtr right);
+        public static bool IsEvenInteger(IntPtr value);
+        public static bool IsNegative(IntPtr value);
+        public static bool IsOddInteger(IntPtr value);
+        public static bool IsPositive(IntPtr value);
+        public static bool IsPow2(IntPtr value);
+        public static IntPtr LeadingZeroCount(IntPtr value);
+        public static IntPtr Log2(IntPtr value);
+        public static IntPtr Max(IntPtr x, IntPtr y);
+        public static IntPtr MaxMagnitude(IntPtr x, IntPtr y);
+        public static IntPtr Min(IntPtr x, IntPtr y);
+        public static IntPtr MinMagnitude(IntPtr x, IntPtr y);
+        public static IntPtr Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static IntPtr PopCount(IntPtr value);
+        public static IntPtr RotateLeft(IntPtr value, int rotateAmount);
+        public static IntPtr RotateRight(IntPtr value, int rotateAmount);
+        public static int Sign(IntPtr value);
+        static IntPtr IAdditionOperators<IntPtr, IntPtr, IntPtr>.operator +(IntPtr left, IntPtr right);
+        static IntPtr IAdditionOperators<IntPtr, IntPtr, IntPtr>.operator checked +(IntPtr left, IntPtr right);
+        int IBinaryInteger<IntPtr>.GetByteCount();
+        int IBinaryInteger<IntPtr>.GetShortestBitLength();
+        static bool IBinaryInteger<IntPtr>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out IntPtr value);
+        static bool IBinaryInteger<IntPtr>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out IntPtr value);
+        bool IBinaryInteger<IntPtr>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<IntPtr>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator &(IntPtr left, IntPtr right);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator |(IntPtr left, IntPtr right);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator ^(IntPtr left, IntPtr right);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator ~(IntPtr value);
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator >(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator >=(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator <(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator <=(IntPtr left, IntPtr right);
+        static IntPtr IDecrementOperators<IntPtr>.operator checked --(IntPtr value);
+        static IntPtr IDecrementOperators<IntPtr>.operator --(IntPtr value);
+        static IntPtr IDivisionOperators<IntPtr, IntPtr, IntPtr>.operator /(IntPtr left, IntPtr right);
+        static IntPtr IIncrementOperators<IntPtr>.operator checked ++(IntPtr value);
+        static IntPtr IIncrementOperators<IntPtr>.operator ++(IntPtr value);
+        static IntPtr IModulusOperators<IntPtr, IntPtr, IntPtr>.operator %(IntPtr left, IntPtr right);
+        static IntPtr IMultiplyOperators<IntPtr, IntPtr, IntPtr>.operator checked *(IntPtr left, IntPtr right);
+        static IntPtr IMultiplyOperators<IntPtr, IntPtr, IntPtr>.operator *(IntPtr left, IntPtr right);
+        static IntPtr INumber<IntPtr>.MaxNumber(IntPtr x, IntPtr y);
+        static IntPtr INumber<IntPtr>.MinNumber(IntPtr x, IntPtr y);
+        static bool INumberBase<IntPtr>.IsCanonical(IntPtr value);
+        static bool INumberBase<IntPtr>.IsComplexNumber(IntPtr value);
+        static bool INumberBase<IntPtr>.IsFinite(IntPtr value);
+        static bool INumberBase<IntPtr>.IsImaginaryNumber(IntPtr value);
+        static bool INumberBase<IntPtr>.IsInfinity(IntPtr value);
+        static bool INumberBase<IntPtr>.IsInteger(IntPtr value);
+        static bool INumberBase<IntPtr>.IsNaN(IntPtr value);
+        static bool INumberBase<IntPtr>.IsNegativeInfinity(IntPtr value);
+        static bool INumberBase<IntPtr>.IsNormal(IntPtr value);
+        static bool INumberBase<IntPtr>.IsPositiveInfinity(IntPtr value);
+        static bool INumberBase<IntPtr>.IsRealNumber(IntPtr value);
+        static bool INumberBase<IntPtr>.IsSubnormal(IntPtr value);
+        static bool INumberBase<IntPtr>.IsZero(IntPtr value);
+        static IntPtr INumberBase<IntPtr>.MaxMagnitudeNumber(IntPtr x, IntPtr y);
+        static IntPtr INumberBase<IntPtr>.MinMagnitudeNumber(IntPtr x, IntPtr y);
+        static bool INumberBase<IntPtr>.TryConvertFromChecked<TOther>(TOther value, out IntPtr result);
+        static bool INumberBase<IntPtr>.TryConvertFromSaturating<TOther>(TOther value, out IntPtr result);
+        static bool INumberBase<IntPtr>.TryConvertFromTruncating<TOther>(TOther value, out IntPtr result);
+        static bool INumberBase<IntPtr>.TryConvertToChecked<TOther>(IntPtr value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<IntPtr>.TryConvertToSaturating<TOther>(IntPtr value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<IntPtr>.TryConvertToTruncating<TOther>(IntPtr value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static IntPtr IShiftOperators<IntPtr, int, IntPtr>.operator <<(IntPtr value, int shiftAmount);
+        static IntPtr IShiftOperators<IntPtr, int, IntPtr>.operator >>(IntPtr value, int shiftAmount);
+        static IntPtr IShiftOperators<IntPtr, int, IntPtr>.operator >>>(IntPtr value, int shiftAmount);
+        static IntPtr ISubtractionOperators<IntPtr, IntPtr, IntPtr>.operator checked -(IntPtr left, IntPtr right);
+        static IntPtr ISubtractionOperators<IntPtr, IntPtr, IntPtr>.operator -(IntPtr left, IntPtr right);
+        static IntPtr IUnaryNegationOperators<IntPtr, IntPtr>.operator checked -(IntPtr value);
+        static IntPtr IUnaryNegationOperators<IntPtr, IntPtr>.operator -(IntPtr value);
+        static IntPtr IUnaryPlusOperators<IntPtr, IntPtr>.operator +(IntPtr value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static IntPtr TrailingZeroCount(IntPtr value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out IntPtr result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out IntPtr result);
     }
+    public interface IParsable<TSelf> where TSelf : IParsable<TSelf>? {
+        static abstract TSelf Parse(string s, IFormatProvider? provider);
+        static abstract bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, [MaybeNullWhenAttribute(false)] out TSelf result);
+    }
+    public interface ISpanParsable<TSelf> : IParsable<TSelf> where TSelf : ISpanParsable<TSelf>? {
+        static abstract TSelf Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        static abstract bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, [MaybeNullWhenAttribute(false)] out TSelf result);
+    }
     public static class MemoryExtensions {
+        public static int CommonPrefixLength<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other);
+        public static int CommonPrefixLength<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other, IEqualityComparer<T>? comparer);
+        public static int CommonPrefixLength<T>(this Span<T> span, ReadOnlySpan<T> other);
+        public static int CommonPrefixLength<T>(this Span<T> span, ReadOnlySpan<T> other, IEqualityComparer<T>? comparer);
-        public static bool Contains<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static bool Contains<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>?;
-        public static bool Contains<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static bool Contains<T>(this Span<T> span, T value) where T : IEquatable<T>?;
-        public static bool EndsWith<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static bool EndsWith<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
-        public static bool EndsWith<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static bool EndsWith<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
-        public static int IndexOf<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int IndexOf<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
-        public static int IndexOf<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static int IndexOf<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>?;
-        public static int IndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int IndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
-        public static int IndexOf<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static int IndexOf<T>(this Span<T> span, T value) where T : IEquatable<T>?;
-        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
-        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>?;
-        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
-        public static int IndexOfAny<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
-        public static int IndexOfAny<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>?;
-        public static int IndexOfAny<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int IndexOfAny<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, T value) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
-        public static int LastIndexOf<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int LastIndexOf<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
-        public static int LastIndexOf<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static int LastIndexOf<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>?;
-        public static int LastIndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static int LastIndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T?>;
-        public static int LastIndexOf<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static int LastIndexOf<T>(this Span<T> span, T value) where T : IEquatable<T>?;
-        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
-        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>?;
-        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
-        public static int LastIndexOfAny<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
-        public static int LastIndexOfAny<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>?;
-        public static int LastIndexOfAny<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int LastIndexOfAny<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, T value) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>?;
-        public static int SequenceCompareTo<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IComparable<T>;
+        public static int SequenceCompareTo<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IComparable<T>?;
-        public static int SequenceCompareTo<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IComparable<T>;
+        public static int SequenceCompareTo<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IComparable<T>?;
-        public static bool SequenceEqual<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>;
+        public static bool SequenceEqual<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>?;
-        public static bool SequenceEqual<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>;
+        public static bool SequenceEqual<T>(this Span<T> span, ReadOnlySpan<T> other) where T : IEquatable<T>?;
-        public static bool StartsWith<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static bool StartsWith<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
-        public static bool StartsWith<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>;
+        public static bool StartsWith<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
-        public static Memory<T> Trim<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> Trim<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static Memory<T> Trim<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Memory<T> Trim<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>?;
-        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>?;
-        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>?;
-        public static Span<T> Trim<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static Span<T> Trim<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> span, T trimElement) where T : IEquatable<T>?;
-        public static Memory<T> TrimEnd<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static Memory<T> TrimEnd<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>?;
-        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>?;
-        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>?;
-        public static Span<T> TrimEnd<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static Span<T> TrimEnd<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> span, T trimElement) where T : IEquatable<T>?;
-        public static Memory<T> TrimStart<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static Memory<T> TrimStart<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>?;
-        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>?;
-        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>?;
-        public static Span<T> TrimStart<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>?;
-        public static Span<T> TrimStart<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> span, T trimElement) where T : IEquatable<T>?;
     }
-    public struct ModuleHandle
+    public struct ModuleHandle : IEquatable<ModuleHandle>
     public static class Nullable {
+        public static ref readonly T GetValueRefOrDefaultRef<T>(in T? nullable) where T : struct;
     }
     public class ObjectDisposedException : InvalidOperationException {
+        public static void ThrowIf([DoesNotReturnIfAttribute(true)] bool condition, object instance);
+        public static void ThrowIf([DoesNotReturnIfAttribute(true)] bool condition, Type type);
     }
-    public readonly ref struct ReadOnlySpan<T> {
+    [NativeMarshallingAttribute(typeof(ReadOnlySpanMarshaller<,>))]
+    public readonly ref struct ReadOnlySpan<T> {
+        public ReadOnlySpan(in T reference);
     }
-    public struct RuntimeFieldHandle : ISerializable {
+    public struct RuntimeFieldHandle : IEquatable<RuntimeFieldHandle>, ISerializable {
+        public static RuntimeFieldHandle FromIntPtr(IntPtr value);
+        public static IntPtr ToIntPtr(RuntimeFieldHandle value);
     }
-    public struct RuntimeMethodHandle : ISerializable {
+    public struct RuntimeMethodHandle : IEquatable<RuntimeMethodHandle>, ISerializable {
+        public static RuntimeMethodHandle FromIntPtr(IntPtr value);
+        public static IntPtr ToIntPtr(RuntimeMethodHandle value);
     }
-    public struct RuntimeTypeHandle : ISerializable {
+    public struct RuntimeTypeHandle : IEquatable<RuntimeTypeHandle>, ISerializable {
+        public static RuntimeTypeHandle FromIntPtr(IntPtr value);
+        public static IntPtr ToIntPtr(RuntimeTypeHandle value);
     }
-    [CLSCompliantAttribute(false)]
-    public readonly struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable, ISpanFormattable {
+    [CLSCompliantAttribute(false)]
+    public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte, bool>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte, bool>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, INumberBase<sbyte>, IParsable<sbyte>, IShiftOperators<sbyte, int, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParsable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
+        static sbyte System.Numerics.IAdditiveIdentity<System.SByte,System.SByte>.AdditiveIdentity { get; }
+        static sbyte System.Numerics.IBinaryNumber<System.SByte>.AllBitsSet { get; }
+        static sbyte System.Numerics.IMinMaxValue<System.SByte>.MaxValue { get; }
+        static sbyte System.Numerics.IMinMaxValue<System.SByte>.MinValue { get; }
+        static sbyte System.Numerics.IMultiplicativeIdentity<System.SByte,System.SByte>.MultiplicativeIdentity { get; }
+        static sbyte System.Numerics.INumberBase<System.SByte>.One { get; }
+        static int System.Numerics.INumberBase<System.SByte>.Radix { get; }
+        static sbyte System.Numerics.INumberBase<System.SByte>.Zero { get; }
+        static sbyte System.Numerics.ISignedNumber<System.SByte>.NegativeOne { get; }
+        public static sbyte Abs(sbyte value);
+        public static sbyte Clamp(sbyte value, sbyte min, sbyte max);
+        public static sbyte CopySign(sbyte value, sbyte sign);
+        public static sbyte CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static sbyte CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static sbyte CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (sbyte Quotient, sbyte Remainder) DivRem(sbyte left, sbyte right);
+        public static bool IsEvenInteger(sbyte value);
+        public static bool IsNegative(sbyte value);
+        public static bool IsOddInteger(sbyte value);
+        public static bool IsPositive(sbyte value);
+        public static bool IsPow2(sbyte value);
+        public static sbyte LeadingZeroCount(sbyte value);
+        public static sbyte Log2(sbyte value);
+        public static sbyte Max(sbyte x, sbyte y);
+        public static sbyte MaxMagnitude(sbyte x, sbyte y);
+        public static sbyte Min(sbyte x, sbyte y);
+        public static sbyte MinMagnitude(sbyte x, sbyte y);
+        public static sbyte Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static sbyte PopCount(sbyte value);
+        public static sbyte RotateLeft(sbyte value, int rotateAmount);
+        public static sbyte RotateRight(sbyte value, int rotateAmount);
+        public static int Sign(sbyte value);
+        static sbyte IAdditionOperators<sbyte, sbyte, sbyte>.operator +(sbyte left, sbyte right);
+        static sbyte IAdditionOperators<sbyte, sbyte, sbyte>.operator checked +(sbyte left, sbyte right);
+        int IBinaryInteger<sbyte>.GetByteCount();
+        int IBinaryInteger<sbyte>.GetShortestBitLength();
+        static bool IBinaryInteger<sbyte>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out sbyte value);
+        static bool IBinaryInteger<sbyte>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out sbyte value);
+        bool IBinaryInteger<sbyte>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<sbyte>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator &(sbyte left, sbyte right);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator |(sbyte left, sbyte right);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator ^(sbyte left, sbyte right);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator ~(sbyte value);
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator >(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator >=(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator <(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator <=(sbyte left, sbyte right);
+        static sbyte IDecrementOperators<sbyte>.operator checked --(sbyte value);
+        static sbyte IDecrementOperators<sbyte>.operator --(sbyte value);
+        static sbyte IDivisionOperators<sbyte, sbyte, sbyte>.operator /(sbyte left, sbyte right);
+        static bool IEqualityOperators<sbyte, sbyte, bool>.operator ==(sbyte left, sbyte right);
+        static bool IEqualityOperators<sbyte, sbyte, bool>.operator !=(sbyte left, sbyte right);
+        static sbyte IIncrementOperators<sbyte>.operator checked ++(sbyte value);
+        static sbyte IIncrementOperators<sbyte>.operator ++(sbyte value);
+        static sbyte IModulusOperators<sbyte, sbyte, sbyte>.operator %(sbyte left, sbyte right);
+        static sbyte IMultiplyOperators<sbyte, sbyte, sbyte>.operator checked *(sbyte left, sbyte right);
+        static sbyte IMultiplyOperators<sbyte, sbyte, sbyte>.operator *(sbyte left, sbyte right);
+        static sbyte INumber<sbyte>.MaxNumber(sbyte x, sbyte y);
+        static sbyte INumber<sbyte>.MinNumber(sbyte x, sbyte y);
+        static bool INumberBase<sbyte>.IsCanonical(sbyte value);
+        static bool INumberBase<sbyte>.IsComplexNumber(sbyte value);
+        static bool INumberBase<sbyte>.IsFinite(sbyte value);
+        static bool INumberBase<sbyte>.IsImaginaryNumber(sbyte value);
+        static bool INumberBase<sbyte>.IsInfinity(sbyte value);
+        static bool INumberBase<sbyte>.IsInteger(sbyte value);
+        static bool INumberBase<sbyte>.IsNaN(sbyte value);
+        static bool INumberBase<sbyte>.IsNegativeInfinity(sbyte value);
+        static bool INumberBase<sbyte>.IsNormal(sbyte value);
+        static bool INumberBase<sbyte>.IsPositiveInfinity(sbyte value);
+        static bool INumberBase<sbyte>.IsRealNumber(sbyte value);
+        static bool INumberBase<sbyte>.IsSubnormal(sbyte value);
+        static bool INumberBase<sbyte>.IsZero(sbyte value);
+        static sbyte INumberBase<sbyte>.MaxMagnitudeNumber(sbyte x, sbyte y);
+        static sbyte INumberBase<sbyte>.MinMagnitudeNumber(sbyte x, sbyte y);
+        static bool INumberBase<sbyte>.TryConvertFromChecked<TOther>(TOther value, out sbyte result);
+        static bool INumberBase<sbyte>.TryConvertFromSaturating<TOther>(TOther value, out sbyte result);
+        static bool INumberBase<sbyte>.TryConvertFromTruncating<TOther>(TOther value, out sbyte result);
+        static bool INumberBase<sbyte>.TryConvertToChecked<TOther>(sbyte value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<sbyte>.TryConvertToSaturating<TOther>(sbyte value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<sbyte>.TryConvertToTruncating<TOther>(sbyte value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static sbyte IShiftOperators<sbyte, int, sbyte>.operator <<(sbyte value, int shiftAmount);
+        static sbyte IShiftOperators<sbyte, int, sbyte>.operator >>(sbyte value, int shiftAmount);
+        static sbyte IShiftOperators<sbyte, int, sbyte>.operator >>>(sbyte value, int shiftAmount);
+        static sbyte ISubtractionOperators<sbyte, sbyte, sbyte>.operator checked -(sbyte left, sbyte right);
+        static sbyte ISubtractionOperators<sbyte, sbyte, sbyte>.operator -(sbyte left, sbyte right);
+        static sbyte IUnaryNegationOperators<sbyte, sbyte>.operator checked -(sbyte value);
+        static sbyte IUnaryNegationOperators<sbyte, sbyte>.operator -(sbyte value);
+        static sbyte IUnaryPlusOperators<sbyte, sbyte>.operator +(sbyte value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static sbyte TrailingZeroCount(sbyte value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out sbyte result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out sbyte result);
     }
-    public readonly struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable, ISpanFormattable {
+    public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float, bool>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float, bool>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointConstants<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+        public const float E = 2.7182817f;
+        public const float NegativeZero = -0f;
+        public const float Pi = 3.1415927f;
+        public const float Tau = 6.2831855f;
+        static float System.Numerics.IAdditiveIdentity<System.Single,System.Single>.AdditiveIdentity { get; }
+        static float System.Numerics.IBinaryNumber<System.Single>.AllBitsSet { get; }
+        static float System.Numerics.IFloatingPointConstants<System.Single>.E { get; }
+        static float System.Numerics.IFloatingPointConstants<System.Single>.Pi { get; }
+        static float System.Numerics.IFloatingPointConstants<System.Single>.Tau { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.Epsilon { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.NaN { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.NegativeInfinity { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.NegativeZero { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.PositiveInfinity { get; }
+        static float System.Numerics.IMinMaxValue<System.Single>.MaxValue { get; }
+        static float System.Numerics.IMinMaxValue<System.Single>.MinValue { get; }
+        static float System.Numerics.IMultiplicativeIdentity<System.Single,System.Single>.MultiplicativeIdentity { get; }
+        static float System.Numerics.INumberBase<System.Single>.One { get; }
+        static int System.Numerics.INumberBase<System.Single>.Radix { get; }
+        static float System.Numerics.INumberBase<System.Single>.Zero { get; }
+        static float System.Numerics.ISignedNumber<System.Single>.NegativeOne { get; }
+        public static float Abs(float value);
+        public static float Acos(float x);
+        public static float Acosh(float x);
+        public static float AcosPi(float x);
+        public static float Asin(float x);
+        public static float Asinh(float x);
+        public static float AsinPi(float x);
+        public static float Atan(float x);
+        public static float Atan2(float y, float x);
+        public static float Atan2Pi(float y, float x);
+        public static float Atanh(float x);
+        public static float AtanPi(float x);
+        public static float BitDecrement(float x);
+        public static float BitIncrement(float x);
+        public static float Cbrt(float x);
+        public static float Ceiling(float x);
+        public static float Clamp(float value, float min, float max);
+        public static float CopySign(float value, float sign);
+        public static float Cos(float x);
+        public static float Cosh(float x);
+        public static float CosPi(float x);
+        public static float CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static float CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static float CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static float Exp(float x);
+        public static float Exp10(float x);
+        public static float Exp10M1(float x);
+        public static float Exp2(float x);
+        public static float Exp2M1(float x);
+        public static float ExpM1(float x);
+        public static float Floor(float x);
+        public static float FusedMultiplyAdd(float left, float right, float addend);
+        public static float Hypot(float x, float y);
+        public static float Ieee754Remainder(float left, float right);
+        public static int ILogB(float x);
+        public static bool IsEvenInteger(float value);
+        public static bool IsInteger(float value);
+        public static bool IsOddInteger(float value);
+        public static bool IsPositive(float value);
+        public static bool IsPow2(float value);
+        public static bool IsRealNumber(float value);
+        public static float Log(float x);
+        public static float Log(float x, float newBase);
+        public static float Log10(float x);
+        public static float Log10P1(float x);
+        public static float Log2(float value);
+        public static float Log2P1(float x);
+        public static float LogP1(float x);
+        public static float Max(float x, float y);
+        public static float MaxMagnitude(float x, float y);
+        public static float MaxMagnitudeNumber(float x, float y);
+        public static float MaxNumber(float x, float y);
+        public static float Min(float x, float y);
+        public static float MinMagnitude(float x, float y);
+        public static float MinMagnitudeNumber(float x, float y);
+        public static float MinNumber(float x, float y);
+        public static float Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static float Pow(float x, float y);
+        public static float ReciprocalEstimate(float x);
+        public static float ReciprocalSqrtEstimate(float x);
+        public static float RootN(float x, int n);
+        public static float Round(float x);
+        public static float Round(float x, int digits);
+        public static float Round(float x, int digits, MidpointRounding mode);
+        public static float Round(float x, MidpointRounding mode);
+        public static float ScaleB(float x, int n);
+        public static int Sign(float value);
+        public static float Sin(float x);
+        public static (float Sin, float Cos) SinCos(float x);
+        public static (float SinPi, float CosPi) SinCosPi(float x);
+        public static float Sinh(float x);
+        public static float SinPi(float x);
+        public static float Sqrt(float x);
+        static float IAdditionOperators<float, float, float>.operator +(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator &(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator |(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator ^(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator ~(float value);
+        static float IDecrementOperators<float>.operator --(float value);
+        static float IDivisionOperators<float, float, float>.operator /(float left, float right);
+        int IFloatingPoint<float>.GetExponentByteCount();
+        int IFloatingPoint<float>.GetExponentShortestBitLength();
+        int IFloatingPoint<float>.GetSignificandBitLength();
+        int IFloatingPoint<float>.GetSignificandByteCount();
+        bool IFloatingPoint<float>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<float>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<float>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<float>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static float IIncrementOperators<float>.operator ++(float value);
+        static float IModulusOperators<float, float, float>.operator %(float left, float right);
+        static float IMultiplyOperators<float, float, float>.operator *(float left, float right);
+        static bool INumberBase<float>.IsCanonical(float value);
+        static bool INumberBase<float>.IsComplexNumber(float value);
+        static bool INumberBase<float>.IsImaginaryNumber(float value);
+        static bool INumberBase<float>.IsZero(float value);
+        static bool INumberBase<float>.TryConvertFromChecked<TOther>(TOther value, out float result);
+        static bool INumberBase<float>.TryConvertFromSaturating<TOther>(TOther value, out float result);
+        static bool INumberBase<float>.TryConvertFromTruncating<TOther>(TOther value, out float result);
+        static bool INumberBase<float>.TryConvertToChecked<TOther>(float value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<float>.TryConvertToSaturating<TOther>(float value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<float>.TryConvertToTruncating<TOther>(float value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static float ISubtractionOperators<float, float, float>.operator -(float left, float right);
+        static float IUnaryNegationOperators<float, float>.operator -(float value);
+        static float IUnaryPlusOperators<float, float>.operator +(float value);
+        public static float Tan(float x);
+        public static float Tanh(float x);
+        public static float TanPi(float x);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static float Truncate(float x);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out float result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out float result);
     }
-    public readonly ref struct Span<T> {
+    [NativeMarshallingAttribute(typeof(SpanMarshaller<,>))]
+    public readonly ref struct Span<T> {
+        public Span(ref T reference);
     }
     public sealed class String : ICloneable, IComparable, IComparable<string?>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string?> {
-        public static string Format(IFormatProvider? provider, string format, object? arg0);
+        public static string Format(IFormatProvider? provider, [StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public static string Format(IFormatProvider? provider, string format, object? arg0, object? arg1);
+        public static string Format(IFormatProvider? provider, [StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public static string Format(IFormatProvider? provider, string format, object? arg0, object? arg1, object? arg2);
+        public static string Format(IFormatProvider? provider, [StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public static string Format(IFormatProvider? provider, string format, params object?[] args);
+        public static string Format(IFormatProvider? provider, [StringSyntaxAttribute("CompositeFormat")] string format, params object?[] args);
-        public static string Format(string format, object? arg0);
+        public static string Format([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0);
-        public static string Format(string format, object? arg0, object? arg1);
+        public static string Format([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1);
-        public static string Format(string format, object? arg0, object? arg1, object? arg2);
+        public static string Format([StringSyntaxAttribute("CompositeFormat")] string format, object? arg0, object? arg1, object? arg2);
-        public static string Format(string format, params object?[] args);
+        public static string Format([StringSyntaxAttribute("CompositeFormat")] string format, params object?[] args);
     }
-    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IEquatable<TimeOnly>, IFormattable, ISpanFormattable {
+    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IEquatable<TimeOnly>, IFormattable, IParsable<TimeOnly>, ISpanFormattable, ISpanParsable<TimeOnly> {
+        public TimeOnly(int hour, int minute, int second, int millisecond, int microsecond);
+        public int Microsecond { get; }
+        public int Nanosecond { get; }
+        public static TimeOnly Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static TimeOnly Parse(string s, IFormatProvider? provider);
-        public static TimeOnly ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider? provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("TimeOnlyFormat")] ReadOnlySpan<char> format, IFormatProvider? provider = null, DateTimeStyles style = DateTimeStyles.None);
-        public static TimeOnly ParseExact(ReadOnlySpan<char> s, string[] formats);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("TimeOnlyFormat")] string[] formats);
-        public static TimeOnly ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("TimeOnlyFormat")] string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public static TimeOnly ParseExact(string s, string format);
+        public static TimeOnly ParseExact(string s, [StringSyntaxAttribute("TimeOnlyFormat")] string format);
-        public static TimeOnly ParseExact(string s, string format, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(string s, [StringSyntaxAttribute("TimeOnlyFormat")] string format, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public static TimeOnly ParseExact(string s, string[] formats);
+        public static TimeOnly ParseExact(string s, [StringSyntaxAttribute("TimeOnlyFormat")] string[] formats);
-        public static TimeOnly ParseExact(string s, string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(string s, [StringSyntaxAttribute("TimeOnlyFormat")] string[] formats, IFormatProvider? provider, DateTimeStyles style = DateTimeStyles.None);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("TimeOnlyFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("TimeOnlyFormat")] string? format, IFormatProvider? provider);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("TimeOnlyFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out TimeOnly result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out TimeOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("TimeOnlyFormat")] ReadOnlySpan<char> format, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [StringSyntaxAttribute("TimeOnlyFormat")] ReadOnlySpan<char> format, out TimeOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeOnlyFormat")] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
-        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true)] string?[]? formats, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeOnlyFormat")] string?[]? formats, out TimeOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string? format, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeOnlyFormat")] string? format, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string? format, out TimeOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeOnlyFormat")] string? format, out TimeOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeOnlyFormat")] string?[]? formats, IFormatProvider? provider, DateTimeStyles style, out TimeOnly result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true)] string?[]? formats, out TimeOnly result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? s, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeOnlyFormat")] string?[]? formats, out TimeOnly result);
     }
-    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, ISpanFormattable {
+    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, IParsable<TimeSpan>, ISpanFormattable, ISpanParsable<TimeSpan> {
+        public const long NanosecondsPerTick = (long)100;
+        public const long TicksPerMicrosecond = (long)10;
+        public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds, int microseconds);
+        public int Microseconds { get; }
+        public int Nanoseconds { get; }
+        public double TotalMicroseconds { get; }
+        public double TotalNanoseconds { get; }
+        public static TimeSpan FromMicroseconds(double value);
-        public static TimeSpan ParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider? formatProvider, TimeSpanStyles styles = TimeSpanStyles.None);
+        public static TimeSpan ParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("TimeSpanFormat")] ReadOnlySpan<char> format, IFormatProvider? formatProvider, TimeSpanStyles styles = TimeSpanStyles.None);
-        public static TimeSpan ParseExact(ReadOnlySpan<char> input, string[] formats, IFormatProvider? formatProvider, TimeSpanStyles styles = TimeSpanStyles.None);
+        public static TimeSpan ParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("TimeSpanFormat")] string[] formats, IFormatProvider? formatProvider, TimeSpanStyles styles = TimeSpanStyles.None);
-        public static TimeSpan ParseExact(string input, string format, IFormatProvider? formatProvider);
+        public static TimeSpan ParseExact(string input, [StringSyntaxAttribute("TimeSpanFormat")] string format, IFormatProvider? formatProvider);
-        public static TimeSpan ParseExact(string input, string format, IFormatProvider? formatProvider, TimeSpanStyles styles);
+        public static TimeSpan ParseExact(string input, [StringSyntaxAttribute("TimeSpanFormat")] string format, IFormatProvider? formatProvider, TimeSpanStyles styles);
-        public static TimeSpan ParseExact(string input, string[] formats, IFormatProvider? formatProvider);
+        public static TimeSpan ParseExact(string input, [StringSyntaxAttribute("TimeSpanFormat")] string[] formats, IFormatProvider? formatProvider);
-        public static TimeSpan ParseExact(string input, string[] formats, IFormatProvider? formatProvider, TimeSpanStyles styles);
+        public static TimeSpan ParseExact(string input, [StringSyntaxAttribute("TimeSpanFormat")] string[] formats, IFormatProvider? formatProvider, TimeSpanStyles styles);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("TimeSpanFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? formatProvider);
+        public string ToString([StringSyntaxAttribute("TimeSpanFormat")] string? format, IFormatProvider? formatProvider);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? formatProvider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("TimeSpanFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? formatProvider = null);
-        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("TimeSpanFormat")] ReadOnlySpan<char> format, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
-        public static bool TryParseExact(ReadOnlySpan<char> input, ReadOnlySpan<char> format, IFormatProvider? formatProvider, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, [StringSyntaxAttribute("TimeSpanFormat")] ReadOnlySpan<char> format, IFormatProvider? formatProvider, out TimeSpan result);
-        public static bool TryParseExact(ReadOnlySpan<char> input, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeSpanFormat")] string?[]? formats, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
-        public static bool TryParseExact(ReadOnlySpan<char> input, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? formatProvider, out TimeSpan result);
+        public static bool TryParseExact(ReadOnlySpan<char> input, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeSpanFormat")] string?[]? formats, IFormatProvider? formatProvider, out TimeSpan result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true)] string? format, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeSpanFormat")] string? format, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true)] string? format, IFormatProvider? formatProvider, out TimeSpan result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeSpanFormat")] string? format, IFormatProvider? formatProvider, out TimeSpan result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeSpanFormat")] string?[]? formats, IFormatProvider? formatProvider, TimeSpanStyles styles, out TimeSpan result);
-        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true)] string?[]? formats, IFormatProvider? formatProvider, out TimeSpan result);
+        public static bool TryParseExact([NotNullWhenAttribute(true)] string? input, [NotNullWhenAttribute(true), StringSyntaxAttribute("TimeSpanFormat")] string?[]? formats, IFormatProvider? formatProvider, out TimeSpan result);
     }
     public sealed class TimeZoneInfo : IDeserializationCallback, IEquatable<TimeZoneInfo?>, ISerializable {
         public sealed class AdjustmentRule : IDeserializationCallback, IEquatable<TimeZoneInfo.AdjustmentRule?>, ISerializable {
+            public override bool Equals([NotNullWhenAttribute(true)] object? obj);
         }
     }
     public abstract class Type : MemberInfo, IReflect {
+        public virtual Array GetEnumValuesAsUnderlyingType();
-        public static Type GetTypeFromHandle(RuntimeTypeHandle handle);
+        public static Type? GetTypeFromHandle(RuntimeTypeHandle handle);
     }
+    [CLSCompliantAttribute(false)]
+    public readonly struct UInt128 : IAdditionOperators<UInt128, UInt128, UInt128>, IAdditiveIdentity<UInt128, UInt128>, IBinaryInteger<UInt128>, IBinaryNumber<UInt128>, IBitwiseOperators<UInt128, UInt128, UInt128>, IComparable, IComparable<UInt128>, IComparisonOperators<UInt128, UInt128, bool>, IDecrementOperators<UInt128>, IDivisionOperators<UInt128, UInt128, UInt128>, IEqualityOperators<UInt128, UInt128, bool>, IEquatable<UInt128>, IFormattable, IIncrementOperators<UInt128>, IMinMaxValue<UInt128>, IModulusOperators<UInt128, UInt128, UInt128>, IMultiplicativeIdentity<UInt128, UInt128>, IMultiplyOperators<UInt128, UInt128, UInt128>, INumber<UInt128>, INumberBase<UInt128>, IParsable<UInt128>, IShiftOperators<UInt128, int, UInt128>, ISpanFormattable, ISpanParsable<UInt128>, ISubtractionOperators<UInt128, UInt128, UInt128>, IUnaryNegationOperators<UInt128, UInt128>, IUnaryPlusOperators<UInt128, UInt128>, IUnsignedNumber<UInt128> {
+        [CLSCompliantAttribute(false)]
+        public UInt128(ulong upper, ulong lower);
+        public static UInt128 MaxValue { get; }
+        public static UInt128 MinValue { get; }
+        public static UInt128 One { get; }
+        static UInt128 System.Numerics.IAdditiveIdentity<System.UInt128,System.UInt128>.AdditiveIdentity { get; }
+        static UInt128 System.Numerics.IBinaryNumber<System.UInt128>.AllBitsSet { get; }
+        static UInt128 System.Numerics.IMultiplicativeIdentity<System.UInt128,System.UInt128>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.UInt128>.Radix { get; }
+        public static UInt128 Zero { get; }
+        public static UInt128 Clamp(UInt128 value, UInt128 min, UInt128 max);
+        public int CompareTo(object? value);
+        public int CompareTo(UInt128 value);
+        public static UInt128 CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static UInt128 CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static UInt128 CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (UInt128 Quotient, UInt128 Remainder) DivRem(UInt128 left, UInt128 right);
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
+        public bool Equals(UInt128 other);
+        public override int GetHashCode();
+        public static bool IsEvenInteger(UInt128 value);
+        public static bool IsOddInteger(UInt128 value);
+        public static bool IsPow2(UInt128 value);
+        public static UInt128 LeadingZeroCount(UInt128 value);
+        public static UInt128 Log2(UInt128 value);
+        public static UInt128 Max(UInt128 x, UInt128 y);
+        public static UInt128 Min(UInt128 x, UInt128 y);
+        public static UInt128 operator +(UInt128 left, UInt128 right);
+        public static UInt128 operator &(UInt128 left, UInt128 right);
+        public static UInt128 operator |(UInt128 left, UInt128 right);
+        public static UInt128 operator checked +(UInt128 left, UInt128 right);
+        public static UInt128 operator checked --(UInt128 value);
+        public static UInt128 operator checked /(UInt128 left, UInt128 right);
+        public static explicit operator checked UInt128 (double value);
+        public static explicit operator checked UInt128 (short value);
+        public static explicit operator checked UInt128 (int value);
+        public static explicit operator checked UInt128 (long value);
+        public static explicit operator checked UInt128 (IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UInt128 (sbyte value);
+        public static explicit operator checked UInt128 (float value);
+        public static explicit operator checked byte (UInt128 value);
+        public static explicit operator checked char (UInt128 value);
+        public static explicit operator checked short (UInt128 value);
+        public static explicit operator checked int (UInt128 value);
+        public static explicit operator checked long (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked Int128 (UInt128 value);
+        public static explicit operator checked IntPtr (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked sbyte (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ushort (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked uint (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked ulong (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator checked UIntPtr (UInt128 value);
+        public static UInt128 operator checked ++(UInt128 value);
+        public static UInt128 operator checked *(UInt128 left, UInt128 right);
+        public static UInt128 operator checked -(UInt128 left, UInt128 right);
+        public static UInt128 operator checked -(UInt128 value);
+        public static UInt128 operator --(UInt128 value);
+        public static UInt128 operator /(UInt128 left, UInt128 right);
+        public static bool operator ==(UInt128 left, UInt128 right);
+        public static UInt128 operator ^(UInt128 left, UInt128 right);
+        public static explicit operator UInt128 (decimal value);
+        public static explicit operator UInt128 (double value);
+        public static explicit operator UInt128 (short value);
+        public static explicit operator UInt128 (int value);
+        public static explicit operator UInt128 (long value);
+        public static explicit operator UInt128 (IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UInt128 (sbyte value);
+        public static explicit operator UInt128 (float value);
+        public static explicit operator byte (UInt128 value);
+        public static explicit operator char (UInt128 value);
+        public static explicit operator decimal (UInt128 value);
+        public static explicit operator double (UInt128 value);
+        public static explicit operator Half (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator Int128 (UInt128 value);
+        public static explicit operator short (UInt128 value);
+        public static explicit operator int (UInt128 value);
+        public static explicit operator long (UInt128 value);
+        public static explicit operator IntPtr (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator sbyte (UInt128 value);
+        public static explicit operator float (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ushort (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator uint (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator ulong (UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static explicit operator UIntPtr (UInt128 value);
+        public static bool operator >(UInt128 left, UInt128 right);
+        public static bool operator >=(UInt128 left, UInt128 right);
+        public static implicit operator UInt128 (byte value);
+        public static implicit operator UInt128 (char value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator UInt128 (ushort value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator UInt128 (uint value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator UInt128 (ulong value);
+        [CLSCompliantAttribute(false)]
+        public static implicit operator UInt128 (UIntPtr value);
+        public static UInt128 operator ++(UInt128 value);
+        public static bool operator !=(UInt128 left, UInt128 right);
+        public static UInt128 operator <<(UInt128 value, int shiftAmount);
+        public static bool operator <(UInt128 left, UInt128 right);
+        public static bool operator <=(UInt128 left, UInt128 right);
+        public static UInt128 operator %(UInt128 left, UInt128 right);
+        public static UInt128 operator *(UInt128 left, UInt128 right);
+        public static UInt128 operator ~(UInt128 value);
+        public static UInt128 operator >>(UInt128 value, int shiftAmount);
+        public static UInt128 operator -(UInt128 left, UInt128 right);
+        public static UInt128 operator -(UInt128 value);
+        public static UInt128 operator +(UInt128 value);
+        public static UInt128 operator >>>(UInt128 value, int shiftAmount);
+        public static UInt128 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        public static UInt128 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static UInt128 Parse(string s);
+        public static UInt128 Parse(string s, NumberStyles style);
+        public static UInt128 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static UInt128 Parse(string s, IFormatProvider? provider);
+        public static UInt128 PopCount(UInt128 value);
+        public static UInt128 RotateLeft(UInt128 value, int rotateAmount);
+        public static UInt128 RotateRight(UInt128 value, int rotateAmount);
+        public static int Sign(UInt128 value);
+        int IBinaryInteger<UInt128>.GetByteCount();
+        int IBinaryInteger<UInt128>.GetShortestBitLength();
+        static bool IBinaryInteger<UInt128>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out UInt128 value);
+        static bool IBinaryInteger<UInt128>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out UInt128 value);
+        bool IBinaryInteger<UInt128>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<UInt128>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static UInt128 INumber<UInt128>.CopySign(UInt128 value, UInt128 sign);
+        static UInt128 INumber<UInt128>.MaxNumber(UInt128 x, UInt128 y);
+        static UInt128 INumber<UInt128>.MinNumber(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.Abs(UInt128 value);
+        static bool INumberBase<UInt128>.IsCanonical(UInt128 value);
+        static bool INumberBase<UInt128>.IsComplexNumber(UInt128 value);
+        static bool INumberBase<UInt128>.IsFinite(UInt128 value);
+        static bool INumberBase<UInt128>.IsImaginaryNumber(UInt128 value);
+        static bool INumberBase<UInt128>.IsInfinity(UInt128 value);
+        static bool INumberBase<UInt128>.IsInteger(UInt128 value);
+        static bool INumberBase<UInt128>.IsNaN(UInt128 value);
+        static bool INumberBase<UInt128>.IsNegative(UInt128 value);
+        static bool INumberBase<UInt128>.IsNegativeInfinity(UInt128 value);
+        static bool INumberBase<UInt128>.IsNormal(UInt128 value);
+        static bool INumberBase<UInt128>.IsPositive(UInt128 value);
+        static bool INumberBase<UInt128>.IsPositiveInfinity(UInt128 value);
+        static bool INumberBase<UInt128>.IsRealNumber(UInt128 value);
+        static bool INumberBase<UInt128>.IsSubnormal(UInt128 value);
+        static bool INumberBase<UInt128>.IsZero(UInt128 value);
+        static UInt128 INumberBase<UInt128>.MaxMagnitude(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.MaxMagnitudeNumber(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.MinMagnitude(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.MinMagnitudeNumber(UInt128 x, UInt128 y);
+        static bool INumberBase<UInt128>.TryConvertFromChecked<TOther>(TOther value, out UInt128 result);
+        static bool INumberBase<UInt128>.TryConvertFromSaturating<TOther>(TOther value, out UInt128 result);
+        static bool INumberBase<UInt128>.TryConvertFromTruncating<TOther>(TOther value, out UInt128 result);
+        static bool INumberBase<UInt128>.TryConvertToChecked<TOther>(UInt128 value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<UInt128>.TryConvertToSaturating<TOther>(UInt128 value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<UInt128>.TryConvertToTruncating<TOther>(UInt128 value, [MaybeNullWhenAttribute(false)] out TOther result);
+        public override string ToString();
+        public string ToString(IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static UInt128 TrailingZeroCount(UInt128 value);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out UInt128 result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, NumberStyles style, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, out UInt128 result);
+    }
-    [CLSCompliantAttribute(false)]
-    public readonly struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable, ISpanFormattable {
+    [CLSCompliantAttribute(false)]
+    public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort, bool>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort, bool>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, INumberBase<ushort>, IParsable<ushort>, IShiftOperators<ushort, int, ushort>, ISpanFormattable, ISpanParsable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
+        static ushort System.Numerics.IAdditiveIdentity<System.UInt16,System.UInt16>.AdditiveIdentity { get; }
+        static ushort System.Numerics.IBinaryNumber<System.UInt16>.AllBitsSet { get; }
+        static ushort System.Numerics.IMinMaxValue<System.UInt16>.MaxValue { get; }
+        static ushort System.Numerics.IMinMaxValue<System.UInt16>.MinValue { get; }
+        static ushort System.Numerics.IMultiplicativeIdentity<System.UInt16,System.UInt16>.MultiplicativeIdentity { get; }
+        static ushort System.Numerics.INumberBase<System.UInt16>.One { get; }
+        static int System.Numerics.INumberBase<System.UInt16>.Radix { get; }
+        static ushort System.Numerics.INumberBase<System.UInt16>.Zero { get; }
+        public static ushort Clamp(ushort value, ushort min, ushort max);
+        public static ushort CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static ushort CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static ushort CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (ushort Quotient, ushort Remainder) DivRem(ushort left, ushort right);
+        public static bool IsEvenInteger(ushort value);
+        public static bool IsOddInteger(ushort value);
+        public static bool IsPow2(ushort value);
+        public static ushort LeadingZeroCount(ushort value);
+        public static ushort Log2(ushort value);
+        public static ushort Max(ushort x, ushort y);
+        public static ushort Min(ushort x, ushort y);
+        public static ushort Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static ushort PopCount(ushort value);
+        public static ushort RotateLeft(ushort value, int rotateAmount);
+        public static ushort RotateRight(ushort value, int rotateAmount);
+        public static int Sign(ushort value);
+        static ushort IAdditionOperators<ushort, ushort, ushort>.operator +(ushort left, ushort right);
+        static ushort IAdditionOperators<ushort, ushort, ushort>.operator checked +(ushort left, ushort right);
+        int IBinaryInteger<ushort>.GetByteCount();
+        int IBinaryInteger<ushort>.GetShortestBitLength();
+        static bool IBinaryInteger<ushort>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out ushort value);
+        static bool IBinaryInteger<ushort>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out ushort value);
+        bool IBinaryInteger<ushort>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<ushort>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator &(ushort left, ushort right);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator |(ushort left, ushort right);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator ^(ushort left, ushort right);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator ~(ushort value);
+        static bool IComparisonOperators<ushort, ushort, bool>.operator >(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort, bool>.operator >=(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort, bool>.operator <(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort, bool>.operator <=(ushort left, ushort right);
+        static ushort IDecrementOperators<ushort>.operator checked --(ushort value);
+        static ushort IDecrementOperators<ushort>.operator --(ushort value);
+        static ushort IDivisionOperators<ushort, ushort, ushort>.operator /(ushort left, ushort right);
+        static bool IEqualityOperators<ushort, ushort, bool>.operator ==(ushort left, ushort right);
+        static bool IEqualityOperators<ushort, ushort, bool>.operator !=(ushort left, ushort right);
+        static ushort IIncrementOperators<ushort>.operator checked ++(ushort value);
+        static ushort IIncrementOperators<ushort>.operator ++(ushort value);
+        static ushort IModulusOperators<ushort, ushort, ushort>.operator %(ushort left, ushort right);
+        static ushort IMultiplyOperators<ushort, ushort, ushort>.operator checked *(ushort left, ushort right);
+        static ushort IMultiplyOperators<ushort, ushort, ushort>.operator *(ushort left, ushort right);
+        static ushort INumber<ushort>.CopySign(ushort value, ushort sign);
+        static ushort INumber<ushort>.MaxNumber(ushort x, ushort y);
+        static ushort INumber<ushort>.MinNumber(ushort x, ushort y);
+        static ushort INumberBase<ushort>.Abs(ushort value);
+        static bool INumberBase<ushort>.IsCanonical(ushort value);
+        static bool INumberBase<ushort>.IsComplexNumber(ushort value);
+        static bool INumberBase<ushort>.IsFinite(ushort value);
+        static bool INumberBase<ushort>.IsImaginaryNumber(ushort value);
+        static bool INumberBase<ushort>.IsInfinity(ushort value);
+        static bool INumberBase<ushort>.IsInteger(ushort value);
+        static bool INumberBase<ushort>.IsNaN(ushort value);
+        static bool INumberBase<ushort>.IsNegative(ushort value);
+        static bool INumberBase<ushort>.IsNegativeInfinity(ushort value);
+        static bool INumberBase<ushort>.IsNormal(ushort value);
+        static bool INumberBase<ushort>.IsPositive(ushort value);
+        static bool INumberBase<ushort>.IsPositiveInfinity(ushort value);
+        static bool INumberBase<ushort>.IsRealNumber(ushort value);
+        static bool INumberBase<ushort>.IsSubnormal(ushort value);
+        static bool INumberBase<ushort>.IsZero(ushort value);
+        static ushort INumberBase<ushort>.MaxMagnitude(ushort x, ushort y);
+        static ushort INumberBase<ushort>.MaxMagnitudeNumber(ushort x, ushort y);
+        static ushort INumberBase<ushort>.MinMagnitude(ushort x, ushort y);
+        static ushort INumberBase<ushort>.MinMagnitudeNumber(ushort x, ushort y);
+        static bool INumberBase<ushort>.TryConvertFromChecked<TOther>(TOther value, out ushort result);
+        static bool INumberBase<ushort>.TryConvertFromSaturating<TOther>(TOther value, out ushort result);
+        static bool INumberBase<ushort>.TryConvertFromTruncating<TOther>(TOther value, out ushort result);
+        static bool INumberBase<ushort>.TryConvertToChecked<TOther>(ushort value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<ushort>.TryConvertToSaturating<TOther>(ushort value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<ushort>.TryConvertToTruncating<TOther>(ushort value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static ushort IShiftOperators<ushort, int, ushort>.operator <<(ushort value, int shiftAmount);
+        static ushort IShiftOperators<ushort, int, ushort>.operator >>(ushort value, int shiftAmount);
+        static ushort IShiftOperators<ushort, int, ushort>.operator >>>(ushort value, int shiftAmount);
+        static ushort ISubtractionOperators<ushort, ushort, ushort>.operator checked -(ushort left, ushort right);
+        static ushort ISubtractionOperators<ushort, ushort, ushort>.operator -(ushort left, ushort right);
+        static ushort IUnaryNegationOperators<ushort, ushort>.operator checked -(ushort value);
+        static ushort IUnaryNegationOperators<ushort, ushort>.operator -(ushort value);
+        static ushort IUnaryPlusOperators<ushort, ushort>.operator +(ushort value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static ushort TrailingZeroCount(ushort value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out ushort result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out ushort result);
     }
-    [CLSCompliantAttribute(false)]
-    public readonly struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable, ISpanFormattable {
+    [CLSCompliantAttribute(false)]
+    public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint, bool>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint, bool>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, INumberBase<uint>, IParsable<uint>, IShiftOperators<uint, int, uint>, ISpanFormattable, ISpanParsable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
+        static uint System.Numerics.IAdditiveIdentity<System.UInt32,System.UInt32>.AdditiveIdentity { get; }
+        static uint System.Numerics.IBinaryNumber<System.UInt32>.AllBitsSet { get; }
+        static uint System.Numerics.IMinMaxValue<System.UInt32>.MaxValue { get; }
+        static uint System.Numerics.IMinMaxValue<System.UInt32>.MinValue { get; }
+        static uint System.Numerics.IMultiplicativeIdentity<System.UInt32,System.UInt32>.MultiplicativeIdentity { get; }
+        static uint System.Numerics.INumberBase<System.UInt32>.One { get; }
+        static int System.Numerics.INumberBase<System.UInt32>.Radix { get; }
+        static uint System.Numerics.INumberBase<System.UInt32>.Zero { get; }
+        public static uint Clamp(uint value, uint min, uint max);
+        public static uint CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static uint CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static uint CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (uint Quotient, uint Remainder) DivRem(uint left, uint right);
+        public static bool IsEvenInteger(uint value);
+        public static bool IsOddInteger(uint value);
+        public static bool IsPow2(uint value);
+        public static uint LeadingZeroCount(uint value);
+        public static uint Log2(uint value);
+        public static uint Max(uint x, uint y);
+        public static uint Min(uint x, uint y);
+        public static uint Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static uint PopCount(uint value);
+        public static uint RotateLeft(uint value, int rotateAmount);
+        public static uint RotateRight(uint value, int rotateAmount);
+        public static int Sign(uint value);
+        static uint IAdditionOperators<uint, uint, uint>.operator +(uint left, uint right);
+        static uint IAdditionOperators<uint, uint, uint>.operator checked +(uint left, uint right);
+        int IBinaryInteger<uint>.GetByteCount();
+        int IBinaryInteger<uint>.GetShortestBitLength();
+        static bool IBinaryInteger<uint>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out uint value);
+        static bool IBinaryInteger<uint>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out uint value);
+        bool IBinaryInteger<uint>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<uint>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static uint IBitwiseOperators<uint, uint, uint>.operator &(uint left, uint right);
+        static uint IBitwiseOperators<uint, uint, uint>.operator |(uint left, uint right);
+        static uint IBitwiseOperators<uint, uint, uint>.operator ^(uint left, uint right);
+        static uint IBitwiseOperators<uint, uint, uint>.operator ~(uint value);
+        static bool IComparisonOperators<uint, uint, bool>.operator >(uint left, uint right);
+        static bool IComparisonOperators<uint, uint, bool>.operator >=(uint left, uint right);
+        static bool IComparisonOperators<uint, uint, bool>.operator <(uint left, uint right);
+        static bool IComparisonOperators<uint, uint, bool>.operator <=(uint left, uint right);
+        static uint IDecrementOperators<uint>.operator checked --(uint value);
+        static uint IDecrementOperators<uint>.operator --(uint value);
+        static uint IDivisionOperators<uint, uint, uint>.operator /(uint left, uint right);
+        static bool IEqualityOperators<uint, uint, bool>.operator ==(uint left, uint right);
+        static bool IEqualityOperators<uint, uint, bool>.operator !=(uint left, uint right);
+        static uint IIncrementOperators<uint>.operator checked ++(uint value);
+        static uint IIncrementOperators<uint>.operator ++(uint value);
+        static uint IModulusOperators<uint, uint, uint>.operator %(uint left, uint right);
+        static uint IMultiplyOperators<uint, uint, uint>.operator checked *(uint left, uint right);
+        static uint IMultiplyOperators<uint, uint, uint>.operator *(uint left, uint right);
+        static uint INumber<uint>.CopySign(uint value, uint sign);
+        static uint INumber<uint>.MaxNumber(uint x, uint y);
+        static uint INumber<uint>.MinNumber(uint x, uint y);
+        static uint INumberBase<uint>.Abs(uint value);
+        static bool INumberBase<uint>.IsCanonical(uint value);
+        static bool INumberBase<uint>.IsComplexNumber(uint value);
+        static bool INumberBase<uint>.IsFinite(uint value);
+        static bool INumberBase<uint>.IsImaginaryNumber(uint value);
+        static bool INumberBase<uint>.IsInfinity(uint value);
+        static bool INumberBase<uint>.IsInteger(uint value);
+        static bool INumberBase<uint>.IsNaN(uint value);
+        static bool INumberBase<uint>.IsNegative(uint value);
+        static bool INumberBase<uint>.IsNegativeInfinity(uint value);
+        static bool INumberBase<uint>.IsNormal(uint value);
+        static bool INumberBase<uint>.IsPositive(uint value);
+        static bool INumberBase<uint>.IsPositiveInfinity(uint value);
+        static bool INumberBase<uint>.IsRealNumber(uint value);
+        static bool INumberBase<uint>.IsSubnormal(uint value);
+        static bool INumberBase<uint>.IsZero(uint value);
+        static uint INumberBase<uint>.MaxMagnitude(uint x, uint y);
+        static uint INumberBase<uint>.MaxMagnitudeNumber(uint x, uint y);
+        static uint INumberBase<uint>.MinMagnitude(uint x, uint y);
+        static uint INumberBase<uint>.MinMagnitudeNumber(uint x, uint y);
+        static bool INumberBase<uint>.TryConvertFromChecked<TOther>(TOther value, out uint result);
+        static bool INumberBase<uint>.TryConvertFromSaturating<TOther>(TOther value, out uint result);
+        static bool INumberBase<uint>.TryConvertFromTruncating<TOther>(TOther value, out uint result);
+        static bool INumberBase<uint>.TryConvertToChecked<TOther>(uint value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<uint>.TryConvertToSaturating<TOther>(uint value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<uint>.TryConvertToTruncating<TOther>(uint value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static uint IShiftOperators<uint, int, uint>.operator <<(uint value, int shiftAmount);
+        static uint IShiftOperators<uint, int, uint>.operator >>(uint value, int shiftAmount);
+        static uint IShiftOperators<uint, int, uint>.operator >>>(uint value, int shiftAmount);
+        static uint ISubtractionOperators<uint, uint, uint>.operator checked -(uint left, uint right);
+        static uint ISubtractionOperators<uint, uint, uint>.operator -(uint left, uint right);
+        static uint IUnaryNegationOperators<uint, uint>.operator checked -(uint value);
+        static uint IUnaryNegationOperators<uint, uint>.operator -(uint value);
+        static uint IUnaryPlusOperators<uint, uint>.operator +(uint value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static uint TrailingZeroCount(uint value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out uint result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out uint result);
     }
-    [CLSCompliantAttribute(false)]
-    public readonly struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable, ISpanFormattable {
+    [CLSCompliantAttribute(false)]
+    public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong, bool>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong, bool>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, INumberBase<ulong>, IParsable<ulong>, IShiftOperators<ulong, int, ulong>, ISpanFormattable, ISpanParsable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
+        static ulong System.Numerics.IAdditiveIdentity<System.UInt64,System.UInt64>.AdditiveIdentity { get; }
+        static ulong System.Numerics.IBinaryNumber<System.UInt64>.AllBitsSet { get; }
+        static ulong System.Numerics.IMinMaxValue<System.UInt64>.MaxValue { get; }
+        static ulong System.Numerics.IMinMaxValue<System.UInt64>.MinValue { get; }
+        static ulong System.Numerics.IMultiplicativeIdentity<System.UInt64,System.UInt64>.MultiplicativeIdentity { get; }
+        static ulong System.Numerics.INumberBase<System.UInt64>.One { get; }
+        static int System.Numerics.INumberBase<System.UInt64>.Radix { get; }
+        static ulong System.Numerics.INumberBase<System.UInt64>.Zero { get; }
+        public static ulong Clamp(ulong value, ulong min, ulong max);
+        public static ulong CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static ulong CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static ulong CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (ulong Quotient, ulong Remainder) DivRem(ulong left, ulong right);
+        public static bool IsEvenInteger(ulong value);
+        public static bool IsOddInteger(ulong value);
+        public static bool IsPow2(ulong value);
+        public static ulong LeadingZeroCount(ulong value);
+        public static ulong Log2(ulong value);
+        public static ulong Max(ulong x, ulong y);
+        public static ulong Min(ulong x, ulong y);
+        public static ulong Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static ulong PopCount(ulong value);
+        public static ulong RotateLeft(ulong value, int rotateAmount);
+        public static ulong RotateRight(ulong value, int rotateAmount);
+        public static int Sign(ulong value);
+        static ulong IAdditionOperators<ulong, ulong, ulong>.operator +(ulong left, ulong right);
+        static ulong IAdditionOperators<ulong, ulong, ulong>.operator checked +(ulong left, ulong right);
+        int IBinaryInteger<ulong>.GetByteCount();
+        int IBinaryInteger<ulong>.GetShortestBitLength();
+        static bool IBinaryInteger<ulong>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out ulong value);
+        static bool IBinaryInteger<ulong>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out ulong value);
+        bool IBinaryInteger<ulong>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<ulong>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator &(ulong left, ulong right);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator |(ulong left, ulong right);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator ^(ulong left, ulong right);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator ~(ulong value);
+        static bool IComparisonOperators<ulong, ulong, bool>.operator >(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong, bool>.operator >=(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong, bool>.operator <(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong, bool>.operator <=(ulong left, ulong right);
+        static ulong IDecrementOperators<ulong>.operator checked --(ulong value);
+        static ulong IDecrementOperators<ulong>.operator --(ulong value);
+        static ulong IDivisionOperators<ulong, ulong, ulong>.operator /(ulong left, ulong right);
+        static bool IEqualityOperators<ulong, ulong, bool>.operator ==(ulong left, ulong right);
+        static bool IEqualityOperators<ulong, ulong, bool>.operator !=(ulong left, ulong right);
+        static ulong IIncrementOperators<ulong>.operator checked ++(ulong value);
+        static ulong IIncrementOperators<ulong>.operator ++(ulong value);
+        static ulong IModulusOperators<ulong, ulong, ulong>.operator %(ulong left, ulong right);
+        static ulong IMultiplyOperators<ulong, ulong, ulong>.operator checked *(ulong left, ulong right);
+        static ulong IMultiplyOperators<ulong, ulong, ulong>.operator *(ulong left, ulong right);
+        static ulong INumber<ulong>.CopySign(ulong value, ulong sign);
+        static ulong INumber<ulong>.MaxNumber(ulong x, ulong y);
+        static ulong INumber<ulong>.MinNumber(ulong x, ulong y);
+        static ulong INumberBase<ulong>.Abs(ulong value);
+        static bool INumberBase<ulong>.IsCanonical(ulong value);
+        static bool INumberBase<ulong>.IsComplexNumber(ulong value);
+        static bool INumberBase<ulong>.IsFinite(ulong value);
+        static bool INumberBase<ulong>.IsImaginaryNumber(ulong value);
+        static bool INumberBase<ulong>.IsInfinity(ulong value);
+        static bool INumberBase<ulong>.IsInteger(ulong value);
+        static bool INumberBase<ulong>.IsNaN(ulong value);
+        static bool INumberBase<ulong>.IsNegative(ulong value);
+        static bool INumberBase<ulong>.IsNegativeInfinity(ulong value);
+        static bool INumberBase<ulong>.IsNormal(ulong value);
+        static bool INumberBase<ulong>.IsPositive(ulong value);
+        static bool INumberBase<ulong>.IsPositiveInfinity(ulong value);
+        static bool INumberBase<ulong>.IsRealNumber(ulong value);
+        static bool INumberBase<ulong>.IsSubnormal(ulong value);
+        static bool INumberBase<ulong>.IsZero(ulong value);
+        static ulong INumberBase<ulong>.MaxMagnitude(ulong x, ulong y);
+        static ulong INumberBase<ulong>.MaxMagnitudeNumber(ulong x, ulong y);
+        static ulong INumberBase<ulong>.MinMagnitude(ulong x, ulong y);
+        static ulong INumberBase<ulong>.MinMagnitudeNumber(ulong x, ulong y);
+        static bool INumberBase<ulong>.TryConvertFromChecked<TOther>(TOther value, out ulong result);
+        static bool INumberBase<ulong>.TryConvertFromSaturating<TOther>(TOther value, out ulong result);
+        static bool INumberBase<ulong>.TryConvertFromTruncating<TOther>(TOther value, out ulong result);
+        static bool INumberBase<ulong>.TryConvertToChecked<TOther>(ulong value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<ulong>.TryConvertToSaturating<TOther>(ulong value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<ulong>.TryConvertToTruncating<TOther>(ulong value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static ulong IShiftOperators<ulong, int, ulong>.operator <<(ulong value, int shiftAmount);
+        static ulong IShiftOperators<ulong, int, ulong>.operator >>(ulong value, int shiftAmount);
+        static ulong IShiftOperators<ulong, int, ulong>.operator >>>(ulong value, int shiftAmount);
+        static ulong ISubtractionOperators<ulong, ulong, ulong>.operator checked -(ulong left, ulong right);
+        static ulong ISubtractionOperators<ulong, ulong, ulong>.operator -(ulong left, ulong right);
+        static ulong IUnaryNegationOperators<ulong, ulong>.operator checked -(ulong value);
+        static ulong IUnaryNegationOperators<ulong, ulong>.operator -(ulong value);
+        static ulong IUnaryPlusOperators<ulong, ulong>.operator +(ulong value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static ulong TrailingZeroCount(ulong value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out ulong result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out ulong result);
     }
-    [CLSCompliantAttribute(false)]
-    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable, ISpanFormattable {
+    [CLSCompliantAttribute(false)]
+    public readonly struct UIntPtr : IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>, IAdditiveIdentity<UIntPtr, UIntPtr>, IBinaryInteger<UIntPtr>, IBinaryNumber<UIntPtr>, IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>, IComparable, IComparable<UIntPtr>, IComparisonOperators<UIntPtr, UIntPtr, bool>, IDecrementOperators<UIntPtr>, IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>, IEqualityOperators<UIntPtr, UIntPtr, bool>, IEquatable<UIntPtr>, IFormattable, IIncrementOperators<UIntPtr>, IMinMaxValue<UIntPtr>, IModulusOperators<UIntPtr, UIntPtr, UIntPtr>, IMultiplicativeIdentity<UIntPtr, UIntPtr>, IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>, INumber<UIntPtr>, INumberBase<UIntPtr>, IParsable<UIntPtr>, ISerializable, IShiftOperators<UIntPtr, int, UIntPtr>, ISpanFormattable, ISpanParsable<UIntPtr>, ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>, IUnaryNegationOperators<UIntPtr, UIntPtr>, IUnaryPlusOperators<UIntPtr, UIntPtr>, IUnsignedNumber<UIntPtr> {
+        static UIntPtr System.Numerics.IAdditiveIdentity<nuint,nuint>.AdditiveIdentity { get; }
+        static UIntPtr System.Numerics.IBinaryNumber<nuint>.AllBitsSet { get; }
+        static UIntPtr System.Numerics.IMinMaxValue<nuint>.MaxValue { get; }
+        static UIntPtr System.Numerics.IMinMaxValue<nuint>.MinValue { get; }
+        static UIntPtr System.Numerics.IMultiplicativeIdentity<nuint,nuint>.MultiplicativeIdentity { get; }
+        static UIntPtr System.Numerics.INumberBase<nuint>.One { get; }
+        static int System.Numerics.INumberBase<nuint>.Radix { get; }
+        static UIntPtr System.Numerics.INumberBase<nuint>.Zero { get; }
+        public static UIntPtr Clamp(UIntPtr value, UIntPtr min, UIntPtr max);
+        public static UIntPtr CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static UIntPtr CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static UIntPtr CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        public static (UIntPtr Quotient, UIntPtr Remainder) DivRem(UIntPtr left, UIntPtr right);
+        public static bool IsEvenInteger(UIntPtr value);
+        public static bool IsOddInteger(UIntPtr value);
+        public static bool IsPow2(UIntPtr value);
+        public static UIntPtr LeadingZeroCount(UIntPtr value);
+        public static UIntPtr Log2(UIntPtr value);
+        public static UIntPtr Max(UIntPtr x, UIntPtr y);
+        public static UIntPtr Min(UIntPtr x, UIntPtr y);
+        public static UIntPtr Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static UIntPtr PopCount(UIntPtr value);
+        public static UIntPtr RotateLeft(UIntPtr value, int rotateAmount);
+        public static UIntPtr RotateRight(UIntPtr value, int rotateAmount);
+        public static int Sign(UIntPtr value);
+        static UIntPtr IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>.operator +(UIntPtr left, UIntPtr right);
+        static UIntPtr IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked +(UIntPtr left, UIntPtr right);
+        int IBinaryInteger<UIntPtr>.GetByteCount();
+        int IBinaryInteger<UIntPtr>.GetShortestBitLength();
+        static bool IBinaryInteger<UIntPtr>.TryReadBigEndian(ReadOnlySpan<byte> source, bool isUnsigned, out UIntPtr value);
+        static bool IBinaryInteger<UIntPtr>.TryReadLittleEndian(ReadOnlySpan<byte> source, bool isUnsigned, out UIntPtr value);
+        bool IBinaryInteger<UIntPtr>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<UIntPtr>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator &(UIntPtr left, UIntPtr right);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator |(UIntPtr left, UIntPtr right);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator ^(UIntPtr left, UIntPtr right);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator ~(UIntPtr value);
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator >(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator >=(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator <(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator <=(UIntPtr left, UIntPtr right);
+        static UIntPtr IDecrementOperators<UIntPtr>.operator checked --(UIntPtr value);
+        static UIntPtr IDecrementOperators<UIntPtr>.operator --(UIntPtr value);
+        static UIntPtr IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>.operator /(UIntPtr left, UIntPtr right);
+        static UIntPtr IIncrementOperators<UIntPtr>.operator checked ++(UIntPtr value);
+        static UIntPtr IIncrementOperators<UIntPtr>.operator ++(UIntPtr value);
+        static UIntPtr IModulusOperators<UIntPtr, UIntPtr, UIntPtr>.operator %(UIntPtr left, UIntPtr right);
+        static UIntPtr IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked *(UIntPtr left, UIntPtr right);
+        static UIntPtr IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>.operator *(UIntPtr left, UIntPtr right);
+        static UIntPtr INumber<UIntPtr>.CopySign(UIntPtr value, UIntPtr sign);
+        static UIntPtr INumber<UIntPtr>.MaxNumber(UIntPtr x, UIntPtr y);
+        static UIntPtr INumber<UIntPtr>.MinNumber(UIntPtr x, UIntPtr y);
+        static UIntPtr INumberBase<UIntPtr>.Abs(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsCanonical(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsComplexNumber(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsFinite(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsImaginaryNumber(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsInfinity(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsInteger(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNaN(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNegative(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNegativeInfinity(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNormal(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsPositive(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsPositiveInfinity(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsRealNumber(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsSubnormal(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsZero(UIntPtr value);
+        static UIntPtr INumberBase<UIntPtr>.MaxMagnitude(UIntPtr x, UIntPtr y);
+        static UIntPtr INumberBase<UIntPtr>.MaxMagnitudeNumber(UIntPtr x, UIntPtr y);
+        static UIntPtr INumberBase<UIntPtr>.MinMagnitude(UIntPtr x, UIntPtr y);
+        static UIntPtr INumberBase<UIntPtr>.MinMagnitudeNumber(UIntPtr x, UIntPtr y);
+        static bool INumberBase<UIntPtr>.TryConvertFromChecked<TOther>(TOther value, out UIntPtr result);
+        static bool INumberBase<UIntPtr>.TryConvertFromSaturating<TOther>(TOther value, out UIntPtr result);
+        static bool INumberBase<UIntPtr>.TryConvertFromTruncating<TOther>(TOther value, out UIntPtr result);
+        static bool INumberBase<UIntPtr>.TryConvertToChecked<TOther>(UIntPtr value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<UIntPtr>.TryConvertToSaturating<TOther>(UIntPtr value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static bool INumberBase<UIntPtr>.TryConvertToTruncating<TOther>(UIntPtr value, [MaybeNullWhenAttribute(false)] out TOther result);
+        static UIntPtr IShiftOperators<UIntPtr, int, UIntPtr>.operator <<(UIntPtr value, int shiftAmount);
+        static UIntPtr IShiftOperators<UIntPtr, int, UIntPtr>.operator >>(UIntPtr value, int shiftAmount);
+        static UIntPtr IShiftOperators<UIntPtr, int, UIntPtr>.operator >>>(UIntPtr value, int shiftAmount);
+        static UIntPtr ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked -(UIntPtr left, UIntPtr right);
+        static UIntPtr ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>.operator -(UIntPtr left, UIntPtr right);
+        static UIntPtr IUnaryNegationOperators<UIntPtr, UIntPtr>.operator checked -(UIntPtr value);
+        static UIntPtr IUnaryNegationOperators<UIntPtr, UIntPtr>.operator -(UIntPtr value);
+        static UIntPtr IUnaryPlusOperators<UIntPtr, UIntPtr>.operator +(UIntPtr value);
-        public string ToString(string? format);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format);
-        public string ToString(string? format, IFormatProvider? provider);
+        public string ToString([StringSyntaxAttribute("NumericFormat")] string? format, IFormatProvider? provider);
+        public static UIntPtr TrailingZeroCount(UIntPtr value);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out UIntPtr result);
+        public static bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, out UIntPtr result);
     }
     public class Uri : ISerializable {
-        public Uri(string uriString);
+        public Uri([StringSyntaxAttribute("Uri")] string uriString);
-        [ObsoleteAttribute("This constructor has been deprecated; the dontEscape parameter is always false. Use Uri(string) instead.")]
-        public Uri(string uriString, bool dontEscape);
+        [ObsoleteAttribute("This constructor has been deprecated; the dontEscape parameter is always false. Use Uri(string) instead.")]
+        public Uri([StringSyntaxAttribute("Uri")] string uriString, bool dontEscape);
-        public Uri(string uriString, in UriCreationOptions creationOptions);
+        public Uri([StringSyntaxAttribute("Uri")] string uriString, in UriCreationOptions creationOptions);
-        public Uri(string uriString, UriKind uriKind);
+        public Uri([StringSyntaxAttribute("Uri", new object[]{ "uriKind"})] string uriString, UriKind uriKind);
-        [ObsoleteAttribute("Uri.EscapeString has been deprecated. Use GetComponents() or static EscapeDataString() to escape a Uri component or a string.")]
-        protected static string EscapeString(string? str);
+        [ObsoleteAttribute("Uri.EscapeString has been deprecated. Use GetComponents() or Uri.EscapeDataString to escape a Uri component or a string.")]
+        protected static string EscapeString(string? str);
-        [ObsoleteAttribute("Uri.EscapeUriString can corrupt the Uri string in some cases. Consider using Uri.EscapeDataString for query string components.", DiagnosticId="SYSLIB0013", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public static string EscapeUriString(string stringToEscape);
+        [ObsoleteAttribute("Uri.EscapeUriString can corrupt the Uri string in some cases. Consider using Uri.EscapeDataString for query string components instead.", DiagnosticId="SYSLIB0013", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public static string EscapeUriString(string stringToEscape);
-        public static bool IsWellFormedUriString([NotNullWhenAttribute(true)] string? uriString, UriKind uriKind);
+        public static bool IsWellFormedUriString([NotNullWhenAttribute(true), StringSyntaxAttribute("Uri", new object[]{ "uriKind"})] string? uriString, UriKind uriKind);
-        [ObsoleteAttribute("Uri.MakeRelative has been deprecated. Use MakeRelativeUri(Uri uri).")]
-        public string MakeRelative(Uri toUri);
+        [ObsoleteAttribute("Uri.MakeRelative has been deprecated. Use MakeRelativeUri(Uri uri) instead.")]
+        public string MakeRelative(Uri toUri);
-        public static bool TryCreate([NotNullWhenAttribute(true)] string? uriString, in UriCreationOptions creationOptions, [NotNullWhenAttribute(true)] out Uri? result);
+        public static bool TryCreate([NotNullWhenAttribute(true), StringSyntaxAttribute("Uri")] string? uriString, in UriCreationOptions creationOptions, [NotNullWhenAttribute(true)] out Uri? result);
-        public static bool TryCreate([NotNullWhenAttribute(true)] string? uriString, UriKind uriKind, [NotNullWhenAttribute(true)] out Uri? result);
+        public static bool TryCreate([NotNullWhenAttribute(true), StringSyntaxAttribute("Uri", new object[]{ "uriKind"})] string? uriString, UriKind uriKind, [NotNullWhenAttribute(true)] out Uri? result);
     }
     public class UriBuilder {
-        public UriBuilder(string uri);
+        public UriBuilder([StringSyntaxAttribute("Uri")] string uri);
     }
     public class UriTypeConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
 }
```

