# System.Drawing

``` diff
 namespace System.Drawing {
-    public struct CharacterRange {
+    public struct CharacterRange : IEquatable<CharacterRange> {
+        public bool Equals(CharacterRange other);
     }
     public class FontConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public sealed class Graphics : MarshalByRefObject, IDeviceContext, IDisposable {
+        public void DrawRectangle(Pen pen, RectangleF rect);
+        public void FillPie(Brush brush, RectangleF rect, float startAngle, float sweepAngle);
-        [SupportedOSPlatformAttribute("windows")]
-        public void GetContextInfo(out PointF offset);
+        [EditorBrowsableAttribute(1)]
+        [SupportedOSPlatformAttribute("windows")]
+        public void GetContextInfo(out PointF offset);
-        [SupportedOSPlatformAttribute("windows")]
-        public void GetContextInfo(out PointF offset, out Region? clip);
+        [EditorBrowsableAttribute(1)]
+        [SupportedOSPlatformAttribute("windows")]
+        public void GetContextInfo(out PointF offset, out Region? clip);
-        public delegate bool EnumerateMetafileProc(EmfPlusRecordType recordType, int flags, int dataSize, IntPtr data, PlayRecordCallback callbackData);
+        public delegate bool EnumerateMetafileProc(EmfPlusRecordType recordType, int flags, int dataSize, IntPtr data, PlayRecordCallback? callbackData);
     }
     public class IconConverter : ExpandableObjectConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public sealed class ImageAnimator {
-        public static void UpdateFrames(Image image);
+        public static void UpdateFrames(Image? image);
     }
     public class ImageConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
     public class ImageFormatConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
     }
 }
```

